/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.axis.label;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AbstractFixedBreaksLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/HorizontalVerticalLabelsLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AbstractFixedBreaksLabelsLayout;", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "breaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "(Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;)V", "labelHorizontalAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "getLabelHorizontalAnchor", "()Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "labelVerticalAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;", "getLabelVerticalAnchor", "()Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "axisDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "axisLength", "", "labelBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "labelNormalSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "Companion", "plot-builder"})
public final class HorizontalVerticalLabelsLayout
extends AbstractFixedBreaksLabelsLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Text.VerticalAnchor labelVerticalAnchor;
    private static final double MIN_DISTANCE = 5.0;
    private static final double ROTATION_DEGREE = 90.0;

    public HorizontalVerticalLabelsLayout(@NotNull Orientation orientation, @NotNull ScaleBreaks breaks, @NotNull AxisTheme theme2) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        super(orientation, breaks, theme2);
        this.labelVerticalAnchor = Text.VerticalAnchor.CENTER;
    }

    @NotNull
    public final Text.HorizontalAnchor getLabelHorizontalAnchor() {
        Text.HorizontalAnchor horizontalAnchor;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getOrientation().ordinal()]) {
            case 1: {
                horizontalAnchor = Text.HorizontalAnchor.RIGHT;
                break;
            }
            case 2: {
                horizontalAnchor = Text.HorizontalAnchor.LEFT;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported orientation " + (Object)((Object)this.getOrientation()));
            }
        }
        return horizontalAnchor;
    }

    @NotNull
    public final Text.VerticalAnchor getLabelVerticalAnchor() {
        return this.labelVerticalAnchor;
    }

    @Override
    @NotNull
    public AxisLabelsLayoutInfo doLayout(@NotNull DoubleSpan axisDomain, double axisLength) {
        DoubleRectangle bounds;
        Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
        double height = this.getLabelSpec().height();
        List<Double> ticks = this.getBreaks().projectOnAxis(axisDomain, axisLength, true);
        boolean overlap = false;
        if (this.getBreaks().getSize() >= 2) {
            double minTickDistance = height + 5.0;
            double tickDistance = Math.abs(((Number)ticks.get(0)).doubleValue() - ((Number)ticks.get(1)).doubleValue());
            overlap = tickDistance < minTickDistance;
        }
        DoubleRectangle doubleRectangle = bounds = this.labelsBounds(ticks, this.getBreaks().getLabels(), AbstractFixedBreaksLabelsLayout.Companion.getHORIZONTAL_TICK_LOCATION());
        Intrinsics.checkNotNull((Object)doubleRectangle);
        return this.createAxisLabelsLayoutInfoBuilder(doubleRectangle, overlap).labelHorizontalAnchor(this.getLabelHorizontalAnchor()).labelVerticalAnchor(this.labelVerticalAnchor).labelRotationAngle(90.0).build();
    }

    @Override
    @NotNull
    protected DoubleRectangle labelBounds(@NotNull DoubleVector labelNormalSize) {
        Intrinsics.checkNotNullParameter((Object)labelNormalSize, (String)"labelNormalSize");
        if (!(this.labelVerticalAnchor == Text.VerticalAnchor.CENTER)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        double w = labelNormalSize.getY();
        double h = labelNormalSize.getX();
        double x2 = -w / (double)2;
        double y2 = 0.0;
        return new DoubleRectangle(x2, y2, w, h);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/HorizontalVerticalLabelsLayout$Companion;", "", "()V", "MIN_DISTANCE", "", "ROTATION_DEGREE", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

