/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.ui.unified.SshUiData;
import com.jetbrains.plugins.webDeployment.config.ServerPasswordSafeDeployable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CredentialsDeployable
extends ServerPasswordSafeDeployable {
    public CredentialsDeployable() {
        this(null);
    }

    public CredentialsDeployable(@Nullable RemoteCredentials credentials) {
        super(new WebServerConfig(), new SshUiData(new SshConfig(true), false));
        if (credentials != null) {
            this.initFrom(credentials);
        }
    }

    private void initFrom(RemoteCredentials credentials) {
        SshUiData sshUiData = Objects.requireNonNull(this.getSshUiData());
        sshUiData.loadFromCredentials(credentials);
        this.myServer.getFileTransferConfig().setSshConfig(sshUiData.getConfig());
    }

    public String toString() {
        return "CredentialsDeployable{myServer.name=" + this.myServer.getName() + "myServer.id=" + this.myServer.getId() + "}";
    }

    public void setName(String name) {
        this.myServer.setName(name);
    }

    public void setId(@NonNls String id) {
        this.myServer.setId(id);
    }

    public void resetCredentials(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            CredentialsDeployable.$$$reportNull$$$0(0);
        }
        this.initFrom(credentials);
    }

    public void setIsProjectLevel(boolean isProjectLevel) {
        this.myServer.setIsProjectLevel(isProjectLevel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/jetbrains/plugins/remotesdk/CredentialsDeployable", "resetCredentials"));
    }
}

