/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspCommunicationChannel;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerListener;
import com.intellij.platform.lsp.api.LspServerManagerListener;
import com.intellij.platform.lsp.api.LspServerNotificationsHandler;
import com.intellij.platform.lsp.api.LspServerState;
import com.intellij.platform.lsp.api.LspServerSupportProvider;
import com.intellij.platform.lsp.impl.LspDynamicCapabilities;
import com.intellij.platform.lsp.impl.LspRequestExecutorImpl;
import com.intellij.platform.lsp.impl.LspServerImplKt;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.LspServerNotificationsHandlerImpl;
import com.intellij.platform.lsp.impl.connector.Lsp4jServerConnector;
import com.intellij.platform.lsp.impl.connector.Lsp4jServerConnectorSocket;
import com.intellij.platform.lsp.impl.connector.Lsp4jServerConnectorStdio;
import com.intellij.platform.lsp.impl.connector.LspInitializationException;
import com.intellij.platform.lsp.impl.highlighting.DiagnosticAndQuickFixes;
import com.intellij.platform.lsp.impl.highlighting.LspDiagnosticsCache;
import com.intellij.platform.lsp.impl.highlighting.LspDocumentLink;
import com.intellij.platform.lsp.impl.highlighting.LspDocumentLinkCache;
import com.intellij.platform.lsp.impl.highlighting.LspSemanticToken;
import com.intellij.platform.lsp.impl.highlighting.LspSemanticTokensCache;
import com.intellij.platform.lsp.impl.highlightingCommon.LspCachedHighlighting;
import com.intellij.platform.lsp.impl.inlayHintColor.LspDocumentColorCache;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.text.StringKt;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.Color;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesRegistrationOptions;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DocumentFilter;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.FileSystemWatcher;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.RelativePattern;
import org.eclipse.lsp4j.SaveOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ServerInfo;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentRegistrationOptions;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00f0\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\b\b\u0007\u0018\u0000 \u00d2\u00012\u00020\u0001:\u0006\u00d0\u0001\u00d1\u0001\u00d2\u0001B)\b\u0000\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020.H\u0000\u00a2\u0006\u0002\bRJ%\u0010S\u001a\u00020T2\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020T0VH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\bWJ \u0010X\u001a\u00020T2\u0016\u0010Y\u001a\u0012\u0012\b\u0012\u00060Cj\u0002`D\u0012\u0004\u0012\u00020T0VH\u0016J4\u0010Z\u001a\u0004\u0018\u0001H[\"\u0004\b\u0000\u0010[2\u001c\u0010Y\u001a\u0018\u0012\b\u0012\u00060Cj\u0002`D\u0012\n\u0012\b\u0012\u0004\u0012\u0002H[0\\0VH\u0096@\u00a2\u0006\u0002\u0010]J;\u0010^\u001a\u0004\u0018\u0001H[\"\u0004\b\u0000\u0010[2\u0006\u0010_\u001a\u00020`2\u001c\u0010Y\u001a\u0018\u0012\b\u0012\u00060Cj\u0002`D\u0012\n\u0012\b\u0012\u0004\u0012\u0002H[0\\0VH\u0017\u00a2\u0006\u0002\u0010aJ\u0010\u0010b\u001a\u00020c2\u0006\u0010Q\u001a\u00020.H\u0016J\u0010\u0010d\u001a\u00020`2\u0006\u0010e\u001a\u00020fH\u0016J\u0015\u0010g\u001a\u00020T2\u0006\u0010Q\u001a\u00020.H\u0001\u00a2\u0006\u0002\bhJ\r\u0010i\u001a\u00020TH\u0000\u00a2\u0006\u0002\bjJ\u0015\u0010k\u001a\u00020T2\u0006\u0010Q\u001a\u00020.H\u0001\u00a2\u0006\u0002\blJ\u0015\u0010m\u001a\u00020P2\u0006\u0010Q\u001a\u00020.H\u0001\u00a2\u0006\u0002\bnJ\u0013\u0010o\u001a\b\u0012\u0004\u0012\u00020.0pH\u0001\u00a2\u0006\u0002\bqJ\u001b\u0010r\u001a\u00020T2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020t0pH\u0000\u00a2\u0006\u0002\buJ \u0010v\u001a\u0004\u0018\u00010w2\u0006\u0010x\u001a\u00020t2\f\u0010y\u001a\b\u0012\u0004\u0012\u00020{0zH\u0002J#\u0010|\u001a\u00020P2\u0006\u0010}\u001a\u00020~2\u0006\u0010\u007f\u001a\u0002002\t\u0010\u0080\u0001\u001a\u0004\u0018\u000100H\u0002J\u0019\u0010\u0081\u0001\u001a\u00020T2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0000\u00a2\u0006\u0003\b\u0084\u0001J!\u0010\u0085\u0001\u001a\u00020T2\u0006\u0010Q\u001a\u00020.2\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001H\u0000\u00a2\u0006\u0003\b\u0088\u0001J\u000f\u0010\u0089\u0001\u001a\u00020TH\u0000\u00a2\u0006\u0003\b\u008a\u0001J%\u0010\u008b\u0001\u001a\u0010\u0012\f\u0012\n\u0012\u0005\u0012\u00030\u008d\u00010\u008c\u00010z2\u0006\u0010Q\u001a\u00020.H\u0001\u00a2\u0006\u0003\b\u008e\u0001J\u0018\u0010\u008f\u0001\u001a\t\u0012\u0005\u0012\u00030\u0090\u00010z2\u0006\u0010Q\u001a\u00020.H\u0007J%\u0010\u0091\u0001\u001a\u0010\u0012\f\u0012\n\u0012\u0005\u0012\u00030\u0092\u00010\u008c\u00010z2\u0006\u0010Q\u001a\u00020.H\u0001\u00a2\u0006\u0003\b\u0093\u0001J%\u0010\u0094\u0001\u001a\u0010\u0012\f\u0012\n\u0012\u0005\u0012\u00030\u0095\u00010\u008c\u00010z2\u0006\u0010Q\u001a\u00020.H\u0001\u00a2\u0006\u0003\b\u0096\u0001J\u0017\u0010\u0097\u0001\u001a\u00020T2\u0006\u0010Q\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u0098\u0001J\u000f\u0010\u0099\u0001\u001a\u00020TH\u0000\u00a2\u0006\u0003\b\u009a\u0001J\t\u0010\u009b\u0001\u001a\u00020:H\u0002J(\u0010\u009c\u0001\u001a\u00020T2\u0007\u0010\u009d\u0001\u001a\u00020P2\u000e\u0010\u009e\u0001\u001a\t\u0012\u0004\u0012\u00020T0\u009f\u0001H\u0000\u00a2\u0006\u0003\b\u00a0\u0001J\t\u0010\u00a1\u0001\u001a\u00020TH\u0002J\u0017\u0010\u00a2\u0001\u001a\u00020P2\u0006\u0010Q\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00a3\u0001J\u0017\u0010\u00a4\u0001\u001a\u00020P2\u0006\u0010Q\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00a5\u0001J*\u0010\u00a6\u0001\u001a\u00020P2\u0019\u0010\u00a7\u0001\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002000z\u0012\u0004\u0012\u00020P0VH\u0000\u00a2\u0006\u0003\b\u00a8\u0001J\u000f\u0010\u00a9\u0001\u001a\u00020PH\u0000\u00a2\u0006\u0003\b\u00aa\u0001J\u000f\u0010\u00ab\u0001\u001a\u00020PH\u0000\u00a2\u0006\u0003\b\u00ac\u0001J\u000f\u0010\u00ad\u0001\u001a\u00020PH\u0000\u00a2\u0006\u0003\b\u00ae\u0001J\u0017\u0010\u00af\u0001\u001a\u00020P2\u0006\u0010Q\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00b0\u0001J\u001a\u0010\u00b1\u0001\u001a\u0005\u0018\u00010\u00b2\u00012\u0006\u0010Q\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00b3\u0001J\u000f\u0010\u00b4\u0001\u001a\u00020PH\u0000\u00a2\u0006\u0003\b\u00b5\u0001J\u0017\u0010\u00b6\u0001\u001a\u00020P2\u0006\u0010Q\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00b7\u0001J:\u0010\u00b8\u0001\u001a\u00020P\"\n\b\u0000\u0010\u00b9\u0001*\u00030\u00ba\u00012\u0006\u0010Q\u001a\u00020.2\u001b\u0010\u00bb\u0001\u001a\u0016\u0012\u0004\u0012\u000200\u0012\u000b\u0012\t\u0012\u0005\u0012\u0003H\u00b9\u00010\u00030\u00bc\u0001H\u0002JC\u0010\u00bd\u0001\u001a\u0005\u0018\u0001H\u00b9\u0001\"\n\b\u0000\u0010\u00b9\u0001*\u00030\u00ba\u00012\u0006\u0010Q\u001a\u00020.2\u001b\u0010\u00bb\u0001\u001a\u0016\u0012\u0004\u0012\u000200\u0012\u000b\u0012\t\u0012\u0005\u0012\u0003H\u00b9\u00010\u00030\u00bc\u0001H\u0002\u00a2\u0006\u0003\u0010\u00be\u0001J\u0018\u0010\u00bf\u0001\u001a\u00020T2\u0007\u0010\u00c0\u0001\u001a\u000200H\u0000\u00a2\u0006\u0003\b\u00c1\u0001J\t\u0010\u00c2\u0001\u001a\u000200H\u0016J\u001e\u0010\u00c3\u0001\u001a\u00020T2\r\u0010\u00c4\u0001\u001a\b00\u00a2\u0006\u0003\b\u00c5\u0001H\u0000\u00a2\u0006\u0003\b\u00c6\u0001J\u001e\u0010\u00c7\u0001\u001a\u00020T2\r\u0010\u00c4\u0001\u001a\b00\u00a2\u0006\u0003\b\u00c5\u0001H\u0000\u00a2\u0006\u0003\b\u00c8\u0001J,\u0010\u00c9\u0001\u001a\u00020T2\r\u0010\u00c4\u0001\u001a\b00\u00a2\u0006\u0003\b\u00c5\u00012\f\b\u0002\u0010\u00ca\u0001\u001a\u0005\u0018\u00010\u00cb\u0001H\u0000\u00a2\u0006\u0003\b\u00cc\u0001J\u001e\u0010\u00cd\u0001\u001a\u00020T2\r\u0010\u00c4\u0001\u001a\b00\u00a2\u0006\u0003\b\u00c5\u0001H\u0000\u00a2\u0006\u0003\b\u00ce\u0001J\u0012\u0010\u00cf\u0001\u001a\u0002002\u0007\u0010\u00c4\u0001\u001a\u000200H\u0002R\u001c\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u001c@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u0002000-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010<\u001a\u00060=j\u0002`>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010?\u001a\u0004\u0018\u0001008@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0018\u0010B\u001a\u00060Cj\u0002`D8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0016\u0010G\u001a\u0004\u0018\u00010H8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0016\u0010K\u001a\u0004\u0018\u00010L8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010N\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u00d3\u0001"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerImpl;", "Lcom/intellij/platform/lsp/api/LspServer;", "providerClass", "Ljava/lang/Class;", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider;", "descriptor", "Lcom/intellij/platform/lsp/api/LspServerDescriptor;", "eventBroadcaster", "Lcom/intellij/platform/lsp/api/LspServerManagerListener;", "LspServerImpl", "(Ljava/lang/Class;Lcom/intellij/platform/lsp/api/LspServerDescriptor;Lcom/intellij/platform/lsp/api/LspServerManagerListener;)V", "getProviderClass", "()Ljava/lang/Class;", "getDescriptor", "()Lcom/intellij/platform/lsp/api/LspServerDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "Lcom/intellij/platform/lsp/api/LspServerState;", "state", "getState", "()Lcom/intellij/platform/lsp/api/LspServerState;", "m", "(Lcom/intellij/platform/lsp/api/LspServerState;)V", "stateLock", "", "Lorg/eclipse/lsp4j/InitializeResult;", "initializeResult", "getInitializeResult", "()Lorg/eclipse/lsp4j/InitializeResult;", "requestExecutor", "Lcom/intellij/platform/lsp/impl/LspRequestExecutorImpl;", "getRequestExecutor", "()Lcom/intellij/platform/lsp/impl/LspRequestExecutorImpl;", "dynamicCapabilities", "Lcom/intellij/platform/lsp/impl/LspDynamicCapabilities;", "getDynamicCapabilities$intellij_platform_lsp_impl", "()Lcom/intellij/platform/lsp/impl/LspDynamicCapabilities;", "serverNotificationsHandler", "Lcom/intellij/platform/lsp/api/LspServerNotificationsHandler;", "getServerNotificationsHandler$intellij_platform_lsp_impl", "()Lcom/intellij/platform/lsp/api/LspServerNotificationsHandler;", "openedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "unsupportedFilePaths", "", "semanticTokensCache", "Lcom/intellij/platform/lsp/impl/highlighting/LspSemanticTokensCache;", "diagnosticsCache", "Lcom/intellij/platform/lsp/impl/highlighting/LspDiagnosticsCache;", "documentColorCache", "Lcom/intellij/platform/lsp/impl/inlayHintColor/LspDocumentColorCache;", "documentLinkCache", "Lcom/intellij/platform/lsp/impl/highlighting/LspDocumentLinkCache;", "lsp4jServerConnector", "Lcom/intellij/platform/lsp/impl/connector/Lsp4jServerConnector;", "connectorLock", "errorOutputBuffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "errorOutput", "getErrorOutput$intellij_platform_lsp_impl", "()Ljava/lang/String;", "lsp4jServer", "Lorg/eclipse/lsp4j/services/LanguageServer;", "Lcom/intellij/platform/lsp/api/Lsp4jServer;", "getLsp4jServer$intellij_platform_lsp_impl", "()Lorg/eclipse/lsp4j/services/LanguageServer;", "serverCapabilities", "Lorg/eclipse/lsp4j/ServerCapabilities;", "getServerCapabilities$intellij_platform_lsp_impl", "()Lorg/eclipse/lsp4j/ServerCapabilities;", "textDocumentSyncKind", "Lorg/eclipse/lsp4j/TextDocumentSyncKind;", "getTextDocumentSyncKind$intellij_platform_lsp_impl", "()Lorg/eclipse/lsp4j/TextDocumentSyncKind;", "isFileOpened", "", "file", "isFileOpened$intellij_platform_lsp_impl", "forEachOpenedFile", "", "action", "Lkotlin/Function1;", "forEachOpenedFile$intellij_platform_lsp_impl", "sendNotification", "lsp4jSender", "sendRequest", "Lsp4jResponse", "Ljava/util/concurrent/CompletableFuture;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendRequestSync", "timeoutMs", "", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getDocumentIdentifier", "Lorg/eclipse/lsp4j/TextDocumentIdentifier;", "getDocumentVersion", "document", "Lcom/intellij/openapi/editor/Document;", "sendDidOpenRequest", "sendDidOpenRequest$intellij_platform_lsp_impl", "sendOpenedFiles", "sendOpenedFiles$intellij_platform_lsp_impl", "sendDidCloseRequest", "sendDidCloseRequest$intellij_platform_lsp_impl", "isSupportedFile", "isSupportedFile$intellij_platform_lsp_impl", "getFilesToClose", "", "getFilesToClose$intellij_platform_lsp_impl", "processFileEvents", "fileChangeInfos", "Lcom/intellij/platform/lsp/impl/LspServerImpl$FileChangeInfo;", "processFileEvents$intellij_platform_lsp_impl", "m", "Lorg/eclipse/lsp4j/FileEvent;", "fileChangeInfo", "options", "", "Lorg/eclipse/lsp4j/DidChangeWatchedFilesRegistrationOptions;", "m", "fileInfo", "Lcom/intellij/platform/lsp/impl/LspServerImpl$FileInfo;", "globPattern", "basePath", "diagnosticsReceived", "params", "Lorg/eclipse/lsp4j/PublishDiagnosticsParams;", "diagnosticsReceived$intellij_platform_lsp_impl", "fileEdited", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "fileEdited$intellij_platform_lsp_impl", "refreshSemanticTokens", "refreshSemanticTokens$intellij_platform_lsp_impl", "getSemanticTokens", "Lcom/intellij/platform/lsp/impl/highlightingCommon/LspCachedHighlighting;", "Lcom/intellij/platform/lsp/impl/highlighting/LspSemanticToken;", "getSemanticTokens$intellij_platform_lsp_impl", "getDiagnosticsAndQuickFixes", "Lcom/intellij/platform/lsp/impl/highlighting/DiagnosticAndQuickFixes;", "getColorInfos", "Lorg/eclipse/lsp4j/Color;", "getColorInfos$intellij_platform_lsp_impl", "getDocumentLinkInfos", "Lcom/intellij/platform/lsp/impl/highlighting/LspDocumentLink;", "getDocumentLinkInfos$intellij_platform_lsp_impl", "notifyDocumentLinksReceived", "notifyDocumentLinksReceived$intellij_platform_lsp_impl", "start", "start$intellij_platform_lsp_impl", "m", "ensureServerStopped", "explicitStop", "updateLspServerManagerState", "Lkotlin/Function0;", "ensureServerStopped$intellij_platform_lsp_impl", "m", "supportsDocumentColor", "supportsDocumentColor$intellij_platform_lsp_impl", "supportsDocumentLink", "supportsDocumentLink$intellij_platform_lsp_impl", "supportsCodeActions", "codeActionKindsFilter", "supportsCodeActions$intellij_platform_lsp_impl", "supportsGotoDefinition", "supportsGotoDefinition$intellij_platform_lsp_impl", "supportsGotoTypeDefinition", "supportsGotoTypeDefinition$intellij_platform_lsp_impl", "supportsHover", "supportsHover$intellij_platform_lsp_impl", "supportsFindReferences", "supportsFindReferences$intellij_platform_lsp_impl", "getDidSaveOptions", "Lorg/eclipse/lsp4j/SaveOptions;", "getDidSaveOptions$intellij_platform_lsp_impl", "hasFormattingRelatedCapabilities", "hasFormattingRelatedCapabilities$intellij_platform_lsp_impl", "doesServerExplicitlyWantToFormatThisFile", "doesServerExplicitlyWantToFormatThisFile$intellij_platform_lsp_impl", "m", "T", "Lorg/eclipse/lsp4j/TextDocumentRegistrationOptions;", "capabilityAndOptionsClass", "Lkotlin/Pair;", "m", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/Pair;)Lorg/eclipse/lsp4j/TextDocumentRegistrationOptions;", "appendServerErrorOutput", "text", "appendServerErrorOutput$intellij_platform_lsp_impl", "toString", "logDebug", "message", "Lorg/jetbrains/annotations/NonNls;", "logDebug$intellij_platform_lsp_impl", "logInfo", "logInfo$intellij_platform_lsp_impl", "logWarn", "t", "", "logWarn$intellij_platform_lsp_impl", "logError", "logError$intellij_platform_lsp_impl", "m", "FileInfo", "FileChangeInfo", "Companion", "intellij.platform.lsp.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLspServerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspServerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,569:1\n1#2:570\n1#2:586\n1863#3,2:571\n774#3:573\n865#3,2:574\n1611#3,9:576\n1863#3:585\n1864#3:587\n1620#3:588\n1557#3:589\n1628#3,3:590\n1863#3,2:593\n*S KotlinDebug\n*F\n+ 1 LspServerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerImpl\n*L\n227#1:586\n104#1:571,2\n215#1:573\n215#1:574,2\n227#1:576,9\n227#1:585\n227#1:587\n227#1:588\n329#1:589\n329#1:590,3\n178#1:593,2\n*E\n"})
public final class LspServerImpl
implements LspServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Class<? extends LspServerSupportProvider> providerClass;
    @NotNull
    private final LspServerDescriptor descriptor;
    @NotNull
    private final LspServerManagerListener eventBroadcaster;
    @NotNull
    private final Project project;
    @NotNull
    private LspServerState state;
    @NotNull
    private final Object stateLock;
    @Nullable
    private InitializeResult initializeResult;
    @NotNull
    private final LspRequestExecutorImpl requestExecutor;
    @NotNull
    private final LspDynamicCapabilities dynamicCapabilities;
    @NotNull
    private final LspServerNotificationsHandler serverNotificationsHandler;
    @NotNull
    private final Set<VirtualFile> openedFiles;
    @NotNull
    private final Set<String> unsupportedFilePaths;
    @NotNull
    private final LspSemanticTokensCache semanticTokensCache;
    @NotNull
    private final LspDiagnosticsCache diagnosticsCache;
    @NotNull
    private final LspDocumentColorCache documentColorCache;
    @NotNull
    private final LspDocumentLinkCache documentLinkCache;
    private Lsp4jServerConnector lsp4jServerConnector;
    @NotNull
    private final Object connectorLock;
    @NotNull
    private final StringBuilder errorOutputBuffer;
    public static final int NOT_CANCELLABLE_REQUEST_TIMEOUT_MS = 300;
    private static final int MAX_ERROR_OUTPUT_SIZE = 0x100000;

    public LspServerImpl(@NotNull Class<? extends LspServerSupportProvider> providerClass, @NotNull LspServerDescriptor descriptor, @NotNull LspServerManagerListener eventBroadcaster) {
        Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)eventBroadcaster, (String)"eventBroadcaster");
        this.providerClass = providerClass;
        this.descriptor = descriptor;
        this.eventBroadcaster = eventBroadcaster;
        this.project = this.getDescriptor().getProject();
        this.state = LspServerState.Initializing;
        this.stateLock = new Object();
        this.requestExecutor = new LspRequestExecutorImpl(this);
        this.dynamicCapabilities = new LspDynamicCapabilities();
        this.serverNotificationsHandler = new LspServerNotificationsHandlerImpl(this);
        Set set = Collections.synchronizedSet(new HashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        this.openedFiles = set;
        Set set2 = Collections.synchronizedSet(new HashSet());
        Intrinsics.checkNotNullExpressionValue(set2, (String)"synchronizedSet(...)");
        this.unsupportedFilePaths = set2;
        this.semanticTokensCache = new LspSemanticTokensCache(this);
        this.diagnosticsCache = new LspDiagnosticsCache();
        this.documentColorCache = new LspDocumentColorCache(this);
        this.documentLinkCache = new LspDocumentLinkCache(this);
        this.connectorLock = new Object();
        this.errorOutputBuffer = new StringBuilder();
    }

    @Override
    @NotNull
    public Class<? extends LspServerSupportProvider> getProviderClass() {
        return this.providerClass;
    }

    @Override
    @NotNull
    public LspServerDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public LspServerState getState() {
        return this.state;
    }

    private void m(LspServerState lspServerState) {
        if (lspServerState == LspServerState.Initializing || this.state != LspServerState.Initializing && lspServerState == LspServerState.Running || this.state == LspServerState.ShutdownNormally || this.state == LspServerState.ShutdownUnexpectedly) {
            LspServerImplKt.access$getLogger$p().error("Incorrect state change: " + this.state + " -> " + lspServerState);
            return;
        }
        this.state = lspServerState;
        this.eventBroadcaster.serverStateChanged(this);
    }

    @Override
    @Nullable
    public InitializeResult getInitializeResult() {
        return this.initializeResult;
    }

    @NotNull
    public final LspRequestExecutorImpl getRequestExecutor() {
        return this.requestExecutor;
    }

    @NotNull
    public final LspDynamicCapabilities getDynamicCapabilities$intellij_platform_lsp_impl() {
        return this.dynamicCapabilities;
    }

    @NotNull
    public final LspServerNotificationsHandler getServerNotificationsHandler$intellij_platform_lsp_impl() {
        return this.serverNotificationsHandler;
    }

    @Nullable
    public final String getErrorOutput$intellij_platform_lsp_impl() {
        return StringKt.nullize$default((String)this.errorOutputBuffer.toString(), (boolean)false, (int)1, null);
    }

    @NotNull
    public final LanguageServer getLsp4jServer$intellij_platform_lsp_impl() {
        Lsp4jServerConnector lsp4jServerConnector = this.lsp4jServerConnector;
        if (lsp4jServerConnector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lsp4jServerConnector");
            lsp4jServerConnector = null;
        }
        return lsp4jServerConnector.getLsp4jServer();
    }

    @Nullable
    public final ServerCapabilities getServerCapabilities$intellij_platform_lsp_impl() {
        Object object;
        if (this.getState() == LspServerState.Running) {
            InitializeResult initializeResult = this.getInitializeResult();
            object = initializeResult != null ? initializeResult.getCapabilities() : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public final TextDocumentSyncKind getTextDocumentSyncKind$intellij_platform_lsp_impl() {
        TextDocumentSyncKind textDocumentSyncKind;
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getTextDocumentSync()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl = false;
            textDocumentSyncKind = (TextDocumentSyncKind)serverCapabilities2.getLeft();
            if (textDocumentSyncKind == null) {
                textDocumentSyncKind = ((TextDocumentSyncOptions)serverCapabilities2.getRight()).getChange();
            }
        } else {
            textDocumentSyncKind = null;
        }
        return textDocumentSyncKind;
    }

    public final boolean isFileOpened$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getOriginFileIfBacked(...)");
        VirtualFile virtualFile2 = virtualFile;
        return this.openedFiles.contains(virtualFile2);
    }

    public final void forEachOpenedFile$intellij_platform_lsp_impl(@NotNull Function1<? super VirtualFile, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean bl = false;
        Iterable iterable = this.openedFiles;
        boolean bl2 = false;
        for (Object t10 : iterable) {
            action.invoke(t10);
        }
    }

    @Override
    public void sendNotification(@NotNull Function1<? super LanguageServer, Unit> lsp4jSender) {
        Intrinsics.checkNotNullParameter(lsp4jSender, (String)"lsp4jSender");
        this.requestExecutor.sendNotification$intellij_platform_lsp_impl(lsp4jSender);
    }

    @Override
    @Nullable
    public <Lsp4jResponse> Object sendRequest(@NotNull Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> lsp4jSender, @NotNull Continuation<? super Lsp4jResponse> $completion) {
        return this.requestExecutor.sendRequest$intellij_platform_lsp_impl(lsp4jSender, $completion);
    }

    @Override
    @RequiresBackgroundThread
    @Nullable
    public <Lsp4jResponse> Lsp4jResponse sendRequestSync(int timeoutMs, @NotNull Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> lsp4jSender) {
        Intrinsics.checkNotNullParameter(lsp4jSender, (String)"lsp4jSender");
        return this.requestExecutor.sendRequestSync$intellij_platform_lsp_impl(timeoutMs, lsp4jSender);
    }

    @Override
    @NotNull
    public TextDocumentIdentifier getDocumentIdentifier(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new TextDocumentIdentifier(this.getDescriptor().getFileUri(file));
    }

    @Override
    public int getDocumentVersion(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        DocumentEx documentEx = document instanceof DocumentEx ? (DocumentEx)document : null;
        return documentEx != null ? documentEx.getModificationSequence() : (int)document.getModificationStamp();
    }

    @RequiresWriteLock
    public final void sendDidOpenRequest$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.getState() != LspServerState.Running) {
            this.logError$intellij_platform_lsp_impl("Server is not in the Running state. Ignoring sendDidOpenRequest(" + file + ")");
            return;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            this.logInfo$intellij_platform_lsp_impl("Skipping didOpen request because there's no document for file " + file);
            return;
        }
        if (this.openedFiles.add(file)) {
            TextDocumentItem textDocumentItem = new TextDocumentItem(this.getDescriptor().getFileUri(file), this.getDescriptor().getLanguageId(file), this.getDocumentVersion(document), document.getText());
            this.sendNotification((Function1<? super LanguageServer, Unit>)((Function1)arg_0 -> LspServerImpl.m(textDocumentItem, arg_0)));
            this.eventBroadcaster.fileOpened(this, file);
        } else {
            this.logError$intellij_platform_lsp_impl("sendDidOpenRequest() cannot be called for already opened files. Ignoring: " + file);
        }
    }

    public final void sendOpenedFiles$intellij_platform_lsp_impl() {
        ReadAction.nonBlocking(() -> LspServerImpl.m(this)).expireWhen(() -> LspServerImpl.m(this)).finishOnUiThread(ModalityState.nonModal(), arg_0 -> LspServerImpl.m(arg_0 -> LspServerImpl.m(this, arg_0), arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @RequiresWriteLock
    public final void sendDidCloseRequest$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.openedFiles.remove(file)) {
            this.logError$intellij_platform_lsp_impl("sendDidCloseRequest() cannot be called for files that haven't been opened. Ignoring: " + file);
            return;
        }
        DidCloseTextDocumentParams didCloseTextDocumentParams = new DidCloseTextDocumentParams(this.getDocumentIdentifier(file));
        this.sendNotification((Function1<? super LanguageServer, Unit>)((Function1)arg_0 -> LspServerImpl.m(didCloseTextDocumentParams, arg_0)));
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    public final boolean isSupportedFile$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isInLocalFileSystem()) {
            return false;
        }
        if (this.unsupportedFilePaths.contains(file.getPath())) {
            return false;
        }
        if (!ProjectFileIndex.getInstance((Project)this.getProject()).isInContent(file)) {
            return false;
        }
        boolean bl2 = bl = this.getDescriptor().isSupportedFile(file);
        boolean bl3 = false;
        if (!bl2) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            this.unsupportedFilePaths.add(string);
        }
        return bl;
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @NotNull
    public final Collection<VirtualFile> getFilesToClose$intellij_platform_lsp_impl() {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.getProject());
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        Iterable iterable = this.openedFiles;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t10 : iterable2) {
            Document document;
            boolean bl3;
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = (VirtualFile)t10;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)BackedVirtualFile.getOriginFileIfBacked((VirtualFile)virtualFile2), (String)"getOriginFileIfBacked(...)");
            if (!(fileEditorManager.isFileOpen(virtualFile) ? false : (bl3 = (document = FileDocumentManager.getInstance().getCachedDocument(virtualFile)) == null || !fileDocumentManager2.isDocumentUnsaved(document)))) continue;
            collection.add(t10);
        }
        return (List)collection;
    }

    public final void processFileEvents$intellij_platform_lsp_impl(@NotNull Collection<FileChangeInfo> fileChangeInfos) {
        Intrinsics.checkNotNullParameter(fileChangeInfos, (String)"fileChangeInfos");
        List<DidChangeWatchedFilesRegistrationOptions> list = this.dynamicCapabilities.getCapabilityRegistrationOptions(LspDynamicCapabilities.Companion.getDidChangeWatchedFiles());
        Iterable iterable = fileChangeInfos;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator = iterable3.iterator();
        while (iterator.hasNext()) {
            FileEvent fileEvent;
            Object t10;
            Object t11 = t10 = iterator.next();
            boolean bl4 = false;
            FileChangeInfo fileChangeInfo = (FileChangeInfo)t11;
            boolean bl5 = false;
            if (this.m(fileChangeInfo, list) == null) continue;
            boolean bl6 = false;
            collection.add(fileEvent);
        }
        List list2 = (List)collection;
        if (!((Collection)list2).isEmpty()) {
            this.sendNotification((Function1<? super LanguageServer, Unit>)((Function1)arg_0 -> LspServerImpl.m(list2, arg_0)));
        }
    }

    private final FileEvent m(FileChangeInfo fileChangeInfo, List<? extends DidChangeWatchedFilesRegistrationOptions> list) {
        for (DidChangeWatchedFilesRegistrationOptions didChangeWatchedFilesRegistrationOptions : list) {
            for (FileSystemWatcher fileSystemWatcher : didChangeWatchedFilesRegistrationOptions.getWatchers()) {
                String string;
                if (!fileChangeInfo.doesFileWatcherKindMatchFileChangeType(fileSystemWatcher.getKind())) continue;
                if (fileSystemWatcher.getGlobPattern().isLeft()) {
                    string = (String)fileSystemWatcher.getGlobPattern().getLeft();
                    FileInfo fileInfo = fileChangeInfo;
                    Intrinsics.checkNotNull((Object)string);
                    if (!this.m(fileInfo, string, null)) continue;
                    return new FileEvent(fileChangeInfo.getUri(), fileChangeInfo.getChangeType());
                }
                string = (RelativePattern)fileSystemWatcher.getGlobPattern().getRight();
                Object object = string.getBaseUri();
                if (object == null || (object = (WorkspaceFolder)object.getLeft()) == null || (object = object.getUri()) == null) {
                    object = (String)string.getBaseUri().getRight();
                }
                Object object2 = object;
                LspServerDescriptor lspServerDescriptor = this.getDescriptor();
                Intrinsics.checkNotNull((Object)object2);
                VirtualFile virtualFile = lspServerDescriptor.findFileByUri((String)object2);
                if (virtualFile == null || !virtualFile.isDirectory()) continue;
                String string2 = string.getPattern();
                FileInfo fileInfo = fileChangeInfo;
                Intrinsics.checkNotNull((Object)string2);
                if (!this.m(fileInfo, string2, virtualFile.getPath())) continue;
                return new FileEvent(fileChangeInfo.getUri(), fileChangeInfo.getChangeType());
            }
        }
        return null;
    }

    private final boolean m(FileInfo fileInfo, String string, String string2) {
        String string3;
        if (string2 == null) {
            string3 = fileInfo.getPath();
        } else if (Intrinsics.areEqual((Object)fileInfo.getPath(), (Object)string2)) {
            string3 = "";
        } else if (StringsKt.startsWith$default((String)fileInfo.getPath(), (String)(string2 + "/"), (boolean)false, (int)2, null)) {
            String string4 = fileInfo.getPath().substring(string2.length() + 1);
            string3 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        } else {
            return false;
        }
        String string5 = string3;
        if (fileInfo.isDirectory()) {
            return true;
        }
        PathMatcher pathMatcher = this.dynamicCapabilities.getPathMatcherCaching(string);
        return pathMatcher.matches(Path.of(string5, new String[0]));
    }

    public final void diagnosticsReceived$intellij_platform_lsp_impl(@NotNull PublishDiagnosticsParams params) {
        Document document;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        LspServerDescriptor lspServerDescriptor = this.getDescriptor();
        String string = params.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        VirtualFile virtualFile = lspServerDescriptor.findFileByUri(string);
        if (virtualFile != null && params.getVersion() != null && this.openedFiles.contains(virtualFile) && (document = FileDocumentManager.getInstance().getCachedDocument(virtualFile)) != null) {
            Integer n2 = params.getVersion();
            if (n2 == null || this.getDocumentVersion(document) != n2.intValue()) {
                this.logDebug$intellij_platform_lsp_impl("Ignoring diagnostics (version " + params.getVersion() + ") for " + virtualFile.getName() + "; current document version: " + this.getDocumentVersion(document));
                return;
            }
        }
        this.diagnosticsCache.diagnosticsReceived$intellij_platform_lsp_impl(virtualFile, params);
        if (virtualFile != null) {
            BuildersKt.launch$default((CoroutineScope)LspServerManagerImpl.Companion.getInstanceImpl(this.getProject()).getCs$intellij_platform_lsp_impl(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, virtualFile, null){
                int label;
                final /* synthetic */ LspServerImpl this$0;
                final /* synthetic */ VirtualFile $file;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = LspServerManagerImpl.Companion.restartCodeHighlighting$intellij_platform_lsp_impl(this.this$0.getProject(), this.$file, (Continuation<? super Unit>)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            LspServerImpl.access$getEventBroadcaster$p(this.this$0).diagnosticsReceived(this.this$0, this.$file);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public final void fileEdited$intellij_platform_lsp_impl(@NotNull VirtualFile file, @NotNull DocumentEvent e2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        this.semanticTokensCache.fileEdited$intellij_platform_lsp_impl(file, e2);
        this.diagnosticsCache.fileEdited$intellij_platform_lsp_impl(file, e2);
        this.documentColorCache.fileEdited$intellij_platform_lsp_impl(file, e2);
        this.documentLinkCache.fileEdited$intellij_platform_lsp_impl(file, e2);
    }

    public final void refreshSemanticTokens$intellij_platform_lsp_impl() {
        this.semanticTokensCache.clearCache$intellij_platform_lsp_impl();
        DaemonCodeAnalyzerEx.getInstanceEx((Project)this.getProject()).restart((Object)"LspServerImpl.refreshSemanticTokens");
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @NotNull
    public final List<LspCachedHighlighting<LspSemanticToken>> getSemanticTokens$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.semanticTokensCache.getHighlightings$intellij_platform_lsp_impl(file);
    }

    @RequiresBackgroundThread
    @NotNull
    public final List<DiagnosticAndQuickFixes> getDiagnosticsAndQuickFixes(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Iterable iterable = this.diagnosticsCache.getDiagnostics$intellij_platform_lsp_impl(file);
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t10 : iterable2) {
            LspDiagnosticsCache.DiagnosticAndLazyQuickFixes diagnosticAndLazyQuickFixes = (LspDiagnosticsCache.DiagnosticAndLazyQuickFixes)t10;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(new DiagnosticAndQuickFixes(diagnosticAndLazyQuickFixes.getDiagnostic(), diagnosticAndLazyQuickFixes.getQuickFixes(this, file)));
        }
        return (List)collection;
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @NotNull
    public final List<LspCachedHighlighting<Color>> getColorInfos$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.documentColorCache.getHighlightings$intellij_platform_lsp_impl(file);
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @NotNull
    public final List<LspCachedHighlighting<LspDocumentLink>> getDocumentLinkInfos$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.documentLinkCache.getHighlightings$intellij_platform_lsp_impl(file);
    }

    public final void notifyDocumentLinksReceived$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.eventBroadcaster.documentLinksReceived(this, file);
    }

    public final void start$intellij_platform_lsp_impl() {
        if (this.getState() != LspServerState.Initializing) {
            this.logError$intellij_platform_lsp_impl("start() cannot be called for a server twice");
            return;
        }
        this.logInfo$intellij_platform_lsp_impl("Starting LSP server");
        long l2 = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        ApplicationManager.getApplication().executeOnPooledThread(() -> LspServerImpl.m(this, l2));
    }

    private final Lsp4jServerConnector m() {
        Lsp4jServerConnector lsp4jServerConnector;
        LspCommunicationChannel lspCommunicationChannel = this.getDescriptor().getLspCommunicationChannel();
        if (lspCommunicationChannel instanceof LspCommunicationChannel.StdIO) {
            lsp4jServerConnector = new Lsp4jServerConnectorStdio(this);
        } else if (lspCommunicationChannel instanceof LspCommunicationChannel.Socket) {
            lsp4jServerConnector = new Lsp4jServerConnectorSocket(this);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return lsp4jServerConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensureServerStopped$intellij_platform_lsp_impl(boolean explicitStop, @NotNull Function0<Unit> updateLspServerManagerState) {
        Intrinsics.checkNotNullParameter(updateLspServerManagerState, (String)"updateLspServerManagerState");
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = false;
            updateLspServerManagerState.invoke();
            LspServerState[] lspServerStateArray = new LspServerState[]{LspServerState.ShutdownNormally, LspServerState.ShutdownUnexpectedly};
            if (ArraysKt.contains((Object[])lspServerStateArray, (Object)((Object)this.getState()))) {
                return;
            }
            this.logInfo$intellij_platform_lsp_impl("Stopping LSP server " + (explicitStop ? "normally" : "unexpectedly"));
            this.m(explicitStop ? LspServerState.ShutdownNormally : LspServerState.ShutdownUnexpectedly);
            this.openedFiles.clear();
            this.requestExecutor.shutdownNow$intellij_platform_lsp_impl();
            this.semanticTokensCache.clearCache$intellij_platform_lsp_impl();
            this.diagnosticsCache.clearCache$intellij_platform_lsp_impl();
            this.documentColorCache.clearCache$intellij_platform_lsp_impl();
            this.documentLinkCache.clearCache$intellij_platform_lsp_impl();
            Unit unit = Unit.INSTANCE;
        }
        this.m();
    }

    private final void m() {
        Runnable runnable = () -> LspServerImpl.m(this);
        if (ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isReadAccessAllowed()) {
            Future future = ApplicationManager.getApplication().executeOnPooledThread(runnable);
            Intrinsics.checkNotNull((Object)future);
        } else {
            runnable.run();
        }
    }

    public final boolean supportsDocumentColor$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getColorProvider()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl = false;
            Boolean bl2 = (Boolean)serverCapabilities2.getLeft();
            object = bl2 != null ? (Object)bl2 : (Object)true;
        } else {
            object = this.m(file, LspDynamicCapabilities.Companion.getDocumentColor());
        }
        return (boolean)object;
    }

    public final boolean supportsDocumentLink$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        return (serverCapabilities != null ? serverCapabilities.getDocumentLinkProvider() : null) != null || this.m(file, LspDynamicCapabilities.Companion.getDocumentLink()) != false;
    }

    public final boolean supportsCodeActions$intellij_platform_lsp_impl(@NotNull Function1<? super List<String>, Boolean> codeActionKindsFilter) {
        Either either;
        Intrinsics.checkNotNullParameter(codeActionKindsFilter, (String)"codeActionKindsFilter");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (either = serverCapabilities.getCodeActionProvider()) != null) {
            Either either2 = either;
            boolean bl = false;
            if (either2.isLeft()) {
                Object object = either2.getLeft();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLeft(...)");
                return (Boolean)object;
            }
            List list = ((CodeActionOptions)either2.getRight()).getCodeActionKinds();
            if (list == null) {
                return true;
            }
            return (Boolean)codeActionKindsFilter.invoke((Object)list);
        }
        return false;
    }

    public final boolean supportsGotoDefinition$intellij_platform_lsp_impl() {
        boolean bl;
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getDefinitionProvider()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl2 = false;
            Boolean bl3 = (Boolean)serverCapabilities2.getLeft();
            bl = bl3 != null ? bl3 : true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean supportsGotoTypeDefinition$intellij_platform_lsp_impl() {
        boolean bl;
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getTypeDefinitionProvider()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl2 = false;
            Boolean bl3 = (Boolean)serverCapabilities2.getLeft();
            bl = bl3 != null ? bl3 : true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean supportsHover$intellij_platform_lsp_impl() {
        boolean bl;
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getHoverProvider()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl2 = false;
            Boolean bl3 = (Boolean)serverCapabilities2.getLeft();
            bl = bl3 != null ? bl3 : true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean supportsFindReferences$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getReferencesProvider()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl = false;
            Boolean bl2 = (Boolean)serverCapabilities2.getLeft();
            object = bl2 != null ? (Object)bl2 : (Object)true;
        } else {
            object = this.m(file, LspDynamicCapabilities.Companion.getReferences());
        }
        return (boolean)object;
    }

    @Nullable
    public final SaveOptions getDidSaveOptions$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        SaveOptions saveOptions;
        Either either;
        TextDocumentSyncOptions textDocumentSyncOptions;
        Either either2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getTextDocumentSync()) != null && (serverCapabilities = (TextDocumentSyncOptions)serverCapabilities.getRight()) != null && (serverCapabilities = serverCapabilities.getSave()) != null ? Intrinsics.areEqual((Object)serverCapabilities.getLeft(), (Object)true) : false) {
            return new SaveOptions(Boolean.valueOf(false));
        }
        ServerCapabilities serverCapabilities2 = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities2 != null && (either2 = serverCapabilities2.getTextDocumentSync()) != null && (textDocumentSyncOptions = (TextDocumentSyncOptions)either2.getRight()) != null && (either = textDocumentSyncOptions.getSave()) != null && (saveOptions = (SaveOptions)either.getRight()) != null) {
            SaveOptions saveOptions2 = saveOptions;
            boolean bl = false;
            return saveOptions2;
        }
        serverCapabilities2 = this.m(file, LspDynamicCapabilities.Companion.getDidSave());
        if (serverCapabilities2 != null) {
            textDocumentSyncOptions = serverCapabilities2;
            boolean bl = false;
            return new SaveOptions(textDocumentSyncOptions.getIncludeText());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasFormattingRelatedCapabilities$intellij_platform_lsp_impl() {
        if (this.dynamicCapabilities.hasCapability(LspDynamicCapabilities.Companion.getFormatting())) return true;
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        ServerCapabilities serverCapabilities2 = serverCapabilities;
        if (serverCapabilities == null) return false;
        Either either = serverCapabilities2.getDocumentFormattingProvider();
        serverCapabilities2 = either;
        if (either == null) return false;
        ServerCapabilities serverCapabilities3 = serverCapabilities2;
        boolean bl = false;
        Boolean bl2 = (Boolean)serverCapabilities3.getLeft();
        if (bl2 == null) return true;
        boolean bl3 = bl2;
        if (!bl3) return false;
        return true;
    }

    public final boolean doesServerExplicitlyWantToFormatThisFile$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (boolean)this.m(file, LspDynamicCapabilities.Companion.getFormatting());
    }

    private final <T extends TextDocumentRegistrationOptions> boolean m(VirtualFile virtualFile, Pair<String, Class<T>> pair) {
        return this.m(virtualFile, pair) != null;
    }

    private final <T extends TextDocumentRegistrationOptions> T m(VirtualFile virtualFile, Pair<String, Class<T>> pair) {
        if (virtualFile.isDirectory()) {
            LspServerImpl.logWarn$intellij_platform_lsp_impl$default(this, "Directory not expected here. Capability: " + pair.getFirst() + ", file: " + virtualFile.getPath(), null, 2, null);
            return null;
        }
        for (TextDocumentRegistrationOptions textDocumentRegistrationOptions : this.dynamicCapabilities.getCapabilityRegistrationOptions(pair)) {
            List list;
            if (textDocumentRegistrationOptions.getDocumentSelector() == null) {
                return (T)textDocumentRegistrationOptions;
            }
            for (DocumentFilter documentFilter : list) {
                if (documentFilter.getScheme() != null && !Intrinsics.areEqual((Object)documentFilter.getScheme(), (Object)"file")) continue;
                String string = documentFilter.getLanguage();
                String string2 = documentFilter.getPattern();
                if (string == null && string2 == null || string != null && !Intrinsics.areEqual((Object)string, (Object)this.getDescriptor().getLanguageId(virtualFile))) continue;
                if (string2 != null) {
                    String string3 = virtualFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                    if (!this.m(new FileInfo(string3, false), string2, null)) continue;
                }
                return (T)textDocumentRegistrationOptions;
            }
        }
        return null;
    }

    public final void appendServerErrorOutput$intellij_platform_lsp_impl(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!(((CharSequence)this.errorOutputBuffer).length() == 0)) {
            this.errorOutputBuffer.append("\n");
        }
        if (text.length() > 0x100000) {
            int n2 = this.errorOutputBuffer.length();
            String string = text.substring(text.length() - 0x100000);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            v2 = this.errorOutputBuffer.replace(0, n2, string);
        } else if (this.errorOutputBuffer.length() + text.length() > 0x100000) {
            this.errorOutputBuffer.delete(0, this.errorOutputBuffer.length() + text.length() - 0x100000);
            v2 = this.errorOutputBuffer.append(text);
        } else {
            v2 = this.errorOutputBuffer.append(text);
        }
    }

    @NotNull
    public String toString() {
        return this.getDescriptor() + "(" + this.getState() + ";" + this.openedFiles.size() + ")";
    }

    public final void logDebug$intellij_platform_lsp_impl(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LspServerImplKt.access$getLogger$p().debug(this.m(message));
    }

    public final void logInfo$intellij_platform_lsp_impl(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LspServerImplKt.access$getLogger$p().info(this.m(message));
    }

    public final void logWarn$intellij_platform_lsp_impl(@NotNull String message, @Nullable Throwable t10) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LspServerImplKt.access$getLogger$p().warn(this.m(message), t10);
    }

    public static /* synthetic */ void logWarn$intellij_platform_lsp_impl$default(LspServerImpl lspServerImpl, String string, Throwable throwable, int n2, Object object) {
        if ((n2 & 2) != 0) {
            throwable = null;
        }
        lspServerImpl.logWarn$intellij_platform_lsp_impl(string, throwable);
    }

    public final void logError$intellij_platform_lsp_impl(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LspServerImplKt.access$getLogger$p().error(this.m(message));
    }

    private final String m(String string) {
        return this + ": " + string;
    }

    private static final Unit m(TextDocumentItem textDocumentItem, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        languageServer.getTextDocumentService().didOpen(new DidOpenTextDocumentParams(textDocumentItem));
        return Unit.INSTANCE;
    }

    private static final Set m(LspServerImpl lspServerImpl) {
        Set set = new HashSet();
        for (VirtualFile virtualFile : FileEditorManager.getInstance((Project)lspServerImpl.getProject()).getOpenFiles()) {
            if (lspServerImpl.openedFiles.contains(virtualFile)) continue;
            Intrinsics.checkNotNull((Object)virtualFile);
            if (!lspServerImpl.isSupportedFile$intellij_platform_lsp_impl(virtualFile)) continue;
            set.add(virtualFile);
        }
        for (VirtualFile virtualFile : FileDocumentManager.getInstance().getUnsavedDocuments()) {
            VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile((Document)virtualFile);
            if (virtualFile2 == null || lspServerImpl.openedFiles.contains(virtualFile2) || !lspServerImpl.isSupportedFile$intellij_platform_lsp_impl(virtualFile2)) continue;
            set.add(virtualFile2);
        }
        return set;
    }

    private static final boolean m(LspServerImpl lspServerImpl) {
        return lspServerImpl.getState() != LspServerState.Running;
    }

    private static final void m(LspServerImpl lspServerImpl, Set set) {
        lspServerImpl.logDebug$intellij_platform_lsp_impl("Opening files after server initialization or after move/rename: " + set);
        Iterable iterable = set;
        boolean bl = false;
        for (Object t10 : iterable) {
            VirtualFile virtualFile = (VirtualFile)t10;
            boolean bl2 = false;
            lspServerImpl.sendDidOpenRequest$intellij_platform_lsp_impl(virtualFile);
        }
    }

    private static final Unit m(LspServerImpl lspServerImpl, Set set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"files");
        if (set.isEmpty()) {
            return Unit.INSTANCE;
        }
        WriteAction.run(() -> LspServerImpl.m(lspServerImpl, set));
        return Unit.INSTANCE;
    }

    private static final void m(Function1 function1, Object object) {
        function1.invoke(object);
    }

    private static final Unit m(DidCloseTextDocumentParams didCloseTextDocumentParams, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        languageServer.getTextDocumentService().didClose(didCloseTextDocumentParams);
        return Unit.INSTANCE;
    }

    private static final Unit m(List list, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        languageServer.getWorkspaceService().didChangeWatchedFiles(new DidChangeWatchedFilesParams(list));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit m(LspServerImpl lspServerImpl, long l2, InitializeResult initializeResult) {
        block9: {
            Object object;
            LspServerImpl lspServerImpl2;
            block8: {
                String string;
                block7: {
                    Intrinsics.checkNotNullParameter((Object)initializeResult, (String)"initializeResult");
                    lspServerImpl.initializeResult = initializeResult;
                    Object object2 = lspServerImpl.stateLock;
                    synchronized (object2) {
                        boolean bl = false;
                        if (lspServerImpl.getState() == LspServerState.Initializing) {
                            lspServerImpl.m(LspServerState.Running);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    string = "LSP server initialized in " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)l2), (DurationUnit)DurationUnit.SECONDS, (int)3);
                    lspServerImpl2 = lspServerImpl;
                    object = initializeResult.getServerInfo();
                    if (object == null) break block7;
                    ServerInfo serverInfo = object;
                    LspServerImpl lspServerImpl3 = lspServerImpl2;
                    boolean bl = false;
                    String string2 = string + ", name = " + serverInfo.getName() + ", version = " + serverInfo.getVersion();
                    lspServerImpl2 = lspServerImpl3;
                    object = string2;
                    if (string2 != null) break block8;
                }
                object = string;
            }
            lspServerImpl2.logInfo$intellij_platform_lsp_impl((String)object);
            LspServerListener lspServerListener = lspServerImpl.getDescriptor().getLspServerListener();
            if (lspServerListener == null) break block9;
            lspServerListener.serverInitialized(initializeResult);
        }
        return Unit.INSTANCE;
    }

    private static final LspServerManagerImpl m(LspServerImpl lspServerImpl) {
        return !lspServerImpl.getProject().isDisposed() ? LspServerManagerImpl.Companion.getInstanceImpl(lspServerImpl.getProject()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void m(LspServerImpl lspServerImpl, long l2) {
        block7: {
            try {
                Object object = lspServerImpl.connectorLock;
                synchronized (object) {
                    boolean bl = false;
                    lspServerImpl.lsp4jServerConnector = lspServerImpl.m();
                    Lsp4jServerConnector lsp4jServerConnector = lspServerImpl.lsp4jServerConnector;
                    if (lsp4jServerConnector == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"lsp4jServerConnector");
                        lsp4jServerConnector = null;
                    }
                    lsp4jServerConnector.connect$intellij_platform_lsp_impl((Function1<? super InitializeResult, Unit>)((Function1)arg_0 -> LspServerImpl.m(lspServerImpl, l2, arg_0)));
                    Unit unit = Unit.INSTANCE;
                }
                lspServerImpl.sendOpenedFiles$intellij_platform_lsp_impl();
            }
            catch (Exception exception) {
                Throwable throwable = exception instanceof LspInitializationException ? (LspInitializationException)exception : null;
                if (throwable == null || (throwable = throwable.getCause()) == null) {
                    throwable = exception;
                }
                Throwable throwable2 = throwable;
                lspServerImpl.logWarn$intellij_platform_lsp_impl("Failed to start LSP server", throwable2);
                LspServerManagerImpl lspServerManagerImpl = (LspServerManagerImpl)ReadAction.compute(() -> LspServerImpl.m(lspServerImpl));
                String string = (String)(exception instanceof LspInitializationException ? exception + "\nCaused by:\n" : "") + ExceptionsKt.stackTraceToString((Throwable)throwable2);
                LspServerManagerImpl lspServerManagerImpl2 = lspServerManagerImpl;
                if (lspServerManagerImpl2 == null) break block7;
                lspServerManagerImpl2.handleMaybeUnexpectedServerStop$intellij_platform_lsp_impl(lspServerImpl, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void m(LspServerImpl lspServerImpl) {
        Object object = lspServerImpl.connectorLock;
        synchronized (object) {
            boolean bl = false;
            if (lspServerImpl.lsp4jServerConnector != null) {
                Lsp4jServerConnector lsp4jServerConnector = lspServerImpl.lsp4jServerConnector;
                if (lsp4jServerConnector == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lsp4jServerConnector");
                    lsp4jServerConnector = null;
                }
                lsp4jServerConnector.shutdownExitDisconnect$intellij_platform_lsp_impl();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ LspServerManagerListener access$getEventBroadcaster$p(LspServerImpl $this) {
        return $this.eventBroadcaster;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerImpl$Companion;", "", "LspServerImpl$Companion", "()V", "NOT_CANCELLABLE_REQUEST_TIMEOUT_MS", "", "MAX_ERROR_OUTPUT_SIZE", "intellij.platform.lsp.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerImpl$FileChangeInfo;", "Lcom/intellij/platform/lsp/impl/LspServerImpl$FileInfo;", "path", "", "uri", "isDirectory", "", "changeType", "Lorg/eclipse/lsp4j/FileChangeType;", "LspServerImpl$FileChangeInfo", "(Ljava/lang/String;Ljava/lang/String;ZLorg/eclipse/lsp4j/FileChangeType;)V", "getUri", "()Ljava/lang/String;", "getChangeType", "()Lorg/eclipse/lsp4j/FileChangeType;", "doesFileWatcherKindMatchFileChangeType", "watchKind", "", "(Ljava/lang/Integer;)Z", "intellij.platform.lsp.impl"})
    public static final class FileChangeInfo
    extends FileInfo {
        @NotNull
        private final String uri;
        @NotNull
        private final FileChangeType changeType;

        public FileChangeInfo(@NotNull String path, @NotNull String uri, boolean isDirectory, @NotNull FileChangeType changeType) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)changeType, (String)"changeType");
            super(path, isDirectory);
            this.uri = uri;
            this.changeType = changeType;
        }

        @NotNull
        public final String getUri() {
            return this.uri;
        }

        @NotNull
        public final FileChangeType getChangeType() {
            return this.changeType;
        }

        public final boolean doesFileWatcherKindMatchFileChangeType(@Nullable Integer watchKind) {
            if (watchKind == null) {
                return true;
            }
            return switch (WhenMappings.$EnumSwitchMapping$0[this.changeType.ordinal()]) {
                case 1 -> {
                    if ((watchKind & 1) != 0) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if ((watchKind & 2) != 0) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if ((watchKind & 4) != 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FileChangeType.values().length];
                try {
                    nArray[FileChangeType.Created.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FileChangeType.Changed.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FileChangeType.Deleted.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerImpl$FileInfo;", "", "path", "", "isDirectory", "", "LspServerImpl$FileInfo", "(Ljava/lang/String;Z)V", "getPath", "()Ljava/lang/String;", "()Z", "intellij.platform.lsp.impl"})
    public static class FileInfo {
        @NotNull
        private final String path;
        private final boolean isDirectory;

        public FileInfo(@NotNull String path, boolean isDirectory) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
            this.isDirectory = isDirectory;
        }

        @NotNull
        public String getPath() {
            return this.path;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }
    }
}

