/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.GlobUtilKt;
import com.intellij.util.containers.MultiMap;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.CallHierarchyRegistrationOptions;
import org.eclipse.lsp4j.CodeActionRegistrationOptions;
import org.eclipse.lsp4j.CodeLensRegistrationOptions;
import org.eclipse.lsp4j.CompletionRegistrationOptions;
import org.eclipse.lsp4j.DeclarationRegistrationOptions;
import org.eclipse.lsp4j.DefinitionRegistrationOptions;
import org.eclipse.lsp4j.DiagnosticRegistrationOptions;
import org.eclipse.lsp4j.DidChangeWatchedFilesRegistrationOptions;
import org.eclipse.lsp4j.DocumentFormattingRegistrationOptions;
import org.eclipse.lsp4j.DocumentHighlightRegistrationOptions;
import org.eclipse.lsp4j.DocumentLinkRegistrationOptions;
import org.eclipse.lsp4j.DocumentOnTypeFormattingRegistrationOptions;
import org.eclipse.lsp4j.DocumentRangeFormattingRegistrationOptions;
import org.eclipse.lsp4j.DocumentSymbolRegistrationOptions;
import org.eclipse.lsp4j.ExecuteCommandRegistrationOptions;
import org.eclipse.lsp4j.HoverRegistrationOptions;
import org.eclipse.lsp4j.ImplementationRegistrationOptions;
import org.eclipse.lsp4j.InlayHintRegistrationOptions;
import org.eclipse.lsp4j.InlineValueRegistrationOptions;
import org.eclipse.lsp4j.LinkedEditingRangeRegistrationOptions;
import org.eclipse.lsp4j.MonikerRegistrationOptions;
import org.eclipse.lsp4j.ReferenceRegistrationOptions;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.SelectionRangeRegistrationOptions;
import org.eclipse.lsp4j.SignatureHelpRegistrationOptions;
import org.eclipse.lsp4j.TextDocumentChangeRegistrationOptions;
import org.eclipse.lsp4j.TextDocumentRegistrationOptions;
import org.eclipse.lsp4j.TextDocumentSaveRegistrationOptions;
import org.eclipse.lsp4j.TypeDefinitionRegistrationOptions;
import org.eclipse.lsp4j.TypeHierarchyRegistrationOptions;
import org.eclipse.lsp4j.Unregistration;
import org.eclipse.lsp4j.WorkspaceSymbolRegistrationOptions;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u0000 !2\u00020\u0001:\u0002 !B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0006J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006J\u001e\u0010\u0017\u001a\u00020\u00182\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bJ,\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u001e\"\u0004\b\u0000\u0010\u001f2\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001f0\u001c0\u001bR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/platform/lsp/impl/LspDynamicCapabilities;", "", "LspDynamicCapabilities", "()V", "capabilityToInfo", "Lcom/intellij/util/containers/MultiMap;", "", "Lcom/intellij/platform/lsp/impl/LspDynamicCapabilities$CapabilityInfo;", "gson", "Lcom/google/gson/Gson;", "patternToPathMatcherCache", "", "Ljava/nio/file/PathMatcher;", "registerCapability", "", "registration", "Lorg/eclipse/lsp4j/Registration;", "unregisterCapability", "unregistration", "Lorg/eclipse/lsp4j/Unregistration;", "getPathMatcherCaching", "globPattern", "m", "hasCapability", "", "capability", "capabilityAndOptionsClass", "Lkotlin/Pair;", "Ljava/lang/Class;", "getCapabilityRegistrationOptions", "", "T", "CapabilityInfo", "Companion", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspDynamicCapabilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspDynamicCapabilities.kt\ncom/intellij/platform/lsp/impl/LspDynamicCapabilities\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n381#2,7:176\n25#3:183\n1611#4,9:184\n1863#4:193\n1864#4:195\n1620#4:196\n1#5:194\n*S KotlinDebug\n*F\n+ 1 LspDynamicCapabilities.kt\ncom/intellij/platform/lsp/impl/LspDynamicCapabilities\n*L\n129#1:176,7\n138#1:183\n172#1:184,9\n172#1:193\n172#1:195\n172#1:196\n172#1:194\n*E\n"})
public final class LspDynamicCapabilities {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiMap<String, CapabilityInfo> capabilityToInfo;
    @NotNull
    private final Gson gson;
    @NotNull
    private final Map<String, PathMatcher> patternToPathMatcherCache;
    @NotNull
    private static final Pair<String, Class<CallHierarchyRegistrationOptions>> prepareCallHierarchy = TuplesKt.to((Object)"textDocument/prepareCallHierarchy", CallHierarchyRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<CodeActionRegistrationOptions>> codeAction = TuplesKt.to((Object)"textDocument/codeAction", CodeActionRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<CodeLensRegistrationOptions>> codeLens = TuplesKt.to((Object)"textDocument/codeLens", CodeLensRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<CompletionRegistrationOptions>> completion = TuplesKt.to((Object)"textDocument/completion", CompletionRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DeclarationRegistrationOptions>> declaration = TuplesKt.to((Object)"textDocument/declaration", DeclarationRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DefinitionRegistrationOptions>> definition = TuplesKt.to((Object)"textDocument/definition", DefinitionRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DiagnosticRegistrationOptions>> diagnostic = TuplesKt.to((Object)"textDocument/diagnostic", DiagnosticRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DidChangeWatchedFilesRegistrationOptions>> didChangeWatchedFiles = TuplesKt.to((Object)"workspace/didChangeWatchedFiles", DidChangeWatchedFilesRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DocumentFormattingRegistrationOptions>> formatting = TuplesKt.to((Object)"textDocument/formatting", DocumentFormattingRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DocumentHighlightRegistrationOptions>> documentHighlight = TuplesKt.to((Object)"textDocument/documentHighlight", DocumentHighlightRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DocumentLinkRegistrationOptions>> documentLink = TuplesKt.to((Object)"textDocument/documentLink", DocumentLinkRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DocumentOnTypeFormattingRegistrationOptions>> onTypeFormatting = TuplesKt.to((Object)"textDocument/onTypeFormatting", DocumentOnTypeFormattingRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DocumentRangeFormattingRegistrationOptions>> rangeFormatting = TuplesKt.to((Object)"textDocument/rangeFormatting", DocumentRangeFormattingRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DocumentSymbolRegistrationOptions>> documentSymbol = TuplesKt.to((Object)"textDocument/documentSymbol", DocumentSymbolRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<ExecuteCommandRegistrationOptions>> executeCommand = TuplesKt.to((Object)"workspace/executeCommand", ExecuteCommandRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<HoverRegistrationOptions>> hover = TuplesKt.to((Object)"textDocument/hover", HoverRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<ImplementationRegistrationOptions>> implementation = TuplesKt.to((Object)"textDocument/implementation", ImplementationRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<InlayHintRegistrationOptions>> inlayHint = TuplesKt.to((Object)"textDocument/inlayHint", InlayHintRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<InlineValueRegistrationOptions>> inlineValue = TuplesKt.to((Object)"textDocument/inlineValue", InlineValueRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<LinkedEditingRangeRegistrationOptions>> linkedEditingRange = TuplesKt.to((Object)"textDocument/linkedEditingRange", LinkedEditingRangeRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<MonikerRegistrationOptions>> moniker = TuplesKt.to((Object)"textDocument/moniker", MonikerRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<ReferenceRegistrationOptions>> references = TuplesKt.to((Object)"textDocument/references", ReferenceRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<SelectionRangeRegistrationOptions>> selectionRange = TuplesKt.to((Object)"textDocument/selectionRange", SelectionRangeRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<SignatureHelpRegistrationOptions>> signatureHelp = TuplesKt.to((Object)"textDocument/signatureHelp", SignatureHelpRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<TextDocumentChangeRegistrationOptions>> didChange = TuplesKt.to((Object)"textDocument/didChange", TextDocumentChangeRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<TextDocumentRegistrationOptions>> didOpen = TuplesKt.to((Object)"textDocument/didOpen", TextDocumentRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<TextDocumentRegistrationOptions>> willSave = TuplesKt.to((Object)"textDocument/willSave", TextDocumentRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<TextDocumentRegistrationOptions>> willSaveWaitUntil = TuplesKt.to((Object)"textDocument/willSaveWaitUntil", TextDocumentRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<TextDocumentRegistrationOptions>> didClose = TuplesKt.to((Object)"textDocument/didClose", TextDocumentRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<TextDocumentRegistrationOptions>> documentColor = TuplesKt.to((Object)"textDocument/documentColor", TextDocumentRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<TextDocumentSaveRegistrationOptions>> didSave = TuplesKt.to((Object)"textDocument/didSave", TextDocumentSaveRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<TypeDefinitionRegistrationOptions>> typeDefinition = TuplesKt.to((Object)"textDocument/typeDefinition", TypeDefinitionRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<TypeHierarchyRegistrationOptions>> prepareTypeHierarchy = TuplesKt.to((Object)"textDocument/prepareTypeHierarchy", TypeHierarchyRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<WorkspaceSymbolRegistrationOptions>> symbol = TuplesKt.to((Object)"workspace/symbol", WorkspaceSymbolRegistrationOptions.class);
    @NotNull
    private static final Map<String, Class<?>> capabilityToLsp4jRegistrationOptionsClass;

    public LspDynamicCapabilities() {
        MultiMap multiMap = MultiMap.createConcurrent();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createConcurrent(...)");
        this.capabilityToInfo = multiMap;
        Gson gson = new MessageJsonHandler(MapsKt.emptyMap()).getGson();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"getGson(...)");
        this.gson = gson;
        this.patternToPathMatcherCache = new HashMap();
    }

    public final void registerCapability(@NotNull Registration registration) {
        Intrinsics.checkNotNullParameter((Object)registration, (String)"registration");
        String string = registration.getMethod();
        String string2 = registration.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        Object object = registration.getRegisterOptions();
        this.capabilityToInfo.putValue((Object)string, (Object)new CapabilityInfo(string2, object instanceof JsonObject ? (JsonObject)object : null, this.m(registration)));
    }

    public final void unregisterCapability(@NotNull Unregistration unregistration) {
        Intrinsics.checkNotNullParameter((Object)unregistration, (String)"unregistration");
        Collection collection = this.capabilityToInfo.get((Object)unregistration.getMethod());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Collection collection2 = collection;
        collection2.removeIf(arg_0 -> LspDynamicCapabilities.m(arg_0 -> LspDynamicCapabilities.m(unregistration, arg_0), arg_0));
        if (collection2.isEmpty()) {
            this.capabilityToInfo.remove((Object)unregistration.getMethod());
        }
    }

    @NotNull
    public final PathMatcher getPathMatcherCaching(@NotNull String globPattern) {
        PathMatcher pathMatcher;
        Intrinsics.checkNotNullParameter((Object)globPattern, (String)"globPattern");
        Map<String, PathMatcher> map = this.patternToPathMatcherCache;
        boolean bl = false;
        PathMatcher pathMatcher2 = map.get(globPattern);
        if (pathMatcher2 == null) {
            boolean bl2 = false;
            PathMatcher pathMatcher3 = GlobUtilKt.getPathMatcher$default((String)globPattern, (boolean)false, (int)2, null);
            map.put(globPattern, pathMatcher3);
            pathMatcher = pathMatcher3;
        } else {
            pathMatcher = pathMatcher2;
        }
        return pathMatcher;
    }

    private final Object m(Registration registration) {
        Object object = registration.getRegisterOptions();
        JsonObject jsonObject = object instanceof JsonObject ? (JsonObject)object : null;
        if (jsonObject == null) {
            return null;
        }
        JsonObject jsonObject2 = jsonObject;
        Class<?> clazz = capabilityToLsp4jRegistrationOptionsClass.get(registration.getMethod());
        if (clazz == null) {
            return null;
        }
        Class<?> clazz2 = clazz;
        try {
            return this.gson.fromJson((JsonElement)jsonObject2, clazz2);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            LspDynamicCapabilities lspDynamicCapabilities = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(LspDynamicCapabilities.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to convert options of `" + registration.getMethod() + "` to " + clazz2.getSimpleName() + " class: " + jsonSyntaxException + "\n" + jsonObject2);
            return null;
        }
    }

    public final boolean hasCapability(@NotNull String capability) {
        Intrinsics.checkNotNullParameter((Object)capability, (String)"capability");
        return this.capabilityToInfo.containsKey((Object)capability);
    }

    public final boolean hasCapability(@NotNull Pair<String, ? extends Class<?>> capabilityAndOptionsClass) {
        Intrinsics.checkNotNullParameter(capabilityAndOptionsClass, (String)"capabilityAndOptionsClass");
        return this.hasCapability((String)capabilityAndOptionsClass.getFirst());
    }

    @NotNull
    public final <T> List<T> getCapabilityRegistrationOptions(@NotNull Pair<String, Class<T>> capabilityAndOptionsClass) {
        Intrinsics.checkNotNullParameter(capabilityAndOptionsClass, (String)"capabilityAndOptionsClass");
        Collection collection = this.capabilityToInfo.get(capabilityAndOptionsClass.getFirst());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Iterable iterable = collection;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator = iterable3.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object t10;
            Object t11 = t10 = iterator.next();
            boolean bl4 = false;
            CapabilityInfo capabilityInfo = (CapabilityInfo)t11;
            boolean bl5 = false;
            if (capabilityInfo.getLsp4jRegistrationOptions() == null) continue;
            boolean bl6 = false;
            collection2.add(object);
        }
        return CollectionsKt.filterIsInstance((Iterable)((List)collection2), (Class)((Class)capabilityAndOptionsClass.getSecond()));
    }

    private static final boolean m(Unregistration unregistration, CapabilityInfo capabilityInfo) {
        return Intrinsics.areEqual((Object)capabilityInfo.getRegistrationId(), (Object)unregistration.getId());
    }

    private static final boolean m(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }

    static {
        Pair[] pairArray = new Pair[]{prepareCallHierarchy, codeAction, codeLens, completion, declaration, definition, diagnostic, didChangeWatchedFiles, formatting, documentHighlight, documentLink, onTypeFormatting, rangeFormatting, documentSymbol, executeCommand, hover, implementation, inlayHint, inlineValue, linkedEditingRange, moniker, references, selectionRange, signatureHelp, didChange, didOpen, willSave, willSaveWaitUntil, didClose, documentColor, didSave, typeDefinition, prepareTypeHierarchy, symbol};
        capabilityToLsp4jRegistrationOptionsClass = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J+\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/lsp/impl/LspDynamicCapabilities$CapabilityInfo;", "", "registrationId", "", "rawRegistrationOptions", "Lcom/google/gson/JsonObject;", "lsp4jRegistrationOptions", "LspDynamicCapabilities$CapabilityInfo", "(Ljava/lang/String;Lcom/google/gson/JsonObject;Ljava/lang/Object;)V", "getRegistrationId", "()Ljava/lang/String;", "getRawRegistrationOptions", "()Lcom/google/gson/JsonObject;", "getLsp4jRegistrationOptions", "()Ljava/lang/Object;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.lsp.impl"})
    private static final class CapabilityInfo {
        @NotNull
        private final String registrationId;
        @Nullable
        private final JsonObject rawRegistrationOptions;
        @Nullable
        private final Object lsp4jRegistrationOptions;

        public CapabilityInfo(@NotNull String registrationId, @Nullable JsonObject rawRegistrationOptions, @Nullable Object lsp4jRegistrationOptions) {
            Intrinsics.checkNotNullParameter((Object)registrationId, (String)"registrationId");
            this.registrationId = registrationId;
            this.rawRegistrationOptions = rawRegistrationOptions;
            this.lsp4jRegistrationOptions = lsp4jRegistrationOptions;
        }

        @NotNull
        public final String getRegistrationId() {
            return this.registrationId;
        }

        @Nullable
        public final JsonObject getRawRegistrationOptions() {
            return this.rawRegistrationOptions;
        }

        @Nullable
        public final Object getLsp4jRegistrationOptions() {
            return this.lsp4jRegistrationOptions;
        }

        @NotNull
        public final String component1() {
            return this.registrationId;
        }

        @Nullable
        public final JsonObject component2() {
            return this.rawRegistrationOptions;
        }

        @Nullable
        public final Object component3() {
            return this.lsp4jRegistrationOptions;
        }

        @NotNull
        public final CapabilityInfo copy(@NotNull String registrationId, @Nullable JsonObject rawRegistrationOptions, @Nullable Object lsp4jRegistrationOptions) {
            Intrinsics.checkNotNullParameter((Object)registrationId, (String)"registrationId");
            return new CapabilityInfo(registrationId, rawRegistrationOptions, lsp4jRegistrationOptions);
        }

        public static /* synthetic */ CapabilityInfo copy$default(CapabilityInfo capabilityInfo, String string, JsonObject jsonObject, Object object, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                string = capabilityInfo.registrationId;
            }
            if ((n2 & 2) != 0) {
                jsonObject = capabilityInfo.rawRegistrationOptions;
            }
            if ((n2 & 4) != 0) {
                object = capabilityInfo.lsp4jRegistrationOptions;
            }
            return capabilityInfo.copy(string, jsonObject, object);
        }

        @NotNull
        public String toString() {
            return "CapabilityInfo(registrationId=" + this.registrationId + ", rawRegistrationOptions=" + this.rawRegistrationOptions + ", lsp4jRegistrationOptions=" + this.lsp4jRegistrationOptions + ")";
        }

        public int hashCode() {
            int n2 = this.registrationId.hashCode();
            n2 = n2 * 31 + (this.rawRegistrationOptions == null ? 0 : this.rawRegistrationOptions.hashCode());
            n2 = n2 * 31 + (this.lsp4jRegistrationOptions == null ? 0 : this.lsp4jRegistrationOptions.hashCode());
            return n2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CapabilityInfo)) {
                return false;
            }
            CapabilityInfo capabilityInfo = (CapabilityInfo)other;
            if (!Intrinsics.areEqual((Object)this.registrationId, (Object)capabilityInfo.registrationId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rawRegistrationOptions, (Object)capabilityInfo.rawRegistrationOptions)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lsp4jRegistrationOptions, (Object)capabilityInfo.lsp4jRegistrationOptions);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR#\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR#\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR#\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR#\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR#\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\nR#\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\nR#\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\nR#\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\nR#\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\nR#\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\nR#\u0010)\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\nR#\u0010,\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\nR#\u0010/\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002000\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\nR#\u00102\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002030\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\nR#\u00105\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002060\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\nR#\u00108\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002090\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\nR#\u0010;\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\nR#\u0010>\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020?0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\nR#\u0010A\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020B0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\nR#\u0010D\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\nR#\u0010G\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020H0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010\nR#\u0010J\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020K0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010\nR#\u0010M\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020N0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\nR#\u0010P\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020Q0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010\nR#\u0010S\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020T0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\nR#\u0010V\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020T0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010\nR#\u0010X\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020T0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010\nR#\u0010Z\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020T0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\nR#\u0010\\\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020T0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010\nR#\u0010^\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020_0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010\nR#\u0010a\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010\nR#\u0010d\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020e0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010\nR#\u0010g\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020h0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010\nR\u001e\u0010j\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070kX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Lcom/intellij/platform/lsp/impl/LspDynamicCapabilities$Companion;", "", "LspDynamicCapabilities$Companion", "()V", "prepareCallHierarchy", "Lkotlin/Pair;", "", "Ljava/lang/Class;", "Lorg/eclipse/lsp4j/CallHierarchyRegistrationOptions;", "getPrepareCallHierarchy", "()Lkotlin/Pair;", "codeAction", "Lorg/eclipse/lsp4j/CodeActionRegistrationOptions;", "getCodeAction", "codeLens", "Lorg/eclipse/lsp4j/CodeLensRegistrationOptions;", "getCodeLens", "completion", "Lorg/eclipse/lsp4j/CompletionRegistrationOptions;", "getCompletion", "declaration", "Lorg/eclipse/lsp4j/DeclarationRegistrationOptions;", "getDeclaration", "definition", "Lorg/eclipse/lsp4j/DefinitionRegistrationOptions;", "getDefinition", "diagnostic", "Lorg/eclipse/lsp4j/DiagnosticRegistrationOptions;", "getDiagnostic", "didChangeWatchedFiles", "Lorg/eclipse/lsp4j/DidChangeWatchedFilesRegistrationOptions;", "getDidChangeWatchedFiles", "formatting", "Lorg/eclipse/lsp4j/DocumentFormattingRegistrationOptions;", "getFormatting", "documentHighlight", "Lorg/eclipse/lsp4j/DocumentHighlightRegistrationOptions;", "getDocumentHighlight", "documentLink", "Lorg/eclipse/lsp4j/DocumentLinkRegistrationOptions;", "getDocumentLink", "onTypeFormatting", "Lorg/eclipse/lsp4j/DocumentOnTypeFormattingRegistrationOptions;", "getOnTypeFormatting", "rangeFormatting", "Lorg/eclipse/lsp4j/DocumentRangeFormattingRegistrationOptions;", "getRangeFormatting", "documentSymbol", "Lorg/eclipse/lsp4j/DocumentSymbolRegistrationOptions;", "getDocumentSymbol", "executeCommand", "Lorg/eclipse/lsp4j/ExecuteCommandRegistrationOptions;", "getExecuteCommand", "hover", "Lorg/eclipse/lsp4j/HoverRegistrationOptions;", "getHover", "implementation", "Lorg/eclipse/lsp4j/ImplementationRegistrationOptions;", "getImplementation", "inlayHint", "Lorg/eclipse/lsp4j/InlayHintRegistrationOptions;", "getInlayHint", "inlineValue", "Lorg/eclipse/lsp4j/InlineValueRegistrationOptions;", "getInlineValue", "linkedEditingRange", "Lorg/eclipse/lsp4j/LinkedEditingRangeRegistrationOptions;", "getLinkedEditingRange", "moniker", "Lorg/eclipse/lsp4j/MonikerRegistrationOptions;", "getMoniker", "references", "Lorg/eclipse/lsp4j/ReferenceRegistrationOptions;", "getReferences", "selectionRange", "Lorg/eclipse/lsp4j/SelectionRangeRegistrationOptions;", "getSelectionRange", "signatureHelp", "Lorg/eclipse/lsp4j/SignatureHelpRegistrationOptions;", "getSignatureHelp", "didChange", "Lorg/eclipse/lsp4j/TextDocumentChangeRegistrationOptions;", "getDidChange", "didOpen", "Lorg/eclipse/lsp4j/TextDocumentRegistrationOptions;", "getDidOpen", "willSave", "getWillSave", "willSaveWaitUntil", "getWillSaveWaitUntil", "didClose", "getDidClose", "documentColor", "getDocumentColor", "didSave", "Lorg/eclipse/lsp4j/TextDocumentSaveRegistrationOptions;", "getDidSave", "typeDefinition", "Lorg/eclipse/lsp4j/TypeDefinitionRegistrationOptions;", "getTypeDefinition", "prepareTypeHierarchy", "Lorg/eclipse/lsp4j/TypeHierarchyRegistrationOptions;", "getPrepareTypeHierarchy", "symbol", "Lorg/eclipse/lsp4j/WorkspaceSymbolRegistrationOptions;", "getSymbol", "capabilityToLsp4jRegistrationOptionsClass", "", "intellij.platform.lsp.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<String, Class<CallHierarchyRegistrationOptions>> getPrepareCallHierarchy() {
            return prepareCallHierarchy;
        }

        @NotNull
        public final Pair<String, Class<CodeActionRegistrationOptions>> getCodeAction() {
            return codeAction;
        }

        @NotNull
        public final Pair<String, Class<CodeLensRegistrationOptions>> getCodeLens() {
            return codeLens;
        }

        @NotNull
        public final Pair<String, Class<CompletionRegistrationOptions>> getCompletion() {
            return completion;
        }

        @NotNull
        public final Pair<String, Class<DeclarationRegistrationOptions>> getDeclaration() {
            return declaration;
        }

        @NotNull
        public final Pair<String, Class<DefinitionRegistrationOptions>> getDefinition() {
            return definition;
        }

        @NotNull
        public final Pair<String, Class<DiagnosticRegistrationOptions>> getDiagnostic() {
            return diagnostic;
        }

        @NotNull
        public final Pair<String, Class<DidChangeWatchedFilesRegistrationOptions>> getDidChangeWatchedFiles() {
            return didChangeWatchedFiles;
        }

        @NotNull
        public final Pair<String, Class<DocumentFormattingRegistrationOptions>> getFormatting() {
            return formatting;
        }

        @NotNull
        public final Pair<String, Class<DocumentHighlightRegistrationOptions>> getDocumentHighlight() {
            return documentHighlight;
        }

        @NotNull
        public final Pair<String, Class<DocumentLinkRegistrationOptions>> getDocumentLink() {
            return documentLink;
        }

        @NotNull
        public final Pair<String, Class<DocumentOnTypeFormattingRegistrationOptions>> getOnTypeFormatting() {
            return onTypeFormatting;
        }

        @NotNull
        public final Pair<String, Class<DocumentRangeFormattingRegistrationOptions>> getRangeFormatting() {
            return rangeFormatting;
        }

        @NotNull
        public final Pair<String, Class<DocumentSymbolRegistrationOptions>> getDocumentSymbol() {
            return documentSymbol;
        }

        @NotNull
        public final Pair<String, Class<ExecuteCommandRegistrationOptions>> getExecuteCommand() {
            return executeCommand;
        }

        @NotNull
        public final Pair<String, Class<HoverRegistrationOptions>> getHover() {
            return hover;
        }

        @NotNull
        public final Pair<String, Class<ImplementationRegistrationOptions>> getImplementation() {
            return implementation;
        }

        @NotNull
        public final Pair<String, Class<InlayHintRegistrationOptions>> getInlayHint() {
            return inlayHint;
        }

        @NotNull
        public final Pair<String, Class<InlineValueRegistrationOptions>> getInlineValue() {
            return inlineValue;
        }

        @NotNull
        public final Pair<String, Class<LinkedEditingRangeRegistrationOptions>> getLinkedEditingRange() {
            return linkedEditingRange;
        }

        @NotNull
        public final Pair<String, Class<MonikerRegistrationOptions>> getMoniker() {
            return moniker;
        }

        @NotNull
        public final Pair<String, Class<ReferenceRegistrationOptions>> getReferences() {
            return references;
        }

        @NotNull
        public final Pair<String, Class<SelectionRangeRegistrationOptions>> getSelectionRange() {
            return selectionRange;
        }

        @NotNull
        public final Pair<String, Class<SignatureHelpRegistrationOptions>> getSignatureHelp() {
            return signatureHelp;
        }

        @NotNull
        public final Pair<String, Class<TextDocumentChangeRegistrationOptions>> getDidChange() {
            return didChange;
        }

        @NotNull
        public final Pair<String, Class<TextDocumentRegistrationOptions>> getDidOpen() {
            return didOpen;
        }

        @NotNull
        public final Pair<String, Class<TextDocumentRegistrationOptions>> getWillSave() {
            return willSave;
        }

        @NotNull
        public final Pair<String, Class<TextDocumentRegistrationOptions>> getWillSaveWaitUntil() {
            return willSaveWaitUntil;
        }

        @NotNull
        public final Pair<String, Class<TextDocumentRegistrationOptions>> getDidClose() {
            return didClose;
        }

        @NotNull
        public final Pair<String, Class<TextDocumentRegistrationOptions>> getDocumentColor() {
            return documentColor;
        }

        @NotNull
        public final Pair<String, Class<TextDocumentSaveRegistrationOptions>> getDidSave() {
            return didSave;
        }

        @NotNull
        public final Pair<String, Class<TypeDefinitionRegistrationOptions>> getTypeDefinition() {
            return typeDefinition;
        }

        @NotNull
        public final Pair<String, Class<TypeHierarchyRegistrationOptions>> getPrepareTypeHierarchy() {
            return prepareTypeHierarchy;
        }

        @NotNull
        public final Pair<String, Class<WorkspaceSymbolRegistrationOptions>> getSymbol() {
            return symbol;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

