/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.variables.common;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.variables.common.JupyterVarsCollector;
import com.intellij.jupyter.core.jupyter.variables.common.JupyterVarsToolWindowPanelKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.xdebugger.impl.frame.XStandaloneVariablesView;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020\u001a2\b\u0010$\u001a\u0004\u0018\u00010 J\b\u0010%\u001a\u00020\u001eH$J\u0006\u0010&\u001a\u00020\u001eJ\b\u0010'\u001a\u00020\u001eH\u0004J\b\u0010(\u001a\u00020\u001eH\u0014J\u0012\u0010)\u001a\u00020\u001e2\b\b\u0001\u0010*\u001a\u00020 H\u0004J\u0006\u0010+\u001a\u00020\u001eJ\b\u0010,\u001a\u00020\u001eH\u0014J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u001eH\u0016J\u0010\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u000202H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00064"}, d2={"Lcom/intellij/jupyter/core/jupyter/variables/common/JupyterVarsToolWindowPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getNotebookFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "variablesView", "Lcom/intellij/xdebugger/impl/frame/XStandaloneVariablesView;", "getVariablesView", "()Lcom/intellij/xdebugger/impl/frame/XStandaloneVariablesView;", "setVariablesView", "(Lcom/intellij/xdebugger/impl/frame/XStandaloneVariablesView;)V", "clickListener", "Lcom/intellij/ui/ClickListener;", "getClickListener", "()Lcom/intellij/ui/ClickListener;", "setClickListener", "(Lcom/intellij/ui/ClickListener;)V", "shouldBeAddedOnTopLevel", "", "getShouldBeAddedOnTopLevel", "()Z", "focusOnVariable", "", "variableName", "", "(Ljava/lang/String;)Lkotlin/Unit;", "getName", "isVariablePanelForNotebook", "notebookName", "initVariablesView", "logViewUsage", "removeClickListener", "clearInlineValuesData", "showMessage", "text", "rebuildView", "onVariablesViewRebuilt", "createPanelContent", "Lcom/intellij/ui/content/Content;", "dispose", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "Companion", "intellij.jupyter.core"})
public abstract class JupyterVarsToolWindowPanel
extends SimpleToolWindowPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final BackedNotebookVirtualFile notebookFile;
    @Nullable
    private XStandaloneVariablesView variablesView;
    @Nullable
    private ClickListener clickListener;
    private final boolean shouldBeAddedOnTopLevel;
    @NotNull
    private static final String HELP_ID = "tool_window.jupyter_variables";

    public JupyterVarsToolWindowPanel(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        super(false);
        this.project = project;
        this.notebookFile = notebookFile;
        this.shouldBeAddedOnTopLevel = true;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final BackedNotebookVirtualFile getNotebookFile() {
        return this.notebookFile;
    }

    @Nullable
    protected final XStandaloneVariablesView getVariablesView() {
        return this.variablesView;
    }

    protected final void setVariablesView(@Nullable XStandaloneVariablesView xStandaloneVariablesView) {
        this.variablesView = xStandaloneVariablesView;
    }

    @Nullable
    protected final ClickListener getClickListener() {
        return this.clickListener;
    }

    protected final void setClickListener(@Nullable ClickListener clickListener) {
        this.clickListener = clickListener;
    }

    public boolean getShouldBeAddedOnTopLevel() {
        return this.shouldBeAddedOnTopLevel;
    }

    @Nullable
    public final Unit focusOnVariable(@NotNull String variableName) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        XStandaloneVariablesView xStandaloneVariablesView = this.variablesView;
        if (xStandaloneVariablesView != null && (xStandaloneVariablesView = xStandaloneVariablesView.getTree()) != null) {
            xStandaloneVariablesView.findElementAndRequestFocus(variableName);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @NotNull
    public String getName() {
        return JupyterVarsToolWindowPanelKt.getJUPYTER_VARIABLES_TAB_PREFIX() + " " + this.notebookFile.getFile().getName();
    }

    public final boolean isVariablePanelForNotebook(@Nullable String notebookName) {
        return Intrinsics.areEqual((Object)(JupyterVarsToolWindowPanelKt.getJUPYTER_VARIABLES_TAB_PREFIX() + " " + notebookName), (Object)this.getName());
    }

    protected abstract void initVariablesView();

    public final void logViewUsage() {
        JupyterVarsCollector.logClick(this.project);
    }

    protected final void removeClickListener() {
        block1: {
            XStandaloneVariablesView xStandaloneVariablesView = this.variablesView;
            if (xStandaloneVariablesView == null) break block1;
            XStandaloneVariablesView it = xStandaloneVariablesView;
            boolean bl = false;
            ClickListener clickListener = this.clickListener;
            if (clickListener != null) {
                ClickListener listener = clickListener;
                boolean bl2 = false;
                ListenerUtil.removeClickListener((Component)it.getPanel(), (ClickListener)listener);
            }
        }
    }

    protected void clearInlineValuesData() {
    }

    protected final void showMessage(@NlsContexts.DialogMessage @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.removeAll();
        JLabel initLabel = new JLabel();
        initLabel.setHorizontalAlignment(0);
        initLabel.setVerticalAlignment(0);
        initLabel.setText(text);
        this.add(initLabel);
        this.variablesView = null;
        this.clearInlineValuesData();
        this.repaint();
    }

    public final void rebuildView() {
        if (this.variablesView == null) {
            this.initVariablesView();
        } else {
            XStandaloneVariablesView xStandaloneVariablesView = this.variablesView;
            if (xStandaloneVariablesView != null) {
                xStandaloneVariablesView.rebuildView();
            }
            this.onVariablesViewRebuilt();
        }
    }

    protected void onVariablesViewRebuilt() {
    }

    @NotNull
    public Content createPanelContent() {
        ContentFactory contentFactory = ContentFactory.getInstance();
        Content content = contentFactory.createContent((JComponent)((Object)this), this.getName(), true);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setComponent((JComponent)((Object)this));
        content2.setShouldDisposeContent(true);
        Disposer.register((Disposable)this, (Disposable)((Disposable)content2));
        return content2;
    }

    public void dispose() {
        this.removeClickListener();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super.uiDataSnapshot(sink);
        DataKey dataKey = PlatformCoreDataKeys.HELP_ID;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"HELP_ID");
        sink.set(dataKey, (Object)HELP_ID);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/core/jupyter/variables/common/JupyterVarsToolWindowPanel$Companion;", "", "<init>", "()V", "HELP_ID", "", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

