/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen;

import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.CellOutputBounds;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.JupyterWebOutputInfo;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.jcef.HasViewport;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.NotebookCefManager;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster.JcefOffScreenViewComponent;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.outputs.NotebookOutputInlayShowable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.PopupHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001*B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b!2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0018J\u0018\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J\b\u0010)\u001a\u00020#H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookOffscreenCellOutput;", "Lcom/intellij/openapi/Disposable;", "info", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/JupyterWebOutputInfo;", "cefManager", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookCefManager;", "cellBounds", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/CellOutputBounds;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/JupyterWebOutputInfo;Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookCefManager;Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/CellOutputBounds;)V", "getInfo", "()Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/JupyterWebOutputInfo;", "setInfo", "(Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/JupyterWebOutputInfo;)V", "id", "", "getId$intellij_jupyter_core", "()Ljava/lang/String;", "value", "Ljavax/swing/JComponent;", "component", "getComponent", "()Ljavax/swing/JComponent;", "viewport", "Ljava/awt/Rectangle;", "getViewport", "()Ljava/awt/Rectangle;", "panel", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookOffscreenCellOutput$ShowablePanel;", "viewComponent", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenViewComponent;", "initViewComponent", "Lcom/intellij/ui/PopupHandler;", "Lorg/jetbrains/annotations/NotNull;", "createOrUpdateViewPort", "", "bounds", "createPort", "top", "", "height", "dispose", "ShowablePanel", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookOffscreenCellOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookOffscreenCellOutput.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookOffscreenCellOutput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1#2:130\n*E\n"})
public final class NotebookOffscreenCellOutput
implements Disposable {
    @NotNull
    private JupyterWebOutputInfo info;
    @NotNull
    private final NotebookCefManager cefManager;
    @NotNull
    private JComponent component;
    @Nullable
    private final ShowablePanel panel;
    @Nullable
    private JcefOffScreenViewComponent viewComponent;

    public NotebookOffscreenCellOutput(@NotNull JupyterWebOutputInfo info, @NotNull NotebookCefManager cefManager, @Nullable CellOutputBounds cellBounds) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)cefManager, (String)"cefManager");
        this.info = info;
        this.cefManager = cefManager;
        if (cellBounds != null) {
            JcefOffScreenViewComponent viewComponent = new JcefOffScreenViewComponent(this.cefManager, cellBounds.getTop(), cellBounds.getHeight());
            Disposer.register((Disposable)this, (Disposable)viewComponent);
            this.initViewComponent(viewComponent);
            this.component = viewComponent;
            this.viewComponent = viewComponent;
            this.panel = null;
        } else {
            this.panel = new ShowablePanel(this);
            this.component = this.panel;
            this.viewComponent = null;
        }
    }

    @NotNull
    public final JupyterWebOutputInfo getInfo() {
        return this.info;
    }

    public final void setInfo(@NotNull JupyterWebOutputInfo jupyterWebOutputInfo) {
        Intrinsics.checkNotNullParameter((Object)jupyterWebOutputInfo, (String)"<set-?>");
        this.info = jupyterWebOutputInfo;
    }

    @NotNull
    public final String getId$intellij_jupyter_core() {
        return this.info.getId();
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @Nullable
    public final Rectangle getViewport() {
        NotebookOutputInlayShowable notebookOutputInlayShowable = this.viewComponent;
        return notebookOutputInlayShowable != null && (notebookOutputInlayShowable = notebookOutputInlayShowable.getViewPort()) != null ? notebookOutputInlayShowable.getBounds() : null;
    }

    private final PopupHandler initViewComponent(JcefOffScreenViewComponent viewComponent) {
        Object object = ActionsKt.invokeAndWaitIfNeeded$default(null, () -> NotebookOffscreenCellOutput.initViewComponent$lambda$0(this, viewComponent), (int)1, null);
        Intrinsics.checkNotNull((Object)object);
        return (PopupHandler)object;
    }

    public final void createOrUpdateViewPort(@NotNull Rectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        JcefOffScreenViewComponent viewComponent = this.viewComponent;
        if (viewComponent == null) {
            this.createPort(bounds.y, bounds.height);
        } else {
            viewComponent.getViewPort().setBounds(bounds);
        }
    }

    private final void createPort(int top, int height) {
        boolean bl;
        boolean bl2 = bl = this.panel != null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-NotebookOffscreenCellOutput$createPort$22 = false;
            String $i$a$-assert-NotebookOffscreenCellOutput$createPort$22 = "Panel can't be null if viewPort is not set";
            throw new AssertionError((Object)$i$a$-assert-NotebookOffscreenCellOutput$createPort$22);
        }
        ShowablePanel showablePanel = this.panel;
        Intrinsics.checkNotNull((Object)showablePanel);
        ShowablePanel panel = showablePanel;
        JcefOffScreenViewComponent viewComponent = new JcefOffScreenViewComponent(this.cefManager, top, height);
        Disposer.register((Disposable)this, (Disposable)viewComponent);
        this.initViewComponent(viewComponent);
        this.viewComponent = viewComponent;
        panel.add((Component)viewComponent, "Center");
        panel.setViewComponent(viewComponent);
        panel.revalidate();
    }

    public void dispose() {
    }

    private static final PopupHandler initViewComponent$lambda$0(NotebookOffscreenCellOutput this$0, JcefOffScreenViewComponent $viewComponent) {
        NotebookIntervalPointer notebookIntervalPointer = NotebookIntervalPointerFactory.Companion.get(this$0.cefManager.getEditor()).getForOrdinalIfExists(this$0.info.getCellIndex());
        if (notebookIntervalPointer == null) {
            throw new IllegalStateException(("Pointer is not found for " + this$0.info.getCellIndex()).toString());
        }
        NotebookIntervalPointer pointer = notebookIntervalPointer;
        NotebookCellLines.Interval interval = pointer.get();
        boolean isCode = (interval != null ? interval.getType() : null) == NotebookCellLines.CellType.CODE;
        $viewComponent.setFocusable(isCode);
        $viewComponent.setIntervalPointer(pointer);
        return PopupHandler.installPopupMenu((JComponent)$viewComponent, (String)(isCode ? "JupyterWebOutputPopupActions" : "JupyterMarkdownOutputPopupActions"), (String)"JcefOffScreenViewComponent");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR(\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0011@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookOffscreenCellOutput$ShowablePanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputInlayShowable;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/jcef/HasViewport;", "cellOutput", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookOffscreenCellOutput;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookOffscreenCellOutput;)V", "getCellOutput", "()Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookOffscreenCellOutput;", "value", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenViewComponent;", "viewComponent", "getViewComponent", "()Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenViewComponent;", "setViewComponent", "(Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenViewComponent;)V", "", "shown", "getShown", "()Z", "setShown", "(Z)V", "convertComponentPointToViewport", "Ljava/awt/Point;", "point", "convertViewportPointToComponent", "intellij.jupyter.core"})
    public static final class ShowablePanel
    extends JPanel
    implements NotebookOutputInlayShowable,
    HasViewport {
        @NotNull
        private final NotebookOffscreenCellOutput cellOutput;
        @Nullable
        private JcefOffScreenViewComponent viewComponent;
        private boolean shown;

        public ShowablePanel(@NotNull NotebookOffscreenCellOutput cellOutput) {
            Intrinsics.checkNotNullParameter((Object)cellOutput, (String)"cellOutput");
            super(new BorderLayout());
            this.cellOutput = cellOutput;
            this.setOpaque(false);
        }

        @NotNull
        public final NotebookOffscreenCellOutput getCellOutput() {
            return this.cellOutput;
        }

        @Nullable
        public final JcefOffScreenViewComponent getViewComponent() {
            return this.viewComponent;
        }

        public final void setViewComponent(@Nullable JcefOffScreenViewComponent value) {
            block0: {
                this.viewComponent = value;
                JcefOffScreenViewComponent jcefOffScreenViewComponent = value;
                if (jcefOffScreenViewComponent == null) break block0;
                jcefOffScreenViewComponent.setShown(this.getShown());
            }
        }

        public boolean getShown() {
            return this.shown;
        }

        public void setShown(boolean value) {
            block0: {
                this.shown = value;
                JcefOffScreenViewComponent jcefOffScreenViewComponent = this.viewComponent;
                if (jcefOffScreenViewComponent == null) break block0;
                jcefOffScreenViewComponent.setShown(value);
            }
        }

        @Override
        @NotNull
        public Point convertComponentPointToViewport(@NotNull Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Serializable serializable = this.viewComponent;
            if (serializable == null || (serializable = serializable.convertComponentPointToViewport(point)) == null) {
                serializable = point;
            }
            return serializable;
        }

        @Override
        @NotNull
        public Point convertViewportPointToComponent(@NotNull Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Serializable serializable = this.viewComponent;
            if (serializable == null || (serializable = serializable.convertViewportPointToComponent(point)) == null) {
                serializable = point;
            }
            return serializable;
        }
    }
}

