/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs;

import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.editor.outputs.HasExecutionCountKt;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterJsonDataKey;
import com.intellij.lang.Language;
import com.intellij.notebooks.visualization.outputs.NotebookOutputComponentFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0003H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterJsonOutputComponentFactory;", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory;", "Lcom/intellij/ui/EditorTextField;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterJsonDataKey;", "<init>", "()V", "componentClass", "Ljava/lang/Class;", "getComponentClass", "()Ljava/lang/Class;", "outputDataKeyClass", "getOutputDataKeyClass", "match", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory$Match;", "component", "outputDataKey", "updateComponent", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "createComponent", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory$CreatedComponent;", "output", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterJsonOutputComponentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterJsonOutputComponentFactory.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/JupyterJsonOutputComponentFactory\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,80:1\n16575#2,14:81\n*S KotlinDebug\n*F\n+ 1 JupyterJsonOutputComponentFactory.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/JupyterJsonOutputComponentFactory\n*L\n73#1:81,14\n*E\n"})
public final class JupyterJsonOutputComponentFactory
implements NotebookOutputComponentFactory<EditorTextField, JupyterJsonDataKey> {
    @NotNull
    private final Class<EditorTextField> componentClass = EditorTextField.class;
    @NotNull
    private final Class<JupyterJsonDataKey> outputDataKeyClass = JupyterJsonDataKey.class;

    @NotNull
    public Class<EditorTextField> getComponentClass() {
        return this.componentClass;
    }

    @NotNull
    public Class<JupyterJsonDataKey> getOutputDataKeyClass() {
        return this.outputDataKeyClass;
    }

    @NotNull
    public NotebookOutputComponentFactory.Match match(@NotNull EditorTextField component2, @NotNull JupyterJsonDataKey outputDataKey) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)outputDataKey, (String)"outputDataKey");
        return Intrinsics.areEqual((Object)component2.getText(), (Object)outputDataKey.getJson()) && !HasExecutionCountKt.shouldUpdate(outputDataKey, NotebookOutputComponentFactory.Companion.getGutterPainter((JComponent)component2)) ? NotebookOutputComponentFactory.Match.SAME : NotebookOutputComponentFactory.Match.NONE;
    }

    public void updateComponent(@NotNull EditorImpl editor, @NotNull EditorTextField component2, @NotNull JupyterJsonDataKey outputDataKey) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)outputDataKey, (String)"outputDataKey");
        throw new IllegalStateException("Should never be called".toString());
    }

    @NotNull
    public NotebookOutputComponentFactory.CreatedComponent<EditorTextField> createComponent(@NotNull EditorImpl editor, @NotNull JupyterJsonDataKey output) {
        EditorTextField editorTextField;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Language language = Language.findLanguageByID((String)"JSON");
        if (language == null) {
            language = (Language)PlainTextLanguage.INSTANCE;
        }
        Language language2 = language;
        Project project = editor.getProject();
        if (project == null) {
            throw new IllegalStateException("Editor should have a project".toString());
        }
        Project project2 = project;
        EditorTextField $this$createComponent_u24lambda_u242 = editorTextField = EditorTextFieldProvider.getInstance().getEditorField(language2, project2, (Iterable)CollectionsKt.listOf(arg_0 -> JupyterJsonOutputComponentFactory.createComponent$lambda$1(editor, arg_0)));
        boolean bl = false;
        $this$createComponent_u24lambda_u242.setText(output.getJson());
        $this$createComponent_u24lambda_u242.setFontInheritedFromLAF(false);
        $this$createComponent_u24lambda_u242.setAutoscrolls(false);
        $this$createComponent_u24lambda_u242.getDocument().setReadOnly(true);
        $this$createComponent_u24lambda_u242.setDisposedWith(editor.getDisposable());
        $this$createComponent_u24lambda_u242.getComponent().setFocusable(true);
        $this$createComponent_u24lambda_u242.getComponent().putClientProperty("AuxEditorComponent", true);
        EditorTextField editorTextField2 = editorTextField;
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField2, (String)"apply(...)");
        EditorTextField newEditorTextField = editorTextField2;
        NotebookOutputComponentFactory.GutterPainter gutterPainter = HasExecutionCountKt.createGutterPainter$default(output, 0, 1, null);
        return new NotebookOutputComponentFactory.CreatedComponent((JComponent)newEditorTextField, NotebookOutputComponentFactory.WidthStretching.STRETCH_AND_SQUEEZE, gutterPainter, true, true, () -> JupyterJsonOutputComponentFactory.createComponent$lambda$4(newEditorTextField), null, 64, null);
    }

    private static final void createComponent$lambda$1(EditorImpl $editor, EditorEx it) {
        EditorSettings editorSettings;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setColorsScheme($editor.createBoundColorSchemeDelegate($editor.getColorsScheme()));
        it.setFontSize($editor.getFontSize());
        it.setBackgroundColor($editor.getBackgroundColor());
        EditorSettings $this$createComponent_u24lambda_u241_u24lambda_u240 = editorSettings = it.getSettings();
        boolean bl = false;
        $this$createComponent_u24lambda_u241_u24lambda_u240.setLineNumbersShown(false);
        $this$createComponent_u24lambda_u241_u24lambda_u240.setLineMarkerAreaShown(false);
        $this$createComponent_u24lambda_u241_u24lambda_u240.setFoldingOutlineShown(true);
        $this$createComponent_u24lambda_u241_u24lambda_u240.setRightMarginShown(true);
        $this$createComponent_u24lambda_u241_u24lambda_u240.setAdditionalPageAtBottom(false);
        $this$createComponent_u24lambda_u241_u24lambda_u240.setShowIntentionBulb(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String createComponent$lambda$4(EditorTextField $newEditorTextField) {
        String string;
        Object[] objectArray;
        FoldingModelEx foldingModelEx;
        EditorEx editorEx = $newEditorTextField.getEditor(true);
        if (editorEx != null && (foldingModelEx = editorEx.getFoldingModel()) != null && (objectArray = foldingModelEx.getAllFoldRegions()) != null) {
            String string2;
            FoldRegion foldRegion;
            Object[] objectArray2 = objectArray;
            boolean $i$f$minByOrNull = false;
            if (objectArray2.length == 0) {
                v0 = null;
            } else {
                Object minElem$iv = objectArray2[0];
                int lastIndex$iv = ArraysKt.getLastIndex((Object[])objectArray2);
                if (lastIndex$iv == 0) {
                    v0 = minElem$iv;
                } else {
                    FoldRegion it = minElem$iv;
                    boolean bl = false;
                    int minValue$iv = it.getStartOffset();
                    int i$iv = 1;
                    if (i$iv <= lastIndex$iv) {
                        while (true) {
                            Object e$iv;
                            Object it2 = e$iv = objectArray2[i$iv];
                            $i$a$-minByOrNull-JupyterJsonOutputComponentFactory$createComponent$1$1 = false;
                            int v$iv = it2.getStartOffset();
                            if (minValue$iv > v$iv) {
                                minElem$iv = e$iv;
                                minValue$iv = v$iv;
                            }
                            if (i$iv == lastIndex$iv) break;
                            ++i$iv;
                        }
                    }
                    v0 = foldRegion = minElem$iv;
                }
            }
            if (foldRegion != null && (string2 = foldRegion.getPlaceholderText()) != null) {
                string = string2;
                return string;
            }
        }
        string = JupyterBundle.message("notebook.collapsed.json.output.text", new Object[0]);
        return string;
    }
}

