/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.utils;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.ref.Reference;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.ui.preview.MarkdownEditorWithPreview;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J?\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u0001H\u000f0\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/fileActions/utils/MarkdownFileEditorUtils;", "", "<init>", "()V", "findMarkdownPreviewEditor", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor;", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "requireOpenedPreview", "", "findEditor", "T", "predicate", "Lkotlin/Function1;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/jvm/functions/Function1;)Lcom/intellij/openapi/fileEditor/FileEditor;", "intellij.markdown"})
@ApiStatus.Experimental
public final class MarkdownFileEditorUtils {
    @NotNull
    public static final MarkdownFileEditorUtils INSTANCE = new MarkdownFileEditorUtils();

    private MarkdownFileEditorUtils() {
    }

    @JvmStatic
    @Nullable
    public static final MarkdownPreviewFileEditor findMarkdownPreviewEditor(@NotNull FileEditor editor2) {
        MarkdownPreviewFileEditor markdownPreviewFileEditor;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        FileEditor fileEditor = editor2;
        if (fileEditor instanceof MarkdownEditorWithPreview) {
            FileEditor fileEditor2 = ((MarkdownEditorWithPreview)editor2).getPreviewEditor();
            markdownPreviewFileEditor = fileEditor2 instanceof MarkdownPreviewFileEditor ? (MarkdownPreviewFileEditor)fileEditor2 : null;
        } else if (fileEditor instanceof MarkdownPreviewFileEditor) {
            markdownPreviewFileEditor = (MarkdownPreviewFileEditor)editor2;
        } else {
            TextEditorWithPreview textEditorWithPreview = TextEditorWithPreview.Companion.getParentSplitEditor(editor2);
            FileEditor fileEditor3 = textEditorWithPreview != null ? textEditorWithPreview.getPreviewEditor() : null;
            markdownPreviewFileEditor = fileEditor3 instanceof MarkdownPreviewFileEditor ? (MarkdownPreviewFileEditor)fileEditor3 : null;
        }
        return markdownPreviewFileEditor;
    }

    @JvmStatic
    @Nullable
    public static final MarkdownPreviewFileEditor findMarkdownPreviewEditor(@NotNull Project project, @NotNull VirtualFile file, boolean requireOpenedPreview) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MarkdownPreviewFileEditor editor2 = (MarkdownPreviewFileEditor)INSTANCE.findEditor(project, file, (Function1)new Function1<FileEditor, MarkdownPreviewFileEditor>((Object)INSTANCE){

            public final MarkdownPreviewFileEditor invoke(FileEditor p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return MarkdownFileEditorUtils.findMarkdownPreviewEditor(p0);
            }
        });
        if (requireOpenedPreview && ((object = editor2) != null && (object = ((MarkdownPreviewFileEditor)object).getUserData(MarkdownPreviewFileEditor.Companion.getPREVIEW_BROWSER())) != null ? (MarkdownHtmlPanel)((Reference)object).get() : null) == null) {
            return null;
        }
        return editor2;
    }

    private final <T extends FileEditor> T findEditor(Project project, VirtualFile file, Function1<? super FileEditor, ? extends T> predicate) {
        FileEditor selectedEditor;
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        FileEditor fileEditor = editorManager.getSelectedEditor(file);
        FileEditor fileEditor2 = selectedEditor = fileEditor != null ? (FileEditor)predicate.invoke((Object)fileEditor) : null;
        if (selectedEditor != null) {
            return (T)selectedEditor;
        }
        for (FileEditor editor2 : editorManager.getEditorList(file)) {
            Intrinsics.checkNotNull((Object)editor2);
            FileEditor previewEditor = (FileEditor)predicate.invoke((Object)editor2);
            if (previewEditor == null) continue;
            return (T)previewEditor;
        }
        return null;
    }
}

