/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.ModelEntityStorage;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.basic.BasicModModel;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ+\u0010\b\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010\u00a2\u0006\u0002\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/model/ModelFactory;", "", "textStorage", "Lcom/intellij/database/model/ModelTextStorage;", "<init>", "(Lcom/intellij/database/model/ModelTextStorage;)V", "getTextStorage", "()Lcom/intellij/database/model/ModelTextStorage;", "createModel", "Lcom/intellij/database/model/basic/BasicModModel;", "dbms", "Lcom/intellij/database/Dbms;", "keepPersistentData", "", "M", "modelClass", "Ljava/lang/Class;", "(Lcom/intellij/database/Dbms;Ljava/lang/Class;)Lcom/intellij/database/model/basic/BasicModModel;", "Companion", "intellij.database.core.impl"})
public final class ModelFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModelTextStorage textStorage;
    @JvmField
    @NotNull
    public static final ModelFactory BLACK_HOLE = new ModelFactory(BlackHoleTextStorage.INSTANCE);

    public ModelFactory(@NotNull ModelTextStorage textStorage) {
        Intrinsics.checkNotNullParameter((Object)textStorage, (String)"textStorage");
        this.textStorage = textStorage;
    }

    @NotNull
    public final ModelTextStorage getTextStorage() {
        return this.textStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final BasicModModel createModel(@NotNull Dbms dbms, boolean keepPersistentData) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        ModelFacade modelFacade = ModelFacade.forDbms(dbms);
        Intrinsics.checkNotNullExpressionValue((Object)modelFacade, (String)"forDbms(...)");
        ModelFacade factory = modelFacade;
        if (!keepPersistentData) {
            ModelEntityStorage.Backend storage = this.textStorage.createEntityStorage();
            try {
                storage.clear();
            }
            finally {
                storage.shelve();
            }
        }
        BasicModModel basicModModel = factory.createModel(this.textStorage);
        Intrinsics.checkNotNullExpressionValue((Object)basicModModel, (String)"createModel(...)");
        return basicModModel;
    }

    @NotNull
    public final BasicModModel createModel(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return this.createModel(dbms, false);
    }

    @NotNull
    public final <M extends BasicModModel> M createModel(@NotNull Dbms dbms, @NotNull Class<M> modelClass) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
        BasicModModel model = this.createModel(dbms);
        if (modelClass.isAssignableFrom(model.getClass())) {
            Intrinsics.checkNotNull((Object)model, (String)"null cannot be cast to non-null type M of com.intellij.database.model.ModelFactory.createModel");
            return (M)model;
        }
        throw new IllegalArgumentException("Cannot cast " + dbms + " model to " + modelClass.getSimpleName());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/model/ModelFactory$Companion;", "", "<init>", "()V", "BLACK_HOLE", "Lcom/intellij/database/model/ModelFactory;", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

