/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.markdown.extensions.github.alerts;

import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.text.TextContentNodeRendererContext;
import org.commonmark.renderer.text.TextContentWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jewel.markdown.extensions.github.alerts.AlertBlock;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/jewel/markdown/extensions/github/alerts/AlertTextContentNodeRenderer;", "Lorg/commonmark/renderer/NodeRenderer;", "context", "Lorg/commonmark/renderer/text/TextContentNodeRendererContext;", "<init>", "(Lorg/commonmark/renderer/text/TextContentNodeRendererContext;)V", "writer", "Lorg/commonmark/renderer/text/TextContentWriter;", "kotlin.jvm.PlatformType", "Lorg/commonmark/renderer/text/TextContentWriter;", "getNodeTypes", "", "Ljava/lang/Class;", "Lorg/commonmark/node/Node;", "render", "", "node", "renderChildren", "intellij.platform.jewel.markdown.extension.gfmAlerts"})
final class AlertTextContentNodeRenderer
implements NodeRenderer {
    @NotNull
    private final TextContentNodeRendererContext context;
    private final TextContentWriter writer;

    public AlertTextContentNodeRenderer(@NotNull TextContentNodeRendererContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.writer = this.context.getWriter();
    }

    @NotNull
    public Set<Class<? extends Node>> getNodeTypes() {
        return SetsKt.setOf(AlertBlock.class);
    }

    public void render(@NotNull Node node) {
        String string;
        AlertBlock alertBlock;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        AlertBlock alertBlock2 = alertBlock = node instanceof AlertBlock ? (AlertBlock)node : null;
        if (alertBlock instanceof AlertBlock.Caution) {
            string = "\ud83d\uded1 Caution! ";
        } else if (alertBlock instanceof AlertBlock.Important) {
            string = "\u26a0\ufe0f Important! ";
        } else if (alertBlock instanceof AlertBlock.Note) {
            string = "\u2139\ufe0f Note: ";
        } else if (alertBlock instanceof AlertBlock.Tip) {
            string = "\ud83d\udca1 Tip: ";
        } else if (alertBlock instanceof AlertBlock.Warning) {
            string = "\u26a0\ufe0f Warning: ";
        } else {
            if (alertBlock == null) {
                throw new IllegalStateException(("Unsupported node type " + node.getClass().getName()).toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        String premise = string;
        this.writer.write(premise);
        this.renderChildren(node);
    }

    private final void renderChildren(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
            this.context.render(node);
        }
    }
}

