/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.runner;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.util.EnvironmentRestorer;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.CollectionFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.runner.LocalTerminalStartCommandBuilder;
import org.jetbrains.plugins.terminal.util.TerminalEnvironment;

@ApiStatus.Internal
public final class LocalOptionsConfigurer {
    private static final Logger LOG = Logger.getInstance(LocalOptionsConfigurer.class);

    @NotNull
    public static ShellStartupOptions configureStartupOptions(@NotNull ShellStartupOptions baseOptions, @NotNull Project project) {
        if (baseOptions == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(0);
        }
        if (project == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(1);
        }
        String workingDir = LocalOptionsConfigurer.getWorkingDirectory(baseOptions.getWorkingDirectory(), project);
        Map<String, String> envs = LocalOptionsConfigurer.getTerminalEnvironment(baseOptions.getEnvVariables(), workingDir, project);
        List<String> initialCommand = LocalOptionsConfigurer.getInitialCommand(baseOptions, project);
        TerminalWidget widget = baseOptions.getWidget();
        if (widget != null) {
            widget.setShellCommand(initialCommand);
        }
        ShellStartupOptions shellStartupOptions = baseOptions.builder().shellCommand(initialCommand).workingDirectory(workingDir).envVariables(envs).build();
        if (shellStartupOptions == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(2);
        }
        return shellStartupOptions;
    }

    @VisibleForTesting
    @NotNull
    static String getWorkingDirectory(@Nullable String directory, Project project) {
        if (directory != null && LocalTerminalDirectRunner.isDirectory(directory)) {
            String string = directory;
            if (string == null) {
                LocalOptionsConfigurer.$$$reportNull$$$0(3);
            }
            return string;
        }
        String configuredWorkingDirectory = TerminalProjectOptionsProvider.getInstance(project).getStartingDirectory();
        if (configuredWorkingDirectory != null && LocalTerminalDirectRunner.isDirectory(configuredWorkingDirectory)) {
            String string = configuredWorkingDirectory;
            if (string == null) {
                LocalOptionsConfigurer.$$$reportNull$$$0(4);
            }
            return string;
        }
        String defaultWorkingDirectory = TerminalProjectOptionsProvider.getInstance(project).getDefaultStartingDirectory();
        if (defaultWorkingDirectory != null && LocalTerminalDirectRunner.isDirectory(defaultWorkingDirectory)) {
            String string = defaultWorkingDirectory;
            if (string == null) {
                LocalOptionsConfigurer.$$$reportNull$$$0(5);
            }
            return string;
        }
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        if (projectDir != null) {
            String string = VfsUtilCore.virtualToIoFile((VirtualFile)projectDir).getAbsolutePath();
            if (string == null) {
                LocalOptionsConfigurer.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = SystemProperties.getUserHome();
        if (string == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static Map<String, String> getTerminalEnvironment(@NotNull Map<String, String> baseEnvs, @NotNull String workingDir, @NotNull Project project) {
        if (baseEnvs == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(8);
        }
        if (workingDir == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(9);
        }
        if (project == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(10);
        }
        Map envs = SystemInfo.isWindows ? CollectionFactory.createCaseInsensitiveStringMap() : new HashMap();
        EnvironmentVariablesData envData = TerminalProjectOptionsProvider.getInstance(project).getEnvData();
        if (envData.isPassParentEnvs()) {
            envs.putAll(System.getenv());
            EnvironmentRestorer.restoreOverriddenVars((Map)envs);
        } else {
            LOG.info("No parent environment passed");
        }
        envs.putAll(baseEnvs);
        if (!SystemInfo.isWindows) {
            envs.put("TERM", "xterm-256color");
        }
        envs.put("TERMINAL_EMULATOR", "JetBrains-JediTerm");
        envs.put("TERM_SESSION_ID", UUID.randomUUID().toString());
        TerminalEnvironment.INSTANCE.setCharacterEncoding(envs);
        if (TrustedProjects.isTrusted((Project)project)) {
            PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)project);
            for (Map.Entry env : envData.getEnvs().entrySet()) {
                envs.put((String)env.getKey(), macroManager.expandPath((String)env.getValue()));
            }
            if (WslPath.isWslUncPath((String)workingDir)) {
                LocalOptionsConfigurer.setupWslEnv(envData.getEnvs(), envs);
            }
        }
        Map map2 = envs;
        if (map2 == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(11);
        }
        return map2;
    }

    @NotNull
    private static List<String> getInitialCommand(@NotNull ShellStartupOptions options, @NotNull Project project) {
        List<String> shellCommand;
        if (options == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(12);
        }
        if (project == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(13);
        }
        List<String> list = (shellCommand = options.getShellCommand()) != null ? shellCommand : LocalTerminalStartCommandBuilder.convertShellPathToCommand(LocalOptionsConfigurer.getShellPath(project));
        if (list == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private static String getShellPath(@NotNull Project project) {
        if (project == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(15);
        }
        String string = TerminalProjectOptionsProvider.getInstance(project).getShellPath();
        if (string == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static void setupWslEnv(@NotNull Map<String, String> userEnvs, @NotNull Map<String, String> resultEnvs) {
        String wslEnv;
        if (userEnvs == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(17);
        }
        if (resultEnvs == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(18);
        }
        if ((wslEnv = userEnvs.keySet().stream().map(name -> name + "/u").collect(Collectors.joining(":"))).isEmpty()) {
            return;
        }
        String prevValue = userEnvs.get("WSLENV");
        if (prevValue == null) {
            prevValue = System.getenv("WSLENV");
        }
        String newWslEnv = prevValue != null ? StringUtil.trimEnd((String)prevValue, (char)':') + ":" + wslEnv : wslEnv;
        resultEnvs.put("WSLENV", newWslEnv);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 11, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseOptions";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/runner/LocalOptionsConfigurer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseEnvs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userEnvs";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultEnvs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/runner/LocalOptionsConfigurer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "configureStartupOptions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalEnvironment";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialCommand";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureStartupOptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 16: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTerminalEnvironment";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInitialCommand";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getShellPath";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setupWslEnv";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 11, 14, 16 -> new IllegalStateException(string);
        };
    }
}

