/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PythonDocumentationHighlightingService;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u001d\u0010\u0000\u001a\u00020\u00012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001f\u0010\u0007\u001a\u00020\u00012\u000b\u0010\b\u001a\u00070\u0003\u00a2\u0006\u0002\b\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u001a\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0003\u001a\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u001a\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a8\u0006\u0018"}, d2={"styledSpan", "Lcom/intellij/openapi/util/text/HtmlChunk;", "text", "", "Lorg/jetbrains/annotations/Nls;", "textAttributeKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "highlightExpressionText", "expressionText", "Lcom/intellij/openapi/util/NlsSafe;", "expression", "Lcom/jetbrains/python/psi/PyExpression;", "styledSpanWithRawText", "paramNameTextAttribute", "isSelf", "", "functionNameTextAttribute", "function", "Lcom/jetbrains/python/psi/PyFunction;", "funcName", "styledReference", "refText", "refTarget", "Lcom/intellij/psi/PsiElement;", "intellij.python.psi.impl"})
public final class PyDocSignaturesHighlighterKt {
    @NotNull
    public static final HtmlChunk styledSpan(@NotNull String text, @NotNull TextAttributesKey textAttributeKey) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)textAttributeKey, (String)"textAttributeKey");
        String string = HtmlChunk.text((String)text).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        HtmlChunk htmlChunk = HtmlChunk.raw((String)PyDocSignaturesHighlighterKt.styledSpanWithRawText(string, textAttributeKey));
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"raw(...)");
        return htmlChunk;
    }

    @NotNull
    public static final HtmlChunk styledSpan(@NotNull HtmlChunk text, @NotNull TextAttributesKey textAttributeKey) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)textAttributeKey, (String)"textAttributeKey");
        String string = text.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        HtmlChunk htmlChunk = HtmlChunk.raw((String)PyDocSignaturesHighlighterKt.styledSpanWithRawText(string, textAttributeKey));
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"raw(...)");
        return htmlChunk;
    }

    @NotNull
    public static final HtmlChunk highlightExpressionText(@NotNull String expressionText, @Nullable PyExpression expression) {
        HtmlChunk htmlChunk;
        Intrinsics.checkNotNullParameter((Object)expressionText, (String)"expressionText");
        PyExpression pyExpression = expression;
        if (pyExpression == null) {
            HtmlChunk htmlChunk2 = HtmlChunk.text((String)expressionText);
            htmlChunk = htmlChunk2;
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk2, (String)"text(...)");
        } else if (pyExpression instanceof PyStringLiteralExpression) {
            TextAttributesKey textAttributesKey = PyHighlighter.PY_UNICODE_STRING;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"PY_UNICODE_STRING");
            htmlChunk = PyDocSignaturesHighlighterKt.styledSpan(expressionText, textAttributesKey);
        } else {
            PythonDocumentationHighlightingService pythonDocumentationHighlightingService = PythonDocumentationHighlightingService.Companion.getInstance();
            Project project = expression.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            HtmlChunk htmlChunk3 = HtmlChunk.raw((String)pythonDocumentationHighlightingService.highlightedCodeSnippet(project, expressionText));
            htmlChunk = htmlChunk3;
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk3, (String)"raw(...)");
        }
        return htmlChunk;
    }

    @NlsSafe
    private static final String styledSpanWithRawText(String text, TextAttributesKey textAttributeKey) {
        return PythonDocumentationHighlightingService.Companion.getInstance().styledSpan(textAttributeKey, text);
    }

    @NotNull
    public static final TextAttributesKey paramNameTextAttribute(boolean isSelf) {
        TextAttributesKey textAttributesKey;
        if (isSelf) {
            TextAttributesKey textAttributesKey2 = PyHighlighter.PY_SELF_PARAMETER;
            textAttributesKey = textAttributesKey2;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"PY_SELF_PARAMETER");
        } else {
            TextAttributesKey textAttributesKey3 = PyHighlighter.PY_PARAMETER;
            textAttributesKey = textAttributesKey3;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey3, (String)"PY_PARAMETER");
        }
        return textAttributesKey;
    }

    @NotNull
    public static final TextAttributesKey functionNameTextAttribute(@NotNull PyFunction function, @Nullable String funcName) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)function);
        Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"forElement(...)");
        LanguageLevel languageLevel2 = languageLevel;
        if ((PyNames.UNDERSCORED_ATTRIBUTES.contains(funcName) || PyNames.getBuiltinMethods((LanguageLevel)languageLevel2).containsKey(funcName)) && function.getContainingClass() != null) {
            TextAttributesKey textAttributesKey = PyHighlighter.PY_PREDEFINED_USAGE;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"PY_PREDEFINED_USAGE");
            return textAttributesKey;
        }
        TextAttributesKey textAttributesKey = PyHighlighter.PY_FUNC_DEFINITION;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"PY_FUNC_DEFINITION");
        return textAttributesKey;
    }

    @NotNull
    public static final HtmlChunk styledReference(@NotNull HtmlChunk refText, @NotNull PsiElement refTarget) {
        Intrinsics.checkNotNullParameter((Object)refText, (String)"refText");
        Intrinsics.checkNotNullParameter((Object)refTarget, (String)"refTarget");
        if (PyBuiltinCache.getInstance(refTarget).isBuiltin(refTarget)) {
            TextAttributesKey textAttributesKey = PyHighlighter.PY_BUILTIN_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"PY_BUILTIN_NAME");
            return PyDocSignaturesHighlighterKt.styledSpan(refText, textAttributesKey);
        }
        return refText;
    }
}

