/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.json.psi.impl.JsonPropertyNameReference;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.findUsages.JSUsageViewElementsListener;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXNamespaceReference;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.presentable.Capitalization;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.ES6ChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSLiteralTextReference;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.TypeScriptLiteralBasedPropertyElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSRenamePsiFileProcessor;
import com.intellij.lang.javascript.refactoring.rename.JSInplaceRenameHandler;
import com.intellij.lang.javascript.refactoring.ui.JSRenameTargetChooser;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 E2\u00020\u0001:\u0003DEFB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J4\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J@\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u00132\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0014H\u0016J,\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0013H\u0016J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J*\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 2\u0010\u0010!\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\b0\"H\u0016J0\u0010#\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0012\u0010!\u001a\u000e\u0012\b\b\u0000\u0012\u0004\u0018\u00010\b\u0018\u00010\"H\u0002J0\u0010$\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0012\u0010!\u001a\u000e\u0012\b\b\u0000\u0012\u0004\u0018\u00010\b\u0018\u00010\"H\u0002Jn\u0010%\u001a\u0004\u0018\u00010\b2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0012\u0010!\u001a\u000e\u0012\b\b\u0000\u0012\u0004\u0018\u00010\b\u0018\u00010\"2\u000b\u0010&\u001a\u00070\f\u00a2\u0006\u0002\b'2\r\u0010(\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b)2\u0006\u0010*\u001a\u00020\b2\u000b\u0010+\u001a\u00070\f\u00a2\u0006\u0002\b,2\u0006\u0010-\u001a\u00020\b2\u000b\u0010.\u001a\u00070\f\u00a2\u0006\u0002\b,H\u0005J,\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\b2\b\u00103\u001a\u0004\u0018\u00010\b2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J0\u00104\u001a\u0004\u0018\u00010\b2\u0006\u00105\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0012\u0010!\u001a\u000e\u0012\b\b\u0000\u0012\u0004\u0018\u00010\b\u0018\u000106H\u0004J5\u00107\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\f\u00108\u001a\b\u0012\u0004\u0012\u00020:092\b\u0010;\u001a\u0004\u0018\u00010<H\u0016\u00a2\u0006\u0002\u0010=J \u0010>\u001a\u00020:2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010?\u001a\u00020\u00172\u0006\u0010@\u001a\u00020\bH\u0016J\u0018\u0010A\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\u0010\u0010B\u001a\u00020\u00052\u0006\u00105\u001a\u00020\bH\u0016J\b\u0010C\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor;", "Lcom/intellij/refactoring/rename/RenamePsiElementProcessor;", "<init>", "()V", "myForceShowPreview", "", "canProcessElement", "element", "Lcom/intellij/psi/PsiElement;", "prepareRenaming", "", "newName", "", "allRenames", "", "scope", "Lcom/intellij/psi/search/SearchScope;", "findExistingNameConflicts", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "searchScope", "searchInCommentsAndStrings", "isToSearchInComments", "setToSearchInComments", "enabled", "isToSearchForTextOccurrences", "substituteElementToRename", "editor", "Lcom/intellij/openapi/editor/Editor;", "renameCallback", "Lcom/intellij/openapi/util/Pass;", "substituteShorthandedProperty", "substituteDestructuringShorthanding", "substituteWithPopup", "title", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "message", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "defaultElement", "defaultElementLabel", "Lcom/intellij/openapi/util/NlsContexts$Button;", "otherElement", "otherElementLabel", "createRenameDialog", "Lcom/intellij/refactoring/rename/RenameDialog;", "project", "Lcom/intellij/openapi/project/Project;", "nameSuggestionContext", "processSubstituted", "psiElement", "Ljava/util/function/Consumer;", "renameElement", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "createUsageInfo", "ref", "referenceElement", "setToSearchForTextOccurrences", "showRenamePreviewButton", "forcesShowPreview", "ReferencesType", "Companion", "JSNonRenameableReference", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSDefaultRenameProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSDefaultRenameProcessor.kt\ncom/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,740:1\n1863#2,2:741\n1#3:743\n*S KotlinDebug\n*F\n+ 1 JSDefaultRenameProcessor.kt\ncom/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor\n*L\n105#1:741,2\n*E\n"})
public class JSDefaultRenameProcessor
extends RenamePsiElementProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean myForceShowPreview;
    @JvmField
    @NotNull
    public static final Key<Long> FORCE_SEARCH_FOR_FILE_REFERENCES_KEY = new Key("js.rename.force.search.for.file.references");
    public static final boolean SEARCH_FOR_DYNAMIC_DEFAULT = false;
    public static final boolean SEARCH_FOR_JAVASCRIPT_DEFAULT = true;
    public static final boolean SEARCH_IN_STRINGS_AND_COMMENTS_DEFAULT_VALUE = false;
    @NotNull
    public static final String SEARCH_IN_COMMENTS = "js.rename.search.in.comments";
    @NotNull
    public static final String SEARCH_FOR_TEXT_OCCURRENCES = "js.rename.search.for.text.occurrences";
    @NotNull
    public static final String SEARCH_FOR_JAVASCRIPT_OCCURRENCES = "ts.rename.search.for.js.occurrences";
    @NotNull
    public static final String SEARCH_FOR_DYNAMIC_OCCURRENCES = "ts.rename.search.for.dynamic.occurrences";

    public boolean canProcessElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof JSNamedElement || element instanceof TypeScriptLiteralBasedPropertyElement;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope2) {
        String newFileName;
        VirtualFile virtualFile;
        PsiFile containingFile;
        Object it;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        super.prepareRenaming(element, newName, allRenames, scope2);
        if (element instanceof TypeScriptFunction) {
            Collection<TypeScriptFunction> collection = TypeScriptPsiUtil.getAllOverloadsWithImplementation((TypeScriptFunction)element);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllOverloadsWithImplementation(...)");
            Collection<TypeScriptFunction> overloads = collection;
            Iterable $this$forEach$iv = overloads;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (TypeScriptFunction)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                allRenames.put((PsiElement)it, newName);
            }
        }
        PsiFile psiFile = containingFile = element.getContainingFile();
        Object object = virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
        if (!StringUtil.isEmpty((String)newName) && element instanceof JSNamedElement && !DialectDetector.isActionScript(element) && virtualFile != null && JSDefaultRenameProcessor.Companion.isTopLevelElementInMatchingFile((JSNamedElement)element) && (newFileName = JSNameSuggestionsUtil.fileNameFromElementName((JSNamedElement)element, newName)) != null && !StringUtil.equals((CharSequence)newFileName, (CharSequence)virtualFile.getNameWithoutExtension())) {
            boolean renameContainingFile;
            String newFileNameWithExtension = newFileName + "." + virtualFile.getExtension();
            Object bl = new Object[]{HtmlChunk.span().addText(newFileNameWithExtension).bold(), new JSNamedElementPresenter(element, Capitalization.LowerCase).describeElementKind()};
            it = JavaScriptBundle.message("javascript.rename.containing.file.message", bl);
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"message(...)");
            Object message = it;
            Object[] objectArray = new Object[]{new JSNamedElementPresenter(element, Capitalization.UpperCase).describeElementKind()};
            bl = JavaScriptBundle.message("javascript.rename.element.with.related.elements.title", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"message(...)");
            Object title = bl;
            boolean bl2 = renameContainingFile = Messages.showYesNoDialog((Project)((JSNamedElement)element).getProject(), (String)message, (String)title, (Icon)Messages.getQuestionIcon()) == 0;
            if (renameContainingFile) {
                allRenames.put((PsiElement)containingFile, newFileNameWithExtension);
                JSRenamePsiFileProcessor.renameRelatedSymbols(allRenames, containingFile, (JSNamedElement)element, newFileName);
            }
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts, @NotNull Map<PsiElement, String> allRenames) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        for (Map.Entry<PsiElement, String> entry : allRenames.entrySet()) {
            this.findExistingNameConflicts(entry.getKey(), entry.getValue(), conflicts);
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        boolean processStatics = element instanceof JSAttributeListOwner && JSPsiImplUtils.hasModifier((JSAttributeListOwner)element, JSAttributeList.ModifierType.STATIC);
        Class[] classArray = new Class[]{JSExecutionScope.class, JSClass.class, JSObjectLiteralExpression.class};
        JSElement scope2 = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])classArray);
        List<PsiElement> list = JSRefactoringUtil.findExistingInScope(newName, (PsiElement)scope2, processStatics);
        Intrinsics.checkNotNullExpressionValue(list, (String)"findExistingInScope(...)");
        PsiElement existing = (PsiElement)CollectionsKt.firstOrNull(list);
        if (!(existing == null || existing == element || existing instanceof JSInitializerOwner && ((JSInitializerOwner)existing).getInitializer() == element)) {
            conflicts.putValue((Object)existing, (Object)JSRefactoringUtil.getMemberAlreadyExistsMessage(existing));
        }
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        boolean isTypeScript = DialectDetector.isTypeScript(element);
        ReferencesType refType = isTypeScript && !Companion.getSearchJavaScriptReferences(element) ? ReferencesType.TS : ReferencesType.ALL;
        return Companion.getReferences(element, searchScope, searchInCommentsAndStrings, refType);
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return PropertiesComponent.getInstance().getBoolean(SEARCH_IN_COMMENTS, false);
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PropertiesComponent.getInstance().setValue(SEARCH_IN_COMMENTS, String.valueOf(enabled));
        super.setToSearchInComments(element, enabled);
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return PropertiesComponent.getInstance().getBoolean(SEARCH_FOR_TEXT_OCCURRENCES);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement it = psiElement = element;
        boolean bl = false;
        if (element instanceof ImplicitJSVariableImpl) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        PsiElement psiElement2 = psiElement;
        PsiElement psiElement3 = psiElement2;
        if (psiElement3 == null) return null;
        PsiElement it2 = psiElement3;
        boolean bl3 = false;
        psiElement = JSDefaultRenameProcessor.Companion.substituteOverload(it2);
        if (psiElement == null) return null;
        PsiElement it3 = psiElement;
        boolean bl4 = false;
        PsiElement psiElement4 = this.substituteDestructuringShorthanding(it3, editor, null);
        if (psiElement4 == null) return null;
        it3 = psiElement4;
        boolean bl5 = false;
        PsiElement psiElement5 = this.substituteShorthandedProperty(it3, editor, null);
        return psiElement5;
    }

    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Pass<? super PsiElement> renameCallback) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(renameCallback, (String)"renameCallback");
            PsiElement it = JSDefaultRenameProcessor.Companion.substituteOverload(element);
            boolean bl = false;
            PsiElement psiElement = this.substituteDestructuringShorthanding(it, editor, renameCallback);
            if (psiElement == null) break block1;
            PsiElement it2 = psiElement;
            boolean bl2 = false;
            PsiElement psiElement2 = this.substituteShorthandedProperty(it2, editor, renameCallback);
            if (psiElement2 != null) {
                it2 = psiElement2;
                boolean bl3 = false;
                renameCallback.accept((Object)it2);
            }
        }
    }

    private final PsiElement substituteShorthandedProperty(PsiElement element, Editor editor, Pass<? super PsiElement> renameCallback) {
        PsiElement valueResolveResult;
        JSProperty property;
        JSProperty jSProperty = property = element instanceof JSProperty ? (JSProperty)element : null;
        if (property == null || !property.isShorthanded() || property.getValue() == null) {
            return element;
        }
        PsiReference reference = editor != null ? TargetElementUtil.findReference((Editor)editor) : null;
        JSProperty atCaret = reference != null ? (JSProperty)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), JSProperty.class, (boolean)false) : null;
        JSExpression jSExpression = property.getValue();
        JSReferenceExpression referenceExpression = jSExpression instanceof JSReferenceExpression ? (JSReferenceExpression)jSExpression : null;
        PsiElement propertyResolveResult = (PsiElement)ObjectUtils.coalesce((Object)new PsiMultiReference(property.getReferences(), (PsiElement)property).resolve(), (Object)property);
        if (atCaret == property && referenceExpression != null && (valueResolveResult = referenceExpression.resolve()) != null) {
            String string = ElementDescriptionUtil.getElementDescription((PsiElement)valueResolveResult, (ElementDescriptionLocation)((ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementDescription(...)");
            String valueDescription = string;
            Object[] objectArray = new Object[]{valueDescription};
            String string2 = JavaScriptBundle.message("javascript.rename.shorthand.target.dialog.title", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String string3 = JavaScriptBundle.message("javascript.rename.choose.target.message", new Object[0]);
            String string4 = StringUtil.capitalize((String)valueDescription);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"capitalize(...)");
            Intrinsics.checkNotNull((Object)propertyResolveResult);
            String string5 = JavaScriptBundle.message("javascript.rename.shorthand.property.description", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            return this.substituteWithPopup(editor, renameCallback, string2, string3, valueResolveResult, string4, propertyResolveResult, string5);
        }
        return propertyResolveResult;
    }

    private final PsiElement substituteDestructuringShorthanding(PsiElement element, Editor editor, Pass<? super PsiElement> renameCallback) {
        if (!(element instanceof JSVariable)) {
            return element;
        }
        PsiElement psiElement = ((JSVariable)element).getParent();
        JSDestructuringShorthandedProperty jSDestructuringShorthandedProperty = psiElement instanceof JSDestructuringShorthandedProperty ? (JSDestructuringShorthandedProperty)psiElement : null;
        if (jSDestructuringShorthandedProperty == null) {
            return element;
        }
        JSDestructuringShorthandedProperty parent = jSDestructuringShorthandedProperty;
        PsiReference psiReference = parent.getReference();
        JSDestructuringPropertyReference jSDestructuringPropertyReference = psiReference instanceof JSDestructuringPropertyReference ? (JSDestructuringPropertyReference)psiReference : null;
        if (jSDestructuringPropertyReference == null) {
            return element;
        }
        JSDestructuringPropertyReference propertyRef = jSDestructuringPropertyReference;
        PsiElement psiElement2 = propertyRef.resolve();
        if (psiElement2 == null) {
            return element;
        }
        PsiElement shorthandedPropertyResolve = psiElement2;
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)shorthandedPropertyResolve, (ElementDescriptionLocation)((ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementDescription(...)");
        String description = string;
        Object[] objectArray = new Object[]{description};
        String string2 = JavaScriptBundle.message("javascript.rename.destructuring.target.dialog.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String string3 = JavaScriptBundle.message("javascript.rename.choose.target.message", new Object[0]);
        objectArray = new Object[]{description};
        String string4 = JavaScriptBundle.message("javascript.destructuring.initializer", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        String string5 = JavaScriptBundle.message("javascript.destructuring.variable.only", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        return this.substituteWithPopup(editor, renameCallback, string2, string3, shorthandedPropertyResolve, string4, element, string5);
    }

    @Contract(value="null,null,_,_,_,_,_,_ -> fail")
    @Nullable
    protected final PsiElement substituteWithPopup(@Nullable Editor editor, @Nullable Pass<? super PsiElement> renameCallback, @NotNull String title, @Nullable String message, @NotNull PsiElement defaultElement, @NotNull String defaultElementLabel, @NotNull PsiElement otherElement, @NotNull String otherElementLabel) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)defaultElement, (String)"defaultElement");
        Intrinsics.checkNotNullParameter((Object)defaultElementLabel, (String)"defaultElementLabel");
        Intrinsics.checkNotNullParameter((Object)otherElement, (String)"otherElement");
        Intrinsics.checkNotNullParameter((Object)otherElementLabel, (String)"otherElementLabel");
        if (defaultElement == otherElement) {
            return this.processSubstituted(defaultElement, editor, (Consumer)renameCallback);
        }
        if (renameCallback == null || ApplicationManager.getApplication().isUnitTestMode()) {
            boolean isOk;
            String string = message;
            if (string == null) {
                string = "";
            }
            return this.processSubstituted((isOk = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(title, string).yesText(defaultElementLabel)).noText(otherElementLabel)).ask(defaultElement.getProject())) ? defaultElement : otherElement, editor, (Consumer)renameCallback);
        }
        if (editor == null) {
            boolean bl = false;
            String string = "editor must be provided for inplace rename";
            throw new IllegalStateException(string.toString());
        }
        Object[] objectArray = new JSRenameTargetChooser.OptionData[]{new JSRenameTargetChooser.OptionData(defaultElement, defaultElementLabel), new JSRenameTargetChooser.OptionData(otherElement, otherElementLabel)};
        JSRenameTargetChooser.INSTANCE.show(editor, CollectionsKt.listOf((Object[])objectArray), (Function1<? super JSRenameTargetChooser.OptionData, Unit>)((Function1)arg_0 -> JSDefaultRenameProcessor.substituteWithPopup$lambda$9(this, editor, renameCallback, arg_0)));
        return null;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean isContextTypeScript = nameSuggestionContext != null && DialectDetector.isTypeScript(nameSuggestionContext);
        boolean isElementToRenameTypeScript = DialectDetector.isTypeScript(element);
        this.myForceShowPreview = JSDefaultRenameProcessor.Companion.forcesShowPreview(element);
        if (!isContextTypeScript) {
            if (isElementToRenameTypeScript) {
                Companion.setSearchJavaScriptReferences(element, true);
            }
            RenameDialog renameDialog = super.createRenameDialog(project, element, nameSuggestionContext, editor);
            Intrinsics.checkNotNullExpressionValue((Object)renameDialog, (String)"createRenameDialog(...)");
            return renameDialog;
        }
        return new RenameDialog(project, element, nameSuggestionContext, editor){
            private JCheckBox myCbSearchForJSReferences;
            private JCheckBox myCbSearchForDynamicReferences;
            final /* synthetic */ PsiElement $element;
            {
                this.$element = $element;
                super($project, $element, $nameSuggestionContext, $editor);
            }

            protected void createCheckboxes(JPanel panel, GridBagConstraints gbConstraints) {
                Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
                Intrinsics.checkNotNullParameter((Object)gbConstraints, (String)"gbConstraints");
                gbConstraints.insets = (Insets)JBUI.insetsBottom((int)4);
                gbConstraints.gridwidth = 1;
                gbConstraints.gridx = 0;
                gbConstraints.weighty = 0.0;
                gbConstraints.weightx = 1.0;
                gbConstraints.fill = 1;
                this.myCbSearchForJSReferences = (JCheckBox)new NonFocusableCheckBox(JavaScriptBundle.message("typescript.rename.javascript.references", new Object[0]));
                JCheckBox jCheckBox = this.myCbSearchForJSReferences;
                if (jCheckBox == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myCbSearchForJSReferences");
                    jCheckBox = null;
                }
                jCheckBox.setSelected(JSDefaultRenameProcessor.Companion.getSearchJavaScriptReferences(this.$element));
                JCheckBox jCheckBox2 = this.myCbSearchForJSReferences;
                if (jCheckBox2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myCbSearchForJSReferences");
                    jCheckBox2 = null;
                }
                panel.add((Component)jCheckBox2, gbConstraints);
                this.myCbSearchForDynamicReferences = (JCheckBox)new NonFocusableCheckBox(JavaScriptBundle.message("typescript.rename.dynamic.references", new Object[0]));
                JCheckBox jCheckBox3 = this.myCbSearchForDynamicReferences;
                if (jCheckBox3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myCbSearchForDynamicReferences");
                    jCheckBox3 = null;
                }
                jCheckBox3.setSelected(JSDefaultRenameProcessor.Companion.getSearchDynamicReferences(this.$element));
                JCheckBox jCheckBox4 = this.myCbSearchForDynamicReferences;
                if (jCheckBox4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myCbSearchForDynamicReferences");
                    jCheckBox4 = null;
                }
                panel.add((Component)jCheckBox4, gbConstraints);
                super.createCheckboxes(panel, gbConstraints);
                JCheckBox comments = this.getCbSearchInComments();
                panel.remove(comments);
                gbConstraints.insets = (Insets)JBUI.insets((int)0, (int)10, (int)4, (int)0);
                gbConstraints.gridwidth = 0;
                gbConstraints.gridx = 1;
                gbConstraints.weightx = 1.0;
                gbConstraints.fill = 1;
                panel.add((Component)comments, gbConstraints);
            }

            protected void doAction() {
                JCheckBox jCheckBox = this.myCbSearchForJSReferences;
                if (jCheckBox == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myCbSearchForJSReferences");
                    jCheckBox = null;
                }
                JSDefaultRenameProcessor.Companion.setSearchJavaScriptReferences(this.$element, jCheckBox.isSelected());
                JCheckBox jCheckBox2 = this.myCbSearchForDynamicReferences;
                if (jCheckBox2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myCbSearchForDynamicReferences");
                    jCheckBox2 = null;
                }
                JSDefaultRenameProcessor.Companion.setSearchDynamicReferences(this.$element, jCheckBox2.isSelected());
                super.doAction();
            }
        };
    }

    @Nullable
    protected final PsiElement processSubstituted(@NotNull PsiElement psiElement, @Nullable Editor editor, @Nullable Consumer<? super PsiElement> renameCallback) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (!PsiElementRenameHandler.canRename((Project)psiElement.getProject(), (Editor)editor, (PsiElement)psiElement)) {
            return null;
        }
        if (renameCallback != null) {
            renameCallback.accept((PsiElement)super.substituteElementToRename(psiElement, editor));
            return null;
        }
        return psiElement;
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        if (element instanceof ImplicitJSVariableImpl) {
            return;
        }
        PsiElement parent = element.getParent();
        JSDestructuringProperty destructuringProperty = element instanceof JSVariable && parent instanceof JSDestructuringProperty ? (JSDestructuringProperty)parent : null;
        PsiElement elementToRename = element;
        if (destructuringProperty != null) {
            destructuringProperty = destructuringProperty.setDestructuringElementName(newName);
            JSInitializerOwner jSInitializerOwner = destructuringProperty.getDestructuringElement();
            Intrinsics.checkNotNull((Object)jSInitializerOwner);
            elementToRename = (PsiElement)jSInitializerOwner;
        }
        JSDefaultRenameProcessor.Companion.processShorthandProperties(elementToRename, newName, usages);
        super.renameElement(elementToRename, newName, usages, listener2);
    }

    @NotNull
    public UsageInfo createUsageInfo(@NotNull PsiElement element, @NotNull PsiReference ref2, @NotNull PsiElement referenceElement) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)referenceElement, (String)"referenceElement");
        MoveRenameUsageInfo result2 = new MoveRenameUsageInfo(referenceElement, ref2, ref2.getRangeInElement().getStartOffset(), ref2.getRangeInElement().getEndOffset(), element, JSDefaultRenameProcessor.Companion.isNonCodeUsage(ref2));
        if (JSDefaultRenameProcessor.Companion.isTypeScriptMergedTypeUsage(element, ref2)) {
            result2.setDynamicUsage(false);
        } else if (JSUsageViewElementsListener.checkIfJavaScriptDynamicUsage((UsageInfo)result2, SetsKt.setOf((Object)element))) {
            result2.setDynamicUsage(true);
        }
        return (UsageInfo)result2;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PropertiesComponent.getInstance().setValue(SEARCH_FOR_TEXT_OCCURRENCES, String.valueOf(enabled));
        super.setToSearchForTextOccurrences(element, enabled);
    }

    public boolean showRenamePreviewButton(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return !JSDefaultRenameProcessor.Companion.forcesShowPreview(psiElement);
    }

    public boolean forcesShowPreview() {
        return this.myForceShowPreview;
    }

    private static final Unit substituteWithPopup$lambda$9(JSDefaultRenameProcessor this$0, Editor $editor, Pass $renameCallback, JSRenameTargetChooser.OptionData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.processSubstituted(it.getElement(), $editor, (Consumer)$renameCallback);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final Collection<PsiReference> getReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings, @NotNull ReferencesType type2) {
        return Companion.getReferences(element, searchScope, searchInCommentsAndStrings, type2);
    }

    @JvmStatic
    @NotNull
    public static final SearchScope getScope(@NotNull PsiElement element, @NotNull ReferencesType type2) {
        return Companion.getScope(element, type2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Collection<PsiReference> findReferencesForScope(@NotNull PsiElement element, boolean searchInCommentsAndStrings, @NotNull SearchScope useScope, long timeoutMs) {
        return Companion.findReferencesForScope(element, searchInCommentsAndStrings, useScope, timeoutMs);
    }

    @JvmStatic
    public static final boolean acceptReference(@NotNull PsiReference psiReference, boolean searchInCommentsAndStrings, boolean hasES6Imports, @NotNull PsiElement renameTarget, boolean checkStrictness) {
        return Companion.acceptReference(psiReference, searchInCommentsAndStrings, hasES6Imports, renameTarget, checkStrictness);
    }

    @JvmStatic
    public static final boolean isStrictEnoughReference(@NotNull PsiReference psiReference) {
        return Companion.isStrictEnoughReference(psiReference);
    }

    @JvmStatic
    public static final boolean getSearchJavaScriptReferences(@NotNull PsiElement element) {
        return Companion.getSearchJavaScriptReferences(element);
    }

    @JvmStatic
    public static final boolean getSearchJavaScriptReferences(@NotNull Project project) {
        return Companion.getSearchJavaScriptReferences(project);
    }

    @JvmStatic
    public static final void setSearchJavaScriptReferences(@NotNull Project project, boolean enabled) {
        Companion.setSearchJavaScriptReferences(project, enabled);
    }

    @JvmStatic
    public static final boolean getSearchDynamicReferences(@NotNull PsiElement project) {
        return Companion.getSearchDynamicReferences(project);
    }

    @JvmStatic
    public static final void setSearchDynamicReferences(@NotNull Project project, boolean enabled) {
        Companion.setSearchDynamicReferences(project, enabled);
    }

    @JvmStatic
    @NotNull
    public static final List<JSProperty> collectShorthandPropertyUsages(@NotNull Collection<? extends PsiReference> refs) {
        return Companion.collectShorthandPropertyUsages(refs);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Collection<PsiReference> findReferencesForScope(@NotNull PsiElement element, boolean searchInCommentsAndStrings, @NotNull SearchScope useScope) {
        return Companion.findReferencesForScope(element, searchInCommentsAndStrings, useScope);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J0\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00162\b\b\u0002\u0010\u001d\u001a\u00020\u0006H\u0007J.\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00162\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J0\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\bH\u0007J\u001c\u0010&\u001a\u00020\b2\b\u0010'\u001a\u0004\u0018\u00010\u00142\b\u0010(\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010)\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0012H\u0007J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010+\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020,H\u0002J+\u0010-\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\f2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0002\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\u0012H\u0002J\u0018\u00105\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u0012H\u0002J\u0010\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020\u0014H\u0002J\u0010\u00108\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020:H\u0007J\u0016\u0010;\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\bJ\u0018\u0010;\u001a\u00020\u001f2\u0006\u00109\u001a\u00020:2\u0006\u0010<\u001a\u00020\bH\u0007J\u0010\u0010=\u001a\u00020\b2\u0006\u00109\u001a\u00020\u0014H\u0007J\u0016\u0010>\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\bJ\u0018\u0010>\u001a\u00020\u001f2\u0006\u00109\u001a\u00020:2\u0006\u0010<\u001a\u00020\bH\u0007J\u001c\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor$Companion;", "", "<init>", "()V", "FORCE_SEARCH_FOR_FILE_REFERENCES_KEY", "Lcom/intellij/openapi/util/Key;", "", "SEARCH_FOR_DYNAMIC_DEFAULT", "", "SEARCH_FOR_JAVASCRIPT_DEFAULT", "SEARCH_IN_STRINGS_AND_COMMENTS_DEFAULT_VALUE", "SEARCH_IN_COMMENTS", "", "SEARCH_FOR_TEXT_OCCURRENCES", "SEARCH_FOR_JAVASCRIPT_OCCURRENCES", "SEARCH_FOR_DYNAMIC_OCCURRENCES", "getReferences", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "searchInCommentsAndStrings", "type", "Lcom/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor$ReferencesType;", "getScope", "findReferencesForScope", "useScope", "timeoutMs", "doFindReferencesForScope", "", "outResult", "acceptReference", "psiReference", "hasES6Imports", "renameTarget", "checkStrictness", "importDefinesLocalName", "importElement", "elementName", "isStrictEnoughReference", "substituteOverload", "isTopLevelElementInMatchingFile", "Lcom/intellij/lang/javascript/psi/JSNamedElement;", "processShorthandProperties", "newName", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;)V", "isNonCodeUsage", "ref", "isTypeScriptMergedTypeUsage", "forcesShowPreview", "psiElement", "getSearchJavaScriptReferences", "project", "Lcom/intellij/openapi/project/Project;", "setSearchJavaScriptReferences", "enabled", "getSearchDynamicReferences", "setSearchDynamicReferences", "collectShorthandPropertyUsages", "", "Lcom/intellij/lang/javascript/psi/JSProperty;", "refs", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nJSDefaultRenameProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSDefaultRenameProcessor.kt\ncom/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,740:1\n11476#2,9:741\n13402#2:750\n13403#2:752\n11485#2:753\n12364#2,2:754\n1#3:751\n*S KotlinDebug\n*F\n+ 1 JSDefaultRenameProcessor.kt\ncom/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor$Companion\n*L\n652#1:741,9\n652#1:750\n652#1:752\n652#1:753\n679#1:754,2\n652#1:751\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Collection<PsiReference> getReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings, @NotNull ReferencesType type2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            ApplicationManager.getApplication().assertReadAccessAllowed();
            SearchScope searchScope2 = this.getScope(element, type2).intersectWith(searchScope);
            Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"intersectWith(...)");
            return com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor$Companion.findReferencesForScope$default(this, element, searchInCommentsAndStrings, searchScope2, 0L, 8, null);
        }

        @JvmStatic
        @NotNull
        public final SearchScope getScope(@NotNull PsiElement element, @NotNull ReferencesType type2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            SearchScope searchScope = element.getUseScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getUseScope(...)");
            SearchScope defaultScope = searchScope;
            if (!(defaultScope instanceof GlobalSearchScope) || type2 == ReferencesType.ALL) {
                return defaultScope;
            }
            boolean useJS = type2 == ReferencesType.JS;
            return (SearchScope)new DelegatingGlobalSearchScope(defaultScope, useJS){
                final /* synthetic */ boolean $useJS;
                {
                    this.$useJS = $useJS;
                    super((GlobalSearchScope)$defaultScope);
                }

                public boolean contains(VirtualFile file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    if (!super.contains(file)) {
                        return false;
                    }
                    return this.$useJS == DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType());
                }
            };
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Collection<PsiReference> findReferencesForScope(@NotNull PsiElement element, boolean searchInCommentsAndStrings, @NotNull SearchScope useScope, long timeoutMs) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)useScope, (String)"useScope");
            List<PsiReference> result2 = Collections.synchronizedList(new ArrayList());
            if (timeoutMs > 0L) {
                Unit cfr_ignored_0 = (Unit)ProgressIndicatorUtils.withTimeout((long)timeoutMs, (Computable)new Computable(element, searchInCommentsAndStrings, useScope, result2){
                    final /* synthetic */ PsiElement $element;
                    final /* synthetic */ boolean $searchInCommentsAndStrings;
                    final /* synthetic */ SearchScope $useScope;
                    final /* synthetic */ List<PsiReference> $result;
                    {
                        this.$element = $element;
                        this.$searchInCommentsAndStrings = $searchInCommentsAndStrings;
                        this.$useScope = $useScope;
                        this.$result = $result;
                    }

                    public final Void compute() {
                        List<PsiReference> list = this.$result;
                        Intrinsics.checkNotNull(list);
                        com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor$Companion.access$doFindReferencesForScope(JSDefaultRenameProcessor.Companion, this.$element, this.$searchInCommentsAndStrings, this.$useScope, list);
                        return null;
                    }
                });
            } else {
                Intrinsics.checkNotNull(result2);
                this.doFindReferencesForScope(element, searchInCommentsAndStrings, useScope, (Collection<? extends PsiReference>)result2);
            }
            Intrinsics.checkNotNull(result2);
            return result2;
        }

        public static /* synthetic */ Collection findReferencesForScope$default(Companion companion, PsiElement psiElement, boolean bl, SearchScope searchScope, long l, int n, Object object) {
            if ((n & 8) != 0) {
                l = -1L;
            }
            return companion.findReferencesForScope(psiElement, bl, searchScope, l);
        }

        private final void doFindReferencesForScope(PsiElement element, boolean searchInCommentsAndStrings, SearchScope useScope, Collection<? extends PsiReference> outResult) {
            DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
            boolean checkStrict = holder != null && holder.isTypeScript && !this.getSearchDynamicReferences(element);
            boolean hasES6Imports = holder != null && (holder.isTypeScript || holder.isECMA6);
            ReferencesSearch.search((PsiElement)element, (SearchScope)useScope).forEach((Processor)new CommonProcessors.CollectProcessor<PsiReference>(outResult, searchInCommentsAndStrings, hasES6Imports, element, checkStrict){
                final /* synthetic */ boolean $searchInCommentsAndStrings;
                final /* synthetic */ boolean $hasES6Imports;
                final /* synthetic */ PsiElement $element;
                final /* synthetic */ boolean $checkStrict;
                {
                    this.$searchInCommentsAndStrings = $searchInCommentsAndStrings;
                    this.$hasES6Imports = $hasES6Imports;
                    this.$element = $element;
                    this.$checkStrict = $checkStrict;
                    super($outResult);
                }

                protected boolean accept(PsiReference psiReference) {
                    Intrinsics.checkNotNullParameter((Object)psiReference, (String)"psiReference");
                    return JSDefaultRenameProcessor.Companion.acceptReference(psiReference, this.$searchInCommentsAndStrings, this.$hasES6Imports, this.$element, this.$checkStrict);
                }
            });
        }

        @JvmStatic
        public final boolean acceptReference(@NotNull PsiReference psiReference, boolean searchInCommentsAndStrings, boolean hasES6Imports, @NotNull PsiElement renameTarget, boolean checkStrictness) {
            PsiElement resolve2;
            String elementName;
            Intrinsics.checkNotNullParameter((Object)psiReference, (String)"psiReference");
            Intrinsics.checkNotNullParameter((Object)renameTarget, (String)"renameTarget");
            if (psiReference instanceof JSNonRenameableReference) {
                return false;
            }
            if (!this.isStrictEnoughReference(psiReference)) {
                return searchInCommentsAndStrings;
            }
            if (checkStrictness && JSResolveUtil.isResolveDynamic(psiReference, SetsKt.setOf((Object)renameTarget))) {
                return false;
            }
            PsiElement psiElement = psiReference.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
            PsiElement referenceElement = psiElement;
            if (JSResolveUtil.isSelfReference(renameTarget, referenceElement)) {
                return false;
            }
            if (!hasES6Imports) {
                return true;
            }
            if (renameTarget instanceof ES6ImportExportSpecifierAlias) {
                return true;
            }
            String string = elementName = renameTarget instanceof JSNamedElement ? ((JSNamedElement)renameTarget).getName() : null;
            if (referenceElement instanceof ES6ImportExportSpecifier && Intrinsics.areEqual((Object)"default", (Object)((ES6ImportExportSpecifier)referenceElement).getReferenceName())) {
                return false;
            }
            if (referenceElement instanceof JSReferenceExpression && ((JSReferenceExpression)referenceElement).getQualifier() == null || referenceElement instanceof ES6ImportExportSpecifier) {
                PsiElement item;
                ResolveResult[] resolveResultArray = ((PsiPolyVariantReference)referenceElement).multiResolve(false);
                Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
                ResolveResult[] results = resolveResultArray;
                if (results.length == 1 && (renameTarget.isEquivalentTo(item = results[0].getElement()) || item instanceof TypeScriptProxyImplicitElement && renameTarget.isEquivalentTo(((TypeScriptProxyImplicitElement)item).getExplicitElement()))) {
                    return true;
                }
                for (ResolveResult result2 : results) {
                    if (!this.importDefinesLocalName(result2.getElement(), elementName)) continue;
                    return false;
                }
            }
            if (this.importDefinesLocalName(referenceElement, elementName)) {
                return false;
            }
            if (referenceElement instanceof JSXmlLiteralExpression && DialectDetector.isJSX(renameTarget) && (resolve2 = psiReference.resolve()) != null) {
                if (renameTarget.isEquivalentTo(resolve2)) {
                    return true;
                }
                if (this.importDefinesLocalName(resolve2, elementName)) {
                    return false;
                }
            }
            return true;
        }

        private final boolean importDefinesLocalName(PsiElement importElement, String elementName) {
            PsiElement importElement2 = importElement;
            if (importElement2 instanceof TypeScriptImplicitOverloadedAliasElement) {
                importElement2 = (PsiElement)((TypeScriptImplicitOverloadedAliasElement)importElement2).getAliasElement();
            }
            if (importElement2 instanceof ES6ImportedBinding) {
                return !StringUtil.equals((CharSequence)((ES6ImportedBinding)importElement2).getName(), (CharSequence)elementName);
            }
            return importElement2 instanceof ES6ImportExportSpecifierAlias || importElement2 instanceof TypeScriptImportStatement;
        }

        @JvmStatic
        public final boolean isStrictEnoughReference(@NotNull PsiReference psiReference) {
            Intrinsics.checkNotNullParameter((Object)psiReference, (String)"psiReference");
            if (psiReference instanceof JSXNamespaceReference) {
                return true;
            }
            PsiElement psiElement = psiReference.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
            PsiElement element = psiElement;
            if (psiReference instanceof JsonPropertyNameReference) {
                return false;
            }
            if (psiReference instanceof JSLiteralTextReference) {
                return !((JSLiteralTextReference)psiReference).isTextOnlyReference();
            }
            if (!(element instanceof JSLiteralExpression) || !psiReference.isSoft()) {
                return true;
            }
            return element.getParent() instanceof JSIndexedPropertyAccessExpression;
        }

        private final PsiElement substituteOverload(PsiElement element) {
            TypeScriptFunction impl;
            if (element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isOverloadDeclaration() && (impl = TypeScriptPsiUtil.getOverloadImplementation((TypeScriptFunction)element)) != null) {
                return impl;
            }
            return element;
        }

        private final boolean isTopLevelElementInMatchingFile(JSNamedElement element) {
            JSSourceElement sourceElement = null;
            if (element instanceof JSVariable) {
                sourceElement = ((JSVariable)element).getStatement();
            } else if (element.getContext() instanceof ES6ExportDefaultAssignment) {
                PsiElement psiElement = element.getContext();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment");
                sourceElement = (ES6ExportDefaultAssignment)psiElement;
            } else if (element instanceof JSSourceElement) {
                sourceElement = (JSSourceElement)((Object)element);
            }
            return sourceElement != null && sourceElement.getParent() instanceof JSFile && JSNameSuggestionsUtil.matchesFileNameRelaxed(element);
        }

        /*
         * WARNING - void declaration
         */
        private final void processShorthandProperties(PsiElement element, String newName, UsageInfo[] usages) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            if (element instanceof JSProperty && ((JSProperty)element).isShorthanded()) {
                ES6ChangeUtil.expandShorthandPropertyWithName((JSProperty)element, newName);
            }
            boolean isTypeMemberOrRequiresQualifiedAccess = element instanceof JSProperty || element instanceof TypeScriptTypeMember || JSUtils.isMember(element);
            UsageInfo[] usageInfoArray = usages;
            Companion companion = this;
            boolean $i$f$mapNotNull = false;
            void var8_10 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                PsiReference it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (it.getReference() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List<JSProperty> shorthandUsages = companion.collectShorthandPropertyUsages((List)destination$iv$iv);
            if (isTypeMemberOrRequiresQualifiedAccess) {
                for (JSProperty usage : shorthandUsages) {
                    ES6ChangeUtil.expandShorthandPropertyWithName(usage, newName);
                }
            } else {
                for (JSProperty usage : shorthandUsages) {
                    ES6ChangeUtil.expandShorthandPropertyWithValue(usage, newName);
                }
            }
        }

        private final boolean isNonCodeUsage(PsiReference ref2) {
            if (!this.isStrictEnoughReference(ref2)) {
                return true;
            }
            return ref2.resolve() == null && (!(ref2 instanceof PsiPolyVariantReference) || ((PsiPolyVariantReference)ref2).multiResolve(true).length <= 0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isTypeScriptMergedTypeUsage(PsiElement element, PsiReference ref2) {
            if (!DialectDetector.isTypeScript(element)) return false;
            if (!(ref2 instanceof PsiPolyVariantReference)) return false;
            ResolveResult[] resolveResultArray = ((PsiPolyVariantReference)ref2).multiResolve(true);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
            ResolveResult[] resolveResults = resolveResultArray;
            if (resolveResults.length <= 0) return false;
            ResolveResult[] $this$all$iv = resolveResults;
            boolean $i$f$all = false;
            int n = 0;
            int n2 = $this$all$iv.length;
            while (n < n2) {
                ResolveResult element$iv;
                ResolveResult it = element$iv = $this$all$iv[n];
                boolean bl = false;
                if (!(it.getElement() instanceof TypeScriptProxyImplicitElement)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private final boolean forcesShowPreview(PsiElement psiElement) {
            if (DialectDetector.isTypeScript(psiElement) || DialectDetector.isActionScript(psiElement)) {
                return false;
            }
            PsiFile file = psiElement.getContainingFile();
            return file != null && !JSInplaceRenameHandler.isSuitableForInplaceRename(psiElement, file);
        }

        @JvmStatic
        public final boolean getSearchJavaScriptReferences(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return this.getSearchJavaScriptReferences(project);
        }

        @JvmStatic
        public final boolean getSearchJavaScriptReferences(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return PropertiesComponent.getInstance((Project)project).getBoolean(JSDefaultRenameProcessor.SEARCH_FOR_JAVASCRIPT_OCCURRENCES, true);
        }

        public final void setSearchJavaScriptReferences(@NotNull PsiElement element, boolean enabled) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.setSearchJavaScriptReferences(project, enabled);
        }

        @JvmStatic
        public final void setSearchJavaScriptReferences(@NotNull Project project, boolean enabled) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PropertiesComponent.getInstance((Project)project).setValue(JSDefaultRenameProcessor.SEARCH_FOR_JAVASCRIPT_OCCURRENCES, enabled, true);
        }

        @JvmStatic
        public final boolean getSearchDynamicReferences(@NotNull PsiElement project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return PropertiesComponent.getInstance((Project)project.getProject()).getBoolean(JSDefaultRenameProcessor.SEARCH_FOR_DYNAMIC_OCCURRENCES, false);
        }

        public final void setSearchDynamicReferences(@NotNull PsiElement element, boolean enabled) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            this.setSearchDynamicReferences(project2, enabled);
        }

        @JvmStatic
        public final void setSearchDynamicReferences(@NotNull Project project, boolean enabled) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PropertiesComponent.getInstance((Project)project).setValue(JSDefaultRenameProcessor.SEARCH_FOR_DYNAMIC_OCCURRENCES, enabled, false);
        }

        @JvmStatic
        @NotNull
        public final List<JSProperty> collectShorthandPropertyUsages(@NotNull Collection<? extends PsiReference> refs) {
            Intrinsics.checkNotNullParameter(refs, (String)"refs");
            ArrayList<JSProperty> results = new ArrayList<JSProperty>();
            for (PsiReference psiReference : refs) {
                PsiElement element = psiReference instanceof JSPropertyNameReference ? (PsiElement)((JSPropertyNameReference)psiReference).getElement() : psiReference.getElement().getParent();
                JSProperty property = element instanceof JSProperty ? (JSProperty)element : null;
                if (property == null || !property.isShorthanded()) continue;
                results.add(property);
            }
            return results;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Collection<PsiReference> findReferencesForScope(@NotNull PsiElement element, boolean searchInCommentsAndStrings, @NotNull SearchScope useScope) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)useScope, (String)"useScope");
            return com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor$Companion.findReferencesForScope$default(this, element, searchInCommentsAndStrings, useScope, 0L, 8, null);
        }

        public static final /* synthetic */ void access$doFindReferencesForScope(Companion $this, PsiElement element, boolean searchInCommentsAndStrings, SearchScope useScope, Collection outResult) {
            $this.doFindReferencesForScope(element, searchInCommentsAndStrings, useScope, outResult);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0002\u00c0\u0006\u0001"}, d2={"Lcom/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor$JSNonRenameableReference;", "Lcom/intellij/psi/PsiReference;", "intellij.javascript.impl"})
    public static interface JSNonRenameableReference
    extends PsiReference {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor$ReferencesType;", "", "<init>", "(Ljava/lang/String;I)V", "ALL", "TS", "JS", "intellij.javascript.impl"})
    public static final class ReferencesType
    extends Enum<ReferencesType> {
        public static final /* enum */ ReferencesType ALL = new ReferencesType();
        public static final /* enum */ ReferencesType TS = new ReferencesType();
        public static final /* enum */ ReferencesType JS = new ReferencesType();
        private static final /* synthetic */ ReferencesType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ReferencesType[] values() {
            return (ReferencesType[])$VALUES.clone();
        }

        public static ReferencesType valueOf(String value) {
            return Enum.valueOf(ReferencesType.class, value);
        }

        @NotNull
        public static EnumEntries<ReferencesType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = referencesTypeArray = new ReferencesType[]{ReferencesType.ALL, ReferencesType.TS, ReferencesType.JS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

