/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.JSFunctionExpressionToArrowFunctionInspection;
import com.intellij.lang.javascript.intentions.JSAnonymousToNamedFunctionIntention;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSArrowFunctionToAnonymousIntention
extends JavaScriptIntention {
    public JSArrowFunctionToAnonymousIntention() {
        this.setText(JavaScriptBundle.message("js.convert.to.anonymous.function", new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSArrowFunctionToAnonymousIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSArrowFunctionToAnonymousIntention.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(project, editor, element) || !DialectDetector.hasFeature(element, JSLanguageFeature.ARROW_FUNCTIONS)) {
            return false;
        }
        JSFunctionExpression functionExpression = JSAnonymousToNamedFunctionIntention.getWrappingAnonymousFunction(element);
        return functionExpression != null && functionExpression.isArrowFunction() && !JSUtils.isMember((PsiElement)functionExpression.getElementAssignedTo()) && !JSFunctionExpressionToArrowFunctionInspection.hasThisReferences(functionExpression);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSArrowFunctionToAnonymousIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSArrowFunctionToAnonymousIntention.$$$reportNull$$$0(3);
        }
        JSFunctionExpression arrowFunction = JSAnonymousToNamedFunctionIntention.getWrappingAnonymousFunction(element);
        assert (arrowFunction != null);
        boolean removeParentheses = arrowFunction.getParent() instanceof JSParenthesizedExpression && arrowFunction.getParent().getParent() instanceof JSReferenceExpression;
        JSFunctionExpression anonymousFunction = JSFunctionsRefactoringUtil.createAnonymousFunctionExpression(arrowFunction);
        JSElement replaced = (JSElement)PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> JSChangeUtil.replaceElement(removeParentheses ? (JSElement)arrowFunction.getParent() : arrowFunction, anonymousFunction));
        FormatFixer.create((PsiElement)replaced, FormatFixer.Mode.Reformat).fixFormat();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.convert.to.anonymous.function.family.name", new Object[0]);
        if (string == null) {
            JSArrowFunctionToAnonymousIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSArrowFunctionToAnonymousIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSArrowFunctionToAnonymousIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

