/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.config.JSFileImports;
import com.intellij.lang.javascript.config.JSImportResolveContext;
import com.intellij.lang.javascript.config.JSImportSimpleResolveContextImpl;
import com.intellij.lang.javascript.config.graph.JSImportGraph;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSFileImportsResolverImpl;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeIndex;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0016J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/ecmascript6/psi/impl/JSCrossLocalPackageImports;", "Lcom/intellij/lang/javascript/config/JSFileImports;", "project", "Lcom/intellij/openapi/project/Project;", "rootDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "resolver", "Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSFileImportsResolverImpl;", "getRootFiles", "", "getOutFiles", "", "file", "consumer", "Ljava/util/function/Consumer;", "resolveFile", "moduleName", "", "containingFile", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSCrossLocalPackageImports.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSCrossLocalPackageImports.kt\ncom/intellij/lang/ecmascript6/psi/impl/JSCrossLocalPackageImports\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,101:1\n37#2:102\n36#2,3:103\n1317#3,2:106\n*S KotlinDebug\n*F\n+ 1 JSCrossLocalPackageImports.kt\ncom/intellij/lang/ecmascript6/psi/impl/JSCrossLocalPackageImports\n*L\n66#1:102\n66#1:103,3\n94#1:106,2\n*E\n"})
public final class JSCrossLocalPackageImports
implements JSFileImports {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile rootDirectory;
    @NotNull
    private final JSFileImportsResolverImpl resolver;

    public JSCrossLocalPackageImports(@NotNull Project project, @NotNull VirtualFile rootDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        this.project = project;
        this.rootDirectory = rootDirectory;
        JSImportResolveContext jSImportResolveContext = new JSImportSimpleResolveContextImpl(this.rootDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)JSFileReferencesUtil.IMPLICIT_EXTENSIONS, (String)"IMPLICIT_EXTENSIONS");
        this.resolver = new JSFileImportsResolverImpl(this.project, jSImportResolveContext, JSFileReferencesUtil.IMPLICIT_EXTENSIONS);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRootFiles() {
        Set<FileType> set = JavaScriptIndex.getFileTypesToIndexJS();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getFileTypesToIndexJS(...)");
        Set<FileType> fileTypes = set;
        Collection $this$toTypedArray$iv = fileTypes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        FileType[] fileTypeArray = thisCollection$iv.toArray(new FileType[0]);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.project), (FileType[])Arrays.copyOf(fileTypeArray, fileTypeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getScopeRestrictedByFileTypes(...)");
        GlobalSearchScope parentScope = globalSearchScope;
        DelegatingGlobalSearchScope scope2 = new DelegatingGlobalSearchScope(parentScope, this){
            final /* synthetic */ JSCrossLocalPackageImports this$0;
            {
                this.this$0 = $receiver;
                super($parentScope);
            }

            public boolean contains(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return VfsUtil.isAncestor((VirtualFile)JSCrossLocalPackageImports.access$getRootDirectory$p(this.this$0), (VirtualFile)file, (boolean)true) && !JSLibraryUtil.isProbableLibraryFile(file) && super.contains(file);
            }
        };
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        for (FileType type2 : fileTypes) {
            ProgressManager.checkCanceled();
            FileTypeIndex.processFiles((FileType)type2, (Processor)((Processor)processor), (GlobalSearchScope)((GlobalSearchScope)scope2));
        }
        Collection collection = processor.getResults();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getResults(...)");
        return CollectionsKt.toSet((Iterable)collection);
    }

    @Override
    public void getOutFiles(@NotNull VirtualFile file, @NotNull Consumer<VirtualFile> consumer) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        List list = FileIncludeIndex.getIncludes((VirtualFile)file, (Project)this.project).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        Sequence $this$forEach$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), JSCrossLocalPackageImports::getOutFiles$lambda$0), JSCrossLocalPackageImports::getOutFiles$lambda$1), arg_0 -> JSCrossLocalPackageImports.getOutFiles$lambda$2(this, file, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            consumer.accept(it);
        }
    }

    @Override
    @Nullable
    public VirtualFile resolveFile(@NotNull String moduleName, @NotNull VirtualFile containingFile) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        return this.resolver.resolveFileModule(moduleName, containingFile);
    }

    private static final String getOutFiles$lambda$0(FileIncludeInfo it) {
        return it.path;
    }

    private static final boolean getOutFiles$lambda$1(String it) {
        Intrinsics.checkNotNull((Object)it);
        return StringsKt.startsWith$default((String)it, (String)".", (boolean)false, (int)2, null);
    }

    private static final VirtualFile getOutFiles$lambda$2(JSCrossLocalPackageImports this$0, VirtualFile $file, String it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.resolveFile(it, $file);
    }

    public static final /* synthetic */ VirtualFile access$getRootDirectory$p(JSCrossLocalPackageImports $this) {
        return $this.rootDirectory;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/ecmascript6/psi/impl/JSCrossLocalPackageImports$Companion;", "", "<init>", "()V", "detectRelatedRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "rootDirectory", "calculateRelatedRoots", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nJSCrossLocalPackageImports.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSCrossLocalPackageImports.kt\ncom/intellij/lang/ecmascript6/psi/impl/JSCrossLocalPackageImports$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1863#2:102\n1864#2:104\n1#3:103\n*S KotlinDebug\n*F\n+ 1 JSCrossLocalPackageImports.kt\ncom/intellij/lang/ecmascript6/psi/impl/JSCrossLocalPackageImports$Companion\n*L\n46#1:102\n46#1:104\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<VirtualFile> detectRelatedRoots(@NotNull Project project, @NotNull VirtualFile rootDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
            PsiDirectory psiDirectory = PsiManager.getInstance((Project)project).findDirectory(rootDirectory);
            if (psiDirectory == null) {
                return SetsKt.emptySet();
            }
            PsiDirectory psi = psiDirectory;
            Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)psi), () -> Companion.detectRelatedRoots$lambda$0(project, psi));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
            return (Set)object;
        }

        private final Set<VirtualFile> calculateRelatedRoots(Project project, VirtualFile rootDirectory) {
            JSCrossLocalPackageImports packageImports = new JSCrossLocalPackageImports(project, rootDirectory);
            Set relatedRoots = new LinkedHashSet();
            Collection collection = new JSImportGraph(packageImports).initialize().getNodes();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getNodes(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            block0: for (Object element$iv : $this$forEach$iv) {
                VirtualFile it;
                VirtualFile file = (VirtualFile)element$iv;
                boolean bl = false;
                ProgressManager.checkCanceled();
                for (VirtualFile root : relatedRoots) {
                    if (!VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)true)) continue;
                    continue block0;
                }
                if (NodeModuleUtil.findMainModuleRoot(project, file) == null) continue;
                boolean bl2 = false;
                relatedRoots.add(it);
            }
            return relatedRoots;
        }

        private static final CachedValueProvider.Result detectRelatedRoots$lambda$0(Project $project, PsiDirectory $psi) {
            VirtualFile virtualFile = $psi.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            Set<VirtualFile> roots = Companion.calculateRelatedRoots($project, virtualFile);
            Object[] objectArray = new Object[]{JSTypeUtils.getTypeInvalidationDependency()};
            return CachedValueProvider.Result.create(roots, (Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

