/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.service;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.AutodetectLinterPackage;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.LinterLanguageServiceClient;
import com.intellij.lang.javascript.linter.tslint.TsLintBundle;
import com.intellij.lang.javascript.linter.tslint.TslintUtil;
import com.intellij.lang.javascript.linter.tslint.config.TsLintConfiguration;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.tslint.execution.TsLintOutputJsonParser;
import com.intellij.lang.javascript.linter.tslint.execution.TsLinterError;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceInitialState;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TsLintLanguageService
extends JSLanguageServiceBase {
    private static final Logger LOG = Logger.getInstance(TsLintLanguageService.class);
    @NotNull
    private final VirtualFile myWorkingDirectory;
    @NotNull
    private final NodePackage myNodePackage;

    public TsLintLanguageService(@NotNull Project project, @NotNull NodePackage nodePackage, @NotNull VirtualFile workingDirectory) {
        if (project == null) {
            TsLintLanguageService.$$$reportNull$$$0(0);
        }
        if (nodePackage == null) {
            TsLintLanguageService.$$$reportNull$$$0(1);
        }
        if (workingDirectory == null) {
            TsLintLanguageService.$$$reportNull$$$0(2);
        }
        super(project);
        this.myWorkingDirectory = workingDirectory;
        this.myNodePackage = nodePackage;
    }

    @NotNull
    public NodePackage getNodePackage() {
        NodePackage nodePackage = this.myNodePackage;
        if (nodePackage == null) {
            TsLintLanguageService.$$$reportNull$$$0(3);
        }
        return nodePackage;
    }

    @Nullable
    public CompletableFuture<List<TsLinterError>> highlight(@NotNull VirtualFile virtualFile, @Nullable VirtualFile config, @Nullable String content, @NotNull TsLintState state) {
        if (virtualFile == null) {
            TsLintLanguageService.$$$reportNull$$$0(4);
        }
        if (state == null) {
            TsLintLanguageService.$$$reportNull$$$0(5);
        }
        return this.createHighlightFuture(virtualFile, config, state, (filePath, configPath) -> new GetErrorsCommand((LocalFilePath)filePath, (LocalFilePath)configPath, StringUtil.notNullize((String)content)));
    }

    @Nullable
    public CompletableFuture<List<TsLinterError>> highlightAndFix(@NotNull VirtualFile virtualFile, @NotNull TsLintState state) {
        if (virtualFile == null) {
            TsLintLanguageService.$$$reportNull$$$0(6);
        }
        if (state == null) {
            TsLintLanguageService.$$$reportNull$$$0(7);
        }
        VirtualFile config = TslintUtil.getConfig(state, this.myProject, virtualFile);
        return this.createHighlightFuture(virtualFile, config, state, FixErrorsCommand::new);
    }

    private CompletableFuture<List<TsLinterError>> createHighlightFuture(@NotNull VirtualFile virtualFile, @Nullable VirtualFile config, @NotNull TsLintState state, @NotNull BiFunction<LocalFilePath, LocalFilePath, BaseCommand> commandProvider) {
        String configFilePath;
        if (virtualFile == null) {
            TsLintLanguageService.$$$reportNull$$$0(8);
        }
        if (state == null) {
            TsLintLanguageService.$$$reportNull$$$0(9);
        }
        if (commandProvider == null) {
            TsLintLanguageService.$$$reportNull$$$0(10);
        }
        if ((configFilePath = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks((VirtualFile)config)) == null) {
            if (state.getNodePackageRef() == AutodetectLinterPackage.INSTANCE) {
                return CompletableFuture.completedFuture(ContainerUtil.emptyList());
            }
            return CompletableFuture.completedFuture(Collections.singletonList(TsLinterError.createGlobalError(TsLintBundle.message("tslint.inspection.message.config.file.was.not.found", new Object[0]))));
        }
        String path = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks((VirtualFile)virtualFile);
        if (path == null) {
            return null;
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return CompletableFuture.completedFuture(Collections.singletonList(TsLinterError.createGlobalError(JSLanguageServiceUtil.getLanguageServiceCreationError((LinterLanguageServiceClient)this))));
        }
        BaseCommand command = commandProvider.apply(LocalFilePath.create((String)path), LocalFilePath.create((String)configFilePath));
        return process.execute((JSLanguageServiceCommand)command, this.createHighlightProcessor(path));
    }

    @NotNull
    private JSLanguageServiceCommandProcessor<List<TsLinterError>> createHighlightProcessor(@NotNull String path) {
        if (path == null) {
            TsLintLanguageService.$$$reportNull$$$0(11);
        }
        JSLanguageServiceCommandProcessor jSLanguageServiceCommandProcessor = (object, answer) -> TsLintLanguageService.parseResults(answer, path, JSLanguageServiceUtil.getGson((JSLanguageServiceBase)this));
        if (jSLanguageServiceCommandProcessor == null) {
            TsLintLanguageService.$$$reportNull$$$0(12);
        }
        return jSLanguageServiceCommandProcessor;
    }

    @Nullable
    private static List<TsLinterError> parseResults(@NotNull JSLanguageServiceAnswer answer, @NotNull String path, @NotNull Gson gson) {
        JsonObject element;
        JsonElement error;
        if (answer == null) {
            TsLintLanguageService.$$$reportNull$$$0(13);
        }
        if (path == null) {
            TsLintLanguageService.$$$reportNull$$$0(14);
        }
        if (gson == null) {
            TsLintLanguageService.$$$reportNull$$$0(15);
        }
        if ((error = (element = answer.getElement()).get("error")) != null) {
            return Collections.singletonList(TsLinterError.createGlobalError(error.getAsString()));
        }
        JsonElement body = TsLintLanguageService.parseBody(element);
        if (body == null) {
            return null;
        }
        String version = element.get("version").getAsString();
        SemVer tsLintVersion = SemVer.parseFromText((String)version);
        boolean isZeroBased = TsLintOutputJsonParser.isVersionZeroBased(tsLintVersion);
        TsLintOutputJsonParser parser = new TsLintOutputJsonParser(path, body, isZeroBased, gson);
        return new ArrayList<TsLinterError>(parser.getErrors());
    }

    private static JsonElement parseBody(@NotNull JsonObject element) {
        JsonElement body;
        if (element == null) {
            TsLintLanguageService.$$$reportNull$$$0(16);
        }
        if ((body = element.get("body")) == null) {
            return null;
        }
        if (body.isJsonPrimitive() && body.getAsJsonPrimitive().isString()) {
            String bodyContent = StringUtil.unquoteString((String)body.getAsJsonPrimitive().getAsString());
            if (!StringUtil.isEmptyOrSpaces((String)bodyContent)) {
                try {
                    return JsonParser.parseString((String)bodyContent);
                }
                catch (JsonParseException e) {
                    LOG.info(String.format("Problem parsing body: '%s'\n%s", body, e.getMessage()), (Throwable)e);
                }
            }
        } else {
            LOG.info(String.format("Error body type, should be a string with json inside. Body:'%s'", body.getAsString()));
        }
        return null;
    }

    protected JSLanguageServiceQueue createLanguageServiceQueueBlocking() {
        return new JSLanguageServiceQueueImpl(this.myProject, (JSLanguageServiceProtocol)new Protocol(this.myNodePackage, this.myWorkingDirectory, this.myProject), null, (JSLanguageServiceQueue.ServiceInfoReporter)this.myDefaultReporter, (JSLanguageServiceCacheData)new JSLanguageServiceDefaultCacheData());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandProvider";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gson";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodePackage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlightProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 12: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "highlightAndFix";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightFuture";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightProcessor";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseResults";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseBody";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 12 -> new IllegalStateException(string);
        };
    }

    private static abstract class BaseCommand
    implements JSLanguageServiceCommand,
    JSLanguageServiceSimpleCommand,
    JSLanguageServiceObject {
        public LocalFilePath filePath;
        @Nullable
        public LocalFilePath configPath;

        protected BaseCommand(LocalFilePath filePath, @Nullable LocalFilePath configPath) {
            this.filePath = filePath;
            this.configPath = configPath;
        }

        @NotNull
        public JSLanguageServiceObject toSerializableObject() {
            BaseCommand baseCommand = this;
            if (baseCommand == null) {
                BaseCommand.$$$reportNull$$$0(0);
            }
            return baseCommand;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$BaseCommand", "toSerializableObject"));
        }
    }

    private static final class Protocol
    extends JSLanguageServiceNodeStdProtocolBase {
        private final NodePackage myNodePackage;
        private final VirtualFile myWorkingDirectory;

        private Protocol(@NotNull NodePackage nodePackage, @NotNull VirtualFile workingDirectory, @NotNull Project project) {
            if (nodePackage == null) {
                Protocol.$$$reportNull$$$0(0);
            }
            if (workingDirectory == null) {
                Protocol.$$$reportNull$$$0(1);
            }
            if (project == null) {
                Protocol.$$$reportNull$$$0(2);
            }
            super("tslint", project, o -> {});
            this.myNodePackage = nodePackage;
            this.myWorkingDirectory = workingDirectory;
        }

        protected String getWorkingDirectory() {
            return JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks((VirtualFile)this.myWorkingDirectory);
        }

        protected JSLanguageServiceInitialState createState() {
            InitialState result = new InitialState();
            ExtendedLinterState extendedState = TsLintConfiguration.getInstance(this.myProject).getExtendedState();
            if (this.myNodePackage instanceof YarnPnpNodePackage) {
                result.tslintPackagePath = LocalFilePath.create((String)this.myNodePackage.getName());
                String packageJsonPath = ((YarnPnpNodePackage)this.myNodePackage).getPackageJsonPath(this.myProject);
                if (packageJsonPath == null) {
                    throw new IllegalStateException("Cannot find package.json path for " + String.valueOf(this.myNodePackage));
                }
                result.packageJsonPath = LocalFilePath.create((String)FileUtil.toSystemDependentName((String)packageJsonPath));
            } else {
                result.tslintPackagePath = LocalFilePath.create((String)this.myNodePackage.getSystemDependentPath());
            }
            result.additionalRootDirectory = LocalFilePath.create((String)((TsLintState)extendedState.getState()).getRulesDirectory());
            result.pluginName = "tslint";
            result.pluginPath = LocalFilePath.create((String)JSLanguageServiceUtil.getPluginDirectory(((Object)((Object)this)).getClass(), (String)"js/languageService/tslint-plugin-provider.js").getAbsolutePath());
            return result;
        }

        protected void addNodeProcessAdditionalArguments(@NotNull NodeTargetRun targetRun) {
            if (targetRun == null) {
                Protocol.$$$reportNull$$$0(3);
            }
            super.addNodeProcessAdditionalArguments(targetRun);
            targetRun.path(JSLanguageServiceUtil.getPluginDirectory(((Object)((Object)this)).getClass(), (String)"js").getAbsolutePath());
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodePackage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workingDirectory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetRun";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$Protocol";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addNodeProcessAdditionalArguments";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class GetErrorsCommand
    extends BaseCommand {
        public String content;

        private GetErrorsCommand(LocalFilePath filePath, @Nullable LocalFilePath configPath, String content) {
            super(filePath, configPath);
            this.content = content;
        }

        @NotNull
        public String getCommand() {
            return "GetErrors";
        }
    }

    private static class InitialState
    extends JSLanguageServiceInitialState {
        LocalFilePath tslintPackagePath;
        @Nullable
        LocalFilePath packageJsonPath;
        LocalFilePath additionalRootDirectory;

        private InitialState() {
        }
    }

    private static final class FixErrorsCommand
    extends BaseCommand {
        private FixErrorsCommand(LocalFilePath filePath, @Nullable LocalFilePath configPath) {
            super(filePath, configPath);
        }

        @NotNull
        public String getCommand() {
            return "FixErrors";
        }
    }
}

