/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.callusage;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.MainCallTreeNode;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.TreeNode;
import com.intellij.profiler.model.TreeUtilKt;
import com.intellij.profiler.ui.callusage.MainCallTreeUIModel;
import com.intellij.profiler.ui.grouping.FoldingNodesGroup;
import com.intellij.profiler.ui.grouping.GroupingCommand;
import com.intellij.profiler.ui.grouping.GroupingController;
import com.intellij.ui.TreeSpeedSearchInsideCollapsedNodes;
import com.intellij.ui.components.JBTreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0014J\u001c\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0014J\u001a\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010 \u001a\u00020\u000eH\u0014J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u000eH\u0016J\b\u0010\"\u001a\u00020\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000Rx\u0010\u000f\u001aj\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0012*\b\u0012\u0002\b\u0003\u0018\u00010\u00110\u0011\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u0012*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00130\u0013 \u0012*4\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0012*\b\u0012\u0002\b\u0003\u0018\u00010\u00110\u0011\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u0012*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00130\u0013\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/intellij/profiler/ui/callusage/ExpandGroupsTreeSpeedSearch;", "Lcom/intellij/ui/TreeSpeedSearchInsideCollapsedNodes;", "Lcom/intellij/openapi/Disposable;", "groupingController", "Lcom/intellij/profiler/ui/grouping/GroupingController;", "treeTable", "Lcom/intellij/ui/components/JBTreeTable;", "toString", "Lkotlin/Function1;", "Ljavax/swing/tree/TreePath;", "", "<init>", "(Lcom/intellij/profiler/ui/grouping/GroupingController;Lcom/intellij/ui/components/JBTreeTable;Lkotlin/jvm/functions/Function1;)V", "expandAllGroups", "", "pathIterators", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/profiler/MainCallTreeNode;", "kotlin.jvm.PlatformType", "Lcom/intellij/util/containers/JBIterable;", "Lcom/github/benmanes/caffeine/cache/Cache;", "currentRoot", "getCurrentRoot", "()Lcom/intellij/profiler/MainCallTreeNode;", "allPaths", "selectElement", "", "element", "", "selectedText", "doSelectElement", "path", "canExpand", "setCanExpand", "dispose", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nExpandGroupsTreeSpeedSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpandGroupsTreeSpeedSearch.kt\ncom/intellij/profiler/ui/callusage/ExpandGroupsTreeSpeedSearch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n808#2,11:82\n*S KotlinDebug\n*F\n+ 1 ExpandGroupsTreeSpeedSearch.kt\ncom/intellij/profiler/ui/callusage/ExpandGroupsTreeSpeedSearch\n*L\n72#1:82,11\n*E\n"})
public final class ExpandGroupsTreeSpeedSearch
extends TreeSpeedSearchInsideCollapsedNodes
implements Disposable {
    @NotNull
    private final GroupingController groupingController;
    @NotNull
    private final JBTreeTable treeTable;
    private boolean expandAllGroups;
    private final Cache<MainCallTreeNode<?>, JBIterable<TreePath>> pathIterators;

    public ExpandGroupsTreeSpeedSearch(@NotNull GroupingController groupingController, @NotNull JBTreeTable treeTable2, @NotNull Function1<? super TreePath, String> toString) {
        Intrinsics.checkNotNullParameter((Object)groupingController, (String)"groupingController");
        Intrinsics.checkNotNullParameter((Object)treeTable2, (String)"treeTable");
        Intrinsics.checkNotNullParameter(toString, (String)"toString");
        super((JTree)treeTable2.getTree(), true, CommonProfilerBundleKt.commonProfilerMessage("ui.search.inside.collapsed.groups", new Object[0]), arg_0 -> ExpandGroupsTreeSpeedSearch._init_$lambda$0(toString, arg_0));
        this.groupingController = groupingController;
        this.treeTable = treeTable2;
        this.pathIterators = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).build();
        this.setupListeners();
    }

    private final MainCallTreeNode<?> getCurrentRoot() {
        TreeTableModel treeTableModel = this.treeTable.getModel();
        MainCallTreeUIModel mainCallTreeUIModel = treeTableModel instanceof MainCallTreeUIModel ? (MainCallTreeUIModel)treeTableModel : null;
        if (mainCallTreeUIModel == null) {
            return null;
        }
        MainCallTreeUIModel model2 = mainCallTreeUIModel;
        CallTreeNode<BaseCallStackElement> callTreeNode = model2.getCallTree();
        return callTreeNode instanceof MainCallTreeNode ? (MainCallTreeNode)callTreeNode : null;
    }

    @NotNull
    protected JBIterable<TreePath> allPaths() {
        MainCallTreeNode<?> mainCallTreeNode = this.getCurrentRoot();
        if (mainCallTreeNode == null) {
            JBIterable jBIterable = super.allPaths();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"allPaths(...)");
            return jBIterable;
        }
        MainCallTreeNode<?> root = mainCallTreeNode;
        Object object = this.pathIterators.get(root, arg_0 -> ExpandGroupsTreeSpeedSearch.allPaths$lambda$2(arg_0 -> ExpandGroupsTreeSpeedSearch.allPaths$lambda$1(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (JBIterable)object;
    }

    protected void selectElement(@Nullable Object element, @Nullable String selectedText) {
        TreePath treePath = element instanceof TreePath ? (TreePath)element : null;
        if (treePath == null) {
            return;
        }
        TreePath path = treePath;
        this.groupingController.invokeAfterGroupingFinished((Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, path, selectedText, null){
            int label;
            final /* synthetic */ ExpandGroupsTreeSpeedSearch this$0;
            final /* synthetic */ TreePath $path;
            final /* synthetic */ String $selectedText;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                this.$selectedText = $selectedText;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$path, this.$selectedText, null){
                            int label;
                            final /* synthetic */ ExpandGroupsTreeSpeedSearch this$0;
                            final /* synthetic */ TreePath $path;
                            final /* synthetic */ String $selectedText;
                            {
                                this.this$0 = $receiver;
                                this.$path = $path;
                                this.$selectedText = $selectedText;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        ExpandGroupsTreeSpeedSearch.access$doSelectElement(this.this$0, this.$path, this.$selectedText);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void doSelectElement(TreePath path, String selectedText) {
        super.selectElement((Object)path, selectedText);
        TreeUtil.scrollToVisible((JTree)((JTree)this.getComponent()), (TreePath)path, (boolean)true);
    }

    protected boolean canExpand() {
        return this.expandAllGroups;
    }

    /*
     * WARNING - void declaration
     */
    public void setCanExpand(boolean canExpand) {
        Collection destination$iv$iv;
        super.setCanExpand(canExpand);
        this.expandAllGroups = canExpand;
        MainCallTreeNode<?> mainCallTreeNode = this.getCurrentRoot();
        if (mainCallTreeNode != null && (mainCallTreeNode = TreeUtilKt.allNodesIterable((TreeNode)mainCallTreeNode)) != null) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = (Iterable)((Object)mainCallTreeNode);
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FoldingNodesGroup)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
        } else {
            return;
        }
        List allGroups = (List)destination$iv$iv;
        GroupingController.execute$default(this.groupingController, canExpand ? (GroupingCommand)new GroupingCommand.UnfoldAll(allGroups) : (GroupingCommand)new GroupingCommand.FoldAll(allGroups), null, 2, null);
        this.pathIterators.cleanUp();
    }

    public void dispose() {
        this.pathIterators.cleanUp();
    }

    private static final String _init_$lambda$0(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final JBIterable allPaths$lambda$1(ExpandGroupsTreeSpeedSearch this$0, MainCallTreeNode it) {
        return super.allPaths();
    }

    private static final JBIterable allPaths$lambda$2(Function1 $tmp0, Object p0) {
        return (JBIterable)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$doSelectElement(ExpandGroupsTreeSpeedSearch $this, TreePath path, String selectedText) {
        $this.doSelectElement(path, selectedText);
    }
}

