/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.ui.visualization;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.notebooks.ui.visualization.NotebookEditorAppearanceUtils;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.scale.JBUIScale;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\"J\u0016\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u000fJ\u0012\u0010'\u001a\u00020\"2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R(\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"Lcom/intellij/notebooks/ui/visualization/NotebookAboveCellDelimiterPanel;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isCodeCell", "", "isFirstCell", "<init>", "(Lcom/intellij/openapi/editor/Editor;ZZ)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "()Z", "delimiterPanel", "roofPanel", "value", "Ljava/awt/Color;", "backgroundColor", "getBackgroundColor", "()Ljava/awt/Color;", "setBackgroundColor", "(Ljava/awt/Color;)V", "cellRoofColor", "getCellRoofColor", "setCellRoofColor", "isHighlighted", "standardDelimiterHeight", "", "isConsole", "delimiterPanelHeight", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addDropHighlight", "", "removeDropHighlight", "setFrameVisible", "isVisible", "frameColor", "createRoofAndDelimiterPanels", "intellij.notebooks.ui"})
@SourceDebugExtension(value={"SMAP\nNotebookAboveCellDelimiterPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookAboveCellDelimiterPanel.kt\ncom/intellij/notebooks/ui/visualization/NotebookAboveCellDelimiterPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class NotebookAboveCellDelimiterPanel
extends JPanel {
    @NotNull
    private final Editor editor;
    private final boolean isCodeCell;
    @Nullable
    private JPanel delimiterPanel;
    @Nullable
    private JPanel roofPanel;
    @NotNull
    private Color backgroundColor;
    @Nullable
    private Color cellRoofColor;
    private boolean isHighlighted;
    private final int standardDelimiterHeight;
    private final boolean isConsole;
    private final int delimiterPanelHeight;

    public NotebookAboveCellDelimiterPanel(@NotNull Editor editor, boolean isCodeCell, boolean isFirstCell) {
        block2: {
            JPanel it;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            super(new BorderLayout());
            this.editor = editor;
            this.isCodeCell = isCodeCell;
            Color color = this.editor.getColorsScheme().getDefaultBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultBackground(...)");
            this.backgroundColor = color;
            this.standardDelimiterHeight = NotebookUtil.INSTANCE.getNotebookAppearance(this.editor).getCellBorderHeight() / 2;
            this.isConsole = Intrinsics.areEqual((Object)this.editor.getUserData(ConsoleViewUtil.EDITOR_IS_CONSOLE_HISTORY_VIEW), (Object)true);
            this.delimiterPanelHeight = isFirstCell && this.isConsole ? 0 : (isFirstCell ? NotebookUtil.INSTANCE.getNotebookAppearance(this.editor).getAboveFirstCellDelimiterHeight() : NotebookUtil.INSTANCE.getNotebookAppearance(this.editor).getDistanceBetweenCells());
            EditorKind editorKind = this.editor.getEditorKind();
            Intrinsics.checkNotNullExpressionValue((Object)editorKind, (String)"getEditorKind(...)");
            if (NotebookEditorAppearanceUtils.INSTANCE.isDiff(editorKind)) break block2;
            this.createRoofAndDelimiterPanels(this.cellRoofColor);
            JPanel jPanel = this.delimiterPanel;
            if (jPanel != null) {
                it = jPanel;
                boolean bl = false;
                this.add((Component)it, "North");
            }
            JPanel jPanel2 = this.roofPanel;
            if (jPanel2 != null) {
                it = jPanel2;
                boolean bl = false;
                this.add((Component)it, "South");
            }
        }
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public final boolean isCodeCell() {
        return this.isCodeCell;
    }

    @NotNull
    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public final void setBackgroundColor(@NotNull Color value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JPanel jPanel = this.delimiterPanel;
        if (jPanel != null) {
            jPanel.setBackground(value);
        }
        this.backgroundColor = value;
    }

    @Nullable
    public final Color getCellRoofColor() {
        return this.cellRoofColor;
    }

    public final void setCellRoofColor(@Nullable Color value) {
        JPanel jPanel = this.roofPanel;
        if (jPanel != null) {
            jPanel.setBackground(value);
        }
        this.cellRoofColor = value;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.editor.getProject();
        if (project == null) {
            Project project2 = ProjectManager.getInstance().getDefaultProject();
            project = project2;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
        }
        return project;
    }

    public final void addDropHighlight() {
        block0: {
            this.isHighlighted = true;
            JPanel jPanel = this.delimiterPanel;
            if (jPanel == null) break block0;
            jPanel.repaint();
        }
    }

    public final void removeDropHighlight() {
        block0: {
            this.isHighlighted = false;
            JPanel jPanel = this.delimiterPanel;
            if (jPanel == null) break block0;
            jPanel.repaint();
        }
    }

    public final void setFrameVisible(boolean isVisible, @NotNull Color frameColor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)frameColor, (String)"frameColor");
            JPanel jPanel = this.roofPanel;
            if (jPanel == null) break block0;
            JPanel it = jPanel;
            boolean bl = false;
            it.setBorder(isVisible ? IdeBorderFactory.createBorder((Color)frameColor, (int)6) : BorderFactory.createEmptyBorder(1, 0, 0, 1));
            it.repaint();
        }
    }

    private final void createRoofAndDelimiterPanels(Color cellRoofColor) {
        JPanel it;
        JPanel jPanel;
        JPanel jPanel2 = jPanel = new JPanel(this){
            final /* synthetic */ NotebookAboveCellDelimiterPanel this$0;
            {
                this.this$0 = $receiver;
            }

            protected void paintComponent(Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                super.paintComponent(g);
                if (NotebookAboveCellDelimiterPanel.access$isHighlighted$p(this.this$0)) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setColor((Color)NotebookUtil.INSTANCE.getNotebookAppearance(this.this$0.getEditor()).getCellStripeSelectedColor().get());
                    int y = this.getHeight() / 2;
                    g2d.fillRect(0, y - 1, this.getWidth(), 2);
                }
            }
        };
        NotebookAboveCellDelimiterPanel notebookAboveCellDelimiterPanel = this;
        boolean bl = false;
        it.setBackground(this.backgroundColor);
        it.setPreferredSize(new Dimension(JBUIScale.scale((int)1), this.delimiterPanelHeight));
        notebookAboveCellDelimiterPanel.delimiterPanel = jPanel;
        it = jPanel = new JPanel();
        notebookAboveCellDelimiterPanel = this;
        boolean bl2 = false;
        it.setBackground(cellRoofColor);
        it.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 1));
        it.setPreferredSize(new Dimension(JBUIScale.scale((int)1), this.standardDelimiterHeight));
        notebookAboveCellDelimiterPanel.roofPanel = jPanel;
    }

    public static final /* synthetic */ boolean access$isHighlighted$p(NotebookAboveCellDelimiterPanel $this) {
        return $this.isHighlighted;
    }
}

