/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;

public abstract class PropertiesHighlighter
extends SyntaxHighlighterBase {

    public static enum PropertiesComponent {
        PROPERTY_KEY(TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.KEY", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD), PropertiesBundle.messagePointer("options.properties.attribute.descriptor.property.key", new Object[0]), PropertiesTokenTypes.KEY_CHARACTERS),
        PROPERTY_VALUE(TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.VALUE", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING), PropertiesBundle.messagePointer("options.properties.attribute.descriptor.property.value", new Object[0]), PropertiesTokenTypes.VALUE_CHARACTERS),
        PROPERTY_COMMENT(TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.LINE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT), PropertiesBundle.messagePointer("options.properties.attribute.descriptor.comment", new Object[0]), PropertiesTokenTypes.END_OF_LINE_COMMENT),
        PROPERTY_KEY_VALUE_SEPARATOR(TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.KEY_VALUE_SEPARATOR", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN), PropertiesBundle.messagePointer("options.properties.attribute.descriptor.key.value.separator", new Object[0]), PropertiesTokenTypes.KEY_VALUE_SEPARATOR),
        PROPERTIES_VALID_STRING_ESCAPE(TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.VALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE), PropertiesBundle.messagePointer("options.properties.attribute.descriptor.valid.string.escape", new Object[0]), StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN),
        PROPERTIES_INVALID_STRING_ESCAPE(TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.INVALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE), PropertiesBundle.messagePointer("options.properties.attribute.descriptor.invalid.string.escape", new Object[0]), StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN);

        private static final Map<IElementType, PropertiesComponent> elementTypeToComponent;
        private static final Map<TextAttributesKey, PropertiesComponent> textAttributeKeyToComponent;
        private final TextAttributesKey myTextAttributesKey;
        private final Supplier<@Nls String> myMessagePointer;
        private final IElementType myTokenType;

        private PropertiesComponent(TextAttributesKey textAttributesKey, Supplier<String> messagePointer, IElementType tokenType) {
            this.myTextAttributesKey = textAttributesKey;
            this.myMessagePointer = messagePointer;
            this.myTokenType = tokenType;
        }

        public TextAttributesKey getTextAttributesKey() {
            return this.myTextAttributesKey;
        }

        Supplier<@Nls String> getMessagePointer() {
            return this.myMessagePointer;
        }

        IElementType getTokenType() {
            return this.myTokenType;
        }

        static PropertiesComponent getByTokenType(IElementType tokenType) {
            return elementTypeToComponent.get(tokenType);
        }

        static PropertiesComponent getByTextAttribute(TextAttributesKey textAttributesKey) {
            return textAttributeKeyToComponent.get(textAttributesKey);
        }

        @Nls
        static String getDisplayName(TextAttributesKey key) {
            PropertiesComponent component = PropertiesComponent.getByTextAttribute(key);
            if (component == null) {
                return null;
            }
            return component.getMessagePointer().get();
        }

        @Nls
        static HighlightSeverity getSeverity(TextAttributesKey key) {
            PropertiesComponent component = PropertiesComponent.getByTextAttribute(key);
            return component == PROPERTIES_INVALID_STRING_ESCAPE ? HighlightSeverity.WARNING : null;
        }

        static {
            elementTypeToComponent = Arrays.stream(PropertiesComponent.values()).collect(Collectors.toMap(PropertiesComponent::getTokenType, Function.identity()));
            textAttributeKeyToComponent = Arrays.stream(PropertiesComponent.values()).collect(Collectors.toMap(PropertiesComponent::getTextAttributesKey, Function.identity()));
        }
    }
}

