/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.DockerAgentSourceType;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remote.run.target.DockerBindVolumes;
import com.intellij.docker.remote.run.target.DockerDownloadVolume;
import com.intellij.docker.remote.run.target.DockerMountedVolume;
import com.intellij.docker.remote.run.target.DockerRemoteRequest;
import com.intellij.docker.remote.run.target.PathInsideBindMount;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.utils.DockerNetworkUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.DeferredRemoteProcess;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DockerEnvironment
extends TargetEnvironment {
    private static final Logger LOG = Logger.getInstance(DockerEnvironment.class);
    private static final String ROOT_USER = "root";
    private static final String ROOT_UID = "0";
    private static final String LOCALHOST = "localhost";
    private static final String INADDR_ANY = "0.0.0.0";
    @NotNull
    private final DockerAgentImage myAgentImage;
    @NotNull
    private final Collection<DockerVolumeBinding> myVolumeBindings;
    @NotNull
    private final List<DockerVolumesFrom> myVolumesFromList;
    @NotNull
    private final List<DockerRemoteRequest.BoundPortValue> myPortBindings;
    @Nullable
    private final Map<String, String> myEnvironmentVariables;
    @NotNull
    private final String myRunCliOptions;
    @NotNull
    private final Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> myUploadVolumes;
    @NotNull
    private final Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> myDownloadVolumes;
    @NotNull
    private final Map<TargetEnvironment.TargetPortBinding, ResolvedPortBinding> myTargetPortBindings;
    @NotNull
    private final Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> myLocalPortBindings;
    private boolean myDeferContainerRemovalUntilShutdown;
    @Nullable
    private RemoteDockerApplicationRuntime myContainer;

    DockerEnvironment(@NotNull DockerAgentImage image, @NotNull DockerRemoteRequest request2, @NotNull String options, @NotNull Collection<DockerVolumeBinding> volumeBindings2, @NotNull List<DockerVolumesFrom> dockerVolumesFromList, @Nullable Map<String, String> envs) {
        if (image == null) {
            DockerEnvironment.$$$reportNull$$$0(0);
        }
        if (request2 == null) {
            DockerEnvironment.$$$reportNull$$$0(1);
        }
        if (options == null) {
            DockerEnvironment.$$$reportNull$$$0(2);
        }
        if (volumeBindings2 == null) {
            DockerEnvironment.$$$reportNull$$$0(3);
        }
        if (dockerVolumesFromList == null) {
            DockerEnvironment.$$$reportNull$$$0(4);
        }
        super((TargetEnvironmentRequest)request2);
        this.myPortBindings = new ArrayList<DockerRemoteRequest.BoundPortValue>();
        this.myUploadVolumes = new HashMap<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume>();
        this.myDownloadVolumes = new HashMap<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume>();
        this.myTargetPortBindings = new HashMap<TargetEnvironment.TargetPortBinding, ResolvedPortBinding>();
        this.myLocalPortBindings = new HashMap<TargetEnvironment.LocalPortBinding, ResolvedPortBinding>();
        this.myAgentImage = image;
        this.myRunCliOptions = options;
        this.myVolumeBindings = volumeBindings2;
        this.myVolumesFromList = dockerVolumesFromList;
        this.myEnvironmentVariables = envs;
    }

    @NotNull
    public Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> getUploadVolumes() {
        Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> map2 = Collections.unmodifiableMap(this.myUploadVolumes);
        if (map2 == null) {
            DockerEnvironment.$$$reportNull$$$0(5);
        }
        return map2;
    }

    @NotNull
    public Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> getDownloadVolumes() {
        Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> map2 = Collections.unmodifiableMap(this.myDownloadVolumes);
        if (map2 == null) {
            DockerEnvironment.$$$reportNull$$$0(6);
        }
        return map2;
    }

    @NotNull
    public Map<TargetEnvironment.TargetPortBinding, ResolvedPortBinding> getTargetPortBindings() {
        Map<TargetEnvironment.TargetPortBinding, ResolvedPortBinding> map2 = Collections.unmodifiableMap(this.myTargetPortBindings);
        if (map2 == null) {
            DockerEnvironment.$$$reportNull$$$0(7);
        }
        return map2;
    }

    @NotNull
    public Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> getLocalPortBindings() {
        Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> map2 = Collections.unmodifiableMap(this.myLocalPortBindings);
        if (map2 == null) {
            DockerEnvironment.$$$reportNull$$$0(8);
        }
        return map2;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        TargetPlatform targetPlatform = this.getRequest().getTargetPlatform();
        if (targetPlatform == null) {
            DockerEnvironment.$$$reportNull$$$0(9);
        }
        return targetPlatform;
    }

    public void shutdown() {
        if (this.myDeferContainerRemovalUntilShutdown && this.myContainer != null) {
            RemoteDockerApplicationRuntime container = this.myContainer;
            ApplicationManager.getApplication().executeOnPooledThread(() -> container.removeContainer());
        }
        this.myContainer = null;
    }

    @Nullable
    public RemoteDockerApplicationRuntime getContainerRuntime() {
        return this.myContainer;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public Process createProcess(final @NotNull TargetedCommandLine commandLine, @NotNull ProgressIndicator indicator) throws ExecutionException {
        if (commandLine == null) {
            DockerEnvironment.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            DockerEnvironment.$$$reportNull$$$0(11);
        }
        try {
            resolvedCommand = ArrayUtil.toStringArray((Collection)commandLine.collectCommandsSynchronously());
            inputFilePath = commandLine.getInputFilePath();
            if (inputFilePath != null) {
                // empty if block
            }
            workingDirectory = StringUtil.nullize((String)commandLine.getWorkingDirectory());
            portBindings = this.getPortBindings();
            actualPortMappings = portBindings.stream().collect(Collectors.toMap((Function<DockerPortBinding, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getContainerPort(), (Lcom/intellij/docker/agent/settings/DockerPortBinding;)Ljava/lang/Integer;)(), (Function<DockerPortBinding, DockerPortBinding>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$createProcess$1(com.intellij.docker.agent.settings.DockerPortBinding ), (Lcom/intellij/docker/agent/settings/DockerPortBinding;)Lcom/intellij/docker/agent/settings/DockerPortBinding;)(), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$createProcess$2(com.intellij.docker.agent.settings.DockerPortBinding com.intellij.docker.agent.settings.DockerPortBinding ), (Lcom/intellij/docker/agent/settings/DockerPortBinding;Lcom/intellij/docker/agent/settings/DockerPortBinding;)Lcom/intellij/docker/agent/settings/DockerPortBinding;)(), (Supplier<HashMap>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$createProcess$3(), ()Ljava/util/HashMap;)()));
            environmentVariables = commandLine.getEnvironmentVariables();
            if (this.myEnvironmentVariables != null) {
                environmentVariables.putAll(this.myEnvironmentVariables);
            }
            v0 /* !! */  = runCliOptionsList /* !! */  = StringUtil.isEmptyOrSpaces((String)this.myRunCliOptions) != false ? new ArrayList<E>() : ParametersListUtil.parse((String)this.myRunCliOptions);
            if (this.getRequest().getDownloadVolumes().isEmpty()) ** GOTO lbl-1000
            if (ContainerUtil.exists((Object[])DockerEnvironment.RM_OPTION_ALTERNATIVES(), (Condition)(Condition)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(runCliOptionsList /* !! */ ))) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            this.myDeferContainerRemovalUntilShutdown = v1;
            deployConfig = new DockerAgentDeploymentConfig(){

                @Override
                public String[] getImageTags() {
                    return new String[]{DockerEnvironment.this.myAgentImage.getImageId()};
                }

                @Override
                public boolean withTty() {
                    return commandLine.getPtyOptions() != null;
                }

                @Override
                public DockerPortBinding[] getPortBindings() {
                    DockerPortBinding[] result2 = (DockerPortBinding[])portBindings.toArray(DockerPortBinding[]::new);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("ports: " + Stream.of(result2).map(next -> (DockerPortBindingImpl)ObjectUtils.tryCast((Object)next, DockerPortBindingImpl.class)).filter(Objects::nonNull).map(DockerPortBindingImpl::toCommandLineString).map(DockerEnvironment::quote).collect(Collectors.joining(",\n\t")));
                    }
                    return result2;
                }

                @Override
                public DockerEnvVar[] getEnvVars() {
                    return (DockerEnvVar[])environmentVariables.entrySet().stream().map(e -> new DockerEnvVarImpl((String)e.getKey(), (String)e.getValue())).toArray(DockerEnvVar[]::new);
                }

                @Override
                public String getWorkingDir() {
                    return workingDirectory;
                }

                @Override
                public DockerVolumeBinding[] getVolumeBindings() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("volumes: " + DockerEnvironment.this.myVolumeBindings.stream().map(next -> ((DockerVolumeBindingImpl)next).toCommandLineString()).map(DockerEnvironment::quote).collect(Collectors.joining(",\n\t")));
                    }
                    return DockerEnvironment.this.myVolumeBindings.toArray(new DockerVolumeBinding[0]);
                }

                @Override
                public DockerVolumesFrom[] getVolumesFrom() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("volumes from: " + DockerEnvironment.this.myVolumesFromList.stream().map(DockerEnvironment::getVolumesFromStringPresentation).collect(Collectors.joining(",\n\t")));
                    }
                    return DockerEnvironment.this.myVolumesFromList.toArray(new DockerVolumesFrom[0]);
                }

                @Override
                public String[] getCommand() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("command: " + Stream.of(resolvedCommand).map(DockerEnvironment::quote).collect(Collectors.joining()));
                    }
                    return resolvedCommand;
                }

                @Override
                public String sourceType() {
                    return DockerAgentSourceType.IMAGE.name();
                }

                @Override
                public String[] getCustomRunOptions() {
                    ArrayList<String> result2 = new ArrayList<String>();
                    result2.add("--security-opt=seccomp:unconfined");
                    if (DockerEnvironment.this.myDeferContainerRemovalUntilShutdown) {
                        for (String nextRm : DockerEnvironment.RM_OPTION_ALTERNATIVES()) {
                            runCliOptionsList.remove(nextRm);
                        }
                    }
                    result2.addAll(runCliOptionsList);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("effective cli options: " + result2.stream().map(DockerEnvironment::quote).collect(Collectors.joining(",\n\t")));
                        LOG.debug("deferred --rm: " + DockerEnvironment.this.myDeferContainerRemovalUntilShutdown);
                    }
                    return ArrayUtil.toStringArray(result2);
                }

                @Override
                public boolean isCreateContainerOnly() {
                    return true;
                }
            };
            if (ApplicationManager.getApplication().isDispatchThread()) {
                return new DeferredRemoteProcess(DockerEnvironment.runAsync((Callable<RemoteProcess>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$createProcess$4(java.util.Map com.intellij.docker.agent.DockerAgentDeploymentConfig ), ()Lcom/intellij/remote/RemoteProcess;)((DockerEnvironment)this, (Map)actualPortMappings, (DockerAgentDeploymentConfig)deployConfig)));
            }
            return this.doCreateDockerProcess(actualPortMappings, deployConfig);
        }
        catch (RemoteSdkException | ServerRuntimeException | IOException e) {
            throw new ExecutionException(DockerBundle.message("DockerEnvironment.cant.run.process", new Object[]{e.getMessage()}), e);
        }
    }

    @NotNull
    private RemoteProcess doCreateDockerProcess(@NotNull Map<Integer, DockerPortBinding> actualPortMappings, @NotNull DockerAgentDeploymentConfig deployConfig) throws ExecutionException, IOException, ServerRuntimeException {
        if (actualPortMappings == null) {
            DockerEnvironment.$$$reportNull$$$0(12);
        }
        if (deployConfig == null) {
            DockerEnvironment.$$$reportNull$$$0(13);
        }
        this.myContainer = RemoteDockerApplicationRuntime.createWithPullImage(((DockerRemoteRequest)this.getRequest()).getDocker(), deployConfig);
        this.myContainer.startAndAttach();
        DockerExecProcess result2 = DockerExecProcess.Factory.newProcess(this.myContainer, false);
        this.myPortBindings.forEach(portValue -> portValue.localPortBound((DockerPortBinding)actualPortMappings.get(portValue.getContainerPort())));
        DockerExecProcess dockerExecProcess = result2;
        if (dockerExecProcess == null) {
            DockerEnvironment.$$$reportNull$$$0(14);
        }
        return dockerExecProcess;
    }

    @NotNull
    private static <T> AsyncPromise<T> runAsync(@NotNull Callable<T> callable) {
        if (callable == null) {
            DockerEnvironment.$$$reportNull$$$0(15);
        }
        AsyncPromise promise = new AsyncPromise();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                Object result2 = callable.call();
                promise.setResult(result2);
            }
            catch (Throwable t) {
                promise.setError(t);
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            DockerEnvironment.$$$reportNull$$$0(16);
        }
        return asyncPromise;
    }

    @NotNull
    private static @NotNull String @NotNull [] RM_OPTION_ALTERNATIVES() {
        String[] stringArray = new String[]{"--rm", "-rm"};
        if (stringArray == null) {
            DockerEnvironment.$$$reportNull$$$0(17);
        }
        return stringArray;
    }

    @Contract(pure=true)
    @NotNull
    private static String quote(String text) {
        String string = "`" + text + "`";
        if (string == null) {
            DockerEnvironment.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private @NotNull List<@NotNull DockerPortBinding> getPortBindings() throws IOException {
        if (this.myPortBindings.isEmpty()) {
            List<DockerPortBinding> list2 = Collections.emptyList();
            if (list2 == null) {
                DockerEnvironment.$$$reportNull$$$0(19);
            }
            return list2;
        }
        int[] localPorts = NetUtils.findAvailableSocketPorts((int)this.myPortBindings.size());
        int idx = 0;
        ArrayList<DockerPortBinding> result2 = new ArrayList<DockerPortBinding>(localPorts.length);
        for (DockerRemoteRequest.BoundPortValue nextPortRequest : this.myPortBindings) {
            DockerPortBindingImpl nextBinding = nextPortRequest.asDockerPortBinding();
            if (nextBinding.getHostPort() == null) {
                nextBinding.setHostPort(localPorts[idx]);
            }
            result2.add(nextBinding);
            ++idx;
        }
        ArrayList<DockerPortBinding> arrayList = result2;
        if (arrayList == null) {
            DockerEnvironment.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @NotNull
    static DockerEnvironment create(@NotNull RemoteDockerRuntime docker, @NotNull DockerAgentImage image, @NotNull DockerRemoteRequest request2, @NotNull String options, @NotNull Collection<DockerVolumeBinding> volumeBindings2, @NotNull List<DockerVolumesFrom> volumesFromList, @Nullable Map<String, String> envs, @NotNull TargetProgressIndicator progressIndicator) throws IOException, ServerRuntimeException, ExecutionException {
        if (docker == null) {
            DockerEnvironment.$$$reportNull$$$0(21);
        }
        if (image == null) {
            DockerEnvironment.$$$reportNull$$$0(22);
        }
        if (request2 == null) {
            DockerEnvironment.$$$reportNull$$$0(23);
        }
        if (options == null) {
            DockerEnvironment.$$$reportNull$$$0(24);
        }
        if (volumeBindings2 == null) {
            DockerEnvironment.$$$reportNull$$$0(25);
        }
        if (volumesFromList == null) {
            DockerEnvironment.$$$reportNull$$$0(26);
        }
        if (progressIndicator == null) {
            DockerEnvironment.$$$reportNull$$$0(27);
        }
        DockerEnvironment dockerEnvironment = new DockerEnvironment(image, request2, options, volumeBindings2, volumesFromList, envs);
        List volumeBindingsToReuse = ContainerUtil.filter(DockerBindVolumes.parseDockerVolumeBindingFromDockerRunCliOptions(options, null), DockerVolumeBinding::isEditable);
        for (Object uploadRoot : request2.getUploadVolumes()) {
            DockerEnvironment.handleUploadRoot(dockerEnvironment, (TargetEnvironment.UploadRoot)uploadRoot, volumeBindingsToReuse, volumeBindings2);
        }
        if (!request2.getDownloadVolumes().isEmpty()) {
            @NlsSafe String user2 = image.getUser();
            if (user2 != null) {
                progressIndicator.addSystemLine(DockerBundle.message("DockerEnvironment.docker.image.user.0", user2));
            }
            for (TargetEnvironment.DownloadRoot downloadRoot : request2.getDownloadVolumes()) {
                DockerVolumeBindingImpl dockerJavaBinding;
                Object targetRootPath;
                Path localRootPath = downloadRoot.getLocalRootPath() != null ? downloadRoot.getLocalRootPath().toAbsolutePath() : FileUtil.createTempDirectory((String)"intellij-target.", (String)"", (boolean)true).toPath();
                if (downloadRoot.getTargetRootPath() instanceof TargetEnvironment.TargetPath.Persistent) {
                    targetRootPath = ((TargetEnvironment.TargetPath.Persistent)downloadRoot.getTargetRootPath()).getAbsolutePath();
                } else {
                    assert (downloadRoot.getTargetRootPath() instanceof TargetEnvironment.TargetPath.Temporary);
                    targetRootPath = "/tmp/" + String.valueOf(UUID.randomUUID());
                }
                if (downloadRoot.getPersistentId() != null) {
                    volumeName = downloadRoot.getPersistentId().replace('/', '_');
                    dockerJavaBinding = new DockerVolumeBindingImpl((String)targetRootPath, volumeName, false);
                    if (DockerEnvironment.isUserMightLackSufficientPrivileges(user2)) {
                        DockerEnvironment.changeOwnershipOfVolume(user2, request2.getDocker(), image, volumeName, (String)targetRootPath, progressIndicator);
                    }
                } else if (DockerEnvironment.isUserMightLackSufficientPrivileges(user2)) {
                    volumeName = DockerEnvironment.generateRandomVolumeName();
                    dockerJavaBinding = new DockerVolumeBindingImpl((String)targetRootPath, volumeName, false);
                    DockerEnvironment.changeOwnershipOfVolume(user2, request2.getDocker(), image, volumeName, (String)targetRootPath, progressIndicator);
                } else {
                    dockerJavaBinding = new DockerVolumeBindingImpl((String)targetRootPath, null, false);
                }
                volumeBindings2.add(dockerJavaBinding);
                dockerEnvironment.myDownloadVolumes.put(downloadRoot, new DockerDownloadVolume(dockerEnvironment, localRootPath, (String)targetRootPath));
            }
        }
        for (TargetEnvironment.TargetPortBinding targetPortBinding : request2.getTargetPortBindings()) {
            final int localPort = targetPortBinding.getLocal() == null ? NetUtils.findAvailableSocketPort() : targetPortBinding.getLocal();
            final int targetPort = targetPortBinding.getTarget();
            dockerEnvironment.myPortBindings.add(new DockerRemoteRequest.BoundPortValue(targetPort){

                @Override
                int getContainerPort() {
                    return targetPort;
                }

                @Override
                DockerPortBindingImpl asDockerPortBinding() {
                    DockerPortBindingImpl result2 = super.asDockerPortBinding();
                    result2.setHostPort(localPort);
                    return result2;
                }

                public Promise<Integer> getLocalValue() {
                    return Promises.resolvedPromise((Object)localPort);
                }
            });
            dockerEnvironment.myTargetPortBindings.put(targetPortBinding, new ResolvedPortBinding(new HostPort(LOCALHOST, localPort), new HostPort(INADDR_ANY, targetPort)));
        }
        if (!request2.getLocalPortBindings().isEmpty()) {
            DockerCloudConfiguration dockerCloudConfiguration = docker.getAccount();
            String hostAddress = DockerNetworkUtil.getHostAddress(dockerCloudConfiguration);
            for (TargetEnvironment.LocalPortBinding localPortBinding : request2.getLocalPortBindings()) {
                if (localPortBinding.getTarget() != null && localPortBinding.getTarget().intValue() != localPortBinding.getLocal()) {
                    throw new UnsupportedOperationException("TCP proxy is not implemented.");
                }
                int localPort = localPortBinding.getLocal();
                HostPort localHostPort = new HostPort(DockerNetworkUtil.getDockerNetworkInterface(dockerCloudConfiguration), localPort);
                HostPort targetHostPort = new HostPort(hostAddress, localPort);
                dockerEnvironment.myLocalPortBindings.put(localPortBinding, new ResolvedPortBinding(localHostPort, targetHostPort));
            }
        }
        DockerEnvironment dockerEnvironment2 = dockerEnvironment;
        if (dockerEnvironment2 == null) {
            DockerEnvironment.$$$reportNull$$$0(28);
        }
        return dockerEnvironment2;
    }

    private static void handleUploadRoot(@NotNull DockerEnvironment dockerEnvironment, @NotNull TargetEnvironment.UploadRoot uploadRoot, @NotNull Collection<DockerVolumeBinding> volumeBindingsForReuse, @NotNull Collection<DockerVolumeBinding> volumeBindings2) {
        Object targetRootPath;
        if (dockerEnvironment == null) {
            DockerEnvironment.$$$reportNull$$$0(29);
        }
        if (uploadRoot == null) {
            DockerEnvironment.$$$reportNull$$$0(30);
        }
        if (volumeBindingsForReuse == null) {
            DockerEnvironment.$$$reportNull$$$0(31);
        }
        if (volumeBindings2 == null) {
            DockerEnvironment.$$$reportNull$$$0(32);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing Docker upload: " + String.valueOf(uploadRoot));
        }
        Path localRootPath = uploadRoot.getLocalRootPath();
        if (uploadRoot.getTargetRootPath() instanceof TargetEnvironment.TargetPath.Persistent) {
            targetRootPath = ((TargetEnvironment.TargetPath.Persistent)uploadRoot.getTargetRootPath()).getAbsolutePath();
        } else {
            TargetEnvironment.TargetPath.Temporary targetPath = (TargetEnvironment.TargetPath.Temporary)uploadRoot.getTargetRootPath();
            String customTargetParentDirectory = targetPath.getParentDirectory();
            if (StringUtil.isEmptyOrSpaces((String)customTargetParentDirectory) && Registry.is((String)"docker.target.reuse.bind.mounts")) {
                PathInsideBindMount pathInsideBindMount;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Trying to find existing volume binding for local directory: " + String.valueOf(localRootPath));
                }
                if ((pathInsideBindMount = DockerBindVolumes.tryToResolveLocalPathInBindMounts(localRootPath, volumeBindingsForReuse)) != null) {
                    DockerVolumeBinding existingBinding = pathInsideBindMount.getBinding();
                    String containerPath = pathInsideBindMount.getContainerPath();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Found existing volume binding: " + existingBinding.getHostPath() + ":" + existingBinding.getContainerPath() + "\nUsing corresponding file mapping: " + String.valueOf(localRootPath) + " -> " + containerPath);
                    }
                    dockerEnvironment.myUploadVolumes.put(uploadRoot, new DockerMountedVolume(localRootPath, containerPath));
                    return;
                }
            }
            String parentPath = StringUtil.isEmptyOrSpaces((String)customTargetParentDirectory) ? "/tmp" : customTargetParentDirectory;
            targetRootPath = parentPath + "/" + String.valueOf(UUID.randomUUID());
        }
        volumeBindings2.add(DockerRemoteRequest.safeVolumeBinding((String)targetRootPath, localRootPath.toAbsolutePath().toString()));
        dockerEnvironment.myUploadVolumes.put(uploadRoot, new DockerMountedVolume(localRootPath, (String)targetRootPath));
    }

    @Contract(value="null -> false", pure=true)
    private static boolean isUserMightLackSufficientPrivileges(@Nullable String user2) {
        return !StringUtil.isEmptyOrSpaces((String)user2) && !user2.equals(ROOT_USER) && !user2.startsWith("root:") && !user2.equals(ROOT_UID) && !user2.startsWith("0:");
    }

    @NotNull
    private static String generateRandomVolumeName() {
        String string = UUID.randomUUID().toString();
        if (string == null) {
            DockerEnvironment.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static void changeOwnershipOfVolume(@NotNull String user2, @NotNull RemoteDockerRuntime dockerRuntime, @NotNull DockerAgentImage dockerAgentImage, @NotNull String volumeName, @NotNull String containerPath, @NotNull TargetProgressIndicator progressIndicator) throws IOException, ServerRuntimeException, ExecutionException {
        if (user2 == null) {
            DockerEnvironment.$$$reportNull$$$0(34);
        }
        if (dockerRuntime == null) {
            DockerEnvironment.$$$reportNull$$$0(35);
        }
        if (dockerAgentImage == null) {
            DockerEnvironment.$$$reportNull$$$0(36);
        }
        if (volumeName == null) {
            DockerEnvironment.$$$reportNull$$$0(37);
        }
        if (containerPath == null) {
            DockerEnvironment.$$$reportNull$$$0(38);
        }
        if (progressIndicator == null) {
            DockerEnvironment.$$$reportNull$$$0(39);
        }
        String imageId = dockerAgentImage.getImageId();
        progressIndicator.addSystemLine(DockerBundle.message("DockerEnvironment.changing.the.ownership.of.the.named.volume.0", volumeName));
        VolumesBuilder volumesBuilder = VolumesBuilder.builder().addBoundVolume(containerPath, volumeName);
        DockerAgentDeploymentConfigImpl config2 = new DockerAgentDeploymentConfigImpl(imageId, volumesBuilder.build()).withUser(ROOT_USER).withEntrypoint(ArrayUtilRt.EMPTY_STRING_ARRAY).withCommand("chown", "-R", user2, containerPath);
        RemoteDockerApplicationRuntime applicationRuntime = RemoteDockerApplicationRuntime.create(dockerRuntime, config2);
        ProcessOutput output2 = applicationRuntime.startAndGetOutput();
        if (!output2.checkSuccess(LOG)) {
            throw new ExecutionException(DockerBundle.message("DockerEnvironment.failed.to.change.ownership.of.volume", imageId));
        }
    }

    @NotNull
    private static String getVolumesFromStringPresentation(@NotNull DockerVolumesFrom volumesFrom2) {
        if (volumesFrom2 == null) {
            DockerEnvironment.$$$reportNull$$$0(40);
        }
        if (volumesFrom2.isReadOnly()) {
            String string = volumesFrom2.getContainerId() + ":ro";
            if (string == null) {
                DockerEnvironment.$$$reportNull$$$0(41);
            }
            return string;
        }
        String string = volumesFrom2.getContainerId();
        if (string == null) {
            DockerEnvironment.$$$reportNull$$$0(42);
        }
        return string;
    }

    private /* synthetic */ RemoteProcess lambda$createProcess$4(Map actualPortMappings, DockerAgentDeploymentConfig deployConfig) throws Exception {
        return this.doCreateDockerProcess(actualPortMappings, deployConfig);
    }

    private static /* synthetic */ HashMap lambda$createProcess$3() {
        return new HashMap();
    }

    private static /* synthetic */ DockerPortBinding lambda$createProcess$2(DockerPortBinding oldValue, DockerPortBinding newValue2) {
        return newValue2;
    }

    private static /* synthetic */ DockerPortBinding lambda$createProcess$1(DockerPortBinding binding) {
        return binding;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 14, 16, 17, 18, 19, 20, 28, 33, 41, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 1: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumeBindings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerVolumesFromList";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 28: 
            case 33: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/target/DockerEnvironment";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualPortMappings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployConfig";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docker";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumesFromList";
                break;
            }
            case 27: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerEnvironment";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uploadRoot";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumeBindingsForReuse";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerAgentImage";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumeName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerPath";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumesFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/target/DockerEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUploadVolumes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadVolumes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPortBindings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPortBindings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPlatform";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateDockerProcess";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "runAsync";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "RM_OPTION_ALTERNATIVES";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "quote";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPortBindings";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRandomVolumeName";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getVolumesFromStringPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 28: 
            case 33: 
            case 41: 
            case 42: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doCreateDockerProcess";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runAsync";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "handleUploadRoot";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "changeOwnershipOfVolume";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getVolumesFromStringPresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 14, 16, 17, 18, 19, 20, 28, 33, 41, 42 -> new IllegalStateException(string);
        };
    }
}

