/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.debugger.jinja2;

import com.intellij.jinja.Jinja2Bundle;
import com.intellij.jinja.Jinja2Language;
import com.intellij.jinja.lexer.Jinja2TokenTypes;
import com.intellij.jinja.template.parsing.DjangoTemplateTokenTypes;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpointTypeBase;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.python.debugger.PyBreakpointType;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import org.jetbrains.annotations.NotNull;

public final class Jinja2LineBreakpointType
extends XLineBreakpointTypeBase
implements PyBreakpointType {
    public static final String ID = "jinja2-line";

    public Jinja2LineBreakpointType() {
        super(ID, Jinja2Bundle.message("jinja2.line.breakpoint", new Object[0]), (XDebuggerEditorsProvider)new PyDebuggerEditorsProvider());
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        if (file == null) {
            Jinja2LineBreakpointType.$$$reportNull$$$0(0);
        }
        if (project == null) {
            Jinja2LineBreakpointType.$$$reportNull$$$0(1);
        }
        Ref stoppable = Ref.create((Object)false);
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document != null && this.canPutInDocument(project, document)) {
            XDebuggerUtil.getInstance().iterateLine(project, document, line, psiElement -> {
                if (psiElement != null && (psiElement.getNode().getElementType() == DjangoTemplateTokenTypes.DJANGO_EXPRESSION_START || psiElement.getNode().getElementType() == DjangoTemplateTokenTypes.DJANGO_TAG_START || psiElement.getNode().getElementType() == Jinja2TokenTypes.TAG_START_TRIM || psiElement.getNode().getElementType() == Jinja2TokenTypes.TAG_START_PRESERVE || psiElement.getNode().getElementType() == Jinja2TokenTypes.EXPRESSION_START_TRIM)) {
                    stoppable.set((Object)true);
                    return false;
                }
                return true;
            });
        }
        return (Boolean)stoppable.get();
    }

    public boolean canPutInDocument(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            Jinja2LineBreakpointType.$$$reportNull$$$0(2);
        }
        if (document == null) {
            Jinja2LineBreakpointType.$$$reportNull$$$0(3);
        }
        Ref result = Ref.create((Object)false);
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile != null) {
                result.set((Object)(psiFile.getViewProvider().getPsi((Language)Jinja2Language.INSTANCE) != null ? 1 : 0));
            }
        });
        return (Boolean)result.get();
    }

    public String getBreakpointsDialogHelpTopic() {
        return "reference.dialogs.breakpoints";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/pro/debugger/jinja2/Jinja2LineBreakpointType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canPutAt";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canPutInDocument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

