/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter;

import com.intellij.httpClient.postman.HttpUrl;
import com.intellij.httpClient.postman.PostmanMapperKt;
import com.intellij.httpClient.postman.PostmanUrlProviderKt;
import com.intellij.httpClient.postman.converter.BodyProviderKt;
import com.intellij.httpClient.postman.converter.ConverterHelperKt;
import com.intellij.httpClient.postman.converter.HttpClientFileInfo;
import com.intellij.httpClient.postman.converter.HttpResponseBuilder;
import com.intellij.httpClient.postman.converter.HttpResponses;
import com.intellij.httpClient.postman.converter.PostmanCollectionConversionResult;
import com.intellij.httpClient.postman.converter.PostmanFileCheckerKt;
import com.intellij.httpClient.postman.converter.PostmanVariablesBuilder;
import com.intellij.httpClient.postman.converter.auth.HttpClientAuth;
import com.intellij.httpClient.postman.converter.auth.PostmanAuthProvider;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpAuthEnv;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpClientRequest;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpClientRequestBody;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpEnvItem;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpPostmanCollectionEnv;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpResponse;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpScript;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanAuth;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanBody;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanDescription;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanEvent;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanExec;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanHeader;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanItem;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanRequest;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanResponse;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanRoot;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanScript;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import io.netty.handler.codec.http.HttpMethod;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0001\u00a2\u0006\u0002\b\u0014J2\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u000fH\u0002J$\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020 2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u000fH\u0002J*\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u000fH\u0002J$\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0%2\u0006\u0010)\u001a\u00020\u000fH\u0002J\u001e\u0010*\u001a\u00020\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0%2\u0006\u0010+\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006,"}, d2={"Lcom/intellij/httpClient/postman/converter/PostmanCollectionConverter;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "variableBuilder", "Lcom/intellij/httpClient/postman/converter/PostmanVariablesBuilder;", "responseBuilder", "Lcom/intellij/httpClient/postman/converter/HttpResponseBuilder;", "authProvider", "Lcom/intellij/httpClient/postman/converter/auth/PostmanAuthProvider;", "fileName", "", "getFileName", "()Ljava/lang/String;", "convertCollection", "Lcom/intellij/httpClient/postman/converter/PostmanCollectionConversionResult;", "convertCollection$intellij_restClient", "buildRequests", "", "root", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanRoot;", "item", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanItem;", "requests", "", "Lcom/intellij/httpClient/postman/converter/dto/httpClient/HttpClientRequest;", "group", "buildByItem", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanItem$Item;", "buildRequestFromObject", "request", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanRequest$RequestObject;", "getScripts", "", "Lcom/intellij/httpClient/postman/converter/dto/httpClient/HttpScript;", "events", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanEvent;", "listenType", "convertToHttp", "collectionName", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nPostmanCollectionConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostmanCollectionConverter.kt\ncom/intellij/httpClient/postman/converter/PostmanCollectionConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,260:1\n1863#2,2:261\n1863#2:263\n1864#2:265\n1611#2,9:266\n1863#2:275\n1864#2:277\n1620#2:278\n774#2:279\n865#2,2:280\n1611#2,9:282\n1863#2:291\n1864#2:293\n1620#2:294\n1557#2:295\n1628#2,3:296\n1557#2:299\n1628#2,3:300\n1863#2,2:303\n1#3:264\n1#3:276\n1#3:292\n*S KotlinDebug\n*F\n+ 1 PostmanCollectionConverter.kt\ncom/intellij/httpClient/postman/converter/PostmanCollectionConverter\n*L\n50#1:261,2\n77#1:263\n77#1:265\n137#1:266,9\n137#1:275\n137#1:277\n137#1:278\n155#1:279\n155#1:280,2\n156#1:282,9\n156#1:291\n156#1:293\n156#1:294\n157#1:295\n157#1:296,3\n165#1:299\n165#1:300,3\n172#1:303,2\n137#1:276\n156#1:292\n*E\n"})
public final class PostmanCollectionConverter {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final PostmanVariablesBuilder variableBuilder;
    @NotNull
    private final HttpResponseBuilder responseBuilder;
    @NotNull
    private final PostmanAuthProvider authProvider;

    public PostmanCollectionConverter(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.project = project;
        this.file = file;
        this.variableBuilder = new PostmanVariablesBuilder();
        this.responseBuilder = new HttpResponseBuilder(this.variableBuilder, this.getFileName());
        this.authProvider = new PostmanAuthProvider();
    }

    private final String getFileName() {
        String string = this.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        return StringsKt.contains$default((CharSequence)fileName, (CharSequence)".postman_collection", (boolean)false, (int)2, null) ? StringsKt.substringBefore$default((String)fileName, (String)".postman_collection", null, (int)2, null) : StringsKt.removeSuffix((String)fileName, (CharSequence)".json");
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public final PostmanCollectionConversionResult convertCollection$intellij_restClient() {
        if (!PostmanFileCheckerKt.isPostmanCollectionFile(this.project, this.file)) {
            return null;
        }
        File file = this.file.toNioPath().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        String collectionText = FilesKt.readText$default((File)file, null, (int)1, null);
        PostmanRoot postmanRoot = (PostmanRoot)PostmanMapperKt.getPostmanMapper().readValue(collectionText, PostmanRoot.class);
        List requests2 = new ArrayList();
        Iterable $this$forEach$iv = postmanRoot.getItem();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PostmanItem item = (PostmanItem)element$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            Intrinsics.checkNotNull((Object)postmanRoot);
            this.buildRequests(postmanRoot, item, requests2, null);
        }
        List<HttpEnvItem> envItems = this.variableBuilder.getEnvItems();
        List<HttpAuthEnv> authItems = this.authProvider.getAuthEnv();
        HttpPostmanCollectionEnv httpPostmanCollectionEnv = !((Collection)envItems).isEmpty() || !((Collection)authItems).isEmpty() ? new HttpPostmanCollectionEnv(postmanRoot.getInfo().getName(), envItems, authItems) : null;
        return new PostmanCollectionConversionResult(new HttpClientFileInfo(this.getFileName(), this.convertToHttp(requests2, postmanRoot.getInfo().getName())), httpPostmanCollectionEnv, new HttpResponses(this.responseBuilder.getResponsesFolderName(), this.responseBuilder.getResponses()));
    }

    private final void buildRequests(PostmanRoot root, PostmanItem item, List<HttpClientRequest> requests2, String group) {
        block4: {
            block5: {
                PostmanItem postmanItem;
                block3: {
                    postmanItem = item;
                    if (!(postmanItem instanceof PostmanItem.Item)) break block3;
                    requests2.add(this.buildByItem(root, (PostmanItem.Item)item, group));
                    break block4;
                }
                if (!(postmanItem instanceof PostmanItem.ItemGroup)) break block5;
                Iterable $this$forEach$iv = ((PostmanItem.ItemGroup)item).getItem();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object object;
                    PostmanItem postmanItem2;
                    block7: {
                        String itemName;
                        block6: {
                            postmanItem2 = (PostmanItem)element$iv;
                            boolean bl = false;
                            itemName = ((PostmanItem.ItemGroup)item).getName();
                            object = group;
                            if (object == null) break block6;
                            String it = object;
                            boolean bl2 = false;
                            String string = group + " / " + itemName;
                            object = string;
                            if (string != null) break block7;
                        }
                        object = itemName;
                    }
                    String groupPath = object;
                    this.buildRequests(root, postmanItem2, requests2, groupPath);
                }
                break block4;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    static /* synthetic */ void buildRequests$default(PostmanCollectionConverter postmanCollectionConverter, PostmanRoot postmanRoot, PostmanItem postmanItem, List list2, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        postmanCollectionConverter.buildRequests(postmanRoot, postmanItem, list2, string);
    }

    private final HttpClientRequest buildByItem(PostmanRoot root, PostmanItem.Item item, String group) {
        HttpClientRequest httpClientRequest;
        PostmanRequest request = item.getRequest();
        if (request instanceof PostmanRequest.RequestString) {
            HttpClientAuth httpClientAuth;
            String httpMethod = HttpMethod.GET.name();
            HttpUrl url = PostmanUrlProviderKt.toHttpUrl(((PostmanRequest.RequestString)request).getValue());
            PostmanAuth postmanAuth = root.getAuth();
            if (postmanAuth != null) {
                PostmanAuth auth = postmanAuth;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)httpMethod);
                httpClientAuth = this.authProvider.getAuth(auth, httpMethod, url);
            } else {
                httpClientAuth = null;
            }
            HttpClientAuth auth = httpClientAuth;
            List headers2 = new ArrayList();
            Object object = auth;
            if (object instanceof HttpClientAuth.HeaderAuth) {
                headers2.add(((HttpClientAuth.HeaderAuth)auth).getHeader());
            } else if (object instanceof HttpClientAuth.QueryParamAuth) {
                url.addParameter(((HttpClientAuth.QueryParamAuth)auth).getKey(), ((HttpClientAuth.QueryParamAuth)auth).getValue());
            }
            String string = HttpMethod.GET.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
            object = string;
            httpClientRequest = new HttpClientRequest((String)object, url, headers2, null, group, null, null, null, null, null, 1000, null);
        } else if (request instanceof PostmanRequest.RequestObject) {
            httpClientRequest = this.buildRequestFromObject((PostmanRequest.RequestObject)request, item, root, group);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return httpClientRequest;
    }

    static /* synthetic */ HttpClientRequest buildByItem$default(PostmanCollectionConverter postmanCollectionConverter, PostmanRoot postmanRoot, PostmanItem.Item item, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return postmanCollectionConverter.buildByItem(postmanRoot, item, string);
    }

    /*
     * WARNING - void declaration
     */
    private final HttpClientRequest buildRequestFromObject(PostmanRequest.RequestObject request, PostmanItem.Item item, PostmanRoot root, String group) {
        String string;
        HttpClientRequestBody httpClientRequestBody;
        HttpClientRequestBody httpClientRequestBody2;
        String string2;
        HttpUrl httpUrl;
        List list2;
        String string3;
        String string4;
        List list3;
        List list4;
        Object $this$mapNotNull$iv;
        HttpClientAuth authHeader;
        HttpClientAuth httpClientAuth;
        List<HttpScript> list5;
        List preRequestScripts;
        PostmanBody body2;
        block22: {
            block21: {
                body2 = request.getBody();
                List<HttpScript> events = item.getEvent();
                preRequestScripts = new ArrayList();
                List<HttpScript> list6 = events;
                if (list6 != null) {
                    List<HttpScript> it = list6;
                    boolean bl = false;
                    preRequestScripts.addAll((Collection)this.getScripts((List<PostmanEvent>)events, "prerequest"));
                }
                if ((list5 = events) == null) break block21;
                List<HttpScript> it = list5;
                boolean bl = false;
                List<HttpScript> list7 = this.getScripts((List<PostmanEvent>)events, "test");
                list5 = list7;
                if (list7 != null) break block22;
            }
            list5 = CollectionsKt.emptyList();
        }
        List<HttpScript> responseScripts = list5;
        String httpMethod = ConverterHelperKt.retrieveMethod(request.getMethod(), body2);
        HttpUrl url = PostmanUrlProviderKt.retrieveUrl(request.getUrl(), this.variableBuilder);
        List headers2 = new ArrayList();
        PostmanAuth postmanAuth = request.getAuth();
        if (postmanAuth == null) {
            postmanAuth = root.getAuth();
        }
        if (postmanAuth != null) {
            PostmanAuth auth = postmanAuth;
            boolean bl = false;
            httpClientAuth = this.authProvider.getAuth(auth, httpMethod, url);
        } else {
            httpClientAuth = null;
        }
        HttpClientAuth httpClientAuth2 = authHeader = httpClientAuth;
        if (httpClientAuth2 instanceof HttpClientAuth.HeaderAuth) {
            headers2.add(((HttpClientAuth.HeaderAuth)authHeader).getHeader());
            HttpScript httpScript = ((HttpClientAuth.HeaderAuth)authHeader).getHeader().getCalculationPreScript();
            if (httpScript != null) {
                HttpScript prescript = httpScript;
                boolean bl = false;
                preRequestScripts.add(prescript);
            }
        } else if (httpClientAuth2 instanceof HttpClientAuth.QueryParamAuth) {
            url.addParameter(((HttpClientAuth.QueryParamAuth)authHeader).getKey(), ((HttpClientAuth.QueryParamAuth)authHeader).getValue());
        }
        PostmanHeader postmanHeader = request.getHeader();
        if (postmanHeader != null) {
            PostmanHeader requestHeader = postmanHeader;
            boolean bl = false;
            headers2.addAll((Collection)ConverterHelperKt.retrieveHeaders(requestHeader));
        }
        List<PostmanResponse> list8 = item.getResponse();
        if (list8 != null) {
            void $this$mapNotNullTo$iv$iv;
            $this$mapNotNull$iv = list8;
            boolean $i$f$mapNotNull = false;
            Iterable bl = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                HttpResponse it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                PostmanResponse response2 = (PostmanResponse)element$iv$iv;
                boolean bl3 = false;
                if (this.responseBuilder.buildResponse(response2) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list4 = (List)destination$iv$iv;
        } else {
            list4 = null;
        }
        List responses = list4;
        String string5 = httpMethod;
        HttpUrl httpUrl2 = url;
        List list9 = headers2;
        String string6 = item.getName();
        String string7 = group;
        List list10 = preRequestScripts;
        PostmanBody postmanBody = body2;
        if (postmanBody != null) {
            void it;
            $this$mapNotNull$iv = postmanBody;
            list3 = list10;
            string4 = string7;
            string3 = string6;
            list2 = list9;
            httpUrl = httpUrl2;
            string2 = string5;
            boolean bl = false;
            httpClientRequestBody2 = BodyProviderKt.retrieveBody((PostmanBody)it);
            string5 = string2;
            httpUrl2 = httpUrl;
            list9 = list2;
            string6 = string3;
            string7 = string4;
            list10 = list3;
            httpClientRequestBody = httpClientRequestBody2;
        } else {
            httpClientRequestBody = null;
        }
        List<HttpScript> list11 = responseScripts;
        PostmanDescription postmanDescription = request.getDescription();
        if (postmanDescription != null) {
            void it;
            PostmanDescription bl = postmanDescription;
            List<HttpScript> list12 = list11;
            httpClientRequestBody2 = httpClientRequestBody;
            list3 = list10;
            string4 = string7;
            string3 = string6;
            list2 = list9;
            httpUrl = httpUrl2;
            string2 = string5;
            boolean bl5 = false;
            String string8 = ConverterHelperKt.retrieveDescription((PostmanDescription)it);
            string5 = string2;
            httpUrl2 = httpUrl;
            list9 = list2;
            string6 = string3;
            string7 = string4;
            list10 = list3;
            httpClientRequestBody = httpClientRequestBody2;
            list11 = list12;
            string = string8;
        } else {
            string = null;
        }
        List list13 = responses;
        String string9 = string;
        List<HttpScript> list14 = list11;
        HttpClientRequestBody httpClientRequestBody3 = httpClientRequestBody;
        List list15 = list10;
        String string10 = string7;
        String string11 = string6;
        List list16 = list9;
        HttpUrl httpUrl3 = httpUrl2;
        String string12 = string5;
        return new HttpClientRequest(string12, httpUrl3, list16, string11, string10, list15, httpClientRequestBody3, list14, string9, list13);
    }

    /*
     * WARNING - void declaration
     */
    private final List<HttpScript> getScripts(List<PostmanEvent> events, String listenType) {
        List exec;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = events;
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PostmanEvent)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((PostmanEvent)it).getListen(), (Object)listenType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            PostmanExec it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            PostmanEvent it2 = (PostmanEvent)element$iv$iv;
            boolean bl2 = false;
            PostmanScript postmanScript = it2.getScript();
            if ((postmanScript != null ? postmanScript.getExec() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List list2;
            it = (PostmanExec)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            List list3 = exec;
            if (list3 instanceof PostmanExec.ExecObject) {
                list2 = ((PostmanExec.ExecObject)((Object)exec)).getItems();
            } else if (list3 instanceof PostmanExec.ExecString) {
                list2 = CollectionsKt.listOf((Object)((PostmanExec.ExecString)((Object)exec)).getValue());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List lines = list2;
            collection.add(lines);
        }
        List scripts = (List)destination$iv$iv;
        $this$map$iv = scripts;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            exec = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new HttpScript((List<String>)it, false, true));
        }
        return (List)destination$iv$iv;
    }

    private final String convertToHttp(List<HttpClientRequest> requests2, String collectionName) {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("# " + collectionName);
        Iterable $this$forEach$iv = requests2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpClientRequest request = (HttpClientRequest)element$iv;
            boolean bl = false;
            ConverterHelperKt.addRequestView(request, builder2);
        }
        return ((Object)StringsKt.trim((CharSequence)builder2)).toString();
    }
}

