/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// AlertCause : Cause of this alert.
/// Cause of this alert.
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum AlertCause {
    #[serde(rename = "UNKNOWN_CAUSE")]
    UnknownCause,
    #[serde(rename = "OTHER_CAUSE")]
    OtherCause,
    #[serde(rename = "TECHNICAL_PROBLEM")]
    TechnicalProblem,
    #[serde(rename = "STRIKE")]
    Strike,
    #[serde(rename = "DEMONSTRATION")]
    Demonstration,
    #[serde(rename = "ACCIDENT")]
    Accident,
    #[serde(rename = "HOLIDAY")]
    Holiday,
    #[serde(rename = "WEATHER")]
    Weather,
    #[serde(rename = "MAINTENANCE")]
    Maintenance,
    #[serde(rename = "CONSTRUCTION")]
    Construction,
    #[serde(rename = "POLICE_ACTIVITY")]
    PoliceActivity,
    #[serde(rename = "MEDICAL_EMERGENCY")]
    MedicalEmergency,

}

impl std::fmt::Display for AlertCause {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        match self {
            Self::UnknownCause => write!(f, "UNKNOWN_CAUSE"),
            Self::OtherCause => write!(f, "OTHER_CAUSE"),
            Self::TechnicalProblem => write!(f, "TECHNICAL_PROBLEM"),
            Self::Strike => write!(f, "STRIKE"),
            Self::Demonstration => write!(f, "DEMONSTRATION"),
            Self::Accident => write!(f, "ACCIDENT"),
            Self::Holiday => write!(f, "HOLIDAY"),
            Self::Weather => write!(f, "WEATHER"),
            Self::Maintenance => write!(f, "MAINTENANCE"),
            Self::Construction => write!(f, "CONSTRUCTION"),
            Self::PoliceActivity => write!(f, "POLICE_ACTIVITY"),
            Self::MedicalEmergency => write!(f, "MEDICAL_EMERGENCY"),
        }
    }
}

impl Default for AlertCause {
    fn default() -> AlertCause {
        Self::UnknownCause
    }
}

