# \GeocodeApi

All URIs are relative to *https://api.transitous.org*

Method | HTTP request | Description
------------- | ------------- | -------------
[**geocode**](GeocodeApi.md#geocode) | **GET** /api/v1/geocode | Autocompletion & geocoding that resolves user input addresses including coordinates
[**reverse_geocode**](GeocodeApi.md#reverse_geocode) | **GET** /api/v1/reverse-geocode | Translate coordinates to the closest address(es)/places/stops.



## geocode

> Vec<models::Match> geocode(text, language, r#type, place, place_bias)
Autocompletion & geocoding that resolves user input addresses including coordinates

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**text** | **String** | the (potentially partially typed) address to resolve | [required] |
**language** | Option<[**Vec<String>**](String.md)> | language tags as used in OpenStreetMap (usually ISO 639-1, or ISO 639-2 if there's no ISO 639-1)  |  |
**r#type** | Option<[**LocationType**](.md)> | Optional. Default is all types.  Only return results of the given types. For example, this can be used to allow only `ADDRESS` and `STOP` results.  |  |
**place** | Option<**String**> | Optional. Used for biasing results towards the coordinate.  Format: latitude,longitude in degrees  |  |
**place_bias** | Option<**f64**> | Optional. Used for biasing results towards the coordinate. Higher number = higher bias.  |  |[default to 1]

### Return type

[**Vec<models::Match>**](Match.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## reverse_geocode

> Vec<models::Match> reverse_geocode(place, r#type)
Translate coordinates to the closest address(es)/places/stops.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**place** | **String** | latitude, longitude in degrees | [required] |
**r#type** | Option<[**LocationType**](.md)> | Optional. Default is all types.  Only return results of the given type. For example, this can be used to allow only `ADDRESS` and `STOP` results.  |  |

### Return type

[**Vec<models::Match>**](Match.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

