/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.yaml.internal.load.reader;

import java.io.Serializable;
import org.virtuslab.yaml.Position;
import org.virtuslab.yaml.Range;
import org.virtuslab.yaml.ScannerError;
import org.virtuslab.yaml.ScannerError$;
import org.virtuslab.yaml.YamlError;
import org.virtuslab.yaml.internal.load.TagHandle;
import org.virtuslab.yaml.internal.load.TagHandle$Named$;
import org.virtuslab.yaml.internal.load.TagHandle$Primary$;
import org.virtuslab.yaml.internal.load.TagHandle$Secondary$;
import org.virtuslab.yaml.internal.load.TagPrefix;
import org.virtuslab.yaml.internal.load.TagPrefix$Global$;
import org.virtuslab.yaml.internal.load.TagPrefix$Local$;
import org.virtuslab.yaml.internal.load.TagValue;
import org.virtuslab.yaml.internal.load.TagValue$NonSpecific$;
import org.virtuslab.yaml.internal.load.TagValue$Shorthand$;
import org.virtuslab.yaml.internal.load.TagValue$Verbatim$;
import org.virtuslab.yaml.internal.load.reader.Reader;
import org.virtuslab.yaml.internal.load.reader.Reader$;
import org.virtuslab.yaml.internal.load.reader.Tokenizer;
import org.virtuslab.yaml.internal.load.reader.TokenizerContext;
import org.virtuslab.yaml.internal.load.reader.TokenizerContext$;
import org.virtuslab.yaml.internal.load.reader.UrlDecoder$;
import org.virtuslab.yaml.internal.load.reader.token.BlockChompingIndicator;
import org.virtuslab.yaml.internal.load.reader.token.BlockChompingIndicator$Clip$;
import org.virtuslab.yaml.internal.load.reader.token.BlockChompingIndicator$Keep$;
import org.virtuslab.yaml.internal.load.reader.token.BlockChompingIndicator$Strip$;
import org.virtuslab.yaml.internal.load.reader.token.ScalarStyle$DoubleQuoted$;
import org.virtuslab.yaml.internal.load.reader.token.ScalarStyle$Folded$;
import org.virtuslab.yaml.internal.load.reader.token.ScalarStyle$Literal$;
import org.virtuslab.yaml.internal.load.reader.token.ScalarStyle$Plain$;
import org.virtuslab.yaml.internal.load.reader.token.ScalarStyle$SingleQuoted$;
import org.virtuslab.yaml.internal.load.reader.token.Token;
import org.virtuslab.yaml.internal.load.reader.token.Token$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$Alias$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$Anchor$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$Comma$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$FlowMappingEnd$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$FlowMappingStart$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$FlowSequenceEnd$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$FlowSequenceStart$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$MappingKey$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$MappingStart$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$MappingValue$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$Scalar$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$SequenceStart$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$SequenceValue$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$StreamEnd$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$Tag$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$TagDirective$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Right;

public class StringTokenizer
implements Tokenizer {
    private final TokenizerContext ctx;
    private final Reader in;

    public StringTokenizer(String str) {
        this.ctx = TokenizerContext$.MODULE$.apply(str);
        this.in = this.ctx.reader();
    }

    @Override
    public Either<YamlError, Token> peekToken() {
        Option<Token> option = this.ctx.tokens().headOption();
        if (option instanceof Some) {
            Token token = (Token)((Some)option).value();
            return package$.MODULE$.Right().apply(token);
        }
        if (None$.MODULE$.equals(option)) {
            Right<YamlError, Token> right;
            try {
                right = package$.MODULE$.Right().apply(this.getToken());
            }
            catch (ScannerError e) {
                right = package$.MODULE$.Left().apply(e);
            }
            return right;
        }
        throw new MatchError(option);
    }

    @Override
    public Token popToken() {
        return this.ctx.tokens().removeHead(this.ctx.tokens().removeHead$default$1());
    }

    private Token getToken() {
        while (this.ctx.needMoreTokens()) {
            this.ctx.tokens().appendAll(this.getNextTokens());
        }
        return this.ctx.tokens().head();
    }

    private boolean shouldPopPlainKeys() {
        return this.ctx.isInBlockCollection() && this.ctx.potentialKeyOpt().exists((Function1<Token, Object>)(Function1<Token, boolean> & Serializable)_$1 -> _$1.range().start().line() != this.in.line());
    }

    /*
     * Unable to fully structure code
     */
    private Seq<Token> getNextTokens() {
        block23: {
            block22: {
                this.skipUntilNextToken();
                closedBlockTokens = this.ctx.checkIndents(this.in.column());
                closedTokens = closedBlockTokens.nonEmpty() != false || this.shouldPopPlainKeys() != false ? (List)this.ctx.popPotentialKeys().$plus$plus((IterableOnce)closedBlockTokens) : closedBlockTokens;
                var5_4 = peeked = this.in.peek(this.in.peek$default$1());
                if (Reader$.MODULE$.nullTerminator() != var5_4) break block22;
                v0 = (List)((IterableOps)this.ctx.popPotentialKeys().$plus$plus(this.ctx.checkIndents(-1))).$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{Token$.MODULE$.apply(TokenKind$StreamEnd$.MODULE$, this.in.range())})));
                break block23;
            }
            if ('-' != var5_4) ** GOTO lbl-1000
            if (this.isDocumentStart()) {
                v0 = this.parseDocumentStart();
            } else if (this.in.isNextWhitespace()) {
                v0 = this.parseBlockSequence();
            } else if ('.' == var5_4 && this.isDocumentEnd()) {
                v0 = this.parseDocumentEnd();
            } else {
                switch (var5_4) {
                    case '[': {
                        v0 = this.parseFlowSequenceStart();
                        break;
                    }
                    case ']': {
                        v0 = this.parseFlowSequenceEnd();
                        break;
                    }
                    case '{': {
                        v0 = this.parseFlowMappingStart();
                        break;
                    }
                    case '}': {
                        v0 = this.parseFlowMappingEnd();
                        break;
                    }
                    case '&': {
                        v0 = this.parseAnchor();
                        break;
                    }
                    case '!': {
                        v0 = this.parseTag();
                        break;
                    }
                    case '%': {
                        v0 = this.parseDirective();
                        break;
                    }
                    case '\"': {
                        v0 = this.parseDoubleQuoteValue();
                        break;
                    }
                    case '\'': {
                        v0 = this.parseSingleQuoteValue();
                        break;
                    }
                    case '>': {
                        v0 = this.parseFoldedValue();
                        break;
                    }
                    case '|': {
                        v0 = this.parseLiteral();
                        break;
                    }
                    case '*': {
                        v0 = this.parseAlias();
                        break;
                    }
                    case ',': {
                        this.in.skipCharacter();
                        this.ctx.isPlainKeyAllowed_$eq(true);
                        v0 = (List)this.ctx.popPotentialKeys().$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{Token$.MODULE$.apply(TokenKind$Comma$.MODULE$, this.in.range())})));
                        break;
                    }
                    default: {
                        if (':' == var5_4 && (this.in.isNextWhitespace() || this.ctx.isInFlowCollection() && this.ctx.isPlainKeyAllowed())) {
                            v0 = this.fetchValue();
                            break;
                        }
                        v0 = this.parsePlainScalar();
                        break;
                    }
                }
            }
        }
        tokens = v0;
        return (Seq)closedTokens.$plus$plus((IterableOnce)tokens);
    }

    private boolean isDocumentStart() {
        String string2 = this.in.peekN(3);
        String string3 = "---";
        return !(string2 != null ? !string2.equals(string3) : string3 != null) && RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(this.in.peek(3)));
    }

    private List<Token> parseDocumentStart() {
        this.in.skipN(4);
        return this.ctx.parseDocumentStart(this.in.column());
    }

    private boolean isDocumentEnd() {
        String string2 = this.in.peekN(3);
        String string3 = "...";
        return !(string2 != null ? !string2.equals(string3) : string3 != null) && RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(this.in.peek(3)));
    }

    private List<Token> parseDocumentEnd() {
        this.in.skipN(4);
        return this.ctx.parseDocumentEnd();
    }

    private List<Token> parseFlowSequenceStart() {
        this.in.skipCharacter();
        this.ctx.enterFlowSequence();
        return (List)this.ctx.popPotentialKeys().$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{Token$.MODULE$.apply(TokenKind$FlowSequenceStart$.MODULE$, this.in.range())})));
    }

    private List<Token> parseFlowSequenceEnd() {
        this.in.skipCharacter();
        this.ctx.leaveFlowSequence();
        return (List)this.ctx.popPotentialKeys().$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{Token$.MODULE$.apply(TokenKind$FlowSequenceEnd$.MODULE$, this.in.range())})));
    }

    private List<Token> parseFlowMappingStart() {
        this.in.skipCharacter();
        this.ctx.enterFlowMapping();
        this.ctx.isPlainKeyAllowed_$eq(true);
        return (List)this.ctx.popPotentialKeys().$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{Token$.MODULE$.apply(TokenKind$FlowMappingStart$.MODULE$, this.in.range())})));
    }

    private List<Token> parseFlowMappingEnd() {
        this.in.skipCharacter();
        this.ctx.leaveFlowMapping();
        return (List)this.ctx.popPotentialKeys().$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{Token$.MODULE$.apply(TokenKind$FlowMappingEnd$.MODULE$, this.in.range())})));
    }

    private List<Token> parseBlockSequence() {
        ListBuffer builder = new ListBuffer();
        if (this.ctx.isInBlockCollection() && this.ctx.indent() < this.in.column()) {
            this.ctx.addIndent(this.in.column());
            builder.addOne(Token$.MODULE$.apply(TokenKind$SequenceStart$.MODULE$, this.in.range()));
        }
        if (this.ctx.isInBlockCollection() && !this.ctx.isPlainKeyAllowed()) {
            throw ScannerError$.MODULE$.from(this.in.range(), "cannot start sequence");
        }
        this.in.skipCharacter();
        builder.addAll((IterableOnce)this.ctx.popPotentialKeys());
        builder.addOne(Token$.MODULE$.apply(TokenKind$SequenceValue$.MODULE$, this.in.range()));
        return builder.toList();
    }

    private List<Token> parseDirective() {
        Range range = this.in.range();
        this.in.skipCharacter();
        char c = this.in.peek(this.in.peek$default$1());
        if ('Y' == c) {
            String string2 = this.in.peekN(4);
            String string3 = "YAML";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                this.in.skipN(4);
                throw this.parseYamlDirective$1();
            }
        }
        if ('T' == c) {
            String string4 = this.in.peekN(3);
            String string5 = "TAG";
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                this.in.skipN(3);
                return this.parseTagDirective$1(range);
            }
        }
        throw ScannerError$.MODULE$.from(this.in.range(), "Unknown directive, expected YAML or TAG");
    }

    private List<Token> parseTag() {
        TokenKind.Tag tag;
        TokenKind.Tag tag2;
        char peeked;
        Range range = this.in.range();
        Set invalidChars = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'[', ']', '{', '}'}));
        this.in.skipCharacter();
        char c = peeked = this.in.peek(this.in.peek$default$1());
        if (Reader$.MODULE$.nullTerminator() == c) {
            throw ScannerError$.MODULE$.from(this.in.range(), "Input stream ended unexpectedly");
        }
        if ('<' == c) {
            String tag3 = this.parseVerbatimTag$1();
            tag2 = TokenKind$Tag$.MODULE$.apply(TagValue$Verbatim$.MODULE$.apply(tag3));
        } else if (' ' == c) {
            tag2 = TokenKind$Tag$.MODULE$.apply(TagValue$NonSpecific$.MODULE$);
        } else {
            char c2 = c;
            TagValue tagValue = this.parseShorthandTag$1(invalidChars, c2);
            tag2 = tag = TokenKind$Tag$.MODULE$.apply(tagValue);
        }
        if (this.ctx.isPlainKeyAllowed()) {
            this.ctx.addPotentialKey(Token$.MODULE$.apply(tag, range));
            return package$.MODULE$.Nil();
        }
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{Token$.MODULE$.apply(tag, range)}));
    }

    private Tuple2<String, Range> parseAnchorName() {
        Set invalidChars = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'[', ']', '{', '}', ','}));
        StringBuilder sb = new StringBuilder();
        Range range = this.in.range();
        this.in.skipCharacter();
        String name = this.readAnchorName$1(sb, invalidChars);
        return Tuple2$.MODULE$.apply(name, range);
    }

    private List<Token> parseAnchor() {
        Tuple2<String, Range> tuple2 = this.parseAnchorName();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String name = tuple2._1();
        Range range = tuple2._2();
        Tuple2<String, Range> tuple22 = Tuple2$.MODULE$.apply(name, range);
        String name2 = tuple22._1();
        Range range2 = tuple22._2();
        Token anchorToken = Token$.MODULE$.apply(TokenKind$Anchor$.MODULE$.apply(name2), range2);
        if (this.ctx.isPlainKeyAllowed()) {
            this.ctx.addPotentialKey(anchorToken);
            return package$.MODULE$.Nil();
        }
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{anchorToken}));
    }

    private List<Token> parseAlias() {
        Tuple2<String, Range> tuple2 = this.parseAnchorName();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String name = tuple2._1();
        Range pos = tuple2._2();
        Tuple2<String, Range> tuple22 = Tuple2$.MODULE$.apply(name, pos);
        String name2 = tuple22._1();
        Range pos2 = tuple22._2();
        Token aliasToken = Token$.MODULE$.apply(TokenKind$Alias$.MODULE$.apply(name2), pos2);
        if (this.ctx.isPlainKeyAllowed()) {
            this.ctx.addPotentialKey(aliasToken);
            return package$.MODULE$.Nil();
        }
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{aliasToken}));
    }

    private List<Token> parseDoubleQuoteValue() {
        StringBuilder sb = new StringBuilder();
        boolean isPlainKeyAllowed = this.ctx.isPlainKeyAllowed();
        Range range = this.in.range();
        this.in.skipCharacter();
        String scalar = this.readScalar$1(sb);
        Range endRange = range.withEndPos(this.in.pos());
        Token scalarToken = Token$.MODULE$.apply(TokenKind$Scalar$.MODULE$.apply(scalar, ScalarStyle$DoubleQuoted$.MODULE$), endRange);
        if (isPlainKeyAllowed) {
            this.ctx.addPotentialKey(scalarToken);
            return package$.MODULE$.Nil();
        }
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{scalarToken}));
    }

    private void parseBlockHeader() {
        while (this.in.peek(this.in.peek$default$1()) == ' ') {
            this.in.skipCharacter();
        }
        if (this.in.peek(this.in.peek$default$1()) == '#') {
            this.skipComment();
        }
        if (this.in.isNewline()) {
            this.in.skipCharacter();
            return;
        }
    }

    private BlockChompingIndicator parseChompingIndicator() {
        BlockChompingIndicator blockChompingIndicator;
        char c = this.in.peek(this.in.peek$default$1());
        if ('-' == c) {
            this.in.skipCharacter();
            blockChompingIndicator = BlockChompingIndicator$Strip$.MODULE$;
        } else if ('+' == c) {
            this.in.skipCharacter();
            blockChompingIndicator = BlockChompingIndicator$Keep$.MODULE$;
        } else {
            blockChompingIndicator = BlockChompingIndicator$Clip$.MODULE$;
        }
        return blockChompingIndicator;
    }

    private Option<Object> parseIndentationIndicator() {
        char c = this.in.peek(this.in.peek$default$1());
        char number = c;
        if (RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(number))) {
            this.in.skipCharacter();
            return Some$.MODULE$.apply(BoxesRunTime.boxToInteger(RichChar$.MODULE$.asDigit$extension(Predef$.MODULE$.charWrapper(number))));
        }
        return None$.MODULE$;
    }

    private List<Token> parseLiteral() {
        StringBuilder sb = new StringBuilder();
        Range range = this.in.range();
        this.in.skipCharacter();
        Option<Object> indentationIndicator = this.parseIndentationIndicator();
        BlockChompingIndicator chompingIndicator = this.parseChompingIndicator();
        Option<Object> indentation = indentationIndicator.isEmpty() ? this.parseIndentationIndicator() : indentationIndicator;
        this.parseBlockHeader();
        if (indentation.isEmpty()) {
            this.skipUntilNextChar();
        }
        int foldedIndent = BoxesRunTime.unboxToInt(indentation.getOrElse(this::$anonfun$1));
        this.skipUntilNextIndent(foldedIndent);
        String scalar = this.readLiteral$1(sb, foldedIndent);
        String chompedScalar = chompingIndicator.removeBlankLinesAtEnd(scalar);
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{Token$.MODULE$.apply(TokenKind$Scalar$.MODULE$.apply(chompedScalar, ScalarStyle$Literal$.MODULE$), range)}));
    }

    private List<Token> parseFoldedValue() {
        StringBuilder sb = new StringBuilder();
        Range range = this.in.range();
        this.in.skipCharacter();
        Option<Object> indentationIndicator = this.parseIndentationIndicator();
        BlockChompingIndicator chompingIndicator = this.parseChompingIndicator();
        Option<Object> indentation = indentationIndicator.isEmpty() ? this.parseIndentationIndicator() : indentationIndicator;
        this.parseBlockHeader();
        if (indentation.isEmpty()) {
            this.skipUntilNextToken();
        }
        int foldedIndent = BoxesRunTime.unboxToInt(indentation.getOrElse(this::$anonfun$2));
        this.skipUntilNextIndent(foldedIndent);
        String scalar = this.readFolded$1(sb, foldedIndent, chompingIndicator, StringTokenizer.readFolded$default$1$1(), StringTokenizer.readFolded$default$2$1());
        String chompedScalar = chompingIndicator.removeBlankLinesAtEnd(scalar);
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{Token$.MODULE$.apply(TokenKind$Scalar$.MODULE$.apply(chompedScalar, ScalarStyle$Folded$.MODULE$), range)}));
    }

    private List<Token> parseSingleQuoteValue() {
        StringBuilder sb = new StringBuilder();
        boolean isPlainKeyAllowed = this.ctx.isPlainKeyAllowed();
        Range range = this.in.range();
        this.in.skipCharacter();
        String scalar = this.readScalar$2(sb);
        Range endRange = range.withEndPos(this.in.pos());
        Token scalarToken = Token$.MODULE$.apply(TokenKind$Scalar$.MODULE$.apply(scalar, ScalarStyle$SingleQuoted$.MODULE$), endRange);
        if (isPlainKeyAllowed) {
            this.ctx.addPotentialKey(scalarToken);
            return package$.MODULE$.Nil();
        }
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{scalarToken}));
    }

    private List<Token> parsePlainScalar() {
        StringBuilder sb = new StringBuilder();
        int scalarIndent = this.in.column();
        boolean isPlainKeyAllowed = this.ctx.isPlainKeyAllowed();
        Range range = this.in.range();
        String scalar = this.readScalar$3(sb);
        Range endRange = range.withEndPos(this.in.pos());
        Token scalarToken = Token$.MODULE$.apply(TokenKind$Scalar$.MODULE$.apply(scalar.trim(), ScalarStyle$Plain$.MODULE$), endRange);
        if (isPlainKeyAllowed) {
            this.ctx.addPotentialKey(scalarToken);
            return package$.MODULE$.Nil();
        }
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{scalarToken}));
    }

    private List<Token> fetchValue() {
        List list2;
        LazyRef lazyRef = new LazyRef();
        this.in.skipCharacter();
        Token mappingValueToken = Token$.MODULE$.apply(TokenKind$MappingValue$.MODULE$, this.in.range());
        if (this.ctx.isInBlockCollection() && this.ctx.indent() < this.firstSimpleKey$1(lazyRef, mappingValueToken).start().column()) {
            this.ctx.addIndent(this.firstSimpleKey$1(lazyRef, mappingValueToken).start().column());
            list2 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{Token$.MODULE$.apply(TokenKind$MappingStart$.MODULE$, this.firstSimpleKey$1(lazyRef, mappingValueToken).range())}));
        } else {
            list2 = package$.MODULE$.Nil();
        }
        Nil$ maybeMappingStart = list2;
        List<Token> potentialKeys = this.ctx.popPotentialKeys();
        this.ctx.isPlainKeyAllowed_$eq(false);
        if (this.ctx.isInBlockCollection() && this.firstSimpleKey$1(lazyRef, mappingValueToken).range().end().exists((Function1<Position, Object>)(Function1<Position, boolean> & Serializable)_$2 -> _$2.line() > this.firstSimpleKey$1(lazyRef, mappingValueToken).range().start().line())) {
            throw ScannerError$.MODULE$.from("Mapping value is not allowed", mappingValueToken);
        }
        return (List)((SeqOps)((IterableOps)maybeMappingStart.$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{Token$.MODULE$.apply(TokenKind$MappingKey$.MODULE$, this.in.range())})))).$plus$plus(potentialKeys)).$colon$plus(mappingValueToken);
    }

    public void skipUntilNextToken() {
        while (this.in.isWhitespace() && !this.in.isNewline()) {
            this.in.skipCharacter();
        }
        if (this.in.peek(this.in.peek$default$1()) == '#') {
            this.skipComment();
        }
        if (this.in.isNewline()) {
            this.ctx.isPlainKeyAllowed_$eq(true);
            this.in.skipCharacter();
            this.skipUntilNextToken();
            return;
        }
    }

    public void skipSpaces() {
        while (this.in.peek(this.in.peek$default$1()) == ' ') {
            this.in.skipCharacter();
        }
    }

    public void skipUntilNextIndent(int indentBlock) {
        while (this.in.peek(this.in.peek$default$1()) == ' ' && this.in.column() < indentBlock) {
            this.in.skipCharacter();
        }
    }

    public void skipUntilNextChar() {
        while (this.in.isWhitespace()) {
            this.in.skipCharacter();
        }
    }

    private void skipComment() {
        while (this.in.peek(this.in.peek$default$1()) != Reader$.MODULE$.nullTerminator() && !this.in.isNewline()) {
            this.in.skipCharacter();
        }
    }

    private final Nothing$ parseYamlDirective$1() {
        throw ScannerError$.MODULE$.from(this.in.range(), "YAML directives are not supported yet.");
    }

    private final boolean condition$1() {
        char c = this.in.peek(this.in.peek$default$1());
        return !RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(c)) && c != '!';
    }

    private final TagHandle parseTagHandle$1() {
        TagHandle tagHandle;
        char c = this.in.peekNext();
        if (' ' == c) {
            this.in.skipCharacter();
            tagHandle = TagHandle$Primary$.MODULE$;
        } else if ('!' == c) {
            this.in.skipN(2);
            tagHandle = TagHandle$Secondary$.MODULE$;
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(this.in.read());
            while (this.condition$1()) {
                sb.append(this.in.read());
            }
            sb.append(this.in.read());
            tagHandle = TagHandle$Named$.MODULE$.apply(sb.result());
        }
        return tagHandle;
    }

    private final TagPrefix parseTagPrefix$1() {
        TagPrefix tagPrefix;
        this.skipSpaces();
        char c = this.in.peek(this.in.peek$default$1());
        if ('!' == c) {
            StringBuilder sb = new StringBuilder();
            while (!RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(this.in.peek(this.in.peek$default$1())))) {
                sb.append(this.in.read());
            }
            tagPrefix = TagPrefix$Local$.MODULE$.apply(sb.result());
        } else {
            char c2 = c;
            if (c2 != '!' && c2 != ',') {
                StringBuilder sb = new StringBuilder();
                while (!RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(this.in.peek(this.in.peek$default$1())))) {
                    sb.append(this.in.read());
                }
                tagPrefix = TagPrefix$Global$.MODULE$.apply(sb.result());
            } else {
                throw ScannerError$.MODULE$.from(this.in.range(), "Invalid tag prefix in TAG directive");
            }
        }
        return tagPrefix;
    }

    private final List parseTagDirective$1(Range range$1) {
        this.skipSpaces();
        char c = this.in.peek(this.in.peek$default$1());
        if ('!' == c) {
            TagHandle handle = this.parseTagHandle$1();
            TagPrefix prefix = this.parseTagPrefix$1();
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{Token$.MODULE$.apply(TokenKind$TagDirective$.MODULE$.apply(handle, prefix), range$1)}));
        }
        throw ScannerError$.MODULE$.from(this.in.range(), "Tag handle in TAG directive should start with '!'");
    }

    private final boolean condition$2() {
        char c = this.in.peek(this.in.peek$default$1());
        return c != '>' && !RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(c));
    }

    private final String parseVerbatimTag$1() {
        StringBuilder sb = new StringBuilder();
        sb.append('!');
        while (this.condition$2()) {
            sb.append(this.in.read());
        }
        char c = this.in.peek(this.in.peek$default$1());
        if ('>' == c) {
            sb.append(this.in.read());
            return sb.result();
        }
        throw ScannerError$.MODULE$.from(this.in.range(), "Lacks '>' which closes verbatim tag attribute");
    }

    private final boolean condition$3(Set invalidChars$2) {
        char c = this.in.peek(this.in.peek$default$1());
        return !invalidChars$2.apply(BoxesRunTime.boxToCharacter(c)) && !RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(c));
    }

    private final String parseTagSuffix$1(Set invalidChars$1) {
        StringBuilder sb = new StringBuilder();
        while (this.condition$3(invalidChars$1)) {
            sb.append(this.in.read());
        }
        if (invalidChars$1.contains(BoxesRunTime.boxToCharacter(this.in.peek(this.in.peek$default$1())))) {
            throw ScannerError$.MODULE$.from(this.in.range(), "Invalid character in tag");
        }
        return UrlDecoder$.MODULE$.decode(sb.result());
    }

    private final boolean condition$4(Set invalidChars$4) {
        char c = this.in.peek(this.in.peek$default$1());
        return !invalidChars$4.apply(BoxesRunTime.boxToCharacter(c)) && !RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(c)) && c != '!';
    }

    private final TagValue parseShorthandTag$1(Set invalidChars$3, char second) {
        char c = second;
        if ('!' == c) {
            this.in.skipCharacter();
            return TagValue$Shorthand$.MODULE$.apply(TagHandle$Secondary$.MODULE$, this.parseTagSuffix$1(invalidChars$3));
        }
        StringBuilder sb = new StringBuilder();
        while (this.condition$4(invalidChars$3)) {
            sb.append(this.in.read());
        }
        if (invalidChars$3.contains(BoxesRunTime.boxToCharacter(this.in.peek(this.in.peek$default$1())))) {
            throw ScannerError$.MODULE$.from(this.in.range(), "Invalid character in tag");
        }
        char c2 = this.in.peek(this.in.peek$default$1());
        if ('!' == c2) {
            sb.insert(0, '!');
            sb.append(this.in.read());
            return TagValue$Shorthand$.MODULE$.apply(TagHandle$Named$.MODULE$.apply(sb.result()), this.parseTagSuffix$1(invalidChars$3));
        }
        if (' ' == c2) {
            return TagValue$Shorthand$.MODULE$.apply(TagHandle$Primary$.MODULE$, sb.result());
        }
        throw ScannerError$.MODULE$.from(this.in.range(), "Invalid tag handle");
    }

    private final String readAnchorName$1(StringBuilder sb$1, Set invalidChars$5) {
        while (true) {
            char c = this.in.peek(this.in.peek$default$1());
            if (Reader$.MODULE$.nullTerminator() == c) {
                return sb$1.result();
            }
            char c2 = c;
            if (invalidChars$5.apply(BoxesRunTime.boxToCharacter(c2)) || this.in.isWhitespace()) break;
            sb$1.append(this.in.read());
        }
        return sb$1.result();
    }

    private final String readScalar$1(StringBuilder sb$2) {
        while (true) {
            char c = this.in.peek(this.in.peek$default$1());
            if (Reader$.MODULE$.nullTerminator() == c) {
                return sb$2.result();
            }
            if (this.in.isNewline()) {
                this.skipUntilNextToken();
                sb$2.append(" ");
                continue;
            }
            if ('\\' == c && this.in.peekNext() == '\"') {
                this.in.skipN(2);
                sb$2.append("\"");
                continue;
            }
            if ('\"' == c) {
                this.in.skipCharacter();
                return sb$2.result();
            }
            char c2 = c;
            sb$2.append(this.in.read());
        }
    }

    private final int $anonfun$1() {
        return this.in.column();
    }

    private final String readLiteral$1(StringBuilder sb$3, int foldedIndent$1) {
        while (true) {
            char c = this.in.peek(this.in.peek$default$1());
            if (Reader$.MODULE$.nullTerminator() == c) {
                return sb$3.result();
            }
            if (this.in.isNewline()) {
                this.ctx.isPlainKeyAllowed_$eq(true);
                sb$3.append(this.in.read());
                this.skipUntilNextIndent(foldedIndent$1);
                if (this.in.isWhitespace() || this.in.column() == foldedIndent$1) continue;
                return sb$3.result();
            }
            char c2 = c;
            sb$3.append(this.in.read());
        }
    }

    private final int $anonfun$2() {
        return this.in.column();
    }

    private final void chompedEmptyLines$1(StringBuilder sb$4) {
        while (this.in.isNextNewline()) {
            this.in.skipCharacter();
            sb$4.append("\n");
        }
    }

    private final String readFolded$1(StringBuilder sb$5, int foldedIndent$2, BlockChompingIndicator chompingIndicator$1, boolean prevCharWasNewline, boolean thisLineIsIndented) {
        while (true) {
            char c = this.in.peek(this.in.peek$default$1());
            if (Reader$.MODULE$.nullTerminator() == c) {
                return sb$5.result();
            }
            if (this.in.isNewline()) {
                this.ctx.isPlainKeyAllowed_$eq(true);
                if (this.in.isNextNewline()) {
                    this.chompedEmptyLines$1(sb$5);
                    if (this.in.peek(this.in.peek$default$1()) != Reader$.MODULE$.nullTerminator()) {
                        this.in.skipCharacter();
                        this.skipUntilNextIndent(foldedIndent$2);
                    }
                    if (this.in.column() != foldedIndent$2 || this.in.peek(this.in.peek$default$1()) == Reader$.MODULE$.nullTerminator()) {
                        BlockChompingIndicator blockChompingIndicator = chompingIndicator$1;
                        BlockChompingIndicator$Keep$ blockChompingIndicator$Keep$ = BlockChompingIndicator$Keep$.MODULE$;
                        if (!(blockChompingIndicator != null ? !blockChompingIndicator.equals(blockChompingIndicator$Keep$) : blockChompingIndicator$Keep$ != null)) {
                            sb$5.append("\n");
                        }
                        return sb$5.result();
                    }
                    boolean bl = true;
                    boolean bl2 = StringTokenizer.readFolded$default$2$1();
                    prevCharWasNewline = bl;
                    thisLineIsIndented = bl2;
                    continue;
                }
                this.in.skipCharacter();
                this.skipUntilNextIndent(foldedIndent$2);
                if (this.in.column() != foldedIndent$2 || this.in.peek(this.in.peek$default$1()) == Reader$.MODULE$.nullTerminator()) {
                    Serializable serializable;
                    BlockChompingIndicator blockChompingIndicator = chompingIndicator$1;
                    if (BlockChompingIndicator$Keep$.MODULE$.equals(blockChompingIndicator)) {
                        int count = 1;
                        char lastChar = sb$5.apply(sb$5.length() - 1);
                        while (lastChar == '\n' || lastChar == ' ') {
                            sb$5.deleteCharAt(sb$5.length() - 1);
                            lastChar = sb$5.apply(sb$5.length() - 1);
                            ++count;
                        }
                        serializable = sb$5.append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\n"), count));
                    } else if (BlockChompingIndicator$Strip$.MODULE$.equals(blockChompingIndicator)) {
                        char lastChar = sb$5.apply(sb$5.length() - 1);
                        while (lastChar == '\n' || lastChar == ' ') {
                            sb$5.deleteCharAt(sb$5.length() - 1);
                            lastChar = sb$5.apply(sb$5.length() - 1);
                        }
                        serializable = BoxedUnit.UNIT;
                    } else if (BlockChompingIndicator$Clip$.MODULE$.equals(blockChompingIndicator)) {
                        char lastChar = sb$5.apply(sb$5.length() - 1);
                        while (lastChar == '\n' || lastChar == ' ') {
                            sb$5.deleteCharAt(sb$5.length() - 1);
                            lastChar = sb$5.apply(sb$5.length() - 1);
                        }
                        serializable = sb$5.append('\n');
                    } else {
                        throw new MatchError(blockChompingIndicator);
                    }
                    return sb$5.result();
                }
                StringBuilder stringBuilder = prevCharWasNewline || thisLineIsIndented ? sb$5.append("\n") : sb$5.append(" ");
                boolean bl = true;
                boolean bl3 = StringTokenizer.readFolded$default$2$1();
                prevCharWasNewline = bl;
                thisLineIsIndented = bl3;
                continue;
            }
            if (' ' == c && this.in.column() == foldedIndent$2) {
                if (prevCharWasNewline) {
                    sb$5.update(sb$5.size() - 1, '\n');
                }
                sb$5.append(this.in.read());
                boolean bl = StringTokenizer.readFolded$default$1$1();
                boolean bl4 = true;
                prevCharWasNewline = bl;
                thisLineIsIndented = bl4;
                continue;
            }
            char c2 = c;
            sb$5.append(this.in.read());
            prevCharWasNewline = StringTokenizer.readFolded$default$1$1();
        }
    }

    private static final boolean readFolded$default$1$1() {
        return false;
    }

    private static final boolean readFolded$default$2$1() {
        return false;
    }

    private final String readScalar$2(StringBuilder sb$6) {
        while (true) {
            char c = this.in.peek(this.in.peek$default$1());
            if (Reader$.MODULE$.nullTerminator() == c) {
                return sb$6.result();
            }
            if ('\'' == c && this.in.peekNext() == '\'') {
                this.in.skipN(2);
                sb$6.append('\'');
                continue;
            }
            if ('\n' == c) {
                sb$6.append(' ');
                this.skipUntilNextToken();
                continue;
            }
            if ('\'' == c) {
                this.in.skipCharacter();
                return sb$6.result();
            }
            char c2 = c;
            sb$6.append(this.in.read());
        }
    }

    private final void chompedEmptyLines$2(StringBuilder sb$7) {
        while (this.in.isNextNewline()) {
            this.in.skipCharacter();
            sb$7.append("\n");
        }
    }

    private final String readScalar$3(StringBuilder sb$8) {
        while (true) {
            char c;
            char peeked;
            char c2 = peeked = this.in.peek(this.in.peek$default$1());
            if (Reader$.MODULE$.nullTerminator() == c2) {
                return sb$8.result();
            }
            if (':' == c2) {
                if (this.in.isNextWhitespace()) {
                    return sb$8.result();
                }
                if (this.in.peekNext() == ',' && this.ctx.isInFlowCollection()) {
                    return sb$8.result();
                }
            }
            if (!this.ctx.isAllowedSpecialCharacter(c = c2)) {
                return sb$8.result();
            }
            if ((this.isDocumentEnd() || this.isDocumentStart()) && this.ctx.indent() == -1) {
                return sb$8.result();
            }
            if (' ' == c2 && this.in.peekNext() == '#') {
                return sb$8.result();
            }
            if (this.in.isNewline()) {
                Serializable serializable;
                this.ctx.isPlainKeyAllowed_$eq(true);
                if (this.in.isNextNewline()) {
                    this.chompedEmptyLines$2(sb$8);
                    serializable = BoxedUnit.UNIT;
                } else {
                    serializable = sb$8.append(' ');
                }
                this.skipUntilNextToken();
                if (this.in.column() > this.ctx.indent()) continue;
                return sb$8.result();
            }
            char = c2;
            sb$8.append(this.in.read());
        }
    }

    private static final Token firstSimpleKey$lzyINIT1$1$$anonfun$1(Token mappingValueToken$2) {
        throw ScannerError$.MODULE$.from("Not found expected key for value", mappingValueToken$2);
    }

    private final Token firstSimpleKey$lzyINIT1$1(LazyRef firstSimpleKey$lzy1$1, Token mappingValueToken$1) {
        Token token;
        LazyRef lazyRef = firstSimpleKey$lzy1$1;
        synchronized (lazyRef) {
            token = (Token)(firstSimpleKey$lzy1$1.initialized() ? firstSimpleKey$lzy1$1.value() : firstSimpleKey$lzy1$1.initialize((Token)this.ctx.potentialKeys().headOption().getOrElse(() -> StringTokenizer.firstSimpleKey$lzyINIT1$1$$anonfun$1(mappingValueToken$1))));
        }
        return token;
    }

    private final Token firstSimpleKey$1(LazyRef firstSimpleKey$lzy1$2, Token mappingValueToken$3) {
        return (Token)(firstSimpleKey$lzy1$2.initialized() ? firstSimpleKey$lzy1$2.value() : this.firstSimpleKey$lzyINIT1$1(firstSimpleKey$lzy1$2, mappingValueToken$3));
    }
}

