"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.isStringLiteralLike = exports.findAllSubstringIndices = void 0;
const ts = require("typescript");
/** Finds all start indices of the given search string in the input string. */
function findAllSubstringIndices(input, search) {
    const result = [];
    let i = -1;
    while ((i = input.indexOf(search, i + 1)) !== -1) {
        result.push(i);
    }
    return result;
}
exports.findAllSubstringIndices = findAllSubstringIndices;
/**
 * Checks whether the given node is either a string literal or a no-substitution template
 * literal. Note that we cannot use `ts.isStringLiteralLike()` because if developers update
 * an outdated project, their TypeScript version is not automatically being updated
 * and therefore could throw because the function is not available yet.
 * https://github.com/Microsoft/TypeScript/commit/8518343dc8762475a5e92c9f80b5c5725bd81796
 */
function isStringLiteralLike(node) {
    return ts.isStringLiteral(node) || ts.isNoSubstitutionTemplateLiteral(node);
}
exports.isStringLiteralLike = isStringLiteralLike;
//# sourceMappingURL=data:application/json;base64,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