//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-quartz-core")]
#[cfg(target_vendor = "apple")]
use objc2_quartz_core::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsappkitversionnumberwithcustomsheetposition?language=objc)
#[cfg(feature = "NSApplication")]
pub static NSAppKitVersionNumberWithCustomSheetPosition: NSAppKitVersion = 686.0 as _;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsappkitversionnumberwithdeferredwindowdisplaysupport?language=objc)
#[cfg(feature = "NSApplication")]
pub static NSAppKitVersionNumberWithDeferredWindowDisplaySupport: NSAppKitVersion = 1019.0 as _;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowstylemask?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSWindowStyleMask(pub NSUInteger);
bitflags::bitflags! {
    impl NSWindowStyleMask: NSUInteger {
        #[doc(alias = "NSWindowStyleMaskBorderless")]
        const Borderless = 0;
        #[doc(alias = "NSWindowStyleMaskTitled")]
        const Titled = 1<<0;
        #[doc(alias = "NSWindowStyleMaskClosable")]
        const Closable = 1<<1;
        #[doc(alias = "NSWindowStyleMaskMiniaturizable")]
        const Miniaturizable = 1<<2;
        #[doc(alias = "NSWindowStyleMaskResizable")]
        const Resizable = 1<<3;
        #[doc(alias = "NSWindowStyleMaskTexturedBackground")]
#[deprecated = "Textured window style should no longer be used"]
        const TexturedBackground = 1<<8;
        #[doc(alias = "NSWindowStyleMaskUnifiedTitleAndToolbar")]
        const UnifiedTitleAndToolbar = 1<<12;
        #[doc(alias = "NSWindowStyleMaskFullScreen")]
        const FullScreen = 1<<14;
        #[doc(alias = "NSWindowStyleMaskFullSizeContentView")]
        const FullSizeContentView = 1<<15;
        #[doc(alias = "NSWindowStyleMaskUtilityWindow")]
        const UtilityWindow = 1<<4;
        #[doc(alias = "NSWindowStyleMaskDocModalWindow")]
        const DocModalWindow = 1<<6;
        #[doc(alias = "NSWindowStyleMaskNonactivatingPanel")]
        const NonactivatingPanel = 1<<7;
        #[doc(alias = "NSWindowStyleMaskHUDWindow")]
        const HUDWindow = 1<<13;
    }
}

unsafe impl Encode for NSWindowStyleMask {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSWindowStyleMask {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmodalresponseok?language=objc)
#[cfg(feature = "NSApplication")]
pub static NSModalResponseOK: NSModalResponse = 1;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmodalresponsecancel?language=objc)
#[cfg(feature = "NSApplication")]
pub static NSModalResponseCancel: NSModalResponse = 0;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdisplaywindowrunloopordering?language=objc)
pub const NSDisplayWindowRunLoopOrdering: c_uint = 600000;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsresetcursorrectsrunloopordering?language=objc)
pub const NSResetCursorRectsRunLoopOrdering: c_uint = 700000;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowsharingtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSWindowSharingType(pub NSUInteger);
impl NSWindowSharingType {
    #[doc(alias = "NSWindowSharingNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "NSWindowSharingReadOnly")]
    pub const ReadOnly: Self = Self(1);
}

unsafe impl Encode for NSWindowSharingType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSWindowSharingType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// You may specify at most one of
/// `NSWindowCollectionBehaviorPrimary,``NSWindowCollectionBehaviorAuxiliary,`or
/// `NSWindowCollectionBehaviorCanJoinAllApplications.`If unspecified, the window gets the default treatment determined by its other collection behaviors.
///
///
///
///
///
///
///
///
/// You may specify at most one of
/// `NSWindowCollectionBehaviorManaged,``NSWindowCollectionBehaviorTransient,`or
/// `NSWindowCollectionBehaviorStationary.`If neither is specified, the window gets the default behavior determined by its window level.
///
///
///
///
///
/// You may specify at most one of
/// `NSWindowCollectionBehaviorParticipatesInCycle`or
/// `NSWindowCollectionBehaviorIgnoresCycle.`If unspecified, the window gets the default behavior determined by its window level.
///
///
///
///
/// You may specify at most one of
/// `NSWindowCollectionBehaviorFullScreenPrimary,``NSWindowCollectionBehaviorFullScreenAuxiliary,`or
/// `NSWindowCollectionBehaviorFullScreenNone.`
///
///
///
///
/// You may specify at most one of
/// `NSWindowCollectionBehaviorFullScreenAllowsTiling`or
/// `NSWindowCollectionBehaviorFullScreenDisallowsTiling,`or an assertion will be raised.
///
/// The default behavior is to allow any window to participate in full screen tiling, as long as it meets certain requirements, such as being resizable and not a panel or sheet. Windows which are not full screen capable can still become a secondary tile in full screen. A window can explicitly allow itself to be placed into a full screen tile by including
/// `NSWindowCollectionBehaviorFullScreenAllowsTiling.`Even if a window allows itself to be placed in a tile, it still may not be put in the tile if its
/// `minFullScreenContentSize`is too large to fit. A window can explicitly disallow itself from being placed in a full screen tile by including
/// `NSWindowCollectionBehaviorFullScreenDisallowsTiling.`This is useful for non-full screen capable windows to explicitly prevent themselves from being tiled. It can also be used by a full screen window to prevent any other windows from being placed in its full screen tile.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowcollectionbehavior?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSWindowCollectionBehavior(pub NSUInteger);
bitflags::bitflags! {
    impl NSWindowCollectionBehavior: NSUInteger {
        #[doc(alias = "NSWindowCollectionBehaviorDefault")]
        const Default = 0;
        #[doc(alias = "NSWindowCollectionBehaviorCanJoinAllSpaces")]
        const CanJoinAllSpaces = 1<<0;
        #[doc(alias = "NSWindowCollectionBehaviorMoveToActiveSpace")]
        const MoveToActiveSpace = 1<<1;
        #[doc(alias = "NSWindowCollectionBehaviorManaged")]
        const Managed = 1<<2;
        #[doc(alias = "NSWindowCollectionBehaviorTransient")]
        const Transient = 1<<3;
        #[doc(alias = "NSWindowCollectionBehaviorStationary")]
        const Stationary = 1<<4;
        #[doc(alias = "NSWindowCollectionBehaviorParticipatesInCycle")]
        const ParticipatesInCycle = 1<<5;
        #[doc(alias = "NSWindowCollectionBehaviorIgnoresCycle")]
        const IgnoresCycle = 1<<6;
        #[doc(alias = "NSWindowCollectionBehaviorFullScreenPrimary")]
        const FullScreenPrimary = 1<<7;
        #[doc(alias = "NSWindowCollectionBehaviorFullScreenAuxiliary")]
        const FullScreenAuxiliary = 1<<8;
        #[doc(alias = "NSWindowCollectionBehaviorFullScreenNone")]
        const FullScreenNone = 1<<9;
        #[doc(alias = "NSWindowCollectionBehaviorFullScreenAllowsTiling")]
        const FullScreenAllowsTiling = 1<<11;
        #[doc(alias = "NSWindowCollectionBehaviorFullScreenDisallowsTiling")]
        const FullScreenDisallowsTiling = 1<<12;
        #[doc(alias = "NSWindowCollectionBehaviorPrimary")]
        const Primary = 1<<16;
        #[doc(alias = "NSWindowCollectionBehaviorAuxiliary")]
        const Auxiliary = 1<<17;
        #[doc(alias = "NSWindowCollectionBehaviorCanJoinAllApplications")]
        const CanJoinAllApplications = 1<<18;
    }
}

unsafe impl Encode for NSWindowCollectionBehavior {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSWindowCollectionBehavior {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowanimationbehavior?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSWindowAnimationBehavior(pub NSInteger);
impl NSWindowAnimationBehavior {
    #[doc(alias = "NSWindowAnimationBehaviorDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "NSWindowAnimationBehaviorNone")]
    pub const None: Self = Self(2);
    #[doc(alias = "NSWindowAnimationBehaviorDocumentWindow")]
    pub const DocumentWindow: Self = Self(3);
    #[doc(alias = "NSWindowAnimationBehaviorUtilityWindow")]
    pub const UtilityWindow: Self = Self(4);
    #[doc(alias = "NSWindowAnimationBehaviorAlertPanel")]
    pub const AlertPanel: Self = Self(5);
}

unsafe impl Encode for NSWindowAnimationBehavior {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSWindowAnimationBehavior {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Options used in `+windowNumbersWithOptions:`.  If no options are specified, the returned list contains window numbers for visible windows on the active space belonging to the calling application.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindownumberlistoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSWindowNumberListOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSWindowNumberListOptions: NSUInteger {
        #[doc(alias = "NSWindowNumberListAllApplications")]
        const AllApplications = 1<<0;
        #[doc(alias = "NSWindowNumberListAllSpaces")]
        const AllSpaces = 1<<4;
    }
}

unsafe impl Encode for NSWindowNumberListOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSWindowNumberListOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowocclusionstate?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSWindowOcclusionState(pub NSUInteger);
bitflags::bitflags! {
    impl NSWindowOcclusionState: NSUInteger {
        #[doc(alias = "NSWindowOcclusionStateVisible")]
        const Visible = 1<<1;
    }
}

unsafe impl Encode for NSWindowOcclusionState {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSWindowOcclusionState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowlevel?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type NSWindowLevel = NSInteger;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsnormalwindowlevel?language=objc)
pub static NSNormalWindowLevel: NSWindowLevel = 0;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfloatingwindowlevel?language=objc)
pub static NSFloatingWindowLevel: NSWindowLevel = 3;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssubmenuwindowlevel?language=objc)
pub static NSSubmenuWindowLevel: NSWindowLevel = 3;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstornoffmenuwindowlevel?language=objc)
pub static NSTornOffMenuWindowLevel: NSWindowLevel = 3;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmainmenuwindowlevel?language=objc)
pub static NSMainMenuWindowLevel: NSWindowLevel = 24;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsstatuswindowlevel?language=objc)
pub static NSStatusWindowLevel: NSWindowLevel = 25;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmodalpanelwindowlevel?language=objc)
pub static NSModalPanelWindowLevel: NSWindowLevel = 8;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspopupmenuwindowlevel?language=objc)
pub static NSPopUpMenuWindowLevel: NSWindowLevel = 101;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsscreensaverwindowlevel?language=objc)
pub static NSScreenSaverWindowLevel: NSWindowLevel = 1000;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsselectiondirection?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSSelectionDirection(pub NSUInteger);
impl NSSelectionDirection {
    #[doc(alias = "NSDirectSelection")]
    pub const DirectSelection: Self = Self(0);
    #[doc(alias = "NSSelectingNext")]
    pub const SelectingNext: Self = Self(1);
    #[doc(alias = "NSSelectingPrevious")]
    pub const SelectingPrevious: Self = Self(2);
}

unsafe impl Encode for NSSelectionDirection {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSSelectionDirection {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Standard window buttons.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowbutton?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSWindowButton(pub NSUInteger);
impl NSWindowButton {
    #[doc(alias = "NSWindowCloseButton")]
    pub const CloseButton: Self = Self(0);
    #[doc(alias = "NSWindowMiniaturizeButton")]
    pub const MiniaturizeButton: Self = Self(1);
    #[doc(alias = "NSWindowZoomButton")]
    pub const ZoomButton: Self = Self(2);
    #[doc(alias = "NSWindowToolbarButton")]
    pub const ToolbarButton: Self = Self(3);
    #[doc(alias = "NSWindowDocumentIconButton")]
    pub const DocumentIconButton: Self = Self(4);
    #[doc(alias = "NSWindowDocumentVersionsButton")]
    pub const DocumentVersionsButton: Self = Self(6);
}

unsafe impl Encode for NSWindowButton {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSWindowButton {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowtitlevisibility?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSWindowTitleVisibility(pub NSInteger);
impl NSWindowTitleVisibility {
    #[doc(alias = "NSWindowTitleVisible")]
    pub const Visible: Self = Self(0);
    #[doc(alias = "NSWindowTitleHidden")]
    pub const Hidden: Self = Self(1);
}

unsafe impl Encode for NSWindowTitleVisibility {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSWindowTitleVisibility {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowtoolbarstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSWindowToolbarStyle(pub NSInteger);
impl NSWindowToolbarStyle {
    #[doc(alias = "NSWindowToolbarStyleAutomatic")]
    pub const Automatic: Self = Self(0);
    #[doc(alias = "NSWindowToolbarStyleExpanded")]
    pub const Expanded: Self = Self(1);
    #[doc(alias = "NSWindowToolbarStylePreference")]
    pub const Preference: Self = Self(2);
    #[doc(alias = "NSWindowToolbarStyleUnified")]
    pub const Unified: Self = Self(3);
    #[doc(alias = "NSWindowToolbarStyleUnifiedCompact")]
    pub const UnifiedCompact: Self = Self(4);
}

unsafe impl Encode for NSWindowToolbarStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSWindowToolbarStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nseventdurationforever?language=objc)
pub static NSEventDurationForever: NSTimeInterval = c_double::MAX as _;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowusertabbingpreference?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSWindowUserTabbingPreference(pub NSInteger);
impl NSWindowUserTabbingPreference {
    #[doc(alias = "NSWindowUserTabbingPreferenceManual")]
    pub const Manual: Self = Self(0);
    #[doc(alias = "NSWindowUserTabbingPreferenceAlways")]
    pub const Always: Self = Self(1);
    #[doc(alias = "NSWindowUserTabbingPreferenceInFullScreen")]
    pub const InFullScreen: Self = Self(2);
}

unsafe impl Encode for NSWindowUserTabbingPreference {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSWindowUserTabbingPreference {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowtabbingmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSWindowTabbingMode(pub NSInteger);
impl NSWindowTabbingMode {
    #[doc(alias = "NSWindowTabbingModeAutomatic")]
    pub const Automatic: Self = Self(0);
    #[doc(alias = "NSWindowTabbingModePreferred")]
    pub const Preferred: Self = Self(1);
    #[doc(alias = "NSWindowTabbingModeDisallowed")]
    pub const Disallowed: Self = Self(2);
}

unsafe impl Encode for NSWindowTabbingMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSWindowTabbingMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstitlebarseparatorstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTitlebarSeparatorStyle(pub NSInteger);
impl NSTitlebarSeparatorStyle {
    #[doc(alias = "NSTitlebarSeparatorStyleAutomatic")]
    pub const Automatic: Self = Self(0);
    #[doc(alias = "NSTitlebarSeparatorStyleNone")]
    pub const None: Self = Self(1);
    #[doc(alias = "NSTitlebarSeparatorStyleLine")]
    pub const Line: Self = Self(2);
    #[doc(alias = "NSTitlebarSeparatorStyleShadow")]
    pub const Shadow: Self = Self(3);
}

unsafe impl Encode for NSTitlebarSeparatorStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSTitlebarSeparatorStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowframeautosavename?language=objc)
pub type NSWindowFrameAutosaveName = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowpersistableframedescriptor?language=objc)
pub type NSWindowPersistableFrameDescriptor = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowtabbingidentifier?language=objc)
pub type NSWindowTabbingIdentifier = NSString;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindow?language=objc)
    #[unsafe(super(NSResponder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "NSResponder")]
    pub struct NSWindow;
);

#[cfg(all(feature = "NSAccessibilityProtocols", feature = "NSResponder"))]
extern_conformance!(
    unsafe impl NSAccessibility for NSWindow {}
);

#[cfg(all(feature = "NSAccessibilityProtocols", feature = "NSResponder"))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSWindow {}
);

#[cfg(all(feature = "NSAnimation", feature = "NSResponder"))]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for NSWindow {}
);

#[cfg(all(feature = "NSAppearance", feature = "NSResponder"))]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for NSWindow {}
);

#[cfg(feature = "NSResponder")]
extern_conformance!(
    unsafe impl NSCoding for NSWindow {}
);

#[cfg(all(feature = "NSMenu", feature = "NSResponder"))]
extern_conformance!(
    unsafe impl NSMenuItemValidation for NSWindow {}
);

#[cfg(feature = "NSResponder")]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSWindow {}
);

#[cfg(all(feature = "NSResponder", feature = "NSUserInterfaceItemIdentification"))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSWindow {}
);

#[cfg(all(feature = "NSResponder", feature = "NSUserInterfaceValidation"))]
extern_conformance!(
    unsafe impl NSUserInterfaceValidations for NSWindow {}
);

#[cfg(feature = "NSResponder")]
impl NSWindow {
    extern_methods!(
        #[unsafe(method(frameRectForContentRect:styleMask:))]
        #[unsafe(method_family = none)]
        pub fn frameRectForContentRect_styleMask(
            c_rect: NSRect,
            style: NSWindowStyleMask,
            mtm: MainThreadMarker,
        ) -> NSRect;

        #[unsafe(method(contentRectForFrameRect:styleMask:))]
        #[unsafe(method_family = none)]
        pub fn contentRectForFrameRect_styleMask(
            f_rect: NSRect,
            style: NSWindowStyleMask,
            mtm: MainThreadMarker,
        ) -> NSRect;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(minFrameWidthWithTitle:styleMask:))]
        #[unsafe(method_family = none)]
        pub fn minFrameWidthWithTitle_styleMask(
            title: &NSString,
            style: NSWindowStyleMask,
            mtm: MainThreadMarker,
        ) -> CGFloat;

        #[cfg(feature = "NSGraphics")]
        #[unsafe(method(defaultDepthLimit))]
        #[unsafe(method_family = none)]
        pub fn defaultDepthLimit(mtm: MainThreadMarker) -> NSWindowDepth;

        #[unsafe(method(frameRectForContentRect:))]
        #[unsafe(method_family = none)]
        pub fn frameRectForContentRect(&self, content_rect: NSRect) -> NSRect;

        #[unsafe(method(contentRectForFrameRect:))]
        #[unsafe(method_family = none)]
        pub fn contentRectForFrameRect(&self, frame_rect: NSRect) -> NSRect;

        #[cfg(feature = "NSGraphics")]
        #[unsafe(method(initWithContentRect:styleMask:backing:defer:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentRect_styleMask_backing_defer(
            this: Allocated<Self>,
            content_rect: NSRect,
            style: NSWindowStyleMask,
            backing_store_type: NSBackingStoreType,
            flag: bool,
        ) -> Retained<Self>;

        #[cfg(all(feature = "NSGraphics", feature = "NSScreen"))]
        #[unsafe(method(initWithContentRect:styleMask:backing:defer:screen:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentRect_styleMask_backing_defer_screen(
            this: Allocated<Self>,
            content_rect: NSRect,
            style: NSWindowStyleMask,
            backing_store_type: NSBackingStoreType,
            flag: bool,
            screen: Option<&NSScreen>,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, coder: &NSCoder) -> Retained<Self>;

        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub fn title(&self) -> Retained<NSString>;

        /// Setter for [`title`][Self::title].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTitle:))]
        #[unsafe(method_family = none)]
        pub fn setTitle(&self, title: &NSString);

        /// Secondary text that may be displayed adjacent to or below the primary title depending on the configuration of the window.
        /// A value of empty string will remove the subtitle from the window layout.
        #[unsafe(method(subtitle))]
        #[unsafe(method_family = none)]
        pub fn subtitle(&self) -> Retained<NSString>;

        /// Setter for [`subtitle`][Self::subtitle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSubtitle:))]
        #[unsafe(method_family = none)]
        pub fn setSubtitle(&self, subtitle: &NSString);

        /// See the enum values for how this property works.
        #[unsafe(method(titleVisibility))]
        #[unsafe(method_family = none)]
        pub fn titleVisibility(&self) -> NSWindowTitleVisibility;

        /// Setter for [`titleVisibility`][Self::titleVisibility].
        #[unsafe(method(setTitleVisibility:))]
        #[unsafe(method_family = none)]
        pub fn setTitleVisibility(&self, title_visibility: NSWindowTitleVisibility);

        /// When
        /// `YES,`the titlebar doesn't draw its background, allowing all buttons to show through, and "click through" to happen. In general, this is only useful when
        /// `NSFullSizeContentViewWindowMask`is set.
        #[unsafe(method(titlebarAppearsTransparent))]
        #[unsafe(method_family = none)]
        pub fn titlebarAppearsTransparent(&self) -> bool;

        /// Setter for [`titlebarAppearsTransparent`][Self::titlebarAppearsTransparent].
        #[unsafe(method(setTitlebarAppearsTransparent:))]
        #[unsafe(method_family = none)]
        pub fn setTitlebarAppearsTransparent(&self, titlebar_appears_transparent: bool);

        /// Specifies how the titlebar area of the window should appear when the window displays an NSToolbar
        #[unsafe(method(toolbarStyle))]
        #[unsafe(method_family = none)]
        pub fn toolbarStyle(&self) -> NSWindowToolbarStyle;

        /// Setter for [`toolbarStyle`][Self::toolbarStyle].
        #[unsafe(method(setToolbarStyle:))]
        #[unsafe(method_family = none)]
        pub fn setToolbarStyle(&self, toolbar_style: NSWindowToolbarStyle);

        /// The
        /// `contentLayoutRect`will return the area inside the window that is for non-obscured content. Typically, this is the same thing as the `contentView`'s frame. However, for windows with the
        /// `NSFullSizeContentViewWindowMask`set, there needs to be a way to determine the portion that is not under the toolbar. The
        /// `contentLayoutRect`returns the portion of the layout that is not obscured under the toolbar.
        /// `contentLayoutRect`is in window coordinates. It is KVO compliant. */
        #[unsafe(method(contentLayoutRect))]
        #[unsafe(method_family = none)]
        pub fn contentLayoutRect(&self) -> NSRect;

        /// `contentLayoutGuide`is a corollary to
        /// `contentLayoutRect.`It can be used by autolayout constraints to automatically bind to the
        /// `contentLayoutRect.`
        #[unsafe(method(contentLayoutGuide))]
        #[unsafe(method_family = none)]
        pub fn contentLayoutGuide(&self) -> Option<Retained<AnyObject>>;

        #[cfg(all(
            feature = "NSTitlebarAccessoryViewController",
            feature = "NSViewController"
        ))]
        #[unsafe(method(titlebarAccessoryViewControllers))]
        #[unsafe(method_family = none)]
        pub fn titlebarAccessoryViewControllers(
            &self,
        ) -> Retained<NSArray<NSTitlebarAccessoryViewController>>;

        #[cfg(all(
            feature = "NSTitlebarAccessoryViewController",
            feature = "NSViewController"
        ))]
        /// Setter for [`titlebarAccessoryViewControllers`][Self::titlebarAccessoryViewControllers].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTitlebarAccessoryViewControllers:))]
        #[unsafe(method_family = none)]
        pub fn setTitlebarAccessoryViewControllers(
            &self,
            titlebar_accessory_view_controllers: &NSArray<NSTitlebarAccessoryViewController>,
        );

        #[cfg(all(
            feature = "NSTitlebarAccessoryViewController",
            feature = "NSViewController"
        ))]
        #[unsafe(method(addTitlebarAccessoryViewController:))]
        #[unsafe(method_family = none)]
        pub fn addTitlebarAccessoryViewController(
            &self,
            child_view_controller: &NSTitlebarAccessoryViewController,
        );

        #[cfg(all(
            feature = "NSTitlebarAccessoryViewController",
            feature = "NSViewController"
        ))]
        #[unsafe(method(insertTitlebarAccessoryViewController:atIndex:))]
        #[unsafe(method_family = none)]
        pub fn insertTitlebarAccessoryViewController_atIndex(
            &self,
            child_view_controller: &NSTitlebarAccessoryViewController,
            index: NSInteger,
        );

        #[unsafe(method(removeTitlebarAccessoryViewControllerAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn removeTitlebarAccessoryViewControllerAtIndex(&self, index: NSInteger);

        /// If url is not nil and its path is not empty, the window will show a document icon in the titlebar.
        /// If the url represents a filename or other resource with a known icon, that icon will be used as the document icon.  Otherwise the default document icon will be used.  The icon can be customized using `-[[NSWindow standardWindowButton:NSWindowDocumentIconButton] setImage:customImage]`.  If url is not nil and its path is not empty, the window will have a pop-up menu which can be shown via command-click on the area containing the document icon and title.  By default, this menu will display the path components of the url.  The presence and contents of this menu can be controlled by the delegate method `-[window:shouldPopUpDocumentPathMenu:]`
        /// If the url is nil or has an empty path, the window will not show a document icon and will not have a pop-up menu available via command-click.
        #[unsafe(method(representedURL))]
        #[unsafe(method_family = none)]
        pub fn representedURL(&self) -> Option<Retained<NSURL>>;

        /// Setter for [`representedURL`][Self::representedURL].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setRepresentedURL:))]
        #[unsafe(method_family = none)]
        pub fn setRepresentedURL(&self, represented_url: Option<&NSURL>);

        #[unsafe(method(representedFilename))]
        #[unsafe(method_family = none)]
        pub fn representedFilename(&self) -> Retained<NSString>;

        /// Setter for [`representedFilename`][Self::representedFilename].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setRepresentedFilename:))]
        #[unsafe(method_family = none)]
        pub fn setRepresentedFilename(&self, represented_filename: &NSString);

        #[unsafe(method(setTitleWithRepresentedFilename:))]
        #[unsafe(method_family = none)]
        pub fn setTitleWithRepresentedFilename(&self, filename: &NSString);

        #[unsafe(method(isExcludedFromWindowsMenu))]
        #[unsafe(method_family = none)]
        pub fn isExcludedFromWindowsMenu(&self) -> bool;

        /// Setter for [`isExcludedFromWindowsMenu`][Self::isExcludedFromWindowsMenu].
        #[unsafe(method(setExcludedFromWindowsMenu:))]
        #[unsafe(method_family = none)]
        pub fn setExcludedFromWindowsMenu(&self, excluded_from_windows_menu: bool);

        #[cfg(feature = "NSView")]
        #[unsafe(method(contentView))]
        #[unsafe(method_family = none)]
        pub fn contentView(&self) -> Option<Retained<NSView>>;

        #[cfg(feature = "NSView")]
        /// Setter for [`contentView`][Self::contentView].
        #[unsafe(method(setContentView:))]
        #[unsafe(method_family = none)]
        pub fn setContentView(&self, content_view: Option<&NSView>);

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSWindowDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub fn setDelegate(&self, delegate: Option<&ProtocolObject<dyn NSWindowDelegate>>);

        #[unsafe(method(windowNumber))]
        #[unsafe(method_family = none)]
        pub fn windowNumber(&self) -> NSInteger;

        /// Note: The styleMask can only be set on macOS 10.6 and later. Valid
        /// `styleMask`settings have the same restrictions as the
        /// `styleMask`passed to `-initWithContentRect:styleMask:backing:defer:`.  Some
        /// `styleMask`changes will cause the view hierarchy to be rebuilt, since there is a different subclass for the top level view of a borderless window than for the top level view of a titled window.
        #[unsafe(method(styleMask))]
        #[unsafe(method_family = none)]
        pub fn styleMask(&self) -> NSWindowStyleMask;

        /// Setter for [`styleMask`][Self::styleMask].
        #[unsafe(method(setStyleMask:))]
        #[unsafe(method_family = none)]
        pub fn setStyleMask(&self, style_mask: NSWindowStyleMask);

        #[cfg(all(feature = "NSText", feature = "NSView"))]
        /// # Safety
        ///
        /// `object` should be of the correct type.
        #[unsafe(method(fieldEditor:forObject:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fieldEditor_forObject(
            &self,
            create_flag: bool,
            object: Option<&AnyObject>,
        ) -> Option<Retained<NSText>>;

        /// # Safety
        ///
        /// `object` should be of the correct type.
        #[unsafe(method(endEditingFor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn endEditingFor(&self, object: Option<&AnyObject>);

        #[cfg(feature = "NSScreen")]
        #[unsafe(method(constrainFrameRect:toScreen:))]
        #[unsafe(method_family = none)]
        pub fn constrainFrameRect_toScreen(
            &self,
            frame_rect: NSRect,
            screen: Option<&NSScreen>,
        ) -> NSRect;

        #[unsafe(method(setFrame:display:))]
        #[unsafe(method_family = none)]
        pub fn setFrame_display(&self, frame_rect: NSRect, flag: bool);

        #[unsafe(method(setContentSize:))]
        #[unsafe(method_family = none)]
        pub fn setContentSize(&self, size: NSSize);

        #[unsafe(method(setFrameOrigin:))]
        #[unsafe(method_family = none)]
        pub fn setFrameOrigin(&self, point: NSPoint);

        #[unsafe(method(setFrameTopLeftPoint:))]
        #[unsafe(method_family = none)]
        pub fn setFrameTopLeftPoint(&self, point: NSPoint);

        #[unsafe(method(cascadeTopLeftFromPoint:))]
        #[unsafe(method_family = none)]
        pub fn cascadeTopLeftFromPoint(&self, top_left_point: NSPoint) -> NSPoint;

        /// The frame to use when cascading or sizing a new window based on the receiver's position or size. This may be different from `frame` when the receiver is positioned by the system.
        #[unsafe(method(cascadingReferenceFrame))]
        #[unsafe(method_family = none)]
        pub fn cascadingReferenceFrame(&self) -> NSRect;

        #[unsafe(method(frame))]
        #[unsafe(method_family = none)]
        pub fn frame(&self) -> NSRect;

        /// Subclasses can override
        /// `animationResizeTime:`to control the total time for the frame change.
        /// `newFrame`is the rect passed into
        /// `setFrame:display:animate:`
        #[unsafe(method(animationResizeTime:))]
        #[unsafe(method_family = none)]
        pub fn animationResizeTime(&self, new_frame: NSRect) -> NSTimeInterval;

        /// `setFrame:display:animate:`is equivalent to
        /// `setFrame:display:`if the
        /// `animateFlag`is NO.
        /// If the
        /// `animationFlag`is YES, this method will perform a smooth resize of the window, where the total time for the resize is specified by
        /// `-animationResizeTime:`
        #[unsafe(method(setFrame:display:animate:))]
        #[unsafe(method_family = none)]
        pub fn setFrame_display_animate(
            &self,
            frame_rect: NSRect,
            display_flag: bool,
            animate_flag: bool,
        );

        #[unsafe(method(inLiveResize))]
        #[unsafe(method_family = none)]
        pub fn inLiveResize(&self) -> bool;

        #[unsafe(method(resizeIncrements))]
        #[unsafe(method_family = none)]
        pub fn resizeIncrements(&self) -> NSSize;

        /// Setter for [`resizeIncrements`][Self::resizeIncrements].
        #[unsafe(method(setResizeIncrements:))]
        #[unsafe(method_family = none)]
        pub fn setResizeIncrements(&self, resize_increments: NSSize);

        #[unsafe(method(aspectRatio))]
        #[unsafe(method_family = none)]
        pub fn aspectRatio(&self) -> NSSize;

        /// Setter for [`aspectRatio`][Self::aspectRatio].
        #[unsafe(method(setAspectRatio:))]
        #[unsafe(method_family = none)]
        pub fn setAspectRatio(&self, aspect_ratio: NSSize);

        #[unsafe(method(contentResizeIncrements))]
        #[unsafe(method_family = none)]
        pub fn contentResizeIncrements(&self) -> NSSize;

        /// Setter for [`contentResizeIncrements`][Self::contentResizeIncrements].
        #[unsafe(method(setContentResizeIncrements:))]
        #[unsafe(method_family = none)]
        pub fn setContentResizeIncrements(&self, content_resize_increments: NSSize);

        #[unsafe(method(contentAspectRatio))]
        #[unsafe(method_family = none)]
        pub fn contentAspectRatio(&self) -> NSSize;

        /// Setter for [`contentAspectRatio`][Self::contentAspectRatio].
        #[unsafe(method(setContentAspectRatio:))]
        #[unsafe(method_family = none)]
        pub fn setContentAspectRatio(&self, content_aspect_ratio: NSSize);

        #[unsafe(method(viewsNeedDisplay))]
        #[unsafe(method_family = none)]
        pub fn viewsNeedDisplay(&self) -> bool;

        /// Setter for [`viewsNeedDisplay`][Self::viewsNeedDisplay].
        #[unsafe(method(setViewsNeedDisplay:))]
        #[unsafe(method_family = none)]
        pub fn setViewsNeedDisplay(&self, views_need_display: bool);

        #[unsafe(method(displayIfNeeded))]
        #[unsafe(method_family = none)]
        pub fn displayIfNeeded(&self);

        #[unsafe(method(display))]
        #[unsafe(method_family = none)]
        pub fn display(&self);

        #[unsafe(method(preservesContentDuringLiveResize))]
        #[unsafe(method_family = none)]
        pub fn preservesContentDuringLiveResize(&self) -> bool;

        /// Setter for [`preservesContentDuringLiveResize`][Self::preservesContentDuringLiveResize].
        #[unsafe(method(setPreservesContentDuringLiveResize:))]
        #[unsafe(method_family = none)]
        pub fn setPreservesContentDuringLiveResize(
            &self,
            preserves_content_during_live_resize: bool,
        );

        #[unsafe(method(update))]
        #[unsafe(method_family = none)]
        pub fn update(&self);

        #[unsafe(method(makeFirstResponder:))]
        #[unsafe(method_family = none)]
        pub fn makeFirstResponder(&self, responder: Option<&NSResponder>) -> bool;

        #[unsafe(method(firstResponder))]
        #[unsafe(method_family = none)]
        pub fn firstResponder(&self) -> Option<Retained<NSResponder>>;

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(resizeFlags))]
        #[unsafe(method_family = none)]
        pub fn resizeFlags(&self) -> NSEventModifierFlags;

        #[unsafe(method(close))]
        #[unsafe(method_family = none)]
        pub fn close(&self);

        #[unsafe(method(isReleasedWhenClosed))]
        #[unsafe(method_family = none)]
        pub fn isReleasedWhenClosed(&self) -> bool;

        /// Setter for [`isReleasedWhenClosed`][Self::isReleasedWhenClosed].
        #[unsafe(method(setReleasedWhenClosed:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setReleasedWhenClosed(&self, released_when_closed: bool);

        #[unsafe(method(miniaturize:))]
        #[unsafe(method_family = none)]
        pub fn miniaturize(&self, sender: Option<&AnyObject>);

        #[unsafe(method(deminiaturize:))]
        #[unsafe(method_family = none)]
        pub fn deminiaturize(&self, sender: Option<&AnyObject>);

        #[unsafe(method(isZoomed))]
        #[unsafe(method_family = none)]
        pub fn isZoomed(&self) -> bool;

        #[unsafe(method(zoom:))]
        #[unsafe(method_family = none)]
        pub fn zoom(&self, sender: Option<&AnyObject>);

        #[unsafe(method(isMiniaturized))]
        #[unsafe(method_family = none)]
        pub fn isMiniaturized(&self) -> bool;

        /// # Safety
        ///
        /// - `action` must be a valid selector.
        /// - `object` should be of the correct type.
        #[unsafe(method(tryToPerform:with:))]
        #[unsafe(method_family = none)]
        pub unsafe fn tryToPerform_with(&self, action: Sel, object: Option<&AnyObject>) -> bool;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(validRequestorForSendType:returnType:))]
        #[unsafe(method_family = none)]
        pub fn validRequestorForSendType_returnType(
            &self,
            send_type: Option<&NSPasteboardType>,
            return_type: Option<&NSPasteboardType>,
        ) -> Option<Retained<AnyObject>>;

        #[cfg(feature = "NSColor")]
        #[unsafe(method(backgroundColor))]
        #[unsafe(method_family = none)]
        pub fn backgroundColor(&self) -> Retained<NSColor>;

        #[cfg(feature = "NSColor")]
        /// Setter for [`backgroundColor`][Self::backgroundColor].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundColor(&self, background_color: Option<&NSColor>);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(setContentBorderThickness:forEdge:))]
        #[unsafe(method_family = none)]
        pub fn setContentBorderThickness_forEdge(&self, thickness: CGFloat, edge: NSRectEdge);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(contentBorderThicknessForEdge:))]
        #[unsafe(method_family = none)]
        pub fn contentBorderThicknessForEdge(&self, edge: NSRectEdge) -> CGFloat;

        #[unsafe(method(setAutorecalculatesContentBorderThickness:forEdge:))]
        #[unsafe(method_family = none)]
        pub fn setAutorecalculatesContentBorderThickness_forEdge(
            &self,
            flag: bool,
            edge: NSRectEdge,
        );

        #[unsafe(method(autorecalculatesContentBorderThicknessForEdge:))]
        #[unsafe(method_family = none)]
        pub fn autorecalculatesContentBorderThicknessForEdge(&self, edge: NSRectEdge) -> bool;

        #[unsafe(method(isMovable))]
        #[unsafe(method_family = none)]
        pub fn isMovable(&self) -> bool;

        /// Setter for [`isMovable`][Self::isMovable].
        #[unsafe(method(setMovable:))]
        #[unsafe(method_family = none)]
        pub fn setMovable(&self, movable: bool);

        #[unsafe(method(isMovableByWindowBackground))]
        #[unsafe(method_family = none)]
        pub fn isMovableByWindowBackground(&self) -> bool;

        /// Setter for [`isMovableByWindowBackground`][Self::isMovableByWindowBackground].
        #[unsafe(method(setMovableByWindowBackground:))]
        #[unsafe(method_family = none)]
        pub fn setMovableByWindowBackground(&self, movable_by_window_background: bool);

        #[unsafe(method(hidesOnDeactivate))]
        #[unsafe(method_family = none)]
        pub fn hidesOnDeactivate(&self) -> bool;

        /// Setter for [`hidesOnDeactivate`][Self::hidesOnDeactivate].
        #[unsafe(method(setHidesOnDeactivate:))]
        #[unsafe(method_family = none)]
        pub fn setHidesOnDeactivate(&self, hides_on_deactivate: bool);

        /// Indicates whether a window can be hidden during `-[NSApplication hide:]`.  Default is
        /// `YES.`
        #[unsafe(method(canHide))]
        #[unsafe(method_family = none)]
        pub fn canHide(&self) -> bool;

        /// Setter for [`canHide`][Self::canHide].
        #[unsafe(method(setCanHide:))]
        #[unsafe(method_family = none)]
        pub fn setCanHide(&self, can_hide: bool);

        #[unsafe(method(center))]
        #[unsafe(method_family = none)]
        pub fn center(&self);

        #[unsafe(method(makeKeyAndOrderFront:))]
        #[unsafe(method_family = none)]
        pub fn makeKeyAndOrderFront(&self, sender: Option<&AnyObject>);

        #[unsafe(method(orderFront:))]
        #[unsafe(method_family = none)]
        pub fn orderFront(&self, sender: Option<&AnyObject>);

        #[unsafe(method(orderBack:))]
        #[unsafe(method_family = none)]
        pub fn orderBack(&self, sender: Option<&AnyObject>);

        #[unsafe(method(orderOut:))]
        #[unsafe(method_family = none)]
        pub fn orderOut(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "NSGraphics")]
        #[unsafe(method(orderWindow:relativeTo:))]
        #[unsafe(method_family = none)]
        pub fn orderWindow_relativeTo(&self, place: NSWindowOrderingMode, other_win: NSInteger);

        #[unsafe(method(orderFrontRegardless))]
        #[unsafe(method_family = none)]
        pub fn orderFrontRegardless(&self);

        #[cfg(feature = "NSImage")]
        #[unsafe(method(miniwindowImage))]
        #[unsafe(method_family = none)]
        pub fn miniwindowImage(&self) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSImage")]
        /// Setter for [`miniwindowImage`][Self::miniwindowImage].
        #[unsafe(method(setMiniwindowImage:))]
        #[unsafe(method_family = none)]
        pub fn setMiniwindowImage(&self, miniwindow_image: Option<&NSImage>);

        #[unsafe(method(miniwindowTitle))]
        #[unsafe(method_family = none)]
        pub fn miniwindowTitle(&self) -> Retained<NSString>;

        /// Setter for [`miniwindowTitle`][Self::miniwindowTitle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setMiniwindowTitle:))]
        #[unsafe(method_family = none)]
        pub fn setMiniwindowTitle(&self, miniwindow_title: Option<&NSString>);

        #[cfg(feature = "NSDockTile")]
        #[unsafe(method(dockTile))]
        #[unsafe(method_family = none)]
        pub fn dockTile(&self) -> Retained<NSDockTile>;

        #[unsafe(method(isDocumentEdited))]
        #[unsafe(method_family = none)]
        pub fn isDocumentEdited(&self) -> bool;

        /// Setter for [`isDocumentEdited`][Self::isDocumentEdited].
        #[unsafe(method(setDocumentEdited:))]
        #[unsafe(method_family = none)]
        pub fn setDocumentEdited(&self, document_edited: bool);

        #[unsafe(method(isVisible))]
        #[unsafe(method_family = none)]
        pub fn isVisible(&self) -> bool;

        #[unsafe(method(isKeyWindow))]
        #[unsafe(method_family = none)]
        pub fn isKeyWindow(&self) -> bool;

        #[unsafe(method(isMainWindow))]
        #[unsafe(method_family = none)]
        pub fn isMainWindow(&self) -> bool;

        #[unsafe(method(canBecomeKeyWindow))]
        #[unsafe(method_family = none)]
        pub fn canBecomeKeyWindow(&self) -> bool;

        #[unsafe(method(canBecomeMainWindow))]
        #[unsafe(method_family = none)]
        pub fn canBecomeMainWindow(&self) -> bool;

        /// Makes the window key and main if eligible, updating NSApplication's `-keyWindow` and `-mainWindow` properties.
        #[unsafe(method(makeKeyWindow))]
        #[unsafe(method_family = none)]
        pub fn makeKeyWindow(&self);

        /// Makes the window main if eligible. Updates NSApplication's `-mainWindow` property.
        #[unsafe(method(makeMainWindow))]
        #[unsafe(method_family = none)]
        pub fn makeMainWindow(&self);

        /// Informs the window that it has become the key window. This method exists as an override point. Do not invoke directly. Instead, invoke `-makeKeyWindow`.
        #[unsafe(method(becomeKeyWindow))]
        #[unsafe(method_family = none)]
        pub fn becomeKeyWindow(&self);

        /// Informs the window that it has stopped being the key window. This method exists as an override point. Do not invoke directly. Windows automatically receive this message when deactivating or when another window has become key.
        #[unsafe(method(resignKeyWindow))]
        #[unsafe(method_family = none)]
        pub fn resignKeyWindow(&self);

        /// Informs the window that it has become the main window. This method exists as an override point. Do not invoke directly. Instead, invoke `-makeMainWindow`.
        #[unsafe(method(becomeMainWindow))]
        #[unsafe(method_family = none)]
        pub fn becomeMainWindow(&self);

        /// Informs the window that it has stopped being the main window. This method exists as an override point. Do not invoke directly. Windows automatically receive this message when deactivating or when another window has become main.
        #[unsafe(method(resignMainWindow))]
        #[unsafe(method_family = none)]
        pub fn resignMainWindow(&self);

        #[unsafe(method(worksWhenModal))]
        #[unsafe(method_family = none)]
        pub fn worksWhenModal(&self) -> bool;

        /// A Boolean value that indicates whether or not to prevent application termination when the receiving window is presented modally.
        /// The value of this property is `YES` if the window should prevent application termination when modal; otherwise, `NO`.
        /// The default value is `YES`. However, note that some window subclasses and some windows created indirectly (like those created by UI frameworks like AppKit and SwiftUI), may have different default values. For example, the Open panel and toolbar customization sheets should not prevent application termination, so those windows have `preventsApplicationTerminationWhenModal` set to `NO`. Some `NSAlert`s, like those that are simply informational, have windows that do not prevent application termination by default. Setting this property overrides the default behavior.
        #[unsafe(method(preventsApplicationTerminationWhenModal))]
        #[unsafe(method_family = none)]
        pub fn preventsApplicationTerminationWhenModal(&self) -> bool;

        /// Setter for [`preventsApplicationTerminationWhenModal`][Self::preventsApplicationTerminationWhenModal].
        #[unsafe(method(setPreventsApplicationTerminationWhenModal:))]
        #[unsafe(method_family = none)]
        pub fn setPreventsApplicationTerminationWhenModal(
            &self,
            prevents_application_termination_when_modal: bool,
        );

        #[unsafe(method(convertRectToScreen:))]
        #[unsafe(method_family = none)]
        pub fn convertRectToScreen(&self, rect: NSRect) -> NSRect;

        #[unsafe(method(convertRectFromScreen:))]
        #[unsafe(method_family = none)]
        pub fn convertRectFromScreen(&self, rect: NSRect) -> NSRect;

        #[unsafe(method(convertPointToScreen:))]
        #[unsafe(method_family = none)]
        pub fn convertPointToScreen(&self, point: NSPoint) -> NSPoint;

        #[unsafe(method(convertPointFromScreen:))]
        #[unsafe(method_family = none)]
        pub fn convertPointFromScreen(&self, point: NSPoint) -> NSPoint;

        #[unsafe(method(convertRectToBacking:))]
        #[unsafe(method_family = none)]
        pub fn convertRectToBacking(&self, rect: NSRect) -> NSRect;

        #[unsafe(method(convertRectFromBacking:))]
        #[unsafe(method_family = none)]
        pub fn convertRectFromBacking(&self, rect: NSRect) -> NSRect;

        #[unsafe(method(convertPointToBacking:))]
        #[unsafe(method_family = none)]
        pub fn convertPointToBacking(&self, point: NSPoint) -> NSPoint;

        #[unsafe(method(convertPointFromBacking:))]
        #[unsafe(method_family = none)]
        pub fn convertPointFromBacking(&self, point: NSPoint) -> NSPoint;

        /// Use `NSIntegralRectWithOptions()` to produce a backing store pixel aligned rectangle from the given input rectangle in window coordinates.
        #[unsafe(method(backingAlignedRect:options:))]
        #[unsafe(method_family = none)]
        pub fn backingAlignedRect_options(
            &self,
            rect: NSRect,
            options: NSAlignmentOptions,
        ) -> NSRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// Returns the scale factor representing the number of backing store pixels corresponding to each linear unit in window space on this
        /// `NSWindow.`This method is provided for rare cases when the explicit scale factor is needed. Please use `-convert*ToBacking:` methods whenever possible.
        #[unsafe(method(backingScaleFactor))]
        #[unsafe(method_family = none)]
        pub fn backingScaleFactor(&self) -> CGFloat;

        #[unsafe(method(performClose:))]
        #[unsafe(method_family = none)]
        pub fn performClose(&self, sender: Option<&AnyObject>);

        #[unsafe(method(performMiniaturize:))]
        #[unsafe(method_family = none)]
        pub fn performMiniaturize(&self, sender: Option<&AnyObject>);

        #[unsafe(method(performZoom:))]
        #[unsafe(method_family = none)]
        pub fn performZoom(&self, sender: Option<&AnyObject>);

        #[unsafe(method(dataWithEPSInsideRect:))]
        #[unsafe(method_family = none)]
        pub fn dataWithEPSInsideRect(&self, rect: NSRect) -> Retained<NSData>;

        #[unsafe(method(dataWithPDFInsideRect:))]
        #[unsafe(method_family = none)]
        pub fn dataWithPDFInsideRect(&self, rect: NSRect) -> Retained<NSData>;

        #[unsafe(method(print:))]
        #[unsafe(method_family = none)]
        pub fn print(&self, sender: Option<&AnyObject>);

        /// Default is
        /// `NO.`Set to
        /// `YES`to allow a window to display tooltips even when the application is in the background.  Note that, enabling tooltips in an inactive application will cause the app to do work any time the mouse passes over the window.  This can degrade system performance.
        /// Returns
        /// `YES`if this window displays tooltips even when the application is in the background.  To configure this setting you should call `-setAllowsToolTipsWhenApplicationIsInactive:` instead of overriding `-allowsToolTipsWhenApplicationIsInactive`.
        #[unsafe(method(allowsToolTipsWhenApplicationIsInactive))]
        #[unsafe(method_family = none)]
        pub fn allowsToolTipsWhenApplicationIsInactive(&self) -> bool;

        /// Setter for [`allowsToolTipsWhenApplicationIsInactive`][Self::allowsToolTipsWhenApplicationIsInactive].
        #[unsafe(method(setAllowsToolTipsWhenApplicationIsInactive:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsToolTipsWhenApplicationIsInactive(
            &self,
            allows_tool_tips_when_application_is_inactive: bool,
        );

        #[cfg(feature = "NSGraphics")]
        #[unsafe(method(backingType))]
        #[unsafe(method_family = none)]
        pub fn backingType(&self) -> NSBackingStoreType;

        #[cfg(feature = "NSGraphics")]
        /// Setter for [`backingType`][Self::backingType].
        #[unsafe(method(setBackingType:))]
        #[unsafe(method_family = none)]
        pub fn setBackingType(&self, backing_type: NSBackingStoreType);

        #[unsafe(method(level))]
        #[unsafe(method_family = none)]
        pub fn level(&self) -> NSWindowLevel;

        /// Setter for [`level`][Self::level].
        #[unsafe(method(setLevel:))]
        #[unsafe(method_family = none)]
        pub fn setLevel(&self, level: NSWindowLevel);

        #[cfg(feature = "NSGraphics")]
        #[unsafe(method(depthLimit))]
        #[unsafe(method_family = none)]
        pub fn depthLimit(&self) -> NSWindowDepth;

        #[cfg(feature = "NSGraphics")]
        /// Setter for [`depthLimit`][Self::depthLimit].
        #[unsafe(method(setDepthLimit:))]
        #[unsafe(method_family = none)]
        pub fn setDepthLimit(&self, depth_limit: NSWindowDepth);

        #[unsafe(method(setDynamicDepthLimit:))]
        #[unsafe(method_family = none)]
        pub fn setDynamicDepthLimit(&self, flag: bool);

        #[unsafe(method(hasDynamicDepthLimit))]
        #[unsafe(method_family = none)]
        pub fn hasDynamicDepthLimit(&self) -> bool;

        #[cfg(feature = "NSScreen")]
        /// The screen property returns the best screen for the window. If the window only intersects one screen, it returns that screen. If it intersects more than one screen, then it resolves the tie through based on what space it is mostly on. It may return nil if there are no available screens, or it is completely off screen.
        #[unsafe(method(screen))]
        #[unsafe(method_family = none)]
        pub fn screen(&self) -> Option<Retained<NSScreen>>;

        #[cfg(feature = "NSScreen")]
        #[unsafe(method(deepestScreen))]
        #[unsafe(method_family = none)]
        pub fn deepestScreen(&self) -> Option<Retained<NSScreen>>;

        #[unsafe(method(hasShadow))]
        #[unsafe(method_family = none)]
        pub fn hasShadow(&self) -> bool;

        /// Setter for [`hasShadow`][Self::hasShadow].
        #[unsafe(method(setHasShadow:))]
        #[unsafe(method_family = none)]
        pub fn setHasShadow(&self, has_shadow: bool);

        #[unsafe(method(invalidateShadow))]
        #[unsafe(method_family = none)]
        pub fn invalidateShadow(&self);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(alphaValue))]
        #[unsafe(method_family = none)]
        pub fn alphaValue(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`alphaValue`][Self::alphaValue].
        #[unsafe(method(setAlphaValue:))]
        #[unsafe(method_family = none)]
        pub fn setAlphaValue(&self, alpha_value: CGFloat);

        #[unsafe(method(isOpaque))]
        #[unsafe(method_family = none)]
        pub fn isOpaque(&self) -> bool;

        /// Setter for [`isOpaque`][Self::isOpaque].
        #[unsafe(method(setOpaque:))]
        #[unsafe(method_family = none)]
        pub fn setOpaque(&self, opaque: bool);

        /// `-setSharingType:` specifies whether the window content can be read from another process.  The default sharing type is
        /// `NSWindowSharingReadOnly,`which means other processes can read the window content (eg. for window capture) but cannot modify it.  If you set your window sharing type to
        /// `NSWindowSharingNone,`so that the content cannot be captured, your window will also not be able to participate in a number of system services, so this setting should be used with caution.
        #[unsafe(method(sharingType))]
        #[unsafe(method_family = none)]
        pub fn sharingType(&self) -> NSWindowSharingType;

        /// Setter for [`sharingType`][Self::sharingType].
        #[unsafe(method(setSharingType:))]
        #[unsafe(method_family = none)]
        pub fn setSharingType(&self, sharing_type: NSWindowSharingType);

        /// Controls whether threading of view drawing should be enabled for this window.  Defaults to
        /// `YES.`When this is set to
        /// `YES,`AppKit's view system is allowed to perform `-drawRect:` activity for the window's views on threads other than the main thread, for views that have `canDrawConcurrently == YES`.  When this is set to
        /// `NO,`the window's views will be drawn serially as on 10.5 and earlier, even though some of the views may have `canDrawConcurrently == YES`.
        #[unsafe(method(allowsConcurrentViewDrawing))]
        #[unsafe(method_family = none)]
        pub fn allowsConcurrentViewDrawing(&self) -> bool;

        /// Setter for [`allowsConcurrentViewDrawing`][Self::allowsConcurrentViewDrawing].
        #[unsafe(method(setAllowsConcurrentViewDrawing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsConcurrentViewDrawing(&self, allows_concurrent_view_drawing: bool);

        #[unsafe(method(displaysWhenScreenProfileChanges))]
        #[unsafe(method_family = none)]
        pub fn displaysWhenScreenProfileChanges(&self) -> bool;

        /// Setter for [`displaysWhenScreenProfileChanges`][Self::displaysWhenScreenProfileChanges].
        #[unsafe(method(setDisplaysWhenScreenProfileChanges:))]
        #[unsafe(method_family = none)]
        pub fn setDisplaysWhenScreenProfileChanges(
            &self,
            displays_when_screen_profile_changes: bool,
        );

        /// This API controls whether the receiver is permitted onscreen before the user has logged in.  This property is off by default.  Alert panels and windows presented by input managers are examples of windows which should have this property set.
        #[unsafe(method(canBecomeVisibleWithoutLogin))]
        #[unsafe(method_family = none)]
        pub fn canBecomeVisibleWithoutLogin(&self) -> bool;

        /// Setter for [`canBecomeVisibleWithoutLogin`][Self::canBecomeVisibleWithoutLogin].
        #[unsafe(method(setCanBecomeVisibleWithoutLogin:))]
        #[unsafe(method_family = none)]
        pub fn setCanBecomeVisibleWithoutLogin(&self, can_become_visible_without_login: bool);

        #[unsafe(method(collectionBehavior))]
        #[unsafe(method_family = none)]
        pub fn collectionBehavior(&self) -> NSWindowCollectionBehavior;

        /// Setter for [`collectionBehavior`][Self::collectionBehavior].
        #[unsafe(method(setCollectionBehavior:))]
        #[unsafe(method_family = none)]
        pub fn setCollectionBehavior(&self, collection_behavior: NSWindowCollectionBehavior);

        /// Provides for per-window control over automatic orderFront/orderOut animation behaviors added in 10.7.  Can be set to
        /// `NSWindowAnimationBehaviorNone`to disable Appkit's automatic animations for a given window, or to one of the other non-Default
        /// `NSWindowAnimationBehavior`values to override AppKit's automatic inference of appropriate animation behavior based on the window's apparent type.
        #[unsafe(method(animationBehavior))]
        #[unsafe(method_family = none)]
        pub fn animationBehavior(&self) -> NSWindowAnimationBehavior;

        /// Setter for [`animationBehavior`][Self::animationBehavior].
        #[unsafe(method(setAnimationBehavior:))]
        #[unsafe(method_family = none)]
        pub fn setAnimationBehavior(&self, animation_behavior: NSWindowAnimationBehavior);

        /// Returns
        /// `YES`if this window is associated with the active space.  For visible windows, this API indicates whether the window is currently visible on the active space.  For offscreen windows, it indicates whether ordering the window onscreen would make it bring it onto the active space
        #[unsafe(method(isOnActiveSpace))]
        #[unsafe(method_family = none)]
        pub fn isOnActiveSpace(&self) -> bool;

        /// `-toggleFullScreen:` enters or exits for full screen. A window must have
        /// `NSWindowCollectionBehaviorFullScreenAuxiliary`or
        /// `NSWindowCollectionBehaviorFullScreenPrimary`included in the
        /// `collectionBehavior`property; if it does not, this method may simply do nothing.
        #[unsafe(method(toggleFullScreen:))]
        #[unsafe(method_family = none)]
        pub fn toggleFullScreen(&self, sender: Option<&AnyObject>);

        #[unsafe(method(stringWithSavedFrame))]
        #[unsafe(method_family = none)]
        pub fn stringWithSavedFrame(&self) -> Retained<NSWindowPersistableFrameDescriptor>;

        #[unsafe(method(setFrameFromString:))]
        #[unsafe(method_family = none)]
        pub fn setFrameFromString(&self, string: &NSWindowPersistableFrameDescriptor);

        #[unsafe(method(saveFrameUsingName:))]
        #[unsafe(method_family = none)]
        pub fn saveFrameUsingName(&self, name: &NSWindowFrameAutosaveName);

        #[unsafe(method(setFrameUsingName:force:))]
        #[unsafe(method_family = none)]
        pub fn setFrameUsingName_force(
            &self,
            name: &NSWindowFrameAutosaveName,
            force: bool,
        ) -> bool;

        #[unsafe(method(setFrameUsingName:))]
        #[unsafe(method_family = none)]
        pub fn setFrameUsingName(&self, name: &NSWindowFrameAutosaveName) -> bool;

        #[unsafe(method(setFrameAutosaveName:))]
        #[unsafe(method_family = none)]
        pub fn setFrameAutosaveName(&self, name: &NSWindowFrameAutosaveName) -> bool;

        #[unsafe(method(frameAutosaveName))]
        #[unsafe(method_family = none)]
        pub fn frameAutosaveName(&self) -> Retained<NSWindowFrameAutosaveName>;

        #[unsafe(method(removeFrameUsingName:))]
        #[unsafe(method_family = none)]
        pub fn removeFrameUsingName(name: &NSWindowFrameAutosaveName, mtm: MainThreadMarker);

        #[unsafe(method(minSize))]
        #[unsafe(method_family = none)]
        pub fn minSize(&self) -> NSSize;

        /// Setter for [`minSize`][Self::minSize].
        #[unsafe(method(setMinSize:))]
        #[unsafe(method_family = none)]
        pub fn setMinSize(&self, min_size: NSSize);

        #[unsafe(method(maxSize))]
        #[unsafe(method_family = none)]
        pub fn maxSize(&self) -> NSSize;

        /// Setter for [`maxSize`][Self::maxSize].
        #[unsafe(method(setMaxSize:))]
        #[unsafe(method_family = none)]
        pub fn setMaxSize(&self, max_size: NSSize);

        #[unsafe(method(contentMinSize))]
        #[unsafe(method_family = none)]
        pub fn contentMinSize(&self) -> NSSize;

        /// Setter for [`contentMinSize`][Self::contentMinSize].
        #[unsafe(method(setContentMinSize:))]
        #[unsafe(method_family = none)]
        pub fn setContentMinSize(&self, content_min_size: NSSize);

        #[unsafe(method(contentMaxSize))]
        #[unsafe(method_family = none)]
        pub fn contentMaxSize(&self) -> NSSize;

        /// Setter for [`contentMaxSize`][Self::contentMaxSize].
        #[unsafe(method(setContentMaxSize:))]
        #[unsafe(method_family = none)]
        pub fn setContentMaxSize(&self, content_max_size: NSSize);

        #[unsafe(method(minFullScreenContentSize))]
        #[unsafe(method_family = none)]
        pub fn minFullScreenContentSize(&self) -> NSSize;

        /// Setter for [`minFullScreenContentSize`][Self::minFullScreenContentSize].
        #[unsafe(method(setMinFullScreenContentSize:))]
        #[unsafe(method_family = none)]
        pub fn setMinFullScreenContentSize(&self, min_full_screen_content_size: NSSize);

        #[unsafe(method(maxFullScreenContentSize))]
        #[unsafe(method_family = none)]
        pub fn maxFullScreenContentSize(&self) -> NSSize;

        /// Setter for [`maxFullScreenContentSize`][Self::maxFullScreenContentSize].
        #[unsafe(method(setMaxFullScreenContentSize:))]
        #[unsafe(method_family = none)]
        pub fn setMaxFullScreenContentSize(&self, max_full_screen_content_size: NSSize);

        #[cfg(feature = "NSGraphics")]
        #[unsafe(method(deviceDescription))]
        #[unsafe(method_family = none)]
        pub fn deviceDescription(
            &self,
        ) -> Retained<NSDictionary<NSDeviceDescriptionKey, AnyObject>>;

        #[cfg(feature = "NSWindowController")]
        #[unsafe(method(windowController))]
        #[unsafe(method_family = none)]
        pub fn windowController(&self) -> Option<Retained<NSWindowController>>;

        #[cfg(feature = "NSWindowController")]
        /// Setter for [`windowController`][Self::windowController].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setWindowController:))]
        #[unsafe(method_family = none)]
        pub fn setWindowController(&self, window_controller: Option<&NSWindowController>);

        #[cfg(all(feature = "NSApplication", feature = "block2"))]
        #[unsafe(method(beginSheet:completionHandler:))]
        #[unsafe(method_family = none)]
        pub fn beginSheet_completionHandler(
            &self,
            sheet_window: &NSWindow,
            handler: Option<&block2::DynBlock<dyn Fn(NSModalResponse)>>,
        );

        #[cfg(all(feature = "NSApplication", feature = "block2"))]
        #[unsafe(method(beginCriticalSheet:completionHandler:))]
        #[unsafe(method_family = none)]
        pub fn beginCriticalSheet_completionHandler(
            &self,
            sheet_window: &NSWindow,
            handler: Option<&block2::DynBlock<dyn Fn(NSModalResponse)>>,
        );

        #[unsafe(method(endSheet:))]
        #[unsafe(method_family = none)]
        pub fn endSheet(&self, sheet_window: &NSWindow);

        #[cfg(feature = "NSApplication")]
        #[unsafe(method(endSheet:returnCode:))]
        #[unsafe(method_family = none)]
        pub fn endSheet_returnCode(&self, sheet_window: &NSWindow, return_code: NSModalResponse);

        /// An ordered array of the sheets on the window. This consists of the presented sheets in top-to-bottom order, followed by queued sheets in the order they were queued. This does not include nested/sub-sheets.
        #[unsafe(method(sheets))]
        #[unsafe(method_family = none)]
        pub fn sheets(&self) -> Retained<NSArray<NSWindow>>;

        /// Returns the top-most sheet if there is one or more sheets, or nil if there is no sheet.
        #[unsafe(method(attachedSheet))]
        #[unsafe(method_family = none)]
        pub fn attachedSheet(&self) -> Option<Retained<NSWindow>>;

        #[unsafe(method(isSheet))]
        #[unsafe(method_family = none)]
        pub fn isSheet(&self) -> bool;

        /// Returns the window that the sheet is directly attached to. This is based on the logical attachment of the sheet, not visual attachment.
        /// This relationship exists starting when the sheet is begun (using
        /// `NSApplication's``-beginSheet:modalForWindow:modalDelegate:didEndSelector:contextInfo: or NSWindow's -beginSheet:completionHandler:`), and ending once it is ordered out.
        /// Returns nil if the window is not a sheet or has no sheet parent.
        #[unsafe(method(sheetParent))]
        #[unsafe(method_family = none)]
        pub fn sheetParent(&self) -> Option<Retained<NSWindow>>;

        #[cfg(all(feature = "NSButton", feature = "NSControl", feature = "NSView"))]
        #[unsafe(method(standardWindowButton:forStyleMask:))]
        #[unsafe(method_family = none)]
        pub fn standardWindowButton_forStyleMask(
            b: NSWindowButton,
            style_mask: NSWindowStyleMask,
            mtm: MainThreadMarker,
        ) -> Option<Retained<NSButton>>;

        #[cfg(all(feature = "NSButton", feature = "NSControl", feature = "NSView"))]
        #[unsafe(method(standardWindowButton:))]
        #[unsafe(method_family = none)]
        pub fn standardWindowButton(&self, b: NSWindowButton) -> Option<Retained<NSButton>>;

        #[cfg(feature = "NSGraphics")]
        #[unsafe(method(addChildWindow:ordered:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addChildWindow_ordered(
            &self,
            child_win: &NSWindow,
            place: NSWindowOrderingMode,
        );

        #[unsafe(method(removeChildWindow:))]
        #[unsafe(method_family = none)]
        pub fn removeChildWindow(&self, child_win: &NSWindow);

        #[unsafe(method(childWindows))]
        #[unsafe(method_family = none)]
        pub fn childWindows(&self) -> Option<Retained<NSArray<NSWindow>>>;

        #[unsafe(method(parentWindow))]
        #[unsafe(method_family = none)]
        pub fn parentWindow(&self) -> Option<Retained<NSWindow>>;

        /// Setter for [`parentWindow`][Self::parentWindow].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setParentWindow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setParentWindow(&self, parent_window: Option<&NSWindow>);

        #[cfg(feature = "NSAppearance")]
        /// If set, the receiver will inherit the appearance of that object, as well as use KVO to observe its effectiveAppearance for changes. Typically this is used for child windows that are shown from a parent window or specific view. Defaults to NSApp.
        #[unsafe(method(appearanceSource))]
        #[unsafe(method_family = none)]
        pub fn appearanceSource(&self) -> Option<Retained<NSObject>>;

        #[cfg(feature = "NSAppearance")]
        /// Setter for [`appearanceSource`][Self::appearanceSource].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        ///
        /// # Safety
        ///
        /// - `appearance_source` must implement NSAppearanceCustomization.
        /// - `appearance_source` might not allow `None`.
        #[unsafe(method(setAppearanceSource:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAppearanceSource(&self, appearance_source: Option<&NSObject>);

        #[cfg(feature = "NSColorSpace")]
        #[unsafe(method(colorSpace))]
        #[unsafe(method_family = none)]
        pub fn colorSpace(&self) -> Option<Retained<NSColorSpace>>;

        #[cfg(feature = "NSColorSpace")]
        /// Setter for [`colorSpace`][Self::colorSpace].
        #[unsafe(method(setColorSpace:))]
        #[unsafe(method_family = none)]
        pub fn setColorSpace(&self, color_space: Option<&NSColorSpace>);

        #[cfg(feature = "NSGraphics")]
        /// `-canRepresentDisplayGamut:` returns
        /// `YES`if the colorSpace of the receiving window, and the
        /// `colorSpace`of the screen containing that window, are capable of representing the given display gamut
        #[unsafe(method(canRepresentDisplayGamut:))]
        #[unsafe(method_family = none)]
        pub fn canRepresentDisplayGamut(&self, display_gamut: NSDisplayGamut) -> bool;

        /// `+windowNumbersWithOptions:` returns an autoreleased array of
        /// `NSNumbers`containing windowNumbers for all visible windows satisfying options.  If no options are specified, only visible windows belonging to the calling application and on the active space are included.  If options include
        /// `NSWindowNumberListAllApplications,`visible windows belonging to all applications are included.  If options include
        /// `NSWindowNumberListAllSpaces,`visible windows on all spaces are included.  Windows on the active space are returned in z-order.
        /// Examples:
        /// To get an array of windowNumbers visible on the current space and belonging to the calling application:
        /// `windowNumbers = [NSWindow windowNumbersWithOptions:0];`
        /// To get an array of windowNumbers visible on any space and belonging to any application:
        /// `windowNumbers = [NSWindow windowNumbersWithOptions:NSWindowNumberListAllApplications|NSWindowNumberListAllSpaces];`
        /// To get an array of windowNumbers visible on any space and belonging to the calling application:
        /// `windowNumbers = [NSWindow windowNumbersWithOptions:NSWindowNumberListAllSpaces];`
        #[unsafe(method(windowNumbersWithOptions:))]
        #[unsafe(method_family = none)]
        pub fn windowNumbersWithOptions(
            options: NSWindowNumberListOptions,
            mtm: MainThreadMarker,
        ) -> Option<Retained<NSArray<NSNumber>>>;

        /// `+windowNumberAtPoint:belowWindowWithWindowNumber:` returns the number of the frontmost window that would be hit by a mouseDown at the screen location "point".  "windowNum" can be specified to exclude a given window along with all windows above it, and may belong to any application.  If no windows are to be excluded, specify 0 for "windowNum".  The windowNumber returned may correspond to a window in another application.
        #[unsafe(method(windowNumberAtPoint:belowWindowWithWindowNumber:))]
        #[unsafe(method_family = none)]
        pub fn windowNumberAtPoint_belowWindowWithWindowNumber(
            point: NSPoint,
            window_number: NSInteger,
            mtm: MainThreadMarker,
        ) -> NSInteger;

        #[unsafe(method(occlusionState))]
        #[unsafe(method_family = none)]
        pub fn occlusionState(&self) -> NSWindowOcclusionState;

        /// Specifies the style of separator displayed between the window's titlebar and content.
        ///
        /// The default value is NSTitlebarSeparatorStyleAutomatic. Changing this value will override any preference made by `NSSplitViewItem`.
        #[unsafe(method(titlebarSeparatorStyle))]
        #[unsafe(method_family = none)]
        pub fn titlebarSeparatorStyle(&self) -> NSTitlebarSeparatorStyle;

        /// Setter for [`titlebarSeparatorStyle`][Self::titlebarSeparatorStyle].
        #[unsafe(method(setTitlebarSeparatorStyle:))]
        #[unsafe(method_family = none)]
        pub fn setTitlebarSeparatorStyle(&self, titlebar_separator_style: NSTitlebarSeparatorStyle);

        #[cfg(feature = "NSViewController")]
        /// The main content view controller for the window. This provides the contentView of the window. Assigning this value will remove the existing contentView and will make the contentViewController.view the main contentView for the window. The default value is nil. The contentViewController only controls the contentView, and not the title of the window. The window title can easily be bound to the contentViewController with the following: [window bind:NSTitleBinding toObject:contentViewController withKeyPath:
        /// "
        /// title" options:nil]. Setting the contentViewController will cause the window to resize based on the current size of the contentViewController. Autolayout should be used to restrict the size of the window. The value of the contentViewController is encoded in the NIB. Directly assigning a contentView will clear out the contentViewController.
        #[unsafe(method(contentViewController))]
        #[unsafe(method_family = none)]
        pub fn contentViewController(&self) -> Option<Retained<NSViewController>>;

        #[cfg(feature = "NSViewController")]
        /// Setter for [`contentViewController`][Self::contentViewController].
        #[unsafe(method(setContentViewController:))]
        #[unsafe(method_family = none)]
        pub fn setContentViewController(&self, content_view_controller: Option<&NSViewController>);

        #[cfg(feature = "NSViewController")]
        /// Convenience method for creating an autoreleased titled window with the given contentViewController. A basic NSWindow with the following attributes is made: titled, closable, resizable, miniaturizable. The window's title is automatically bound to the contentViewController's title. The size of the window can easily be controlled by utilizing autolayout and applying size constraints to the view (or its subviews). The window has isReleasedWhenClosed set to NO, and it must be explicitly retained to keep the window instance alive. To have it automatically be freed when it is closed, do the following: [window retain] and [window setReleasedWhenClosed:YES].
        #[unsafe(method(windowWithContentViewController:))]
        #[unsafe(method_family = none)]
        pub fn windowWithContentViewController(
            content_view_controller: &NSViewController,
        ) -> Retained<Self>;

        #[cfg(feature = "NSEvent")]
        /// Call to start a drag (moving the window) in the Window Server process. In general, this can be done after a mouseDown event has come in and been examined by an application or view. The view may determine it wants to allow that portion of the window to start a window drag, and can hand off the work to the Window Server process by calling this method. This allows the window to participate in space switching, and other system features. Pass the original mouseDown event to the method. The method will return right away, and a mouseUp may not get sent.
        #[unsafe(method(performWindowDragWithEvent:))]
        #[unsafe(method_family = none)]
        pub fn performWindowDragWithEvent(&self, event: &NSEvent);

        #[cfg(feature = "NSView")]
        #[unsafe(method(initialFirstResponder))]
        #[unsafe(method_family = none)]
        pub fn initialFirstResponder(&self) -> Option<Retained<NSView>>;

        #[cfg(feature = "NSView")]
        /// Setter for [`initialFirstResponder`][Self::initialFirstResponder].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setInitialFirstResponder:))]
        #[unsafe(method_family = none)]
        pub fn setInitialFirstResponder(&self, initial_first_responder: Option<&NSView>);

        #[unsafe(method(selectNextKeyView:))]
        #[unsafe(method_family = none)]
        pub fn selectNextKeyView(&self, sender: Option<&AnyObject>);

        #[unsafe(method(selectPreviousKeyView:))]
        #[unsafe(method_family = none)]
        pub fn selectPreviousKeyView(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "NSView")]
        #[unsafe(method(selectKeyViewFollowingView:))]
        #[unsafe(method_family = none)]
        pub fn selectKeyViewFollowingView(&self, view: &NSView);

        #[cfg(feature = "NSView")]
        #[unsafe(method(selectKeyViewPrecedingView:))]
        #[unsafe(method_family = none)]
        pub fn selectKeyViewPrecedingView(&self, view: &NSView);

        #[unsafe(method(keyViewSelectionDirection))]
        #[unsafe(method_family = none)]
        pub fn keyViewSelectionDirection(&self) -> NSSelectionDirection;

        #[cfg(all(feature = "NSActionCell", feature = "NSButtonCell", feature = "NSCell"))]
        #[unsafe(method(defaultButtonCell))]
        #[unsafe(method_family = none)]
        pub fn defaultButtonCell(&self) -> Option<Retained<NSButtonCell>>;

        #[cfg(all(feature = "NSActionCell", feature = "NSButtonCell", feature = "NSCell"))]
        /// Setter for [`defaultButtonCell`][Self::defaultButtonCell].
        #[unsafe(method(setDefaultButtonCell:))]
        #[unsafe(method_family = none)]
        pub fn setDefaultButtonCell(&self, default_button_cell: Option<&NSButtonCell>);

        #[unsafe(method(disableKeyEquivalentForDefaultButtonCell))]
        #[unsafe(method_family = none)]
        pub fn disableKeyEquivalentForDefaultButtonCell(&self);

        #[unsafe(method(enableKeyEquivalentForDefaultButtonCell))]
        #[unsafe(method_family = none)]
        pub fn enableKeyEquivalentForDefaultButtonCell(&self);

        #[unsafe(method(autorecalculatesKeyViewLoop))]
        #[unsafe(method_family = none)]
        pub fn autorecalculatesKeyViewLoop(&self) -> bool;

        /// Setter for [`autorecalculatesKeyViewLoop`][Self::autorecalculatesKeyViewLoop].
        #[unsafe(method(setAutorecalculatesKeyViewLoop:))]
        #[unsafe(method_family = none)]
        pub fn setAutorecalculatesKeyViewLoop(&self, autorecalculates_key_view_loop: bool);

        #[unsafe(method(recalculateKeyViewLoop))]
        #[unsafe(method_family = none)]
        pub fn recalculateKeyViewLoop(&self);

        #[cfg(feature = "NSToolbar")]
        #[unsafe(method(toolbar))]
        #[unsafe(method_family = none)]
        pub fn toolbar(&self) -> Option<Retained<NSToolbar>>;

        #[cfg(feature = "NSToolbar")]
        /// Setter for [`toolbar`][Self::toolbar].
        #[unsafe(method(setToolbar:))]
        #[unsafe(method_family = none)]
        pub fn setToolbar(&self, toolbar: Option<&NSToolbar>);

        #[unsafe(method(toggleToolbarShown:))]
        #[unsafe(method_family = none)]
        pub fn toggleToolbarShown(&self, sender: Option<&AnyObject>);

        #[unsafe(method(runToolbarCustomizationPalette:))]
        #[unsafe(method_family = none)]
        pub fn runToolbarCustomizationPalette(&self, sender: Option<&AnyObject>);

        #[deprecated = "This property has no effect"]
        #[unsafe(method(showsToolbarButton))]
        #[unsafe(method_family = none)]
        pub fn showsToolbarButton(&self) -> bool;

        /// Setter for [`showsToolbarButton`][Self::showsToolbarButton].
        #[deprecated = "This property has no effect"]
        #[unsafe(method(setShowsToolbarButton:))]
        #[unsafe(method_family = none)]
        pub fn setShowsToolbarButton(&self, shows_toolbar_button: bool);

        /// Allows automatic window tabbing when the value is
        /// `YES.`By default, this will be set to
        /// `YES,`but applications can explicitly opt out of all automatic tabbing by setting it to NO, and can still adopted explicit window tabbing, if desired.
        #[unsafe(method(allowsAutomaticWindowTabbing))]
        #[unsafe(method_family = none)]
        pub fn allowsAutomaticWindowTabbing(mtm: MainThreadMarker) -> bool;

        /// Setter for [`allowsAutomaticWindowTabbing`][Self::allowsAutomaticWindowTabbing].
        #[unsafe(method(setAllowsAutomaticWindowTabbing:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsAutomaticWindowTabbing(
            allows_automatic_window_tabbing: bool,
            mtm: MainThreadMarker,
        );

        /// Returns the user's tabbing preference as set in System Preferences. This value should be queried anytime a new window is made to see if the user wants to automatically show it in tabs.
        #[unsafe(method(userTabbingPreference))]
        #[unsafe(method_family = none)]
        pub fn userTabbingPreference(mtm: MainThreadMarker) -> NSWindowUserTabbingPreference;

        /// Get and set the tabbing mode for this window. This should be set before a window is shown. The default value is
        /// `NSWindowTabbingModeAutomatic.`When the value is
        /// `NSWindowTabbingModeAutomatic,`the system will look at the
        /// `userTabbingPreference`and automatically tab windows together based on the tabbingIdentifier, when it is appropriate to do so.
        #[unsafe(method(tabbingMode))]
        #[unsafe(method_family = none)]
        pub fn tabbingMode(&self) -> NSWindowTabbingMode;

        /// Setter for [`tabbingMode`][Self::tabbingMode].
        #[unsafe(method(setTabbingMode:))]
        #[unsafe(method_family = none)]
        pub fn setTabbingMode(&self, tabbing_mode: NSWindowTabbingMode);

        /// Windows with the same
        /// `tabbingIdentifier`will have the ability to be tabbed together when a window is being shown. This allows aggregation of similar windows. By default, the
        /// `tabbingIdentifier`will be generated based on inherent window properties, such as the window class name, the delegate class name, the window controller class name, and some additional state. Windows can be explicitly made to group together by using the same
        /// `tabbingIdentifier.`
        #[unsafe(method(tabbingIdentifier))]
        #[unsafe(method_family = none)]
        pub fn tabbingIdentifier(&self) -> Retained<NSWindowTabbingIdentifier>;

        /// Setter for [`tabbingIdentifier`][Self::tabbingIdentifier].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTabbingIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn setTabbingIdentifier(&self, tabbing_identifier: &NSWindowTabbingIdentifier);

        /// Actions that can be called to perform various tabbed window behaviors. UI that is hooked up to these items can be automatically validated by calling `NSWindow`'s
        /// `validateUserInterfaceItem.`
        #[unsafe(method(selectNextTab:))]
        #[unsafe(method_family = none)]
        pub fn selectNextTab(&self, sender: Option<&AnyObject>);

        #[unsafe(method(selectPreviousTab:))]
        #[unsafe(method_family = none)]
        pub fn selectPreviousTab(&self, sender: Option<&AnyObject>);

        #[unsafe(method(moveTabToNewWindow:))]
        #[unsafe(method_family = none)]
        pub fn moveTabToNewWindow(&self, sender: Option<&AnyObject>);

        #[unsafe(method(mergeAllWindows:))]
        #[unsafe(method_family = none)]
        pub fn mergeAllWindows(&self, sender: Option<&AnyObject>);

        #[unsafe(method(toggleTabBar:))]
        #[unsafe(method_family = none)]
        pub fn toggleTabBar(&self, sender: Option<&AnyObject>);

        /// Toggle the Tab Picker / Tab Overview UI which is invoked via "Show All Tabs". Performs the toggle in an animated fashion. Use `tabGroup.isOverviewVisible` to find out if it is visible or not at a given time.
        #[unsafe(method(toggleTabOverview:))]
        #[unsafe(method_family = none)]
        pub fn toggleTabOverview(&self, sender: Option<&AnyObject>);

        /// This is now a cover for `self.tabGroup.windows`, but will return nil if the window is not showing a tab bar.
        #[unsafe(method(tabbedWindows))]
        #[unsafe(method_family = none)]
        pub fn tabbedWindows(&self) -> Option<Retained<NSArray<NSWindow>>>;

        #[cfg(feature = "NSGraphics")]
        /// This is now a cover for `-[self.tabGroup addWindow:]`, which allows more precise placement.
        #[unsafe(method(addTabbedWindow:ordered:))]
        #[unsafe(method_family = none)]
        pub fn addTabbedWindow_ordered(&self, window: &NSWindow, ordered: NSWindowOrderingMode);

        #[cfg(feature = "NSWindowTab")]
        /// Access the properties for this window when it is a tabbed window environment. See the
        /// `NSWindowTab`header and comments for more information.
        #[unsafe(method(tab))]
        #[unsafe(method_family = none)]
        pub fn tab(&self) -> Retained<NSWindowTab>;

        #[cfg(feature = "NSWindowTabGroup")]
        /// Represents a tab group of windows. This
        /// `tabGroup`is lazily created on demand.
        #[unsafe(method(tabGroup))]
        #[unsafe(method_family = none)]
        pub fn tabGroup(&self) -> Option<Retained<NSWindowTabGroup>>;

        #[cfg(feature = "block2")]
        /// Attempt to move window sharing (i.e. within a SharePlay session) from the receiver to another window. In response to this request, the user may choose to transfer sharing to the new window, or simply stop sharing the content.
        ///
        /// Parameter `window`: A window that is replacing the reciever in representing the user's current activity.
        ///
        /// Parameter `completionHandler`: A completion block that is called after the request finishes.
        /// `error`In the event of a failed transfer request, a non-nil error contains details about the failure.
        #[unsafe(method(transferWindowSharingToWindow:completionHandler:))]
        #[unsafe(method_family = none)]
        pub fn transferWindowSharingToWindow_completionHandler(
            &self,
            window: &NSWindow,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        /// Indicates whether the receiver is the subject of an active SharePlay sharing session.
        #[unsafe(method(hasActiveWindowSharingSession))]
        #[unsafe(method_family = none)]
        pub fn hasActiveWindowSharingSession(&self) -> bool;

        #[cfg(feature = "block2")]
        /// Request sharing of window.  If there is an available ScreenCaptureKit sharing session, an alert will be presented asking the user to confirm the share
        ///
        /// Parameter `window`: The window to share
        ///
        /// Parameter `completionHandler`: A completion block that is called after the request finishes.
        /// `error`The error will be non-nil if the request does not result in a window being shared.  The error will be NSUserCancelledError if there is no ScreenCaptureKit session, or if the user rejects the offer to share.  If sharing fails for some other reason, the error will provide the details.
        #[unsafe(method(requestSharingOfWindow:completionHandler:))]
        #[unsafe(method_family = none)]
        pub fn requestSharingOfWindow_completionHandler(
            &self,
            window: &NSWindow,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(feature = "NSImage", feature = "block2"))]
        /// Request sharing of window to be provided later.  If there is an available ScreenCaptureKit sharing session, an alert will be presented asking the user to confirm the share.  The delegate will be asked to provide the window to share via windowForSharingRequestFromWindow:
        ///
        /// Parameter `image`: An image showing a preview of the window to share
        ///
        /// Parameter `title`: The title to show in a confirmation dialog
        ///
        /// Parameter `completionHandler`: A completion block that is called after the request finishes.
        /// `error`The error will be non-nil if the request does not result in a window being shared.  The error will be NSUserCancelledError if there is no ScreenCaptureKit session, or if the user rejects the offer to share.  If sharing fails for some other reason, the error will provide the details.
        #[unsafe(method(requestSharingOfWindowUsingPreview:title:completionHandler:))]
        #[unsafe(method_family = none)]
        pub fn requestSharingOfWindowUsingPreview_title_completionHandler(
            &self,
            image: &NSImage,
            title: &NSString,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(feature = "NSUserInterfaceLayout")]
        /// Retrieve the layout direction of the window titlebar: this includes the standard window buttons (close/minimize/maximize buttons) and the title for this window. In general, this will return "right to left" (RTL) if the primary system language is RTL. The layout direction may be RTL even in applications that do not have a RTL language localization. This value should be utilized if an application uses titlebarAppearsTransparent and places controls underneath the titlebar.
        #[unsafe(method(windowTitlebarLayoutDirection))]
        #[unsafe(method_family = none)]
        pub fn windowTitlebarLayoutDirection(&self) -> NSUserInterfaceLayoutDirection;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(feature = "NSResponder")]
impl NSWindow {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "NSResponder")]
impl NSWindow {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// NSEvent.
#[cfg(feature = "NSResponder")]
impl NSWindow {
    extern_methods!(
        #[cfg(all(feature = "NSEvent", feature = "block2"))]
        /// Tracks events matching the supplied mask with the supplied tracking handler until the tracking handler explicitly terminates tracking. Each event is removed from the event queue then passed to the tracking handler. If a matching event does not exist in the event queue, then the main thread blocks in the specified runloop mode until an event of the requested type is received or the timeout expires. If the timeout expires, the tracking handler is called with a nil event. A negative timeout is interpreted as 0. Use
        /// `NSEventDurationForever`to never timeout. Tracking continues until `*stop` is set to
        /// `YES.`Calls to `-nextEventMatchingMask:…` are allowed inside the trackingHandler block. This method returns once tracking is terminated.
        #[unsafe(method(trackEventsMatchingMask:timeout:mode:handler:))]
        #[unsafe(method_family = none)]
        pub fn trackEventsMatchingMask_timeout_mode_handler(
            &self,
            mask: NSEventMask,
            timeout: NSTimeInterval,
            mode: &NSRunLoopMode,
            tracking_handler: &block2::DynBlock<dyn Fn(*mut NSEvent, NonNull<Bool>) + '_>,
        );

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(nextEventMatchingMask:))]
        #[unsafe(method_family = none)]
        pub fn nextEventMatchingMask(&self, mask: NSEventMask) -> Option<Retained<NSEvent>>;

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(nextEventMatchingMask:untilDate:inMode:dequeue:))]
        #[unsafe(method_family = none)]
        pub fn nextEventMatchingMask_untilDate_inMode_dequeue(
            &self,
            mask: NSEventMask,
            expiration: Option<&NSDate>,
            mode: &NSRunLoopMode,
            deq_flag: bool,
        ) -> Option<Retained<NSEvent>>;

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(discardEventsMatchingMask:beforeEvent:))]
        #[unsafe(method_family = none)]
        pub fn discardEventsMatchingMask_beforeEvent(
            &self,
            mask: NSEventMask,
            last_event: Option<&NSEvent>,
        );

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(postEvent:atStart:))]
        #[unsafe(method_family = none)]
        pub fn postEvent_atStart(&self, event: &NSEvent, flag: bool);

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(sendEvent:))]
        #[unsafe(method_family = none)]
        pub fn sendEvent(&self, event: &NSEvent);

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(currentEvent))]
        #[unsafe(method_family = none)]
        pub fn currentEvent(&self) -> Option<Retained<NSEvent>>;

        #[unsafe(method(acceptsMouseMovedEvents))]
        #[unsafe(method_family = none)]
        pub fn acceptsMouseMovedEvents(&self) -> bool;

        /// Setter for [`acceptsMouseMovedEvents`][Self::acceptsMouseMovedEvents].
        #[unsafe(method(setAcceptsMouseMovedEvents:))]
        #[unsafe(method_family = none)]
        pub fn setAcceptsMouseMovedEvents(&self, accepts_mouse_moved_events: bool);

        #[unsafe(method(ignoresMouseEvents))]
        #[unsafe(method_family = none)]
        pub fn ignoresMouseEvents(&self) -> bool;

        /// Setter for [`ignoresMouseEvents`][Self::ignoresMouseEvents].
        #[unsafe(method(setIgnoresMouseEvents:))]
        #[unsafe(method_family = none)]
        pub fn setIgnoresMouseEvents(&self, ignores_mouse_events: bool);

        #[unsafe(method(mouseLocationOutsideOfEventStream))]
        #[unsafe(method_family = none)]
        pub fn mouseLocationOutsideOfEventStream(&self) -> NSPoint;
    );
}

/// NSCursorRect.
#[cfg(feature = "NSResponder")]
impl NSWindow {
    extern_methods!(
        #[unsafe(method(disableCursorRects))]
        #[unsafe(method_family = none)]
        pub fn disableCursorRects(&self);

        #[unsafe(method(enableCursorRects))]
        #[unsafe(method_family = none)]
        pub fn enableCursorRects(&self);

        #[unsafe(method(discardCursorRects))]
        #[unsafe(method_family = none)]
        pub fn discardCursorRects(&self);

        #[unsafe(method(areCursorRectsEnabled))]
        #[unsafe(method_family = none)]
        pub fn areCursorRectsEnabled(&self) -> bool;

        #[cfg(feature = "NSView")]
        #[unsafe(method(invalidateCursorRectsForView:))]
        #[unsafe(method_family = none)]
        pub fn invalidateCursorRectsForView(&self, view: &NSView);

        #[unsafe(method(resetCursorRects))]
        #[unsafe(method_family = none)]
        pub fn resetCursorRects(&self);
    );
}

/// NSDrag.
#[cfg(feature = "NSResponder")]
impl NSWindow {
    extern_methods!(
        #[cfg(all(
            feature = "NSDragging",
            feature = "NSDraggingItem",
            feature = "NSDraggingSession",
            feature = "NSEvent"
        ))]
        #[unsafe(method(beginDraggingSessionWithItems:event:source:))]
        #[unsafe(method_family = none)]
        pub fn beginDraggingSessionWithItems_event_source(
            &self,
            items: &NSArray<NSDraggingItem>,
            event: &NSEvent,
            source: &ProtocolObject<dyn NSDraggingSource>,
        ) -> Retained<NSDraggingSession>;

        #[cfg(all(feature = "NSEvent", feature = "NSImage", feature = "NSPasteboard"))]
        /// # Safety
        ///
        /// `source_obj` should be of the correct type.
        #[deprecated = "Use -[NSWindow beginDraggingSessionWithItems:event:source:] instead."]
        #[unsafe(method(dragImage:at:offset:event:pasteboard:source:slideBack:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dragImage_at_offset_event_pasteboard_source_slideBack(
            &self,
            image: &NSImage,
            base_location: NSPoint,
            initial_offset: NSSize,
            event: &NSEvent,
            pboard: &NSPasteboard,
            source_obj: &AnyObject,
            slide_flag: bool,
        );

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(registerForDraggedTypes:))]
        #[unsafe(method_family = none)]
        pub fn registerForDraggedTypes(&self, new_types: &NSArray<NSPasteboardType>);

        #[unsafe(method(unregisterDraggedTypes))]
        #[unsafe(method_family = none)]
        pub fn unregisterDraggedTypes(&self);
    );
}

/// NSDisplayLink.
#[cfg(feature = "NSResponder")]
impl NSWindow {
    extern_methods!(
        #[cfg(feature = "objc2-quartz-core")]
        #[cfg(target_vendor = "apple")]
        /// # Safety
        ///
        /// - `target` should be of the correct type.
        /// - `selector` must be a valid selector.
        #[unsafe(method(displayLinkWithTarget:selector:))]
        #[unsafe(method_family = none)]
        pub unsafe fn displayLinkWithTarget_selector(
            &self,
            target: &AnyObject,
            selector: Sel,
        ) -> Retained<CADisplayLink>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdelegate?language=objc)
    pub unsafe trait NSWindowDelegate: NSObjectProtocol + MainThreadOnly {
        #[cfg(feature = "NSResponder")]
        #[optional]
        #[unsafe(method(windowShouldClose:))]
        #[unsafe(method_family = none)]
        fn windowShouldClose(&self, sender: &NSWindow) -> bool;

        #[cfg(feature = "NSResponder")]
        /// # Safety
        ///
        /// `client` should be of the correct type.
        #[optional]
        #[unsafe(method(windowWillReturnFieldEditor:toObject:))]
        #[unsafe(method_family = none)]
        unsafe fn windowWillReturnFieldEditor_toObject(
            &self,
            sender: &NSWindow,
            client: Option<&AnyObject>,
        ) -> Option<Retained<AnyObject>>;

        #[cfg(feature = "NSResponder")]
        #[optional]
        #[unsafe(method(windowWillResize:toSize:))]
        #[unsafe(method_family = none)]
        fn windowWillResize_toSize(&self, sender: &NSWindow, frame_size: NSSize) -> NSSize;

        #[cfg(feature = "NSResponder")]
        #[optional]
        #[unsafe(method(windowWillUseStandardFrame:defaultFrame:))]
        #[unsafe(method_family = none)]
        fn windowWillUseStandardFrame_defaultFrame(
            &self,
            window: &NSWindow,
            new_frame: NSRect,
        ) -> NSRect;

        #[cfg(feature = "NSResponder")]
        #[optional]
        #[unsafe(method(windowShouldZoom:toFrame:))]
        #[unsafe(method_family = none)]
        fn windowShouldZoom_toFrame(&self, window: &NSWindow, new_frame: NSRect) -> bool;

        #[cfg(feature = "NSResponder")]
        #[optional]
        #[unsafe(method(windowWillReturnUndoManager:))]
        #[unsafe(method_family = none)]
        fn windowWillReturnUndoManager(&self, window: &NSWindow)
            -> Option<Retained<NSUndoManager>>;

        #[cfg(feature = "NSResponder")]
        /// Tells the delegate that the window is about to show a sheet, and gives the delegate a chance to customize the location of the sheet.
        #[optional]
        #[unsafe(method(window:willPositionSheet:usingRect:))]
        #[unsafe(method_family = none)]
        fn window_willPositionSheet_usingRect(
            &self,
            window: &NSWindow,
            sheet: &NSWindow,
            rect: NSRect,
        ) -> NSRect;

        #[cfg(all(feature = "NSMenu", feature = "NSResponder"))]
        /// If a window has a
        /// `representedURL,`the window will by default show a path popup menu for a command-click on a rectangle containing the window document icon button and the window title.  The window delegate may implement `-window:shouldPopupDocumentPathMenu:` to override `NSWindow`'s default behavior for path popup menu.  A return of
        /// `NO`will prevent the menu from being shown.  A return of
        /// `YES`will cause the window to show the menu passed to this method, which by default will contain a menuItem for each path component of the
        /// `representedURL.`If the
        /// `representedURL`has no path components, the menu will have no menu items.  Before returning
        /// `YES,`the window delegate may customize the menu by changing the menuItems.  menuItems may be added or deleted, and each menuItem title, action, or target may be modified.
        #[optional]
        #[unsafe(method(window:shouldPopUpDocumentPathMenu:))]
        #[unsafe(method_family = none)]
        fn window_shouldPopUpDocumentPathMenu(&self, window: &NSWindow, menu: &NSMenu) -> bool;

        #[cfg(all(feature = "NSEvent", feature = "NSPasteboard", feature = "NSResponder"))]
        /// The window delegate may implement `-window:shouldDragDocumentWithEvent:from:withPasteboard:` to override
        /// `NSWindow`document icon's default drag behavior.  The delegate can prohibit the drag by returning
        /// `NO.`Before returning
        /// `NO,`the delegate may implement its own dragging behavior using `-[NSWindow dragImage:at:offset:event:pasteboard:source:slideBack:]`.  Alternatively, the delegate can enable a drag by returning
        /// `YES,`for example to override NSWindow's default behavior of prohibiting the drag of an edited document.  Lastly, the delegate can customize the pasteboard contents before returning
        /// `YES.`
        #[optional]
        #[unsafe(method(window:shouldDragDocumentWithEvent:from:withPasteboard:))]
        #[unsafe(method_family = none)]
        fn window_shouldDragDocumentWithEvent_from_withPasteboard(
            &self,
            window: &NSWindow,
            event: &NSEvent,
            drag_image_location: NSPoint,
            pasteboard: &NSPasteboard,
        ) -> bool;

        #[cfg(feature = "NSResponder")]
        #[optional]
        #[unsafe(method(window:willUseFullScreenContentSize:))]
        #[unsafe(method_family = none)]
        fn window_willUseFullScreenContentSize(
            &self,
            window: &NSWindow,
            proposed_size: NSSize,
        ) -> NSSize;

        #[cfg(all(feature = "NSApplication", feature = "NSResponder"))]
        #[optional]
        #[unsafe(method(window:willUseFullScreenPresentationOptions:))]
        #[unsafe(method_family = none)]
        fn window_willUseFullScreenPresentationOptions(
            &self,
            window: &NSWindow,
            proposed_options: NSApplicationPresentationOptions,
        ) -> NSApplicationPresentationOptions;

        #[cfg(feature = "NSResponder")]
        /// The default animation between a window and its fullscreen representation is a crossfade.  With knowledge of the layout of a window before and after it enters fullscreen, an application can do a much better job on the animation.  The following API allows a window delegate to customize the animation by providing a custom window or windows containing layers or other effects.  In order to manage windows on spaces, we need the window delegate to provide a list of windows involved in the animation.  If an application does not do a custom animation, this method can be unimplemented or can return nil.  `-window:startCustomAnimationToEnterFullScreenWithDuration:` will be called only if `-customWindowsToEnterFullScreenForWindow:` returns non-nil.
        #[optional]
        #[unsafe(method(customWindowsToEnterFullScreenForWindow:))]
        #[unsafe(method_family = none)]
        fn customWindowsToEnterFullScreenForWindow(
            &self,
            window: &NSWindow,
        ) -> Option<Retained<NSArray<NSWindow>>>;

        #[cfg(feature = "NSResponder")]
        /// The system has started its animation into fullscreen, including transitioning to a new space.  Start the window fullscreen animation immediately, and perform the animation with the given duration to  be in sync with the system animation.  This method is called only if `-customWindowToEnterFullScreenForWindow:` returned non-nil.
        #[optional]
        #[unsafe(method(window:startCustomAnimationToEnterFullScreenWithDuration:))]
        #[unsafe(method_family = none)]
        fn window_startCustomAnimationToEnterFullScreenWithDuration(
            &self,
            window: &NSWindow,
            duration: NSTimeInterval,
        );

        #[cfg(feature = "NSResponder")]
        /// In some cases, the transition to enter fullscreen will fail, due to being in the midst of handling some other animation or user gesture.  We will attempt to minimize these cases, but believe there is a need for failure handling.  This method indicates that there was an error, and the application should clean up any work it may have done to prepare to enter fullscreen.  This message will be sent whether or not the delegate indicated a custom animation by returning non-nil from `-customWindowsToEnterFullScreenForWindow:`.
        #[optional]
        #[unsafe(method(windowDidFailToEnterFullScreen:))]
        #[unsafe(method_family = none)]
        fn windowDidFailToEnterFullScreen(&self, window: &NSWindow);

        #[cfg(feature = "NSResponder")]
        /// The window is about to exit fullscreen mode.  The following API allows a window delegate to customize the animation when the window is about to exit fullscreen.  In order to manage windows on spaces, we need the window delegate to provide a list of windows involved in the animation.  If an application does not do a custom animation, this method can be unimplemented or can return nil. `-window:startCustomAnimationToExitFullScreenWithDuration:` will be called only if `-customWindowsToExitFullScreenForWindow:` returns non-nil.
        #[optional]
        #[unsafe(method(customWindowsToExitFullScreenForWindow:))]
        #[unsafe(method_family = none)]
        fn customWindowsToExitFullScreenForWindow(
            &self,
            window: &NSWindow,
        ) -> Option<Retained<NSArray<NSWindow>>>;

        #[cfg(feature = "NSResponder")]
        /// The system has started its animation out of fullscreen, including transitioning back to the desktop space.  Start the window animation immediately, and perform the animation with the given duration to  be in sync with the system animation.  This method is called only if `-customWindowsToExitFullScreenForWindow:` returned non-nil.
        #[optional]
        #[unsafe(method(window:startCustomAnimationToExitFullScreenWithDuration:))]
        #[unsafe(method_family = none)]
        fn window_startCustomAnimationToExitFullScreenWithDuration(
            &self,
            window: &NSWindow,
            duration: NSTimeInterval,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSScreen"))]
        /// `-customWindowsToEnterFullScreenForWindow:onScreen:` will be called in place of `-customWindowsToEnterFullScreenForWindow:` if both are implemented.
        #[optional]
        #[unsafe(method(customWindowsToEnterFullScreenForWindow:onScreen:))]
        #[unsafe(method_family = none)]
        fn customWindowsToEnterFullScreenForWindow_onScreen(
            &self,
            window: &NSWindow,
            screen: &NSScreen,
        ) -> Option<Retained<NSArray<NSWindow>>>;

        #[cfg(all(feature = "NSResponder", feature = "NSScreen"))]
        /// `-window:startCustomAnimationToEnterFullScreenOnScreen:withDuration:` will be called in place of `-window:startCustomAnimationToEnterFullScreenWithDuration:` if both are implemented.
        #[optional]
        #[unsafe(method(window:startCustomAnimationToEnterFullScreenOnScreen:withDuration:))]
        #[unsafe(method_family = none)]
        fn window_startCustomAnimationToEnterFullScreenOnScreen_withDuration(
            &self,
            window: &NSWindow,
            screen: &NSScreen,
            duration: NSTimeInterval,
        );

        #[cfg(feature = "NSResponder")]
        /// In some cases, the transition to exit fullscreen will fail, due to being in the midst of handling some other animation or user gesture.  We will attempt to minimize these cases, but believe there is a need for failure handling.  This method indicates that there was an error, and the application should clean up any work it may have done to prepare to exit fullscreen.  This message will be sent whether or not the delegate indicated a custom animation by returning non-nil from `-customWindowsToExitFullScreenForWindow:`.
        #[optional]
        #[unsafe(method(windowDidFailToExitFullScreen:))]
        #[unsafe(method_family = none)]
        fn windowDidFailToExitFullScreen(&self, window: &NSWindow);

        #[cfg(feature = "NSResponder")]
        /// Windows entering the version browser will be resized to the size returned by this method. If either dimension of the returned size is larger than the
        /// `maxPreferredFrameSize,`the window will also be scaled down to ensure it fits properly in the version browser. Returned sizes larger than
        /// `maxAllowedSize`will be constrained to that size. If this method is not implemented, the version browser will use `-window:willUseStandardFrame:` to determine the resulting window frame size.
        #[optional]
        #[unsafe(method(window:willResizeForVersionBrowserWithMaxPreferredSize:maxAllowedSize:))]
        #[unsafe(method_family = none)]
        fn window_willResizeForVersionBrowserWithMaxPreferredSize_maxAllowedSize(
            &self,
            window: &NSWindow,
            max_preferred_frame_size: NSSize,
            max_allowed_frame_size: NSSize,
        ) -> NSSize;

        #[cfg(feature = "NSResponder")]
        /// Method called by `-[NSWindow encodeRestorableStateWithCoder:]` to give the delegate a chance to encode any additional state into the NSCoder.  This state is available in the NSCoder passed to `-restoreWindowWithIdentifier:state:handler:`. See the header `NSWindowRestoration.h` for more information.
        ///
        /// # Safety
        ///
        /// `state` possibly has further requirements.
        #[optional]
        #[unsafe(method(window:willEncodeRestorableState:))]
        #[unsafe(method_family = none)]
        unsafe fn window_willEncodeRestorableState(&self, window: &NSWindow, state: &NSCoder);

        #[cfg(feature = "NSResponder")]
        /// Method called by `-[NSWindow restoreStateWithCoder:]` to give the delegate a chance to restore its own state, which it may decode from the
        /// `NSCoder.`See the header `NSWindowRestoration.h` for more information.
        ///
        /// # Safety
        ///
        /// `state` possibly has further requirements.
        #[optional]
        #[unsafe(method(window:didDecodeRestorableState:))]
        #[unsafe(method_family = none)]
        unsafe fn window_didDecodeRestorableState(&self, window: &NSWindow, state: &NSCoder);

        #[cfg(all(feature = "NSPreviewRepresentingActivityItem", feature = "NSResponder"))]
        /// Preview representable activity items, used for sharing and collaboration.
        #[optional]
        #[unsafe(method(previewRepresentableActivityItemsForWindow:))]
        #[unsafe(method_family = none)]
        fn previewRepresentableActivityItemsForWindow(
            &self,
            window: &NSWindow,
        ) -> Option<Retained<NSArray<ProtocolObject<dyn NSPreviewRepresentableActivityItem>>>>;

        #[cfg(feature = "NSResponder")]
        /// Method called to get the window to share once sharing is confirmed, after a request is initiated by requestSharingOfWindowUsingPreview:title:completionHandler:. Implement this on the delegate of the requesting window
        #[optional]
        #[unsafe(method(windowForSharingRequestFromWindow:))]
        #[unsafe(method_family = none)]
        fn windowForSharingRequestFromWindow(
            &self,
            window: &NSWindow,
        ) -> Option<Retained<NSWindow>>;

        #[optional]
        #[unsafe(method(windowDidResize:))]
        #[unsafe(method_family = none)]
        fn windowDidResize(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidExpose:))]
        #[unsafe(method_family = none)]
        fn windowDidExpose(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowWillMove:))]
        #[unsafe(method_family = none)]
        fn windowWillMove(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidMove:))]
        #[unsafe(method_family = none)]
        fn windowDidMove(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidBecomeKey:))]
        #[unsafe(method_family = none)]
        fn windowDidBecomeKey(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidResignKey:))]
        #[unsafe(method_family = none)]
        fn windowDidResignKey(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidBecomeMain:))]
        #[unsafe(method_family = none)]
        fn windowDidBecomeMain(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidResignMain:))]
        #[unsafe(method_family = none)]
        fn windowDidResignMain(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowWillClose:))]
        #[unsafe(method_family = none)]
        fn windowWillClose(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowWillMiniaturize:))]
        #[unsafe(method_family = none)]
        fn windowWillMiniaturize(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidMiniaturize:))]
        #[unsafe(method_family = none)]
        fn windowDidMiniaturize(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidDeminiaturize:))]
        #[unsafe(method_family = none)]
        fn windowDidDeminiaturize(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidUpdate:))]
        #[unsafe(method_family = none)]
        fn windowDidUpdate(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidChangeScreen:))]
        #[unsafe(method_family = none)]
        fn windowDidChangeScreen(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidChangeScreenProfile:))]
        #[unsafe(method_family = none)]
        fn windowDidChangeScreenProfile(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidChangeBackingProperties:))]
        #[unsafe(method_family = none)]
        fn windowDidChangeBackingProperties(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowWillBeginSheet:))]
        #[unsafe(method_family = none)]
        fn windowWillBeginSheet(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidEndSheet:))]
        #[unsafe(method_family = none)]
        fn windowDidEndSheet(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowWillStartLiveResize:))]
        #[unsafe(method_family = none)]
        fn windowWillStartLiveResize(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidEndLiveResize:))]
        #[unsafe(method_family = none)]
        fn windowDidEndLiveResize(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowWillEnterFullScreen:))]
        #[unsafe(method_family = none)]
        fn windowWillEnterFullScreen(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidEnterFullScreen:))]
        #[unsafe(method_family = none)]
        fn windowDidEnterFullScreen(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowWillExitFullScreen:))]
        #[unsafe(method_family = none)]
        fn windowWillExitFullScreen(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidExitFullScreen:))]
        #[unsafe(method_family = none)]
        fn windowDidExitFullScreen(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowWillEnterVersionBrowser:))]
        #[unsafe(method_family = none)]
        fn windowWillEnterVersionBrowser(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidEnterVersionBrowser:))]
        #[unsafe(method_family = none)]
        fn windowDidEnterVersionBrowser(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowWillExitVersionBrowser:))]
        #[unsafe(method_family = none)]
        fn windowWillExitVersionBrowser(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidExitVersionBrowser:))]
        #[unsafe(method_family = none)]
        fn windowDidExitVersionBrowser(&self, notification: &NSNotification);

        #[optional]
        #[unsafe(method(windowDidChangeOcclusionState:))]
        #[unsafe(method_family = none)]
        fn windowDidChangeOcclusionState(&self, notification: &NSNotification);
    }
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidbecomekeynotification?language=objc)
    pub static NSWindowDidBecomeKeyNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidbecomemainnotification?language=objc)
    pub static NSWindowDidBecomeMainNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidchangescreennotification?language=objc)
    pub static NSWindowDidChangeScreenNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdiddeminiaturizenotification?language=objc)
    pub static NSWindowDidDeminiaturizeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidexposenotification?language=objc)
    pub static NSWindowDidExposeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidminiaturizenotification?language=objc)
    pub static NSWindowDidMiniaturizeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidmovenotification?language=objc)
    pub static NSWindowDidMoveNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidresignkeynotification?language=objc)
    pub static NSWindowDidResignKeyNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidresignmainnotification?language=objc)
    pub static NSWindowDidResignMainNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidresizenotification?language=objc)
    pub static NSWindowDidResizeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidupdatenotification?language=objc)
    pub static NSWindowDidUpdateNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowwillclosenotification?language=objc)
    pub static NSWindowWillCloseNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowwillminiaturizenotification?language=objc)
    pub static NSWindowWillMiniaturizeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowwillmovenotification?language=objc)
    pub static NSWindowWillMoveNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowwillbeginsheetnotification?language=objc)
    pub static NSWindowWillBeginSheetNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidendsheetnotification?language=objc)
    pub static NSWindowDidEndSheetNotification: &'static NSNotificationName;
}

extern "C" {
    /// `NSWindowDidChangeBackingPropertiesNotification`is posted on 10.7.3 and later, when a window's
    /// `backingScaleFactor`and/or its
    /// `colorSpace`changes.  When running on a system version where this new notification is available, applications should use it instead of
    /// `NSWindowDidChangeScreenProfileNotification`to watch for changes to either of these backing store properties.  Many applications won't have any need to watch for this notification, but those that perform sophisticated color handling or manually manage their own caches of window-resolution-and/or/colorspace-appropriate bitmapped images will find this notification useful, as a prompt to invalidate their caches or schedule other reassessment for the new resolution and/or color space as needed.  The notification's userInfo dictionary specifies the window's previous
    /// `backingScaleFactor`and
    /// `colorSpace.`You can compare these with the window's new
    /// `backingScaleFactor`and
    /// `colorSpace`at the time of the notification, to determine which of these two properties (potentially both) changed.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidchangebackingpropertiesnotification?language=objc)
    pub static NSWindowDidChangeBackingPropertiesNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbackingpropertyoldscalefactorkey?language=objc)
    pub static NSBackingPropertyOldScaleFactorKey: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbackingpropertyoldcolorspacekey?language=objc)
    pub static NSBackingPropertyOldColorSpaceKey: &'static NSString;
}

extern "C" {
    /// `NSWindowDidChangeScreenProfileNotification`is posted when a window's display's color profile changes, or when the window moves to a display that has a different color profile.  When running on 10.7.3 or later, this notification is still posted for compatibility, but modern applications should instead watch for
    /// `NSWindowDidChangeBackingPropertiesNotification,`which is posted for both color space and resolution changes, and facilitates handling both in a single update and redisplay pass.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidchangescreenprofilenotification?language=objc)
    pub static NSWindowDidChangeScreenProfileNotification: &'static NSNotificationName;
}

extern "C" {
    /// `NSWindowWillStartLiveResizeNotification`is sent when the user starts a live resize operation via a mouseDown in the resize corner.  The notification will be sent before the window size is changed.  Note that this notification is sent once for a sequence of window resize operations
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowwillstartliveresizenotification?language=objc)
    pub static NSWindowWillStartLiveResizeNotification: &'static NSNotificationName;
}

extern "C" {
    /// `NSWindowDidEndLiveResizeNotification`is sent after the user ends a live resize operation via a mouseUp in the resize corner.  The notification will be sent after the final window size change.    Note that this notification is sent once for a sequence of window resize operations
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidendliveresizenotification?language=objc)
    pub static NSWindowDidEndLiveResizeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowwillenterfullscreennotification?language=objc)
    pub static NSWindowWillEnterFullScreenNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidenterfullscreennotification?language=objc)
    pub static NSWindowDidEnterFullScreenNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowwillexitfullscreennotification?language=objc)
    pub static NSWindowWillExitFullScreenNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidexitfullscreennotification?language=objc)
    pub static NSWindowDidExitFullScreenNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowwillenterversionbrowsernotification?language=objc)
    pub static NSWindowWillEnterVersionBrowserNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidenterversionbrowsernotification?language=objc)
    pub static NSWindowDidEnterVersionBrowserNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowwillexitversionbrowsernotification?language=objc)
    pub static NSWindowWillExitVersionBrowserNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidexitversionbrowsernotification?language=objc)
    pub static NSWindowDidExitVersionBrowserNotification: &'static NSNotificationName;
}

extern "C" {
    /// Upon receiving this notification, you can query the
    /// `NSWindow`for its current occlusion state. Note that this only notifies about changes in the state of the occlusion, not when the occlusion region changes. You can use this notification to increase responsiveness and save power, by halting any expensive calculations that the user can not see.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowdidchangeocclusionstatenotification?language=objc)
    pub static NSWindowDidChangeOcclusionStateNotification: &'static NSNotificationName;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowbackinglocation?language=objc)
// NS_ENUM
#[deprecated]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSWindowBackingLocation(pub NSUInteger);
impl NSWindowBackingLocation {
    #[doc(alias = "NSWindowBackingLocationDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "NSWindowBackingLocationVideoMemory")]
    pub const VideoMemory: Self = Self(1);
    #[doc(alias = "NSWindowBackingLocationMainMemory")]
    pub const MainMemory: Self = Self(2);
}

unsafe impl Encode for NSWindowBackingLocation {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSWindowBackingLocation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// NSDeprecated.
#[cfg(feature = "NSResponder")]
impl NSWindow {
    extern_methods!(
        #[deprecated = "This method shouldn’t be used as it doesn’t work in all drawing situations; instead, a subview should be used that implements the desired drawing behavior"]
        #[unsafe(method(cacheImageInRect:))]
        #[unsafe(method_family = none)]
        pub fn cacheImageInRect(&self, rect: NSRect);

        #[deprecated = "This method shouldn’t be used as it doesn’t work in all drawing situations; instead, a subview should be used that implements the desired drawing behavior"]
        #[unsafe(method(restoreCachedImage))]
        #[unsafe(method_family = none)]
        pub fn restoreCachedImage(&self);

        #[deprecated = "This method shouldn’t be used as it doesn’t work in all drawing situations; instead, a subview should be used that implements the desired drawing behavior"]
        #[unsafe(method(discardCachedImage))]
        #[unsafe(method_family = none)]
        pub fn discardCachedImage(&self);

        #[cfg(feature = "NSMenu")]
        #[deprecated = "This method does not do anything and should not be called."]
        #[unsafe(method(menuChanged:))]
        #[unsafe(method_family = none)]
        pub fn menuChanged(menu: &NSMenu);

        #[deprecated = "This method is unused and should not be called."]
        #[unsafe(method(gState))]
        #[unsafe(method_family = none)]
        pub fn gState(&self) -> NSInteger;

        #[deprecated = "Use -convertRectToScreen: or -convertPointToScreen: instead"]
        #[unsafe(method(convertBaseToScreen:))]
        #[unsafe(method_family = none)]
        pub fn convertBaseToScreen(&self, point: NSPoint) -> NSPoint;

        #[deprecated = "Use -convertRectFromScreen or -convertPointFromScreen: instead"]
        #[unsafe(method(convertScreenToBase:))]
        #[unsafe(method_family = none)]
        pub fn convertScreenToBase(&self, point: NSPoint) -> NSPoint;

        #[cfg(feature = "objc2-core-foundation")]
        #[deprecated = "Use -convertRectToBacking: and -backingScaleFactor instead"]
        #[unsafe(method(userSpaceScaleFactor))]
        #[unsafe(method_family = none)]
        pub fn userSpaceScaleFactor(&self) -> CGFloat;

        #[deprecated = "This method does not do anything and should not be called."]
        #[unsafe(method(useOptimizedDrawing:))]
        #[unsafe(method_family = none)]
        pub fn useOptimizedDrawing(&self, flag: bool);

        #[deprecated = "This method does not do anything and should not be called."]
        #[unsafe(method(canStoreColor))]
        #[unsafe(method_family = none)]
        pub fn canStoreColor(&self) -> bool;

        #[deprecated = "Use +[NSAnimationContext runAnimationGroup:completionHandler:] to perform atomic updates across runloop invocations."]
        #[unsafe(method(disableFlushWindow))]
        #[unsafe(method_family = none)]
        pub fn disableFlushWindow(&self);

        #[deprecated = "Use +[NSAnimationContext runAnimationGroup:completionHandler:] to perform atomic updates across runloop invocations."]
        #[unsafe(method(enableFlushWindow))]
        #[unsafe(method_family = none)]
        pub fn enableFlushWindow(&self);

        #[deprecated = "Use +[NSAnimationContext runAnimationGroup:completionHandler:] to perform atomic updates across runloop invocations."]
        #[unsafe(method(isFlushWindowDisabled))]
        #[unsafe(method_family = none)]
        pub fn isFlushWindowDisabled(&self) -> bool;

        #[deprecated = "Allow AppKit's automatic deferred display mechanism to take care of flushing any graphics contexts as needed."]
        #[unsafe(method(flushWindow))]
        #[unsafe(method_family = none)]
        pub fn flushWindow(&self);

        #[deprecated = "Allow AppKit's automatic deferred display mechanism to take care of flushing any graphics contexts as needed."]
        #[unsafe(method(flushWindowIfNeeded))]
        #[unsafe(method_family = none)]
        pub fn flushWindowIfNeeded(&self);

        #[deprecated = "Use +[NSAnimationContext runAnimationGroup:completionHandler:] to temporarily prevent AppKit's automatic deferred display mechanism from drawing."]
        #[unsafe(method(isAutodisplay))]
        #[unsafe(method_family = none)]
        pub fn isAutodisplay(&self) -> bool;

        /// Setter for [`isAutodisplay`][Self::isAutodisplay].
        #[deprecated = "Use +[NSAnimationContext runAnimationGroup:completionHandler:] to temporarily prevent AppKit's automatic deferred display mechanism from drawing."]
        #[unsafe(method(setAutodisplay:))]
        #[unsafe(method_family = none)]
        pub fn setAutodisplay(&self, autodisplay: bool);

        #[cfg(feature = "NSGraphicsContext")]
        #[deprecated = "Add instances of NSView to display content in a window."]
        #[unsafe(method(graphicsContext))]
        #[unsafe(method_family = none)]
        pub fn graphicsContext(&self) -> Option<Retained<NSGraphicsContext>>;

        #[deprecated = "This property does not do anything and should not be used"]
        #[unsafe(method(isOneShot))]
        #[unsafe(method_family = none)]
        pub fn isOneShot(&self) -> bool;

        /// Setter for [`isOneShot`][Self::isOneShot].
        #[deprecated = "This property does not do anything and should not be used"]
        #[unsafe(method(setOneShot:))]
        #[unsafe(method_family = none)]
        pub fn setOneShot(&self, one_shot: bool);

        #[deprecated = "This property does not do anything and should not be used"]
        #[unsafe(method(preferredBackingLocation))]
        #[unsafe(method_family = none)]
        pub fn preferredBackingLocation(&self) -> NSWindowBackingLocation;

        /// Setter for [`preferredBackingLocation`][Self::preferredBackingLocation].
        #[deprecated = "This property does not do anything and should not be used"]
        #[unsafe(method(setPreferredBackingLocation:))]
        #[unsafe(method_family = none)]
        pub fn setPreferredBackingLocation(
            &self,
            preferred_backing_location: NSWindowBackingLocation,
        );

        #[deprecated = "This property does not do anything and should not be used"]
        #[unsafe(method(backingLocation))]
        #[unsafe(method_family = none)]
        pub fn backingLocation(&self) -> NSWindowBackingLocation;

        #[deprecated = "This property does not do anything and should not be used."]
        #[unsafe(method(showsResizeIndicator))]
        #[unsafe(method_family = none)]
        pub fn showsResizeIndicator(&self) -> bool;

        /// Setter for [`showsResizeIndicator`][Self::showsResizeIndicator].
        #[deprecated = "This property does not do anything and should not be used."]
        #[unsafe(method(setShowsResizeIndicator:))]
        #[unsafe(method_family = none)]
        pub fn setShowsResizeIndicator(&self, shows_resize_indicator: bool);

        /// # Safety
        ///
        /// `window_ref` must be a valid pointer.
        #[deprecated = "This method should not be used."]
        #[unsafe(method(initWithWindowRef:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithWindowRef(
            this: Allocated<Self>,
            window_ref: NonNull<c_void>,
        ) -> Option<Retained<NSWindow>>;

        #[deprecated = "This method should not be used."]
        #[unsafe(method(windowRef))]
        #[unsafe(method_family = none)]
        pub fn windowRef(&self) -> NonNull<c_void>;

        #[deprecated = "This method does not do anything and should not be called."]
        #[unsafe(method(disableScreenUpdatesUntilFlush))]
        #[unsafe(method_family = none)]
        pub fn disableScreenUpdatesUntilFlush(&self);
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsborderlesswindowmask?language=objc)
#[deprecated]
pub static NSBorderlessWindowMask: NSWindowStyleMask =
    NSWindowStyleMask(NSWindowStyleMask::Borderless.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstitledwindowmask?language=objc)
#[deprecated]
pub static NSTitledWindowMask: NSWindowStyleMask = NSWindowStyleMask(NSWindowStyleMask::Titled.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsclosablewindowmask?language=objc)
#[deprecated]
pub static NSClosableWindowMask: NSWindowStyleMask =
    NSWindowStyleMask(NSWindowStyleMask::Closable.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsminiaturizablewindowmask?language=objc)
#[deprecated]
pub static NSMiniaturizableWindowMask: NSWindowStyleMask =
    NSWindowStyleMask(NSWindowStyleMask::Miniaturizable.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsresizablewindowmask?language=objc)
#[deprecated]
pub static NSResizableWindowMask: NSWindowStyleMask =
    NSWindowStyleMask(NSWindowStyleMask::Resizable.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstexturedbackgroundwindowmask?language=objc)
#[deprecated]
pub static NSTexturedBackgroundWindowMask: NSWindowStyleMask =
    NSWindowStyleMask(NSWindowStyleMask::TexturedBackground.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsunifiedtitleandtoolbarwindowmask?language=objc)
#[deprecated]
pub static NSUnifiedTitleAndToolbarWindowMask: NSWindowStyleMask =
    NSWindowStyleMask(NSWindowStyleMask::UnifiedTitleAndToolbar.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfullscreenwindowmask?language=objc)
#[deprecated]
pub static NSFullScreenWindowMask: NSWindowStyleMask =
    NSWindowStyleMask(NSWindowStyleMask::FullScreen.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfullsizecontentviewwindowmask?language=objc)
#[deprecated]
pub static NSFullSizeContentViewWindowMask: NSWindowStyleMask =
    NSWindowStyleMask(NSWindowStyleMask::FullSizeContentView.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsutilitywindowmask?language=objc)
#[deprecated]
pub static NSUtilityWindowMask: NSWindowStyleMask =
    NSWindowStyleMask(NSWindowStyleMask::UtilityWindow.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdocmodalwindowmask?language=objc)
#[deprecated]
pub static NSDocModalWindowMask: NSWindowStyleMask =
    NSWindowStyleMask(NSWindowStyleMask::DocModalWindow.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsnonactivatingpanelmask?language=objc)
#[deprecated]
pub static NSNonactivatingPanelMask: NSWindowStyleMask =
    NSWindowStyleMask(NSWindowStyleMask::NonactivatingPanel.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nshudwindowmask?language=objc)
#[deprecated]
pub static NSHUDWindowMask: NSWindowStyleMask = NSWindowStyleMask(NSWindowStyleMask::HUDWindow.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsunscaledwindowmask?language=objc)
#[deprecated = "NSUnscaledWindowMask is deprecated and has no effect. The scale factor for a window backing store is dynamic and dependent on the screen it is placed on."]
pub static NSUnscaledWindowMask: NSWindowStyleMask = NSWindowStyleMask(1 << 11);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowfullscreenbutton?language=objc)
#[deprecated = "The standard window button for NSWindowFullScreenButton is always nil; use NSWindowZoomButton instead"]
pub static NSWindowFullScreenButton: NSWindowButton = NSWindowButton(7);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdockwindowlevel?language=objc)
#[deprecated]
pub static NSDockWindowLevel: NSWindowLevel = 20;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswindowsharingreadwrite?language=objc)
#[deprecated = "Use NSWindowSharingReadOnly instead"]
pub static NSWindowSharingReadWrite: NSWindowSharingType = NSWindowSharingType(2);
