/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.plan;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerSerialInfo;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerSerializable;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractExecutionPlanSerializer
implements DBCQueryPlannerSerializable {
    public static final String PROP_DESC = "desc";
    public static final String PROP_COND = "cond";
    public static final String PROP_TYPE = "type";
    public static final String PROP_KIND = "kind";
    public static final String PROP_NAME = "name";
    public static final String PROP_DATE = "date";
    public static final String PROP_SIGNATURE = "signature";
    public static final String PROP_VERSION = "version";
    public static final String PROP_SQL = "sql";
    public static final String PROP_CHILD = "child";
    public static final String PROP_NODES = "root";
    public static final String PROP_ATTRIBUTES = "attributes";
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    private JsonElement serializeNode(DBCPlanNode node, DBCQueryPlannerSerialInfo info) {
        JsonObject nodeJson = new JsonObject();
        nodeJson.add(PROP_NAME, (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)node.getNodeName())));
        nodeJson.add(PROP_KIND, (JsonElement)(node.getNodeKind() == null ? new JsonPrimitive("") : new JsonPrimitive(CommonUtils.notEmpty((String)node.getNodeKind().getTitle()))));
        nodeJson.add(PROP_TYPE, (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)node.getNodeType())));
        nodeJson.add(PROP_COND, (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)node.getNodeCondition())));
        nodeJson.add(PROP_DESC, (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)node.getNodeDescription())));
        info.addNodeProperties(node, nodeJson);
        if (!CommonUtils.isEmpty(node.getNested())) {
            JsonArray nodes = new JsonArray();
            for (DBCPlanNode dBCPlanNode : node.getNested()) {
                nodes.add(this.serializeNode(dBCPlanNode, info));
            }
            nodeJson.add(PROP_CHILD, (JsonElement)nodes);
        }
        return nodeJson;
    }

    protected void serializeJson(Writer writer, DBCPlan plan, String signature, DBCQueryPlannerSerialInfo info) throws IOException {
        JsonObject root = new JsonObject();
        root.add(PROP_VERSION, (JsonElement)new JsonPrimitive(info.version()));
        root.add(PROP_SIGNATURE, (JsonElement)new JsonPrimitive(signature));
        root.add(PROP_DATE, (JsonElement)new JsonPrimitive(LocalDateTime.now().toString()));
        root.add(PROP_SQL, (JsonElement)new JsonPrimitive(plan.getQueryString()));
        JsonArray nodes = new JsonArray();
        for (DBCPlanNode dBCPlanNode : plan.getPlanNodes(null)) {
            nodes.add(this.serializeNode(dBCPlanNode, info));
        }
        root.add(PROP_NODES, (JsonElement)nodes);
        writer.write(gson.toJson((JsonElement)root));
    }

    protected String getVersion(@NotNull JsonObject o) throws InvocationTargetException {
        JsonElement queryElement = o.get(PROP_VERSION);
        if (queryElement == null) {
            throw new InvocationTargetException(new Exception("Incorrect file format"));
        }
        return queryElement.getAsString();
    }

    protected String getQuery(@NotNull JsonObject o) throws InvocationTargetException {
        JsonElement queryElement = o.get(PROP_SQL);
        if (queryElement == null) {
            throw new InvocationTargetException(new Exception("Incorrect file format"));
        }
        return queryElement.getAsString();
    }

    protected Map<String, Object> getNodeAttributes(@NotNull JsonObject nodeObject) {
        HashMap<String, Object> attributes;
        block4: {
            JsonElement attrs;
            block3: {
                attributes = new HashMap<String, Object>();
                attrs = nodeObject.get(PROP_ATTRIBUTES);
                if (!(attrs instanceof JsonArray)) break block3;
                for (JsonElement attr : (JsonArray)attrs) {
                    for (Map.Entry p : attr.getAsJsonObject().entrySet()) {
                        attributes.put((String)p.getKey(), p.getValue());
                    }
                }
                break block4;
            }
            if (!(attrs instanceof JsonObject)) break block4;
            for (Map.Entry p : ((JsonObject)attrs).entrySet()) {
                attributes.put((String)p.getKey(), p.getValue());
            }
        }
        return attributes;
    }

    protected Map<String, String> getNodeAttributesAsStrings(@NotNull JsonObject nodeObject) {
        HashMap<String, String> attributes;
        block4: {
            JsonElement attrs;
            block3: {
                attributes = new HashMap<String, String>();
                attrs = nodeObject.get(PROP_ATTRIBUTES);
                if (!(attrs instanceof JsonArray)) break block3;
                for (JsonElement attr : (JsonArray)attrs) {
                    for (Map.Entry p : attr.getAsJsonObject().entrySet()) {
                        attributes.put((String)p.getKey(), ((JsonElement)p.getValue()).getAsString());
                    }
                }
                break block4;
            }
            if (!(attrs instanceof JsonObject)) break block4;
            for (Map.Entry p : ((JsonObject)attrs).entrySet()) {
                attributes.put((String)p.getKey(), ((JsonElement)p.getValue()).getAsString());
            }
        }
        return attributes;
    }
}

