// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by sidekick. DO NOT EDIT.

#[allow(unused_imports)]
use super::*;

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::ErrorInfo {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __reason,
            __domain,
            __metadata,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for ErrorInfo")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "reason" => Ok(__FieldTag::__reason),
                            "domain" => Ok(__FieldTag::__domain),
                            "metadata" => Ok(__FieldTag::__metadata),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::ErrorInfo;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct ErrorInfo")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__reason => {
                            if !fields.insert(__FieldTag::__reason) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for reason",
                                ));
                            }
                            result.reason = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__domain => {
                            if !fields.insert(__FieldTag::__domain) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for domain",
                                ));
                            }
                            result.domain = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__metadata => {
                            if !fields.insert(__FieldTag::__metadata) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for metadata",
                                ));
                            }
                            result.metadata = map
                                .next_value::<std::option::Option<
                                    std::collections::HashMap<
                                        std::string::String,
                                        std::string::String,
                                    >,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::RetryInfo {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __retry_delay,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for RetryInfo")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "retryDelay" => Ok(__FieldTag::__retry_delay),
                            "retry_delay" => Ok(__FieldTag::__retry_delay),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::RetryInfo;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct RetryInfo")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__retry_delay => {
                            if !fields.insert(__FieldTag::__retry_delay) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for retry_delay",
                                ));
                            }
                            result.retry_delay =
                                map.next_value::<std::option::Option<wkt::Duration>>()?;
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::DebugInfo {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __stack_entries,
            __detail,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for DebugInfo")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "stackEntries" => Ok(__FieldTag::__stack_entries),
                            "stack_entries" => Ok(__FieldTag::__stack_entries),
                            "detail" => Ok(__FieldTag::__detail),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::DebugInfo;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct DebugInfo")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__stack_entries => {
                            if !fields.insert(__FieldTag::__stack_entries) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for stack_entries",
                                ));
                            }
                            result.stack_entries = map.next_value::<std::option::Option<std::vec::Vec<std::string::String>>>()?.unwrap_or_default();
                        }
                        __FieldTag::__detail => {
                            if !fields.insert(__FieldTag::__detail) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for detail",
                                ));
                            }
                            result.detail = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::QuotaFailure {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __violations,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for QuotaFailure")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "violations" => Ok(__FieldTag::__violations),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::QuotaFailure;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct QuotaFailure")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__violations => {
                            if !fields.insert(__FieldTag::__violations) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for violations",
                                ));
                            }
                            result.violations = map
                                .next_value::<std::option::Option<
                                    std::vec::Vec<crate::model::quota_failure::Violation>,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::quota_failure::Violation {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __subject,
            __description,
            __api_service,
            __quota_metric,
            __quota_id,
            __quota_dimensions,
            __quota_value,
            __future_quota_value,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for Violation")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "subject" => Ok(__FieldTag::__subject),
                            "description" => Ok(__FieldTag::__description),
                            "apiService" => Ok(__FieldTag::__api_service),
                            "api_service" => Ok(__FieldTag::__api_service),
                            "quotaMetric" => Ok(__FieldTag::__quota_metric),
                            "quota_metric" => Ok(__FieldTag::__quota_metric),
                            "quotaId" => Ok(__FieldTag::__quota_id),
                            "quota_id" => Ok(__FieldTag::__quota_id),
                            "quotaDimensions" => Ok(__FieldTag::__quota_dimensions),
                            "quota_dimensions" => Ok(__FieldTag::__quota_dimensions),
                            "quotaValue" => Ok(__FieldTag::__quota_value),
                            "quota_value" => Ok(__FieldTag::__quota_value),
                            "futureQuotaValue" => Ok(__FieldTag::__future_quota_value),
                            "future_quota_value" => Ok(__FieldTag::__future_quota_value),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::quota_failure::Violation;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct Violation")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__subject => {
                            if !fields.insert(__FieldTag::__subject) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for subject",
                                ));
                            }
                            result.subject = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__description => {
                            if !fields.insert(__FieldTag::__description) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for description",
                                ));
                            }
                            result.description = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__api_service => {
                            if !fields.insert(__FieldTag::__api_service) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for api_service",
                                ));
                            }
                            result.api_service = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__quota_metric => {
                            if !fields.insert(__FieldTag::__quota_metric) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for quota_metric",
                                ));
                            }
                            result.quota_metric = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__quota_id => {
                            if !fields.insert(__FieldTag::__quota_id) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for quota_id",
                                ));
                            }
                            result.quota_id = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__quota_dimensions => {
                            if !fields.insert(__FieldTag::__quota_dimensions) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for quota_dimensions",
                                ));
                            }
                            result.quota_dimensions = map
                                .next_value::<std::option::Option<
                                    std::collections::HashMap<
                                        std::string::String,
                                        std::string::String,
                                    >,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__quota_value => {
                            if !fields.insert(__FieldTag::__quota_value) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for quota_value",
                                ));
                            }
                            struct __With(std::option::Option<i64>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I64> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.quota_value = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__future_quota_value => {
                            if !fields.insert(__FieldTag::__future_quota_value) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for future_quota_value",
                                ));
                            }
                            struct __With(std::option::Option<i64>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I64> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.future_quota_value = map.next_value::<__With>()?.0;
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::PreconditionFailure {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __violations,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for PreconditionFailure")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "violations" => Ok(__FieldTag::__violations),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::PreconditionFailure;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct PreconditionFailure")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__violations => {
                            if !fields.insert(__FieldTag::__violations) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for violations",
                                ));
                            }
                            result.violations = map
                                .next_value::<std::option::Option<
                                    std::vec::Vec<crate::model::precondition_failure::Violation>,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::precondition_failure::Violation {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __type,
            __subject,
            __description,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for Violation")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "type" => Ok(__FieldTag::__type),
                            "subject" => Ok(__FieldTag::__subject),
                            "description" => Ok(__FieldTag::__description),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::precondition_failure::Violation;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct Violation")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__type => {
                            if !fields.insert(__FieldTag::__type) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for type",
                                ));
                            }
                            result.r#type = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__subject => {
                            if !fields.insert(__FieldTag::__subject) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for subject",
                                ));
                            }
                            result.subject = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__description => {
                            if !fields.insert(__FieldTag::__description) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for description",
                                ));
                            }
                            result.description = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::BadRequest {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __field_violations,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for BadRequest")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "fieldViolations" => Ok(__FieldTag::__field_violations),
                            "field_violations" => Ok(__FieldTag::__field_violations),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::BadRequest;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct BadRequest")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__field_violations => {
                            if !fields.insert(__FieldTag::__field_violations) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for field_violations",
                                ));
                            }
                            result.field_violations = map
                                .next_value::<std::option::Option<
                                    std::vec::Vec<crate::model::bad_request::FieldViolation>,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::bad_request::FieldViolation {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __field,
            __description,
            __reason,
            __localized_message,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for FieldViolation")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "field" => Ok(__FieldTag::__field),
                            "description" => Ok(__FieldTag::__description),
                            "reason" => Ok(__FieldTag::__reason),
                            "localizedMessage" => Ok(__FieldTag::__localized_message),
                            "localized_message" => Ok(__FieldTag::__localized_message),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::bad_request::FieldViolation;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct FieldViolation")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__field => {
                            if !fields.insert(__FieldTag::__field) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for field",
                                ));
                            }
                            result.field = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__description => {
                            if !fields.insert(__FieldTag::__description) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for description",
                                ));
                            }
                            result.description = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__reason => {
                            if !fields.insert(__FieldTag::__reason) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for reason",
                                ));
                            }
                            result.reason = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__localized_message => {
                            if !fields.insert(__FieldTag::__localized_message) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for localized_message",
                                ));
                            }
                            result.localized_message = map
                                .next_value::<std::option::Option<crate::model::LocalizedMessage>>(
                                )?;
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::RequestInfo {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __request_id,
            __serving_data,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for RequestInfo")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "requestId" => Ok(__FieldTag::__request_id),
                            "request_id" => Ok(__FieldTag::__request_id),
                            "servingData" => Ok(__FieldTag::__serving_data),
                            "serving_data" => Ok(__FieldTag::__serving_data),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::RequestInfo;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct RequestInfo")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__request_id => {
                            if !fields.insert(__FieldTag::__request_id) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for request_id",
                                ));
                            }
                            result.request_id = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__serving_data => {
                            if !fields.insert(__FieldTag::__serving_data) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for serving_data",
                                ));
                            }
                            result.serving_data = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::ResourceInfo {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __resource_type,
            __resource_name,
            __owner,
            __description,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for ResourceInfo")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "resourceType" => Ok(__FieldTag::__resource_type),
                            "resource_type" => Ok(__FieldTag::__resource_type),
                            "resourceName" => Ok(__FieldTag::__resource_name),
                            "resource_name" => Ok(__FieldTag::__resource_name),
                            "owner" => Ok(__FieldTag::__owner),
                            "description" => Ok(__FieldTag::__description),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::ResourceInfo;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct ResourceInfo")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__resource_type => {
                            if !fields.insert(__FieldTag::__resource_type) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for resource_type",
                                ));
                            }
                            result.resource_type = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__resource_name => {
                            if !fields.insert(__FieldTag::__resource_name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for resource_name",
                                ));
                            }
                            result.resource_name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__owner => {
                            if !fields.insert(__FieldTag::__owner) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for owner",
                                ));
                            }
                            result.owner = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__description => {
                            if !fields.insert(__FieldTag::__description) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for description",
                                ));
                            }
                            result.description = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::Help {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __links,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for Help")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "links" => Ok(__FieldTag::__links),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::Help;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct Help")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__links => {
                            if !fields.insert(__FieldTag::__links) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for links",
                                ));
                            }
                            result.links = map.next_value::<std::option::Option<std::vec::Vec<crate::model::help::Link>>>()?.unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::help::Link {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __description,
            __url,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for Link")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "description" => Ok(__FieldTag::__description),
                            "url" => Ok(__FieldTag::__url),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::help::Link;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct Link")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__description => {
                            if !fields.insert(__FieldTag::__description) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for description",
                                ));
                            }
                            result.description = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__url => {
                            if !fields.insert(__FieldTag::__url) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for url",
                                ));
                            }
                            result.url = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::LocalizedMessage {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __locale,
            __message,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for LocalizedMessage")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "locale" => Ok(__FieldTag::__locale),
                            "message" => Ok(__FieldTag::__message),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::LocalizedMessage;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct LocalizedMessage")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__locale => {
                            if !fields.insert(__FieldTag::__locale) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for locale",
                                ));
                            }
                            result.locale = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__message => {
                            if !fields.insert(__FieldTag::__message) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for message",
                                ));
                            }
                            result.message = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::HttpRequest {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __method,
            __uri,
            __headers,
            __body,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for HttpRequest")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "method" => Ok(__FieldTag::__method),
                            "uri" => Ok(__FieldTag::__uri),
                            "headers" => Ok(__FieldTag::__headers),
                            "body" => Ok(__FieldTag::__body),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::HttpRequest;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct HttpRequest")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__method => {
                            if !fields.insert(__FieldTag::__method) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for method",
                                ));
                            }
                            result.method = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__uri => {
                            if !fields.insert(__FieldTag::__uri) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for uri",
                                ));
                            }
                            result.uri = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__headers => {
                            if !fields.insert(__FieldTag::__headers) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for headers",
                                ));
                            }
                            result.headers = map.next_value::<std::option::Option<std::vec::Vec<crate::model::HttpHeader>>>()?.unwrap_or_default();
                        }
                        __FieldTag::__body => {
                            if !fields.insert(__FieldTag::__body) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for body",
                                ));
                            }
                            struct __With(std::option::Option<::bytes::Bytes>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<serde_with::base64::Base64> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.body = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::HttpResponse {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __status,
            __reason,
            __headers,
            __body,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for HttpResponse")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "status" => Ok(__FieldTag::__status),
                            "reason" => Ok(__FieldTag::__reason),
                            "headers" => Ok(__FieldTag::__headers),
                            "body" => Ok(__FieldTag::__body),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::HttpResponse;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct HttpResponse")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__status => {
                            if !fields.insert(__FieldTag::__status) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for status",
                                ));
                            }
                            struct __With(std::option::Option<i32>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I32> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.status = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__reason => {
                            if !fields.insert(__FieldTag::__reason) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for reason",
                                ));
                            }
                            result.reason = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__headers => {
                            if !fields.insert(__FieldTag::__headers) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for headers",
                                ));
                            }
                            result.headers = map.next_value::<std::option::Option<std::vec::Vec<crate::model::HttpHeader>>>()?.unwrap_or_default();
                        }
                        __FieldTag::__body => {
                            if !fields.insert(__FieldTag::__body) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for body",
                                ));
                            }
                            struct __With(std::option::Option<::bytes::Bytes>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<serde_with::base64::Base64> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.body = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::HttpHeader {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __key,
            __value,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for HttpHeader")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "key" => Ok(__FieldTag::__key),
                            "value" => Ok(__FieldTag::__value),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::HttpHeader;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct HttpHeader")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__key => {
                            if !fields.insert(__FieldTag::__key) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for key",
                                ));
                            }
                            result.key = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__value => {
                            if !fields.insert(__FieldTag::__value) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for value",
                                ));
                            }
                            result.value = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::Status {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __code,
            __message,
            __details,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for Status")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "code" => Ok(__FieldTag::__code),
                            "message" => Ok(__FieldTag::__message),
                            "details" => Ok(__FieldTag::__details),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::Status;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct Status")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__code => {
                            if !fields.insert(__FieldTag::__code) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for code",
                                ));
                            }
                            struct __With(std::option::Option<i32>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I32> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.code = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__message => {
                            if !fields.insert(__FieldTag::__message) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for message",
                                ));
                            }
                            result.message = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__details => {
                            if !fields.insert(__FieldTag::__details) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for details",
                                ));
                            }
                            result.details = map
                                .next_value::<std::option::Option<std::vec::Vec<wkt::Any>>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}
