package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient is the the Azure SQL Database management API provides a
// RESTful set of web services that interact with Azure SQL Database services to manage your databases. The API enables
// you to create, retrieve, update, and delete databases.
type DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient struct {
	BaseClient
}

// NewDatabaseSQLVulnerabilityAssessmentRuleBaselinesClient creates an instance of the
// DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient client.
func NewDatabaseSQLVulnerabilityAssessmentRuleBaselinesClient(subscriptionID string) DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient {
	return NewDatabaseSQLVulnerabilityAssessmentRuleBaselinesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewDatabaseSQLVulnerabilityAssessmentRuleBaselinesClientWithBaseURI creates an instance of the
// DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient client using a custom endpoint.  Use this when interacting
// with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewDatabaseSQLVulnerabilityAssessmentRuleBaselinesClientWithBaseURI(baseURI string, subscriptionID string) DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient {
	return DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate creates or updates a database's vulnerability assessment rule baseline.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
// databaseName - the name of the database.
// ruleID - the vulnerability assessment rule ID.
// parameters - the requested rule baseline resource.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string, parameters DatabaseSQLVulnerabilityAssessmentRuleBaselineInput) (result DatabaseSQLVulnerabilityAssessmentRuleBaseline, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.DatabaseSQLVulnerabilityAssessmentRuleBaselineInputProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.DatabaseSQLVulnerabilityAssessmentRuleBaselineInputProperties.LatestScan", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.DatabaseSQLVulnerabilityAssessmentRuleBaselineInputProperties.Results", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("sql.DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, serverName, databaseName, ruleID, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient", "CreateOrUpdate", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string, parameters DatabaseSQLVulnerabilityAssessmentRuleBaselineInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"baselineName":                autorest.Encode("path", "default"),
		"databaseName":                autorest.Encode("path", databaseName),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"ruleId":                      autorest.Encode("path", ruleID),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.SystemData = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules/{ruleId}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) CreateOrUpdateResponder(resp *http.Response) (result DatabaseSQLVulnerabilityAssessmentRuleBaseline, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete removes the database's vulnerability assessment rule baseline.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
// databaseName - the name of the database.
// ruleID - the vulnerability assessment rule ID.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, resourceGroupName, serverName, databaseName, ruleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) DeletePreparer(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"baselineName":                autorest.Encode("path", "default"),
		"databaseName":                autorest.Encode("path", databaseName),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"ruleId":                      autorest.Encode("path", ruleID),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules/{ruleId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets a database's sql vulnerability assessment rule baseline.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
// databaseName - the name of the database.
// ruleID - the vulnerability assessment rule ID.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string) (result DatabaseSQLVulnerabilityAssessmentRuleBaseline, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, serverName, databaseName, ruleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) GetPreparer(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"baselineName":                autorest.Encode("path", "default"),
		"databaseName":                autorest.Encode("path", databaseName),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"ruleId":                      autorest.Encode("path", ruleID),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules/{ruleId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) GetResponder(resp *http.Response) (result DatabaseSQLVulnerabilityAssessmentRuleBaseline, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByBaseline gets a list of database's sql vulnerability assessment rule baselines.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
// databaseName - the name of the database.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) ListByBaseline(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.ListByBaseline")
		defer func() {
			sc := -1
			if result.dsvarblr.Response.Response != nil {
				sc = result.dsvarblr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByBaselineNextResults
	req, err := client.ListByBaselinePreparer(ctx, resourceGroupName, serverName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient", "ListByBaseline", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByBaselineSender(req)
	if err != nil {
		result.dsvarblr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient", "ListByBaseline", resp, "Failure sending request")
		return
	}

	result.dsvarblr, err = client.ListByBaselineResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient", "ListByBaseline", resp, "Failure responding to request")
		return
	}
	if result.dsvarblr.hasNextLink() && result.dsvarblr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByBaselinePreparer prepares the ListByBaseline request.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) ListByBaselinePreparer(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"baselineName":                autorest.Encode("path", "default"),
		"databaseName":                autorest.Encode("path", databaseName),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByBaselineSender sends the ListByBaseline request. The method will close the
// http.Response Body if it receives an error.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) ListByBaselineSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByBaselineResponder handles the response to the ListByBaseline request. The method always
// closes the http.Response Body.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) ListByBaselineResponder(resp *http.Response) (result DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByBaselineNextResults retrieves the next set of results, if any.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) listByBaselineNextResults(ctx context.Context, lastResults DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult) (result DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult, err error) {
	req, err := lastResults.databaseSQLVulnerabilityAssessmentRuleBaselineListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient", "listByBaselineNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByBaselineSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient", "listByBaselineNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByBaselineResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient", "listByBaselineNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByBaselineComplete enumerates all values, automatically crossing page boundaries as required.
func (client DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient) ListByBaselineComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.ListByBaseline")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByBaseline(ctx, resourceGroupName, serverName, databaseName)
	return
}
