/* Capstone Disassembly Engine, https://www.capstone-engine.org */
/* By Nguyen Anh Quynh <aquynh@gmail.com>, 2013-2022, */
/*    Rot127 <unisono@quyllur.org> 2022-2024 */
/* Automatically generated file by Capstone's LLVM TableGen Disassembler Backend. */

/* LLVM-commit: <commit> */
/* LLVM-tag: <tag> */

/* Do not edit. */

/* Capstone's LLVM TableGen Backends: */
/* https://github.com/capstone-engine/llvm-capstone */

#include <capstone/platform.h>
#include "../../cs_priv.h"

/// getMnemonic - This method is automatically generated by tablegen
/// from the instruction set description.
static MnemonicBitsInfo getMnemonic(MCInst *MI, SStream *O) {
#ifndef CAPSTONE_DIET
  static const char AsmStrs[] = {
  /* 0 */ "sub1\t\0"
  /* 6 */ "sub2\t\0"
  /* 12 */ "sub3\t\0"
  /* 18 */ "ldb.ab\t\0"
  /* 26 */ "stb.ab\t\0"
  /* 34 */ "ld.ab\t\0"
  /* 41 */ "ldh.ab\t\0"
  /* 49 */ "sth.ab\t\0"
  /* 57 */ "ldb.di.ab\t\0"
  /* 68 */ "stb.di.ab\t\0"
  /* 79 */ "ld.di.ab\t\0"
  /* 89 */ "ldh.di.ab\t\0"
  /* 100 */ "sth.di.ab\t\0"
  /* 111 */ "st.di.ab\t\0"
  /* 121 */ "ldb.x.di.ab\t\0"
  /* 134 */ "ldh.x.di.ab\t\0"
  /* 147 */ "st.ab\t\0"
  /* 154 */ "ldb.x.ab\t\0"
  /* 164 */ "ldh.x.ab\t\0"
  /* 174 */ "ldb\t\0"
  /* 179 */ "stb\t\0"
  /* 184 */ "rsub\t\0"
  /* 190 */ "sexb\t\0"
  /* 196 */ "sbc\t\0"
  /* 201 */ "adc\t\0"
  /* 206 */ "add\t\0"
  /* 211 */ "ld\t\0"
  /* 215 */ "and\t\0"
  /* 220 */ "sub_s.ne\t\0"
  /* 230 */ "mov_s.ne\t\0"
  /* 240 */ "sub1.f\t\0"
  /* 248 */ "sub2.f\t\0"
  /* 256 */ "sub3.f\t\0"
  /* 264 */ "rsub.f\t\0"
  /* 272 */ "sexb.f\t\0"
  /* 280 */ "sbc.f\t\0"
  /* 287 */ "adc.f\t\0"
  /* 294 */ "add.f\t\0"
  /* 301 */ "and.f\t\0"
  /* 308 */ "normh.f\t\0"
  /* 317 */ "sexh.f\t\0"
  /* 325 */ "asl.f\t\0"
  /* 332 */ "norm.f\t\0"
  /* 340 */ "mpym.f\t\0"
  /* 348 */ "min.f\t\0"
  /* 355 */ "seteq.f\t\0"
  /* 364 */ "ror.f\t\0"
  /* 371 */ "xor.f\t\0"
  /* 378 */ "asr.f\t\0"
  /* 385 */ "lsr.f\t\0"
  /* 392 */ "ffs.f\t\0"
  /* 399 */ "fls.f\t\0"
  /* 406 */ "mpymu.f\t\0"
  /* 415 */ "mov.f\t\0"
  /* 422 */ "max.f\t\0"
  /* 429 */ "mpy.f\t\0"
  /* 436 */ "ldh\t\0"
  /* 441 */ "normh\t\0"
  /* 448 */ "sth\t\0"
  /* 453 */ "sexh\t\0"
  /* 459 */ "ldb.di\t\0"
  /* 467 */ "stb.di\t\0"
  /* 475 */ "ld.di\t\0"
  /* 482 */ "ldh.di\t\0"
  /* 490 */ "sth.di\t\0"
  /* 498 */ "st.di\t\0"
  /* 505 */ "ldb.x.di\t\0"
  /* 515 */ "ldh.x.di\t\0"
  /* 525 */ "j\t\0"
  /* 528 */ "bl\t\0"
  /* 532 */ "jl\t\0"
  /* 536 */ "asl\t\0"
  /* 541 */ "norm\t\0"
  /* 547 */ "mpym\t\0"
  /* 553 */ "min\t\0"
  /* 558 */ "cmp\t\0"
  /* 563 */ "seteq\t\0"
  /* 570 */ "lr\t\0"
  /* 574 */ "ror\t\0"
  /* 579 */ "xor\t\0"
  /* 584 */ "asr\t\0"
  /* 589 */ "lsr\t\0"
  /* 594 */ "add1_s\t\0"
  /* 602 */ "add2_s\t\0"
  /* 610 */ "add3_s\t\0"
  /* 618 */ "ldb_s\t\0"
  /* 625 */ "stb_s\t\0"
  /* 632 */ "extb_s\t\0"
  /* 640 */ "sub_s\t\0"
  /* 647 */ "sexb_s\t\0"
  /* 655 */ "bic_s\t\0"
  /* 662 */ "add_s\t\0"
  /* 669 */ "ld_s\t\0"
  /* 675 */ "and_s\t\0"
  /* 682 */ "bge_s\t\0"
  /* 689 */ "ble_s\t\0"
  /* 696 */ "bne_s\t\0"
  /* 703 */ "brne_s\t\0"
  /* 711 */ "leave_s\t\0"
  /* 720 */ "neg_s\t\0"
  /* 727 */ "ldh_s\t\0"
  /* 734 */ "push_s\t\0"
  /* 742 */ "sth_s\t\0"
  /* 749 */ "exth_s\t\0"
  /* 757 */ "sexh_s\t\0"
  /* 765 */ "ldi_s\t\0"
  /* 772 */ "ei_s\t\0"
  /* 778 */ "bhi_s\t\0"
  /* 785 */ "jli_s\t\0"
  /* 792 */ "bmsk_s\t\0"
  /* 800 */ "bl_s\t\0"
  /* 806 */ "asl_s\t\0"
  /* 813 */ "blo_s\t\0"
  /* 820 */ "trap_s\t\0"
  /* 828 */ "cmp_s\t\0"
  /* 835 */ "pop_s\t\0"
  /* 842 */ "beq_s\t\0"
  /* 849 */ "breq_s\t\0"
  /* 857 */ "enter_s\t\0"
  /* 866 */ "bclr_s\t\0"
  /* 874 */ "xor_s\t\0"
  /* 881 */ "asr_s\t\0"
  /* 888 */ "lsr_s\t\0"
  /* 895 */ "abs_s\t\0"
  /* 902 */ "bhs_s\t\0"
  /* 909 */ "bls_s\t\0"
  /* 916 */ "bset_s\t\0"
  /* 924 */ "bgt_s\t\0"
  /* 931 */ "blt_s\t\0"
  /* 938 */ "not_s\t\0"
  /* 945 */ "btst_s\t\0"
  /* 953 */ "mov_s\t\0"
  /* 960 */ "mpyuw_s\t\0"
  /* 969 */ "mpyw_s\t\0"
  /* 977 */ "mpy_s\t\0"
  /* 984 */ "ld_s.as\t\0"
  /* 993 */ "ffs\t\0"
  /* 998 */ "fls\t\0"
  /* 1003 */ "st\t\0"
  /* 1007 */ "mpymu\t\0"
  /* 1014 */ "mov\t\0"
  /* 1019 */ "ldb.aw\t\0"
  /* 1027 */ "stb.aw\t\0"
  /* 1035 */ "ld.aw\t\0"
  /* 1042 */ "ldh.aw\t\0"
  /* 1050 */ "sth.aw\t\0"
  /* 1058 */ "ldb.di.aw\t\0"
  /* 1069 */ "stb.di.aw\t\0"
  /* 1080 */ "ld.di.aw\t\0"
  /* 1090 */ "ldh.di.aw\t\0"
  /* 1101 */ "sth.di.aw\t\0"
  /* 1112 */ "st.di.aw\t\0"
  /* 1122 */ "ldb.x.di.aw\t\0"
  /* 1135 */ "ldh.x.di.aw\t\0"
  /* 1148 */ "st.aw\t\0"
  /* 1155 */ "ldb.x.aw\t\0"
  /* 1165 */ "ldh.x.aw\t\0"
  /* 1175 */ "ldb.x\t\0"
  /* 1182 */ "ldh.x\t\0"
  /* 1189 */ "ldh_s.x\t\0"
  /* 1198 */ "max\t\0"
  /* 1203 */ "mpy\t\0"
  /* 1208 */ "add_s\t0, \0"
  /* 1218 */ "mov_s\t0, \0"
  /* 1228 */ "add_s\t%r0, %gp, \0"
  /* 1245 */ "ldb_s\t%r0, [%gp, \0"
  /* 1263 */ "ld_s\t%r0, [%gp, \0"
  /* 1280 */ "ldh_s\t%r0, [%gp, \0"
  /* 1298 */ "st_s\t%r0, [%gp, \0"
  /* 1315 */ "ld_s\t%r1, [%gp, \0"
  /* 1332 */ "sub_s\t%sp, %sp, \0"
  /* 1349 */ "add_s\t%sp, %sp, \0"
  /* 1366 */ "# ADJCALLSTACKDOWN \0"
  /* 1386 */ "# ADJCALLSTACKUP \0"
  /* 1404 */ "STB_FAR \0"
  /* 1413 */ "STH_FAR \0"
  /* 1422 */ "ST_FAR \0"
  /* 1430 */ "pldfi \0"
  /* 1437 */ "error.ffs \0"
  /* 1448 */ "error.fls \0"
  /* 1459 */ "sub1.\0"
  /* 1465 */ "sub2.\0"
  /* 1471 */ "sub3.\0"
  /* 1477 */ "# XRay Function Patchable RET.\0"
  /* 1508 */ "rsub.\0"
  /* 1514 */ "sbc.\0"
  /* 1519 */ "adc.\0"
  /* 1524 */ "add.\0"
  /* 1529 */ "and.\0"
  /* 1534 */ "# XRay Typed Event Log.\0"
  /* 1558 */ "# XRay Custom Event Log.\0"
  /* 1583 */ "asl.\0"
  /* 1588 */ "mpym.\0"
  /* 1594 */ "min.\0"
  /* 1599 */ "seteq.\0"
  /* 1606 */ "# XRay Function Enter.\0"
  /* 1629 */ "ror.\0"
  /* 1634 */ "xor.\0"
  /* 1639 */ "asr.\0"
  /* 1644 */ "lsr.\0"
  /* 1649 */ "# XRay Tail Call Exit.\0"
  /* 1672 */ "# XRay Function Exit.\0"
  /* 1694 */ "mpymu.\0"
  /* 1701 */ "mov.\0"
  /* 1706 */ "max.\0"
  /* 1711 */ "mpy.\0"
  /* 1716 */ "LIFETIME_END\0"
  /* 1729 */ "PSEUDO_PROBE\0"
  /* 1742 */ "BUNDLE\0"
  /* 1749 */ "DBG_VALUE\0"
  /* 1759 */ "DBG_INSTR_REF\0"
  /* 1773 */ "DBG_PHI\0"
  /* 1781 */ "DBG_LABEL\0"
  /* 1791 */ "LIFETIME_START\0"
  /* 1806 */ "DBG_VALUE_LIST\0"
  /* 1821 */ "j_s.d\t[\0"
  /* 1829 */ "jl_s.d\t[\0"
  /* 1838 */ "j\t[\0"
  /* 1842 */ "jl\t[\0"
  /* 1847 */ "j_s\t[\0"
  /* 1853 */ "jl_s\t[\0"
  /* 1860 */ "j_s.d\t[%blink]\0"
  /* 1875 */ "jne_s\t[%blink]\0"
  /* 1890 */ "j_s\t[%blink]\0"
  /* 1903 */ "jeq_s\t[%blink]\0"
  /* 1918 */ "b\0"
  /* 1920 */ "push_s\t%blink\0"
  /* 1934 */ "pop_s\t%blink\0"
  /* 1947 */ "# FEntry call\0"
  /* 1961 */ "pbr\0"
  /* 1965 */ "swi_s\0"
  /* 1971 */ "brk_s\0"
  /* 1977 */ "unimp_s\0"
  /* 1985 */ "nop_s\0"
};
#endif // CAPSTONE_DIET

  static const uint32_t OpInfo0[] = {
    0U,	// PHI
    0U,	// INLINEASM
    0U,	// INLINEASM_BR
    0U,	// CFI_INSTRUCTION
    0U,	// EH_LABEL
    0U,	// GC_LABEL
    0U,	// ANNOTATION_LABEL
    0U,	// KILL
    0U,	// EXTRACT_SUBREG
    0U,	// INSERT_SUBREG
    0U,	// IMPLICIT_DEF
    0U,	// SUBREG_TO_REG
    0U,	// COPY_TO_REGCLASS
    1750U,	// DBG_VALUE
    1807U,	// DBG_VALUE_LIST
    1760U,	// DBG_INSTR_REF
    1774U,	// DBG_PHI
    1782U,	// DBG_LABEL
    0U,	// REG_SEQUENCE
    0U,	// COPY
    1743U,	// BUNDLE
    1792U,	// LIFETIME_START
    1717U,	// LIFETIME_END
    1730U,	// PSEUDO_PROBE
    0U,	// ARITH_FENCE
    0U,	// STACKMAP
    1948U,	// FENTRY_CALL
    0U,	// PATCHPOINT
    0U,	// LOAD_STACK_GUARD
    0U,	// PREALLOCATED_SETUP
    0U,	// PREALLOCATED_ARG
    0U,	// STATEPOINT
    0U,	// LOCAL_ESCAPE
    0U,	// FAULTING_OP
    0U,	// PATCHABLE_OP
    1607U,	// PATCHABLE_FUNCTION_ENTER
    1478U,	// PATCHABLE_RET
    1673U,	// PATCHABLE_FUNCTION_EXIT
    1650U,	// PATCHABLE_TAIL_CALL
    1559U,	// PATCHABLE_EVENT_CALL
    1535U,	// PATCHABLE_TYPED_EVENT_CALL
    0U,	// ICALL_BRANCH_FUNNEL
    0U,	// MEMBARRIER
    0U,	// JUMP_TABLE_DEBUG_INFO
    0U,	// G_ASSERT_SEXT
    0U,	// G_ASSERT_ZEXT
    0U,	// G_ASSERT_ALIGN
    0U,	// G_ADD
    0U,	// G_SUB
    0U,	// G_MUL
    0U,	// G_SDIV
    0U,	// G_UDIV
    0U,	// G_SREM
    0U,	// G_UREM
    0U,	// G_SDIVREM
    0U,	// G_UDIVREM
    0U,	// G_AND
    0U,	// G_OR
    0U,	// G_XOR
    0U,	// G_IMPLICIT_DEF
    0U,	// G_PHI
    0U,	// G_FRAME_INDEX
    0U,	// G_GLOBAL_VALUE
    0U,	// G_CONSTANT_POOL
    0U,	// G_EXTRACT
    0U,	// G_UNMERGE_VALUES
    0U,	// G_INSERT
    0U,	// G_MERGE_VALUES
    0U,	// G_BUILD_VECTOR
    0U,	// G_BUILD_VECTOR_TRUNC
    0U,	// G_CONCAT_VECTORS
    0U,	// G_PTRTOINT
    0U,	// G_INTTOPTR
    0U,	// G_BITCAST
    0U,	// G_FREEZE
    0U,	// G_CONSTANT_FOLD_BARRIER
    0U,	// G_INTRINSIC_FPTRUNC_ROUND
    0U,	// G_INTRINSIC_TRUNC
    0U,	// G_INTRINSIC_ROUND
    0U,	// G_INTRINSIC_LRINT
    0U,	// G_INTRINSIC_ROUNDEVEN
    0U,	// G_READCYCLECOUNTER
    0U,	// G_LOAD
    0U,	// G_SEXTLOAD
    0U,	// G_ZEXTLOAD
    0U,	// G_INDEXED_LOAD
    0U,	// G_INDEXED_SEXTLOAD
    0U,	// G_INDEXED_ZEXTLOAD
    0U,	// G_STORE
    0U,	// G_INDEXED_STORE
    0U,	// G_ATOMIC_CMPXCHG_WITH_SUCCESS
    0U,	// G_ATOMIC_CMPXCHG
    0U,	// G_ATOMICRMW_XCHG
    0U,	// G_ATOMICRMW_ADD
    0U,	// G_ATOMICRMW_SUB
    0U,	// G_ATOMICRMW_AND
    0U,	// G_ATOMICRMW_NAND
    0U,	// G_ATOMICRMW_OR
    0U,	// G_ATOMICRMW_XOR
    0U,	// G_ATOMICRMW_MAX
    0U,	// G_ATOMICRMW_MIN
    0U,	// G_ATOMICRMW_UMAX
    0U,	// G_ATOMICRMW_UMIN
    0U,	// G_ATOMICRMW_FADD
    0U,	// G_ATOMICRMW_FSUB
    0U,	// G_ATOMICRMW_FMAX
    0U,	// G_ATOMICRMW_FMIN
    0U,	// G_ATOMICRMW_UINC_WRAP
    0U,	// G_ATOMICRMW_UDEC_WRAP
    0U,	// G_FENCE
    0U,	// G_PREFETCH
    0U,	// G_BRCOND
    0U,	// G_BRINDIRECT
    0U,	// G_INVOKE_REGION_START
    0U,	// G_INTRINSIC
    0U,	// G_INTRINSIC_W_SIDE_EFFECTS
    0U,	// G_INTRINSIC_CONVERGENT
    0U,	// G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS
    0U,	// G_ANYEXT
    0U,	// G_TRUNC
    0U,	// G_CONSTANT
    0U,	// G_FCONSTANT
    0U,	// G_VASTART
    0U,	// G_VAARG
    0U,	// G_SEXT
    0U,	// G_SEXT_INREG
    0U,	// G_ZEXT
    0U,	// G_SHL
    0U,	// G_LSHR
    0U,	// G_ASHR
    0U,	// G_FSHL
    0U,	// G_FSHR
    0U,	// G_ROTR
    0U,	// G_ROTL
    0U,	// G_ICMP
    0U,	// G_FCMP
    0U,	// G_SELECT
    0U,	// G_UADDO
    0U,	// G_UADDE
    0U,	// G_USUBO
    0U,	// G_USUBE
    0U,	// G_SADDO
    0U,	// G_SADDE
    0U,	// G_SSUBO
    0U,	// G_SSUBE
    0U,	// G_UMULO
    0U,	// G_SMULO
    0U,	// G_UMULH
    0U,	// G_SMULH
    0U,	// G_UADDSAT
    0U,	// G_SADDSAT
    0U,	// G_USUBSAT
    0U,	// G_SSUBSAT
    0U,	// G_USHLSAT
    0U,	// G_SSHLSAT
    0U,	// G_SMULFIX
    0U,	// G_UMULFIX
    0U,	// G_SMULFIXSAT
    0U,	// G_UMULFIXSAT
    0U,	// G_SDIVFIX
    0U,	// G_UDIVFIX
    0U,	// G_SDIVFIXSAT
    0U,	// G_UDIVFIXSAT
    0U,	// G_FADD
    0U,	// G_FSUB
    0U,	// G_FMUL
    0U,	// G_FMA
    0U,	// G_FMAD
    0U,	// G_FDIV
    0U,	// G_FREM
    0U,	// G_FPOW
    0U,	// G_FPOWI
    0U,	// G_FEXP
    0U,	// G_FEXP2
    0U,	// G_FEXP10
    0U,	// G_FLOG
    0U,	// G_FLOG2
    0U,	// G_FLOG10
    0U,	// G_FLDEXP
    0U,	// G_FFREXP
    0U,	// G_FNEG
    0U,	// G_FPEXT
    0U,	// G_FPTRUNC
    0U,	// G_FPTOSI
    0U,	// G_FPTOUI
    0U,	// G_SITOFP
    0U,	// G_UITOFP
    0U,	// G_FABS
    0U,	// G_FCOPYSIGN
    0U,	// G_IS_FPCLASS
    0U,	// G_FCANONICALIZE
    0U,	// G_FMINNUM
    0U,	// G_FMAXNUM
    0U,	// G_FMINNUM_IEEE
    0U,	// G_FMAXNUM_IEEE
    0U,	// G_FMINIMUM
    0U,	// G_FMAXIMUM
    0U,	// G_GET_FPENV
    0U,	// G_SET_FPENV
    0U,	// G_RESET_FPENV
    0U,	// G_GET_FPMODE
    0U,	// G_SET_FPMODE
    0U,	// G_RESET_FPMODE
    0U,	// G_PTR_ADD
    0U,	// G_PTRMASK
    0U,	// G_SMIN
    0U,	// G_SMAX
    0U,	// G_UMIN
    0U,	// G_UMAX
    0U,	// G_ABS
    0U,	// G_LROUND
    0U,	// G_LLROUND
    0U,	// G_BR
    0U,	// G_BRJT
    0U,	// G_INSERT_VECTOR_ELT
    0U,	// G_EXTRACT_VECTOR_ELT
    0U,	// G_SHUFFLE_VECTOR
    0U,	// G_CTTZ
    0U,	// G_CTTZ_ZERO_UNDEF
    0U,	// G_CTLZ
    0U,	// G_CTLZ_ZERO_UNDEF
    0U,	// G_CTPOP
    0U,	// G_BSWAP
    0U,	// G_BITREVERSE
    0U,	// G_FCEIL
    0U,	// G_FCOS
    0U,	// G_FSIN
    0U,	// G_FSQRT
    0U,	// G_FFLOOR
    0U,	// G_FRINT
    0U,	// G_FNEARBYINT
    0U,	// G_ADDRSPACE_CAST
    0U,	// G_BLOCK_ADDR
    0U,	// G_JUMP_TABLE
    0U,	// G_DYN_STACKALLOC
    0U,	// G_STACKSAVE
    0U,	// G_STACKRESTORE
    0U,	// G_STRICT_FADD
    0U,	// G_STRICT_FSUB
    0U,	// G_STRICT_FMUL
    0U,	// G_STRICT_FDIV
    0U,	// G_STRICT_FREM
    0U,	// G_STRICT_FMA
    0U,	// G_STRICT_FSQRT
    0U,	// G_STRICT_FLDEXP
    0U,	// G_READ_REGISTER
    0U,	// G_WRITE_REGISTER
    0U,	// G_MEMCPY
    0U,	// G_MEMCPY_INLINE
    0U,	// G_MEMMOVE
    0U,	// G_MEMSET
    0U,	// G_BZERO
    0U,	// G_VECREDUCE_SEQ_FADD
    0U,	// G_VECREDUCE_SEQ_FMUL
    0U,	// G_VECREDUCE_FADD
    0U,	// G_VECREDUCE_FMUL
    0U,	// G_VECREDUCE_FMAX
    0U,	// G_VECREDUCE_FMIN
    0U,	// G_VECREDUCE_FMAXIMUM
    0U,	// G_VECREDUCE_FMINIMUM
    0U,	// G_VECREDUCE_ADD
    0U,	// G_VECREDUCE_MUL
    0U,	// G_VECREDUCE_AND
    0U,	// G_VECREDUCE_OR
    0U,	// G_VECREDUCE_XOR
    0U,	// G_VECREDUCE_SMAX
    0U,	// G_VECREDUCE_SMIN
    0U,	// G_VECREDUCE_UMAX
    0U,	// G_VECREDUCE_UMIN
    0U,	// G_SBFX
    0U,	// G_UBFX
    3415U,	// ADJCALLSTACKDOWN
    36203U,	// ADJCALLSTACKUP
    6058U,	// BRcc_rr_p
    6058U,	// BRcc_ru6_p
    3497U,	// CTLZ
    3486U,	// CTTZ
    3479U,	// GETFI
    527741U,	// STB_FAR
    527750U,	// STH_FAR
    527759U,	// ST_FAR
    1121776U,	// ADC_cc_f_rru6
    1154544U,	// ADC_cc_rru6
    4196640U,	// ADC_f_rrlimm
    4196640U,	// ADC_f_rrr
    4196640U,	// ADC_f_rrs12
    4196640U,	// ADC_f_rru6
    4196554U,	// ADC_rrlimm
    4196554U,	// ADC_rrr
    4196554U,	// ADC_rrs12
    4196554U,	// ADC_rru6
    1582265U,	// ADD_S_limms3
    22547095U,	// ADD_S_rlimm
    22547095U,	// ADD_S_rr
    4197015U,	// ADD_S_rrr
    4197015U,	// ADD_S_rru6
    22547095U,	// ADD_S_rs3
    4197015U,	// ADD_S_ru3
    22547095U,	// ADD_S_u7
    1121781U,	// ADD_cc_f_rru6
    1154549U,	// ADD_cc_rru6
    4196647U,	// ADD_f_rrlimm
    4196647U,	// ADD_f_rrr
    4196647U,	// ADD_f_rrs12
    4196647U,	// ADD_f_rru6
    4196559U,	// ADD_rrlimm
    4196559U,	// ADD_rrr
    4196559U,	// ADD_rrs12
    4196559U,	// ADD_rru6
    1121786U,	// AND_cc_f_rru6
    1154554U,	// AND_cc_rru6
    4196654U,	// AND_f_rrlimm
    4196654U,	// AND_f_rrr
    4196654U,	// AND_f_rrs12
    4196654U,	// AND_f_rru6
    4196568U,	// AND_rrlimm
    4196568U,	// AND_rrr
    4196568U,	// AND_rrs12
    4196568U,	// AND_rru6
    4197159U,	// ASL_S_ru3
    22547239U,	// ASL_S_ru5
    1121840U,	// ASL_cc_f_rru6
    1154608U,	// ASL_cc_rru6
    4196678U,	// ASL_f_rrlimm
    4196678U,	// ASL_f_rrr
    4196678U,	// ASL_f_rrs12
    4196678U,	// ASL_f_rru6
    4196889U,	// ASL_rrlimm
    4196889U,	// ASL_rrr
    4196889U,	// ASL_rrs12
    4196889U,	// ASL_rru6
    4197234U,	// ASR_S_ru3
    22547314U,	// ASR_S_ru5
    1121896U,	// ASR_cc_f_rru6
    1154664U,	// ASR_cc_rru6
    4196731U,	// ASR_f_rrlimm
    4196731U,	// ASR_f_rrr
    4196731U,	// ASR_f_rrs12
    4196731U,	// ASR_f_rru6
    4196937U,	// ASR_rrlimm
    4196937U,	// ASR_rrr
    4196937U,	// ASR_rrs12
    4196937U,	// ASR_rru6
    22547299U,	// BCLR_S_ru5
    11083U,	// BEQ_S
    10923U,	// BGE_S
    11165U,	// BGT_S
    11019U,	// BHI_S
    11143U,	// BHS_S
    10769U,	// BL
    10930U,	// BLE_S
    11054U,	// BLO_S
    11150U,	// BLS_S
    11172U,	// BLT_S
    11041U,	// BL_S
    22547225U,	// BMSK_S_ru5
    10937U,	// BNE_S
    10264U,	// BR
    133970U,	// BREQ_S
    133824U,	// BRNE_S
    14251U,	// BRcc_rr
    14251U,	// BRcc_ru6
    22547349U,	// BSET_S_ru5
    2994U,	// BTST_S_ru5
    10861U,	// B_S
    16255U,	// Bcc
    1581885U,	// CMP_S_limms3
    2877U,	// CMP_S_rlimm
    2877U,	// CMP_S_rr
    2877U,	// CMP_S_rs3
    2877U,	// CMP_S_u7
    2607U,	// CMP_rlimm
    2607U,	// CMP_rr
    2607U,	// CMP_ru6
    71469726U,	// COMPACT_LD_S
    3002U,	// COMPACT_MOV_S_hreg
    3002U,	// COMPACT_MOV_S_limm
    35589U,	// EI_S
    35674U,	// ENTER_S
    2441U,	// FFS_f_rr
    3042U,	// FFS_rr
    2448U,	// FLS_f_rr
    3047U,	// FLS_rr
    2944U,	// GEN_ABS_S
    22547027U,	// GEN_ADD1_S
    22547035U,	// GEN_ADD2_S
    22547043U,	// GEN_ADD3_S
    22547108U,	// GEN_AND_S
    2855U,	// GEN_AS1L_S
    2930U,	// GEN_AS1R_S
    22547239U,	// GEN_ASL_S
    22547314U,	// GEN_ASR_S
    22547088U,	// GEN_BIC_S
    1972U,	// GEN_BRK_S
    2681U,	// GEN_EXTB_S
    2798U,	// GEN_EXTH_S
    1904U,	// GEN_JEQ_S
    200510U,	// GEN_JL_S
    200486U,	// GEN_JL_S_D
    1876U,	// GEN_JNE_S
    200504U,	// GEN_J_S
    200478U,	// GEN_J_S_D
    1861U,	// GEN_J_S_D_BLINK
    2937U,	// GEN_LS1R_S
    22547321U,	// GEN_LSR_S
    22547393U,	// GEN_MPYUW_S
    22547402U,	// GEN_MPYW_S
    22547410U,	// GEN_MPY_S
    2769U,	// GEN_NEG_S
    1986U,	// GEN_NOP_S
    2987U,	// GEN_NOT_S
    22547308U,	// GEN_OR_S
    2696U,	// GEN_SEXB_S
    2806U,	// GEN_SEXH_S
    22547073U,	// GEN_SUB_S
    39323869U,	// GEN_SUB_S_NE
    1966U,	// GEN_SWI_S
    35637U,	// GEN_TRAP_S
    2995U,	// GEN_TST_S
    1978U,	// GEN_UNIMP_S
    22547307U,	// GEN_XOR_S
    36045U,	// GP_ADD_S
    199902U,	// GP_LDB_S
    199937U,	// GP_LDH_S
    199920U,	// GP_LD_S
    200495U,	// J
    200499U,	// JL
    35602U,	// JLI_S
    35349U,	// JL_LImm
    35342U,	// J_LImm
    1891U,	// J_S_BLINK
    2263059U,	// LDB_AB_rs9
    2264060U,	// LDB_AW_rs9
    2263098U,	// LDB_DI_AB_rs9
    2264099U,	// LDB_DI_AW_rs9
    8554956U,	// LDB_DI_limm
    9079244U,	// LDB_DI_rlimm
    9079244U,	// LDB_DI_rs9
    71469675U,	// LDB_S_OFF
    71469675U,	// LDB_S_rrr
    2263195U,	// LDB_X_AB_rs9
    2264196U,	// LDB_X_AW_rs9
    2263162U,	// LDB_X_DI_AB_rs9
    2264163U,	// LDB_X_DI_AW_rs9
    8555002U,	// LDB_X_DI_limm
    9079290U,	// LDB_X_DI_rlimm
    9079290U,	// LDB_X_DI_rs9
    8555672U,	// LDB_X_limm
    9079960U,	// LDB_X_rlimm
    9079960U,	// LDB_X_rs9
    8554671U,	// LDB_limm
    9078959U,	// LDB_rlimm
    9078959U,	// LDB_rs9
    2263082U,	// LDH_AB_rs9
    2264083U,	// LDH_AW_rs9
    2263130U,	// LDH_DI_AB_rs9
    2264131U,	// LDH_DI_AW_rs9
    8554979U,	// LDH_DI_limm
    9079267U,	// LDH_DI_rlimm
    9079267U,	// LDH_DI_rs9
    71469784U,	// LDH_S_OFF
    71470246U,	// LDH_S_X_OFF
    71469784U,	// LDH_S_rrr
    2263205U,	// LDH_X_AB_rs9
    2264206U,	// LDH_X_AW_rs9
    2263175U,	// LDH_X_DI_AB_rs9
    2264176U,	// LDH_X_DI_AW_rs9
    8555012U,	// LDH_X_DI_limm
    9079300U,	// LDH_X_DI_rlimm
    9079300U,	// LDH_X_DI_rs9
    8555679U,	// LDH_X_limm
    9079967U,	// LDH_X_rlimm
    9079967U,	// LDH_X_rs9
    8554933U,	// LDH_limm
    9079221U,	// LDH_rlimm
    9079221U,	// LDH_rs9
    8555262U,	// LDI_S_u7
    2263075U,	// LD_AB_rs9
    2264076U,	// LD_AW_rs9
    2263120U,	// LD_DI_AB_rs9
    2264121U,	// LD_DI_AW_rs9
    8554972U,	// LD_DI_limm
    9079260U,	// LD_DI_rlimm
    9079260U,	// LD_DI_rs9
    71470041U,	// LD_S_AS_rrr
    71469726U,	// LD_S_OFF
    71469726U,	// LD_S_rrr
    199972U,	// LD_S_s11
    8554708U,	// LD_limm
    9078996U,	// LD_rlimm
    9078996U,	// LD_rs9
    35528U,	// LEAVE_S
    8555067U,	// LR_rs12
    8555067U,	// LR_ru6
    22547321U,	// LSR_S_ru5
    1121901U,	// LSR_cc_f_rru6
    1154669U,	// LSR_cc_rru6
    4196738U,	// LSR_f_rrlimm
    4196738U,	// LSR_f_rrr
    4196738U,	// LSR_f_rrs12
    4196738U,	// LSR_f_rru6
    4196942U,	// LSR_rrlimm
    4196942U,	// LSR_rrr
    4196942U,	// LSR_rrs12
    4196942U,	// LSR_rru6
    1121963U,	// MAX_cc_f_rru6
    1154731U,	// MAX_cc_rru6
    4196775U,	// MAX_f_rrlimm
    4196775U,	// MAX_f_rrr
    4196775U,	// MAX_f_rrs12
    4196775U,	// MAX_f_rru6
    4197551U,	// MAX_rrlimm
    4197551U,	// MAX_rrr
    4197551U,	// MAX_rrs12
    4197551U,	// MAX_rru6
    1121851U,	// MIN_cc_f_rru6
    1154619U,	// MIN_cc_rru6
    4196701U,	// MIN_f_rrlimm
    4196701U,	// MIN_f_rrr
    4196701U,	// MIN_f_rrs12
    4196701U,	// MIN_f_rru6
    4196906U,	// MIN_rrlimm
    4196906U,	// MIN_rrr
    4196906U,	// MIN_rrs12
    4196906U,	// MIN_rru6
    2279U,	// MOV_S_NE_rlimm
    2279U,	// MOV_S_NE_rr
    3002U,	// MOV_S_rs3
    36035U,	// MOV_S_s3
    3002U,	// MOV_S_u8
    18086U,	// MOV_cc
    2707110U,	// MOV_cc_f_ru6
    2739878U,	// MOV_cc_ru6
    2623904U,	// MOV_f_ru6
    3063U,	// MOV_rlimm
    3063U,	// MOV_rr
    3063U,	// MOV_rs12
    3063U,	// MOV_ru6
    1121951U,	// MPYMU_cc_f_rru6
    1154719U,	// MPYMU_cc_rru6
    4196759U,	// MPYMU_f_rrlimm
    4196759U,	// MPYMU_f_rrr
    4196759U,	// MPYMU_f_rrs12
    4196759U,	// MPYMU_f_rru6
    4197360U,	// MPYMU_rrlimm
    4197360U,	// MPYMU_rrr
    4197360U,	// MPYMU_rrs12
    4197360U,	// MPYMU_rru6
    1121845U,	// MPYM_cc_f_rru6
    1154613U,	// MPYM_cc_rru6
    4196693U,	// MPYM_f_rrlimm
    4196693U,	// MPYM_f_rrr
    4196693U,	// MPYM_f_rrs12
    4196693U,	// MPYM_f_rru6
    4196900U,	// MPYM_rrlimm
    4196900U,	// MPYM_rrr
    4196900U,	// MPYM_rrs12
    4196900U,	// MPYM_rru6
    1121968U,	// MPY_cc_f_rru6
    1154736U,	// MPY_cc_rru6
    4196782U,	// MPY_f_rrlimm
    4196782U,	// MPY_f_rrr
    4196782U,	// MPY_f_rrs12
    4196782U,	// MPY_f_rru6
    4197556U,	// MPY_rrlimm
    4197556U,	// MPY_rrr
    4197556U,	// MPY_rrs12
    4197556U,	// MPY_rru6
    2357U,	// NORMH_f_rr
    2490U,	// NORMH_rr
    2381U,	// NORM_f_rr
    2590U,	// NORM_rr
    1121887U,	// OR_cc_f_rru6
    1154655U,	// OR_cc_rru6
    4196718U,	// OR_f_rrlimm
    4196718U,	// OR_f_rrr
    4196718U,	// OR_f_rrs12
    4196718U,	// OR_f_rru6
    4196928U,	// OR_rrlimm
    4196928U,	// OR_rrr
    4196928U,	// OR_rrs12
    4196928U,	// OR_rru6
    232094U,	// PCL_LD
    1935U,	// POP_S_BLINK
    35652U,	// POP_S_r
    1921U,	// PUSH_S_BLINK
    35551U,	// PUSH_S_r
    1121886U,	// ROR_cc_f_rru6
    1154654U,	// ROR_cc_rru6
    4196717U,	// ROR_f_rrlimm
    4196717U,	// ROR_f_rrr
    4196717U,	// ROR_f_rrs12
    4196717U,	// ROR_f_rru6
    4196927U,	// ROR_rrlimm
    4196927U,	// ROR_rrr
    4196927U,	// ROR_rrs12
    4196927U,	// ROR_rru6
    1121765U,	// RSUB_cc_f_rru6
    1154533U,	// RSUB_cc_rru6
    4196617U,	// RSUB_f_rrlimm
    4196617U,	// RSUB_f_rrr
    4196617U,	// RSUB_f_rrs12
    4196617U,	// RSUB_f_rru6
    4196537U,	// RSUB_rrlimm
    4196537U,	// RSUB_rrr
    4196537U,	// RSUB_rrs12
    4196537U,	// RSUB_rru6
    1121771U,	// SBC_cc_f_rru6
    1154539U,	// SBC_cc_rru6
    4196633U,	// SBC_f_rrlimm
    4196633U,	// SBC_f_rrr
    4196633U,	// SBC_f_rrs12
    4196633U,	// SBC_f_rru6
    4196549U,	// SBC_rrlimm
    4196549U,	// SBC_rrr
    4196549U,	// SBC_rrs12
    4196549U,	// SBC_rru6
    1121856U,	// SETEQ_cc_f_rru6
    1154624U,	// SETEQ_cc_rru6
    4196708U,	// SETEQ_f_rrlimm
    4196708U,	// SETEQ_f_rrr
    4196708U,	// SETEQ_f_rrs12
    4196708U,	// SETEQ_f_rru6
    4196916U,	// SETEQ_rrlimm
    4196916U,	// SETEQ_rrr
    4196916U,	// SETEQ_rrs12
    4196916U,	// SETEQ_rru6
    2321U,	// SEXB_f_rr
    2239U,	// SEXB_rr
    2366U,	// SEXH_f_rr
    2502U,	// SEXH_rr
    264855U,	// SP_ADD_S
    36166U,	// SP_ADD_SP_S
    297579U,	// SP_LDB_S
    297630U,	// SP_LD_S
    297586U,	// SP_STB_S
    297908U,	// SP_ST_S
    36149U,	// SP_SUB_SP_S
    2269211U,	// STB_AB_rs9
    2270212U,	// STB_AW_rs9
    2269253U,	// STB_DI_AB_rs9
    2270254U,	// STB_DI_AW_rs9
    8554964U,	// STB_DI_limm
    9079252U,	// STB_DI_rs9
    71469682U,	// STB_S_OFF
    8554676U,	// STB_limm
    9078964U,	// STB_rs9
    2269234U,	// STH_AB_rs9
    2270235U,	// STH_AW_rs9
    2269285U,	// STH_DI_AB_rs9
    2270286U,	// STH_DI_AW_rs9
    8554987U,	// STH_DI_limm
    9079275U,	// STH_DI_rs9
    71469799U,	// STH_S_OFF
    8554945U,	// STH_limm
    9079233U,	// STH_rs9
    2269332U,	// ST_AB_rs9
    2270333U,	// ST_AW_rs9
    2269296U,	// ST_DI_AB_rs9
    2270297U,	// ST_DI_AW_rs9
    8554995U,	// ST_DI_limm
    9079283U,	// ST_DI_rs9
    71470004U,	// ST_S_OFF
    199955U,	// ST_S_s11
    8555500U,	// ST_limm
    9079788U,	// ST_rs9
    1121716U,	// SUB1_cc_f_rru6
    1154484U,	// SUB1_cc_rru6
    4196593U,	// SUB1_f_rrlimm
    4196593U,	// SUB1_f_rrr
    4196593U,	// SUB1_f_rrs12
    4196593U,	// SUB1_f_rru6
    4196353U,	// SUB1_rrlimm
    4196353U,	// SUB1_rrr
    4196353U,	// SUB1_rrs12
    4196353U,	// SUB1_rru6
    1121722U,	// SUB2_cc_f_rru6
    1154490U,	// SUB2_cc_rru6
    4196601U,	// SUB2_f_rrlimm
    4196601U,	// SUB2_f_rrr
    4196601U,	// SUB2_f_rrs12
    4196601U,	// SUB2_f_rru6
    4196359U,	// SUB2_rrlimm
    4196359U,	// SUB2_rrr
    4196359U,	// SUB2_rrs12
    4196359U,	// SUB2_rru6
    1121728U,	// SUB3_cc_f_rru6
    1154496U,	// SUB3_cc_rru6
    4196609U,	// SUB3_f_rrlimm
    4196609U,	// SUB3_f_rrr
    4196609U,	// SUB3_f_rrs12
    4196609U,	// SUB3_f_rru6
    4196365U,	// SUB3_rrlimm
    4196365U,	// SUB3_rrr
    4196365U,	// SUB3_rrs12
    4196365U,	// SUB3_rru6
    4196993U,	// SUB_S_rrr
    4196993U,	// SUB_S_ru3
    22547073U,	// SUB_S_ru5
    1121766U,	// SUB_cc_f_rru6
    1154534U,	// SUB_cc_rru6
    4196618U,	// SUB_f_rrlimm
    4196618U,	// SUB_f_rrr
    4196618U,	// SUB_f_rrs12
    4196618U,	// SUB_f_rru6
    4196538U,	// SUB_rrlimm
    4196538U,	// SUB_rrr
    4196538U,	// SUB_rrs12
    4196538U,	// SUB_rru6
    1121891U,	// XOR_cc_f_rru6
    1154659U,	// XOR_cc_rru6
    4196724U,	// XOR_f_rrlimm
    4196724U,	// XOR_f_rrr
    4196724U,	// XOR_f_rrs12
    4196724U,	// XOR_f_rru6
    4196932U,	// XOR_rrlimm
    4196932U,	// XOR_rrr
    4196932U,	// XOR_rrs12
    4196932U,	// XOR_rru6
  };

  // Emit the opcode for the instruction.
  uint32_t Bits = 0;
  Bits |= OpInfo0[MCInst_getOpcode(MI)] << 0;
  MnemonicBitsInfo MBI = {
#ifndef CAPSTONE_DIET
    AsmStrs+(Bits & 2047)-1,
#else
    NULL,
#endif // CAPSTONE_DIET
    Bits
  };
  return MBI;
}

/// printInstruction - This method is automatically generated by tablegen
/// from the instruction set description.
static void printInstruction(MCInst *MI, uint64_t Address, SStream *O) {
  SStream_concat0(O, "");
  MnemonicBitsInfo MnemonicInfo = getMnemonic(MI, O);

  SStream_concat0(O, MnemonicInfo.first);

  uint32_t Bits = MnemonicInfo.second;
  CS_ASSERT_RET(Bits != 0 && "Cannot print this instruction.");

  // Fragment 0 encoded into 4 bits for 10 unique commands.
  switch ((Bits >> 11) & 15) {
  default: CS_ASSERT_RET(0 && "Invalid command number.");
  case 0:
    // DBG_VALUE, DBG_VALUE_LIST, DBG_INSTR_REF, DBG_PHI, DBG_LABEL, BUNDLE, ...
    return;
    break;
  case 1:
    // ADJCALLSTACKDOWN, ADJCALLSTACKUP, CTLZ, CTTZ, GETFI, STB_FAR, STH_FAR,...
    printOperand(MI, 0, O);
    break;
  case 2:
    // BRcc_rr_p, BRcc_ru6_p
    printPredicateOperand(MI, 3, O);
    SStream_concat0(O, "\t");
    printOperand(MI, 1, O);
    SStream_concat0(O, ", ");
    printOperand(MI, 2, O);
    SStream_concat0(O, ", ");
    printOperandAddr(MI, Address, 0, O);
    return;
    break;
  case 3:
    // ADC_cc_f_rru6, ADC_cc_rru6, ADD_cc_f_rru6, ADD_cc_rru6, AND_cc_f_rru6,...
    printPredicateOperand(MI, 2, O);
    break;
  case 4:
    // ADD_S_limms3, CMP_S_limms3, STB_AB_rs9, STB_AW_rs9, STB_DI_AB_rs9, STB...
    printOperand(MI, 1, O);
    break;
  case 5:
    // BEQ_S, BGE_S, BGT_S, BHI_S, BHS_S, BL, BLE_S, BLO_S, BLS_S, BLT_S, BL_...
    printOperandAddr(MI, Address, 0, O);
    return;
    break;
  case 6:
    // BRcc_rr, BRcc_ru6
    printBRCCPredicateOperand(MI, 3, O);
    SStream_concat0(O, "\t");
    printOperand(MI, 1, O);
    SStream_concat0(O, ", ");
    printOperand(MI, 2, O);
    SStream_concat0(O, ", ");
    printOperandAddr(MI, Address, 0, O);
    return;
    break;
  case 7:
    // Bcc
    printPredicateOperand(MI, 1, O);
    SStream_concat0(O, "\t");
    printOperandAddr(MI, Address, 0, O);
    return;
    break;
  case 8:
    // MOV_cc
    printCCOperand(MI, 3, O);
    SStream_concat0(O, "\t");
    printOperand(MI, 0, O);
    SStream_concat0(O, ", ");
    printOperand(MI, 1, O);
    return;
    break;
  case 9:
    // MOV_cc_f_ru6, MOV_cc_ru6
    printCCOperand(MI, 2, O);
    break;
  }


  // Fragment 1 encoded into 4 bits for 10 unique commands.
  switch ((Bits >> 15) & 15) {
  default: CS_ASSERT_RET(0 && "Invalid command number.");
  case 0:
    // ADJCALLSTACKDOWN, CTLZ, CTTZ, GETFI, STB_FAR, STH_FAR, ST_FAR, ADC_f_r...
    SStream_concat0(O, ", ");
    break;
  case 1:
    // ADJCALLSTACKUP, EI_S, ENTER_S, GEN_TRAP_S, GP_ADD_S, JLI_S, JL_LImm, J...
    return;
    break;
  case 2:
    // ADC_cc_f_rru6, ADD_cc_f_rru6, AND_cc_f_rru6, ASL_cc_f_rru6, ASR_cc_f_r...
    SStream_concat0(O, ".f\t");
    printOperand(MI, 0, O);
    SStream_concat0(O, ", ");
    break;
  case 3:
    // ADC_cc_rru6, ADD_cc_rru6, AND_cc_rru6, ASL_cc_rru6, ASR_cc_rru6, LSR_c...
    SStream_concat0(O, "\t");
    printOperand(MI, 0, O);
    SStream_concat0(O, ", ");
    break;
  case 4:
    // BREQ_S, BRNE_S
    SStream_concat0(O, ", 0, ");
    printOperandAddr(MI, Address, 1, O);
    return;
    break;
  case 5:
    // COMPACT_LD_S, LDB_AB_rs9, LDB_AW_rs9, LDB_DI_AB_rs9, LDB_DI_AW_rs9, LD...
    SStream_concat0(O, ", [");
    break;
  case 6:
    // GEN_JL_S, GEN_JL_S_D, GEN_J_S, GEN_J_S_D, GP_LDB_S, GP_LDH_S, GP_LD_S,...
    SStream_concat1(O, ']');
    return;
    break;
  case 7:
    // PCL_LD
    SStream_concat0(O, ", [%pcl, ");
    printOperand(MI, 1, O);
    SStream_concat1(O, ']');
    return;
    break;
  case 8:
    // SP_ADD_S
    SStream_concat0(O, ", %sp, ");
    printOperand(MI, 1, O);
    return;
    break;
  case 9:
    // SP_LDB_S, SP_LD_S, SP_STB_S, SP_ST_S
    SStream_concat0(O, ", [%sp, ");
    printOperand(MI, 1, O);
    SStream_concat1(O, ']');
    return;
    break;
  }


  // Fragment 2 encoded into 3 bits for 6 unique commands.
  switch ((Bits >> 19) & 7) {
  default: CS_ASSERT_RET(0 && "Invalid command number.");
  case 0:
    // ADJCALLSTACKDOWN, CTLZ, CTTZ, GETFI, ADC_f_rrlimm, ADC_f_rrr, ADC_f_rr...
    printOperand(MI, 1, O);
    break;
  case 1:
    // STB_FAR, STH_FAR, ST_FAR, LDB_DI_rlimm, LDB_DI_rs9, LDB_X_DI_rlimm, LD...
    printMemOperandRI(MI, 1, O);
    break;
  case 2:
    // ADC_cc_f_rru6, ADC_cc_rru6, ADD_cc_f_rru6, ADD_cc_rru6, AND_cc_f_rru6,...
    printOperand(MI, 3, O);
    SStream_concat0(O, ", ");
    printOperand(MI, 1, O);
    return;
    break;
  case 3:
    // ADD_S_limms3, ADD_S_rlimm, ADD_S_rr, ADD_S_rs3, ADD_S_u7, ASL_S_ru5, A...
    printOperand(MI, 0, O);
    break;
  case 4:
    // LDB_AB_rs9, LDB_AW_rs9, LDB_DI_AB_rs9, LDB_DI_AW_rs9, LDB_X_AB_rs9, LD...
    printOperand(MI, 2, O);
    SStream_concat1(O, ',');
    printOperand(MI, 3, O);
    SStream_concat1(O, ']');
    return;
    break;
  case 5:
    // MOV_cc_f_ru6, MOV_cc_ru6, MOV_f_ru6
    printU6(MI, 1, O);
    return;
    break;
  }


  // Fragment 3 encoded into 2 bits for 3 unique commands.
  switch ((Bits >> 22) & 3) {
  default: CS_ASSERT_RET(0 && "Invalid command number.");
  case 0:
    // ADJCALLSTACKDOWN, CTLZ, CTTZ, GETFI, STB_FAR, STH_FAR, ST_FAR, ADD_S_l...
    return;
    break;
  case 1:
    // ADC_f_rrlimm, ADC_f_rrr, ADC_f_rrs12, ADC_f_rru6, ADC_rrlimm, ADC_rrr,...
    SStream_concat0(O, ", ");
    break;
  case 2:
    // LDB_DI_limm, LDB_DI_rlimm, LDB_DI_rs9, LDB_X_DI_limm, LDB_X_DI_rlimm, ...
    SStream_concat1(O, ']');
    return;
    break;
  }


  // Fragment 4 encoded into 2 bits for 3 unique commands.
  switch ((Bits >> 24) & 3) {
  default: CS_ASSERT_RET(0 && "Invalid command number.");
  case 0:
    // ADC_f_rrlimm, ADC_f_rrr, ADC_f_rrs12, ADC_f_rru6, ADC_rrlimm, ADC_rrr,...
    printOperand(MI, 2, O);
    break;
  case 1:
    // ADD_S_rlimm, ADD_S_rr, ADD_S_rs3, ADD_S_u7, ASL_S_ru5, ASR_S_ru5, BCLR...
    printOperand(MI, 1, O);
    return;
    break;
  case 2:
    // GEN_SUB_S_NE
    printOperand(MI, 0, O);
    return;
    break;
  }


  // Fragment 5 encoded into 1 bits for 2 unique commands.
  if ((Bits >> 26) & 1) {
    // COMPACT_LD_S, LDB_S_OFF, LDB_S_rrr, LDH_S_OFF, LDH_S_X_OFF, LDH_S_rrr,...
    SStream_concat1(O, ']');
    return;
  } else {
    // ADC_f_rrlimm, ADC_f_rrr, ADC_f_rrs12, ADC_f_rru6, ADC_rrlimm, ADC_rrr,...
    return;
  }

}


/// getRegisterName - This method is automatically generated by tblgen
/// from the register set description.  This returns the assembler name
/// for the specified register.
static const char *getRegisterName(unsigned RegNo) {
#ifndef CAPSTONE_DIET
  CS_ASSERT_RET_VAL(RegNo && RegNo < 66 && "Invalid register number!", NULL);

  static const char AsmStrs[] = {
  /* 0 */ "%r10\0"
  /* 5 */ "%r20\0"
  /* 10 */ "%r30\0"
  /* 15 */ "%r40\0"
  /* 20 */ "%r50\0"
  /* 25 */ "%r60\0"
  /* 30 */ "%r0\0"
  /* 34 */ "%r11\0"
  /* 39 */ "%r21\0"
  /* 44 */ "%r41\0"
  /* 49 */ "%r51\0"
  /* 54 */ "%r61\0"
  /* 59 */ "%r1\0"
  /* 63 */ "%r12\0"
  /* 68 */ "%r22\0"
  /* 73 */ "%r32\0"
  /* 78 */ "status32\0"
  /* 87 */ "%r42\0"
  /* 92 */ "%r52\0"
  /* 97 */ "%r62\0"
  /* 102 */ "%r2\0"
  /* 106 */ "%r13\0"
  /* 111 */ "%r23\0"
  /* 116 */ "%r33\0"
  /* 121 */ "%r43\0"
  /* 126 */ "%r53\0"
  /* 131 */ "%r63\0"
  /* 136 */ "%r3\0"
  /* 140 */ "%r14\0"
  /* 145 */ "%r24\0"
  /* 150 */ "%r34\0"
  /* 155 */ "%r44\0"
  /* 160 */ "%r54\0"
  /* 165 */ "%r4\0"
  /* 169 */ "%r15\0"
  /* 174 */ "%r25\0"
  /* 179 */ "%r35\0"
  /* 184 */ "%r45\0"
  /* 189 */ "%r55\0"
  /* 194 */ "%r5\0"
  /* 198 */ "%r16\0"
  /* 203 */ "%r36\0"
  /* 208 */ "%r46\0"
  /* 213 */ "%r56\0"
  /* 218 */ "%r6\0"
  /* 222 */ "%r17\0"
  /* 227 */ "%r37\0"
  /* 232 */ "%r47\0"
  /* 237 */ "%r57\0"
  /* 242 */ "%r7\0"
  /* 246 */ "%r18\0"
  /* 251 */ "%r38\0"
  /* 256 */ "%r48\0"
  /* 261 */ "%r58\0"
  /* 266 */ "%r8\0"
  /* 270 */ "%r19\0"
  /* 275 */ "%r39\0"
  /* 280 */ "%r49\0"
  /* 285 */ "%r59\0"
  /* 290 */ "%r9\0"
  /* 294 */ "%blink\0"
  /* 301 */ "%ilink\0"
  /* 308 */ "%fp\0"
  /* 312 */ "%gp\0"
  /* 316 */ "%sp\0"
};
  static const uint16_t RegAsmOffset[] = {
    294, 308, 312, 301, 316, 30, 59, 102, 136, 165, 194, 218, 242, 266, 
    290, 0, 34, 63, 106, 140, 169, 198, 222, 246, 270, 5, 39, 68, 
    111, 145, 174, 10, 73, 116, 150, 179, 203, 227, 251, 275, 15, 44, 
    87, 121, 155, 184, 208, 232, 256, 280, 20, 49, 92, 126, 160, 189, 
    213, 237, 261, 285, 25, 54, 97, 131, 78, 
  };

  CS_ASSERT_RET_VAL(*(AsmStrs+RegAsmOffset[RegNo-1]) &&
          "Invalid alt name index for register!", NULL);
  return AsmStrs+RegAsmOffset[RegNo-1];
#else
  return NULL;
#endif // CAPSTONE_DIET
}
#ifdef PRINT_ALIAS_INSTR
#undef PRINT_ALIAS_INSTR

static bool printAliasInstr(MCInst *MI, uint64_t Address, SStream *OS) {
#ifndef CAPSTONE_DIET
  return false;
#endif // CAPSTONE_DIET
}

#endif // PRINT_ALIAS_INSTR
