//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/http/custom_response/local_response_policy/v3/local_response_policy.proto

package local_response_policyv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on LocalResponsePolicy with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *LocalResponsePolicy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on LocalResponsePolicy with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// LocalResponsePolicyMultiError, or nil if none found.
func (m *LocalResponsePolicy) ValidateAll() error {
	return m.validate(true)
}

func (m *LocalResponsePolicy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetBody()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, LocalResponsePolicyValidationError{
					field:  "Body",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, LocalResponsePolicyValidationError{
					field:  "Body",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBody()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return LocalResponsePolicyValidationError{
				field:  "Body",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetBodyFormat()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, LocalResponsePolicyValidationError{
					field:  "BodyFormat",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, LocalResponsePolicyValidationError{
					field:  "BodyFormat",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBodyFormat()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return LocalResponsePolicyValidationError{
				field:  "BodyFormat",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if wrapper := m.GetStatusCode(); wrapper != nil {

		if val := wrapper.GetValue(); val < 200 || val >= 600 {
			err := LocalResponsePolicyValidationError{
				field:  "StatusCode",
				reason: "value must be inside range [200, 600)",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(m.GetResponseHeadersToAdd()) > 1000 {
		err := LocalResponsePolicyValidationError{
			field:  "ResponseHeadersToAdd",
			reason: "value must contain no more than 1000 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetResponseHeadersToAdd() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, LocalResponsePolicyValidationError{
						field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, LocalResponsePolicyValidationError{
						field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return LocalResponsePolicyValidationError{
					field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return LocalResponsePolicyMultiError(errors)
	}

	return nil
}

// LocalResponsePolicyMultiError is an error wrapping multiple validation
// errors returned by LocalResponsePolicy.ValidateAll() if the designated
// constraints aren't met.
type LocalResponsePolicyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LocalResponsePolicyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LocalResponsePolicyMultiError) AllErrors() []error { return m }

// LocalResponsePolicyValidationError is the validation error returned by
// LocalResponsePolicy.Validate if the designated constraints aren't met.
type LocalResponsePolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LocalResponsePolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LocalResponsePolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LocalResponsePolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LocalResponsePolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LocalResponsePolicyValidationError) ErrorName() string {
	return "LocalResponsePolicyValidationError"
}

// Error satisfies the builtin error interface
func (e LocalResponsePolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLocalResponsePolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LocalResponsePolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LocalResponsePolicyValidationError{}
