/*
 * Copyright 2025 Vibhav Pant
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <stdbool.h>

#include "weakreference.h"

struct exception_alloc
{
    void *unknown;
    void *exception_inner;
    char data[0];
};

struct control_block
{
    IWeakReference IWeakReference_iface;
    LONG ref_weak;
    LONG ref_strong;
    IUnknown *object;
    bool is_inline;
    bool unknown;
    bool is_exception;
#ifdef _WIN32
    char _padding[5];
#endif
};

void *__cdecl AllocateExceptionWithWeakRef(ptrdiff_t, size_t);
void __cdecl FreeException(void *);
void *__cdecl AllocateWithWeakRef(ptrdiff_t, size_t);

void __thiscall control_block_ReleaseTarget(struct control_block *);

void init_exception(void *);
void WINAPI DECLSPEC_NORETURN __abi_WinRTraiseCOMException(HRESULT);
void WINAPI DECLSPEC_NORETURN __abi_WinRTraiseInvalidArgumentException(void);
void WINAPI DECLSPEC_NORETURN __abi_WinRTraiseOutOfMemoryException(void);

void init_delegate(void *base);

#define COM_VTABLE_RTTI_START(iface, type)                                                                             \
    static const struct                                                                                                \
    {                                                                                                                  \
        const rtti_object_locator *locator;                                                                            \
        iface##Vtbl vtable;                                                                                            \
    } type##_vtable = {&(type##_rtti), {
#define COM_VTABLE_ENTRY(func) (func),
#define COM_VTABLE_RTTI_END }}

#define DEFINE_IINSPECTABLE_(pfx, iface_type, impl_type, impl_from, iface_mem, expr)                                   \
    static inline impl_type *impl_from(iface_type *iface) { return CONTAINING_RECORD(iface, impl_type, iface_mem); }   \
    static HRESULT WINAPI pfx##_QueryInterface(iface_type *iface, const GUID *iid, void **out)                         \
    {                                                                                                                  \
        impl_type *impl = impl_from(iface);                                                                            \
        return IInspectable_QueryInterface((IInspectable *)(expr), iid, out);                                          \
    }                                                                                                                  \
    static ULONG WINAPI pfx##_AddRef(iface_type *iface)                                                                \
    {                                                                                                                  \
        impl_type *impl = impl_from(iface);                                                                            \
        return IInspectable_AddRef((IInspectable *)(expr));                                                            \
    }                                                                                                                  \
    static ULONG WINAPI pfx##_Release(iface_type *iface)                                                               \
    {                                                                                                                  \
        impl_type *impl = impl_from(iface);                                                                            \
        return IInspectable_Release((IInspectable *)(expr));                                                           \
    }                                                                                                                  \
    static HRESULT WINAPI pfx##_GetIids(iface_type *iface, ULONG *iid_count, IID **iids)                               \
    {                                                                                                                  \
        impl_type *impl = impl_from(iface);                                                                            \
        return IInspectable_GetIids((IInspectable *)(expr), iid_count, iids);                                          \
    }                                                                                                                  \
    static HRESULT WINAPI pfx##_GetRuntimeClassName(iface_type *iface, HSTRING *class_name)                            \
    {                                                                                                                  \
        impl_type *impl = impl_from(iface);                                                                            \
        return IInspectable_GetRuntimeClassName((IInspectable *)(expr), class_name);                                   \
    }                                                                                                                  \
    static HRESULT WINAPI pfx##_GetTrustLevel(iface_type *iface, TrustLevel *trust_level)                              \
    {                                                                                                                  \
        impl_type *impl = impl_from(iface);                                                                            \
        return IInspectable_GetTrustLevel((IInspectable *)(expr), trust_level);                                        \
    }
#define DEFINE_IINSPECTABLE(pfx, iface_type, impl_type, base_iface)                                                    \
    DEFINE_IINSPECTABLE_(pfx, iface_type, impl_type, impl_from_##iface_type, iface_type##_iface, &impl->base_iface)
#define DEFINE_IINSPECTABLE_OUTER(pfx, iface_type, impl_type, outer_iface)                                             \
    DEFINE_IINSPECTABLE_(pfx, iface_type, impl_type, impl_from_##iface_type, iface_type##_iface, impl->outer_iface)

DEFINE_GUID(IID_IPrintable,0xde0cbaeb,0x8065,0x4a45,0x96,0xb1,0xc9,0xd4,0x43,0xf9,0xba,0xb3);
