// |jit-test| skip-if: !wasmSimdEnabled()

/* Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// ./test/core/simd/simd_i8x16_cmp.wast

// ./test/core/simd/simd_i8x16_cmp.wast:4
let $0 = instantiate(`(module
  (func (export "eq") (param \$x v128) (param \$y v128) (result v128) (i8x16.eq (local.get \$x) (local.get \$y)))
  (func (export "ne") (param \$x v128) (param \$y v128) (result v128) (i8x16.ne (local.get \$x) (local.get \$y)))
  (func (export "lt_s") (param \$x v128) (param \$y v128) (result v128) (i8x16.lt_s (local.get \$x) (local.get \$y)))
  (func (export "lt_u") (param \$x v128) (param \$y v128) (result v128) (i8x16.lt_u (local.get \$x) (local.get \$y)))
  (func (export "le_s") (param \$x v128) (param \$y v128) (result v128) (i8x16.le_s (local.get \$x) (local.get \$y)))
  (func (export "le_u") (param \$x v128) (param \$y v128) (result v128) (i8x16.le_u (local.get \$x) (local.get \$y)))
  (func (export "gt_s") (param \$x v128) (param \$y v128) (result v128) (i8x16.gt_s (local.get \$x) (local.get \$y)))
  (func (export "gt_u") (param \$x v128) (param \$y v128) (result v128) (i8x16.gt_u (local.get \$x) (local.get \$y)))
  (func (export "ge_s") (param \$x v128) (param \$y v128) (result v128) (i8x16.ge_s (local.get \$x) (local.get \$y)))
  (func (export "ge_u") (param \$x v128) (param \$y v128) (result v128) (i8x16.ge_u (local.get \$x) (local.get \$y)))
)`);

// ./test/core/simd/simd_i8x16_cmp.wast:23
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:26
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:29
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:32
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:35
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:38
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:41
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:46
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:49
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:52
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:55
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:58
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:63
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:66
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:69
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:72
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:75
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:78
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:81
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:86
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x0, 0x0, 0x0, 0xc3, 0x0, 0x0, 0xfe, 0xc2, 0x0, 0x0, 0x80, 0xbf, 0x0, 0x0, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:89
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x0, 0x0, 0x80, 0x3f, 0x0, 0x0, 0xfe, 0x42, 0x0, 0x0, 0x0, 0x43, 0x0, 0x0, 0x7f, 0x43]),
    f32x4([1, 127, 128, 255]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:94
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:97
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:100
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0xff, 0xab, 0xaa, 0x1b, 0x1a, 0xb, 0xa, 0x12, 0x11, 0x10, 0x9, 0x4, 0x3, 0x2, 0x1, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:103
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:106
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:111
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:114
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:117
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:120
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:123
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:126
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0x0, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:129
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i16x8([0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:134
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:137
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:140
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:143
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:146
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:149
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffff80, 0x0, 0x1, 0xff]),
  ]),
  [
    i8x16([0xff, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:152
assert_return(
  () => invoke($0, `eq`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:161
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:164
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:167
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:170
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:173
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:176
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:179
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:184
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:187
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:190
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:193
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:196
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:201
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:204
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:207
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:210
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:213
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:216
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:219
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:224
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x0, 0x0, 0x0, 0xc3, 0x0, 0x0, 0xfe, 0xc2, 0x0, 0x0, 0x80, 0xbf, 0x0, 0x0, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:227
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x0, 0x0, 0x80, 0x3f, 0x0, 0x0, 0xfe, 0x42, 0x0, 0x0, 0x0, 0x43, 0x0, 0x0, 0x7f, 0x43]),
    f32x4([1, 127, 128, 255]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:232
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:235
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:238
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0xff, 0xab, 0xaa, 0x1b, 0x1a, 0xb, 0xa, 0x12, 0x11, 0x10, 0x9, 0x4, 0x3, 0x2, 0x1, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:241
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:244
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:249
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:252
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:255
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:258
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:261
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:264
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0xff, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:267
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i16x8([0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:272
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:275
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:278
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:281
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:284
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:287
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffff80, 0x0, 0x1, 0xff]),
  ]),
  [
    i8x16([0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:290
assert_return(
  () => invoke($0, `ne`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:299
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:302
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:305
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:308
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:311
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:314
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:317
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:322
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:325
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:328
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:331
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:334
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:339
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:342
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:345
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:348
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:351
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:354
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:357
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:362
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x0, 0x0, 0x0, 0xc3, 0x0, 0x0, 0xfe, 0xc2, 0x0, 0x0, 0x80, 0xbf, 0x0, 0x0, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:365
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x0, 0x0, 0x80, 0x3f, 0x0, 0x0, 0xfe, 0x42, 0x0, 0x0, 0x0, 0x43, 0x0, 0x0, 0x7f, 0x43]),
    f32x4([1, 127, 128, 255]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:370
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:373
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:376
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0xff, 0xab, 0xaa, 0x1b, 0x1a, 0xb, 0xa, 0x12, 0x11, 0x10, 0x9, 0x4, 0x3, 0x2, 0x1, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:379
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:382
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:387
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:390
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:393
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:396
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:399
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:402
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0xff, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:405
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i16x8([0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:410
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:413
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:416
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:419
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:422
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:425
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffff80, 0x0, 0x1, 0xff]),
  ]),
  [
    i8x16([0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:428
assert_return(
  () => invoke($0, `lt_s`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:437
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:440
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:443
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:446
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:449
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:452
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:455
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:460
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:463
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:466
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:469
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:472
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:477
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:480
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:483
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:486
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:489
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:492
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:495
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:500
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x0, 0x0, 0x0, 0xc3, 0x0, 0x0, 0xfe, 0xc2, 0x0, 0x0, 0x80, 0xbf, 0x0, 0x0, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:503
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x0, 0x0, 0x80, 0x3f, 0x0, 0x0, 0xfe, 0x42, 0x0, 0x0, 0x0, 0x43, 0x0, 0x0, 0x7f, 0x43]),
    f32x4([1, 127, 128, 255]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:508
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:511
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:514
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0xff, 0xab, 0xaa, 0x1b, 0x1a, 0xb, 0xa, 0x12, 0x11, 0x10, 0x9, 0x4, 0x3, 0x2, 0x1, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:517
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:520
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:525
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:528
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:531
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:534
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:537
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:540
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0xff, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:543
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i16x8([0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:548
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:551
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:554
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:557
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:560
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:563
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffff80, 0x0, 0x1, 0xff]),
  ]),
  [
    i8x16([0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:566
assert_return(
  () => invoke($0, `lt_u`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:575
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:578
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:581
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:584
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:587
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:590
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:593
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:598
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:601
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:604
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:607
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:610
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:615
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:618
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:621
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:624
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:627
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:630
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:633
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:638
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x0, 0x0, 0x0, 0xc3, 0x0, 0x0, 0xfe, 0xc2, 0x0, 0x0, 0x80, 0xbf, 0x0, 0x0, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:641
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x0, 0x0, 0x80, 0x3f, 0x0, 0x0, 0xfe, 0x42, 0x0, 0x0, 0x0, 0x43, 0x0, 0x0, 0x7f, 0x43]),
    f32x4([1, 127, 128, 255]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:646
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:649
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:652
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0xff, 0xab, 0xaa, 0x1b, 0x1a, 0xb, 0xa, 0x12, 0x11, 0x10, 0x9, 0x4, 0x3, 0x2, 0x1, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:655
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:658
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:663
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:666
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:669
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:672
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:675
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:678
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:681
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i16x8([0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:686
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:689
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:692
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:695
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:698
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:701
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffff80, 0x0, 0x1, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:704
assert_return(
  () => invoke($0, `le_s`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:713
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:716
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:719
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:722
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:725
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:728
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:731
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:736
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:739
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:742
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:745
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:748
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:753
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:756
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:759
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:762
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:765
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:768
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:771
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:776
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x0, 0x0, 0x0, 0xc3, 0x0, 0x0, 0xfe, 0xc2, 0x0, 0x0, 0x80, 0xbf, 0x0, 0x0, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:779
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x0, 0x0, 0x80, 0x3f, 0x0, 0x0, 0xfe, 0x42, 0x0, 0x0, 0x0, 0x43, 0x0, 0x0, 0x7f, 0x43]),
    f32x4([1, 127, 128, 255]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:784
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:787
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:790
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0xff, 0xab, 0xaa, 0x1b, 0x1a, 0xb, 0xa, 0x12, 0x11, 0x10, 0x9, 0x4, 0x3, 0x2, 0x1, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:793
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:796
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:801
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:804
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:807
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:810
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:813
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:816
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:819
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i16x8([0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:824
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:827
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:830
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:833
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:836
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:839
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffff80, 0x0, 0x1, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:842
assert_return(
  () => invoke($0, `le_u`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:851
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:854
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:857
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:860
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:863
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:866
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:869
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:874
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:877
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:880
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:883
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:886
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:891
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:894
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:897
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:900
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:903
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:906
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:909
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:914
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x0, 0x0, 0x0, 0xc3, 0x0, 0x0, 0xfe, 0xc2, 0x0, 0x0, 0x80, 0xbf, 0x0, 0x0, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:917
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x0, 0x0, 0x80, 0x3f, 0x0, 0x0, 0xfe, 0x42, 0x0, 0x0, 0x0, 0x43, 0x0, 0x0, 0x7f, 0x43]),
    f32x4([1, 127, 128, 255]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:922
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:925
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:928
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0xff, 0xab, 0xaa, 0x1b, 0x1a, 0xb, 0xa, 0x12, 0x11, 0x10, 0x9, 0x4, 0x3, 0x2, 0x1, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:931
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:934
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:939
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:942
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:945
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:948
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:951
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:954
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:957
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i16x8([0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:962
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:965
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:968
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:971
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:974
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:977
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffff80, 0x0, 0x1, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:980
assert_return(
  () => invoke($0, `gt_s`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:989
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:992
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:995
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:998
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1001
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1004
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1007
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1012
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1015
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1018
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1021
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1024
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1029
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1032
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1035
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1038
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1041
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1044
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1047
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1052
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x0, 0x0, 0x0, 0xc3, 0x0, 0x0, 0xfe, 0xc2, 0x0, 0x0, 0x80, 0xbf, 0x0, 0x0, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1055
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x0, 0x0, 0x80, 0x3f, 0x0, 0x0, 0xfe, 0x42, 0x0, 0x0, 0x0, 0x43, 0x0, 0x0, 0x7f, 0x43]),
    f32x4([1, 127, 128, 255]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1060
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1063
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1066
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0xff, 0xab, 0xaa, 0x1b, 0x1a, 0xb, 0xa, 0x12, 0x11, 0x10, 0x9, 0x4, 0x3, 0x2, 0x1, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1069
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1072
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1077
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1080
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1083
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1086
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1089
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1092
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1095
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i16x8([0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1100
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1103
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1106
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1109
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1112
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1115
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffff80, 0x0, 0x1, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1118
assert_return(
  () => invoke($0, `gt_u`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1127
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1130
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1133
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1136
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1139
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1142
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1145
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1150
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1153
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1156
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1159
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1162
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1167
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1170
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1173
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1176
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1179
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1182
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1185
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1190
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x0, 0x0, 0x0, 0xc3, 0x0, 0x0, 0xfe, 0xc2, 0x0, 0x0, 0x80, 0xbf, 0x0, 0x0, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1193
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x0, 0x0, 0x80, 0x3f, 0x0, 0x0, 0xfe, 0x42, 0x0, 0x0, 0x0, 0x43, 0x0, 0x0, 0x7f, 0x43]),
    f32x4([1, 127, 128, 255]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1198
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1201
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1204
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0xff, 0xab, 0xaa, 0x1b, 0x1a, 0xb, 0xa, 0x12, 0x11, 0x10, 0x9, 0x4, 0x3, 0x2, 0x1, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1207
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1210
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1215
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1218
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1221
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1224
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1227
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1230
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0x0, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1233
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i16x8([0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1238
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1241
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1244
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1247
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1250
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1253
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffff80, 0x0, 0x1, 0xff]),
  ]),
  [
    i8x16([0xff, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1256
assert_return(
  () => invoke($0, `ge_s`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1265
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1268
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1271
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1274
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1277
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1280
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1283
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1288
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1291
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1294
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1297
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1300
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1305
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1308
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1311
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1314
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1317
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1320
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1323
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1328
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x0, 0x0, 0x0, 0xc3, 0x0, 0x0, 0xfe, 0xc2, 0x0, 0x0, 0x80, 0xbf, 0x0, 0x0, 0x0, 0x0]),
    f32x4([-128, -127, -1, 0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1331
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x0, 0x0, 0x80, 0x3f, 0x0, 0x0, 0xfe, 0x42, 0x0, 0x0, 0x0, 0x43, 0x0, 0x0, 0x7f, 0x43]),
    f32x4([1, 127, 128, 255]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1336
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf, 0xf]),
    i8x16([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1339
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1342
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x9, 0x10, 0x11, 0x12, 0xa, 0xb, 0x1a, 0x1b, 0xaa, 0xab, 0xff]),
    i8x16([0xff, 0xab, 0xaa, 0x1b, 0x1a, 0xb, 0xa, 0x12, 0x11, 0x10, 0x9, 0x4, 0x3, 0x2, 0x1, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1345
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1348
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i8x16([0xff, 0xfe, 0xfd, 0x80, 0x7f, 0x2, 0x1, 0x0, 0x0, 0xff, 0xfe, 0xfd, 0x83, 0x82, 0x81, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1353
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1356
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1359
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1362
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i16x8([0x100, 0x302, 0x504, 0x706, 0x908, 0xb0a, 0xd0c, 0xf0e]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1365
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i16x8([0x8180, 0x8382, 0xfefd, 0xff, 0x100, 0x7f02, 0xfd80, 0xfffe]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1368
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i16x8([0xff80, 0xff80, 0x0, 0x0, 0x1, 0x1, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0x0, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1371
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i16x8([0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1376
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1379
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1382
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i32x4([0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1385
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xe, 0xf]),
    i32x4([0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1388
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x80, 0x81, 0x82, 0x83, 0xfd, 0xfe, 0xff, 0x0, 0x0, 0x1, 0x2, 0x7f, 0x80, 0xfd, 0xfe, 0xff]),
    i32x4([0x83828180, 0xfffefd, 0x7f020100, 0xfffefd80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1391
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0xff, 0xff, 0xff, 0xff]),
    i32x4([0xffffff80, 0x0, 0x1, 0xff]),
  ]),
  [
    i8x16([0xff, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1394
assert_return(
  () => invoke($0, `ge_u`, [
    i8x16([0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55]),
    i32x4([0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_cmp.wast:1401
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.eq (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1402
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.ge_s (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1403
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.ge_u (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1404
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.gt_s (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1405
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.gt_u (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1406
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.le_s (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1407
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.le_u (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1408
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.lt_s (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1409
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.lt_u (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1410
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.ne (i32.const 0) (f32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1415
let $1 = instantiate(`(module (memory 1)
  (func (export "eq-in-block")
    (block
      (drop
        (block (result v128)
          (i8x16.eq
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "ne-in-block")
    (block
      (drop
        (block (result v128)
          (i8x16.ne
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "lt_s-in-block")
    (block
      (drop
        (block (result v128)
          (i8x16.lt_s
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "le_u-in-block")
    (block
      (drop
        (block (result v128)
          (i8x16.le_u
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "gt_u-in-block")
    (block
      (drop
        (block (result v128)
          (i8x16.gt_u
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "ge_s-in-block")
    (block
      (drop
        (block (result v128)
          (i8x16.ge_s
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "nested-eq")
    (drop
      (i8x16.eq
        (i8x16.eq
          (i8x16.eq
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i8x16.eq
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (i8x16.eq
          (i8x16.eq
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i8x16.eq
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-ne")
    (drop
      (i8x16.ne
        (i8x16.ne
          (i8x16.ne
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i8x16.ne
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (i8x16.ne
          (i8x16.ne
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i8x16.ne
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-lt_s")
    (drop
      (i8x16.lt_s
        (i8x16.lt_s
          (i8x16.lt_s
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i8x16.lt_s
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (i8x16.lt_s
          (i8x16.lt_s
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i8x16.lt_s
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-le_u")
    (drop
      (i8x16.le_u
        (i8x16.le_u
          (i8x16.le_u
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i8x16.le_u
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (i8x16.le_u
          (i8x16.le_u
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i8x16.le_u
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-gt_u")
    (drop
      (i8x16.gt_u
        (i8x16.gt_u
          (i8x16.gt_u
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i8x16.gt_u
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (i8x16.gt_u
          (i8x16.gt_u
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i8x16.gt_u
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-ge_s")
    (drop
      (i8x16.ge_s
        (i8x16.ge_s
          (i8x16.ge_s
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i8x16.ge_s
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (i8x16.ge_s
          (i8x16.ge_s
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i8x16.ge_s
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "as-param")
    (drop
      (i8x16.ge_u
        (i8x16.eq
          (i8x16.lt_s
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i8x16.le_u
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (i8x16.ne
          (i8x16.gt_s
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (i8x16.lt_u
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
)`);

// ./test/core/simd/simd_i8x16_cmp.wast:1671
assert_return(() => invoke($1, `eq-in-block`, []), []);

// ./test/core/simd/simd_i8x16_cmp.wast:1672
assert_return(() => invoke($1, `ne-in-block`, []), []);

// ./test/core/simd/simd_i8x16_cmp.wast:1673
assert_return(() => invoke($1, `lt_s-in-block`, []), []);

// ./test/core/simd/simd_i8x16_cmp.wast:1674
assert_return(() => invoke($1, `le_u-in-block`, []), []);

// ./test/core/simd/simd_i8x16_cmp.wast:1675
assert_return(() => invoke($1, `gt_u-in-block`, []), []);

// ./test/core/simd/simd_i8x16_cmp.wast:1676
assert_return(() => invoke($1, `ge_s-in-block`, []), []);

// ./test/core/simd/simd_i8x16_cmp.wast:1677
assert_return(() => invoke($1, `nested-eq`, []), []);

// ./test/core/simd/simd_i8x16_cmp.wast:1678
assert_return(() => invoke($1, `nested-ne`, []), []);

// ./test/core/simd/simd_i8x16_cmp.wast:1679
assert_return(() => invoke($1, `nested-lt_s`, []), []);

// ./test/core/simd/simd_i8x16_cmp.wast:1680
assert_return(() => invoke($1, `nested-le_u`, []), []);

// ./test/core/simd/simd_i8x16_cmp.wast:1681
assert_return(() => invoke($1, `nested-gt_u`, []), []);

// ./test/core/simd/simd_i8x16_cmp.wast:1682
assert_return(() => invoke($1, `nested-ge_s`, []), []);

// ./test/core/simd/simd_i8x16_cmp.wast:1683
assert_return(() => invoke($1, `as-param`, []), []);

// ./test/core/simd/simd_i8x16_cmp.wast:1688
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.eq-1st-arg-empty (result v128)
      (i8x16.eq (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1696
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.eq-arg-empty (result v128)
      (i8x16.eq)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1704
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.ne-1st-arg-empty (result v128)
      (i8x16.ne (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1712
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.ne-arg-empty (result v128)
      (i8x16.ne)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1720
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.lt_s-1st-arg-empty (result v128)
      (i8x16.lt_s (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1728
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.lt_s-arg-empty (result v128)
      (i8x16.lt_s)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1736
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.lt_u-1st-arg-empty (result v128)
      (i8x16.lt_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1744
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.lt_u-arg-empty (result v128)
      (i8x16.lt_u)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1752
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.le_s-1st-arg-empty (result v128)
      (i8x16.le_s (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1760
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.le_s-arg-empty (result v128)
      (i8x16.le_s)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1768
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.le_u-1st-arg-empty (result v128)
      (i8x16.le_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1776
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.le_u-arg-empty (result v128)
      (i8x16.le_u)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1784
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.gt_s-1st-arg-empty (result v128)
      (i8x16.gt_s (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1792
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.gt_s-arg-empty (result v128)
      (i8x16.gt_s)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1800
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.gt_u-1st-arg-empty (result v128)
      (i8x16.gt_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1808
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.gt_u-arg-empty (result v128)
      (i8x16.gt_u)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1816
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.ge_s-1st-arg-empty (result v128)
      (i8x16.ge_s (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1824
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.ge_s-arg-empty (result v128)
      (i8x16.ge_s)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1832
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.ge_u-1st-arg-empty (result v128)
      (i8x16.ge_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_cmp.wast:1840
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.ge_u-arg-empty (result v128)
      (i8x16.ge_u)
    )
  )`),
  `type mismatch`,
);
