package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDeviceChannels invokes the vs.ListDeviceChannels API synchronously
func (client *Client) ListDeviceChannels(request *ListDeviceChannelsRequest) (response *ListDeviceChannelsResponse, err error) {
	response = CreateListDeviceChannelsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDeviceChannelsWithChan invokes the vs.ListDeviceChannels API asynchronously
func (client *Client) ListDeviceChannelsWithChan(request *ListDeviceChannelsRequest) (<-chan *ListDeviceChannelsResponse, <-chan error) {
	responseChan := make(chan *ListDeviceChannelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDeviceChannels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDeviceChannelsWithCallback invokes the vs.ListDeviceChannels API asynchronously
func (client *Client) ListDeviceChannelsWithCallback(request *ListDeviceChannelsRequest, callback func(response *ListDeviceChannelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDeviceChannelsResponse
		var err error
		defer close(result)
		response, err = client.ListDeviceChannels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDeviceChannelsRequest is the request struct for api ListDeviceChannels
type ListDeviceChannelsRequest struct {
	*requests.RpcRequest
	PageNum  requests.Integer `position:"Query" name:"PageNum"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
	ShowLog  string           `position:"Query" name:"ShowLog"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	DeviceId string           `position:"Query" name:"DeviceId"`
}

// ListDeviceChannelsResponse is the response struct for api ListDeviceChannels
type ListDeviceChannelsResponse struct {
	*responses.BaseResponse
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	PageSize   int64     `json:"PageSize" xml:"PageSize"`
	PageNum    int64     `json:"PageNum" xml:"PageNum"`
	PageCount  int64     `json:"PageCount" xml:"PageCount"`
	TotalCount int64     `json:"TotalCount" xml:"TotalCount"`
	Channels   []Channel `json:"Channels" xml:"Channels"`
}

// CreateListDeviceChannelsRequest creates a request to invoke ListDeviceChannels API
func CreateListDeviceChannelsRequest() (request *ListDeviceChannelsRequest) {
	request = &ListDeviceChannelsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "ListDeviceChannels", "", "")
	request.Method = requests.POST
	return
}

// CreateListDeviceChannelsResponse creates a response to parse from ListDeviceChannels response
func CreateListDeviceChannelsResponse() (response *ListDeviceChannelsResponse) {
	response = &ListDeviceChannelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
