package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRecords invokes the vs.DescribeRecords API synchronously
func (client *Client) DescribeRecords(request *DescribeRecordsRequest) (response *DescribeRecordsResponse, err error) {
	response = CreateDescribeRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRecordsWithChan invokes the vs.DescribeRecords API asynchronously
func (client *Client) DescribeRecordsWithChan(request *DescribeRecordsRequest) (<-chan *DescribeRecordsResponse, <-chan error) {
	responseChan := make(chan *DescribeRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRecordsWithCallback invokes the vs.DescribeRecords API asynchronously
func (client *Client) DescribeRecordsWithCallback(request *DescribeRecordsRequest, callback func(response *DescribeRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRecordsResponse
		var err error
		defer close(result)
		response, err = client.DescribeRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRecordsRequest is the request struct for api DescribeRecords
type DescribeRecordsRequest struct {
	*requests.RpcRequest
	SortDirection string           `position:"Query" name:"SortDirection"`
	StartTime     string           `position:"Query" name:"StartTime"`
	Type          string           `position:"Query" name:"Type"`
	PageNum       requests.Integer `position:"Query" name:"PageNum"`
	PrivateBucket requests.Boolean `position:"Query" name:"PrivateBucket"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	ShowLog       string           `position:"Query" name:"ShowLog"`
	StreamId      string           `position:"Query" name:"StreamId"`
	EndTime       string           `position:"Query" name:"EndTime"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SortBy        string           `position:"Query" name:"SortBy"`
}

// DescribeRecordsResponse is the response struct for api DescribeRecords
type DescribeRecordsResponse struct {
	*responses.BaseResponse
	RequestId     string   `json:"RequestId" xml:"RequestId"`
	PageSize      int64    `json:"PageSize" xml:"PageSize"`
	PageNum       int64    `json:"PageNum" xml:"PageNum"`
	PageCount     int64    `json:"PageCount" xml:"PageCount"`
	TotalCount    int64    `json:"TotalCount" xml:"TotalCount"`
	NextStartTime string   `json:"NextStartTime" xml:"NextStartTime"`
	Records       []Record `json:"Records" xml:"Records"`
}

// CreateDescribeRecordsRequest creates a request to invoke DescribeRecords API
func CreateDescribeRecordsRequest() (request *DescribeRecordsRequest) {
	request = &DescribeRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeRecords", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeRecordsResponse creates a response to parse from DescribeRecords response
func CreateDescribeRecordsResponse() (response *DescribeRecordsResponse) {
	response = &DescribeRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
