package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteParentPlatform invokes the vs.DeleteParentPlatform API synchronously
func (client *Client) DeleteParentPlatform(request *DeleteParentPlatformRequest) (response *DeleteParentPlatformResponse, err error) {
	response = CreateDeleteParentPlatformResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteParentPlatformWithChan invokes the vs.DeleteParentPlatform API asynchronously
func (client *Client) DeleteParentPlatformWithChan(request *DeleteParentPlatformRequest) (<-chan *DeleteParentPlatformResponse, <-chan error) {
	responseChan := make(chan *DeleteParentPlatformResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteParentPlatform(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteParentPlatformWithCallback invokes the vs.DeleteParentPlatform API asynchronously
func (client *Client) DeleteParentPlatformWithCallback(request *DeleteParentPlatformRequest, callback func(response *DeleteParentPlatformResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteParentPlatformResponse
		var err error
		defer close(result)
		response, err = client.DeleteParentPlatform(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteParentPlatformRequest is the request struct for api DeleteParentPlatform
type DeleteParentPlatformRequest struct {
	*requests.RpcRequest
	Id      string           `position:"Query" name:"Id"`
	ShowLog string           `position:"Query" name:"ShowLog"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteParentPlatformResponse is the response struct for api DeleteParentPlatform
type DeleteParentPlatformResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteParentPlatformRequest creates a request to invoke DeleteParentPlatform API
func CreateDeleteParentPlatformRequest() (request *DeleteParentPlatformRequest) {
	request = &DeleteParentPlatformRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DeleteParentPlatform", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteParentPlatformResponse creates a response to parse from DeleteParentPlatform response
func CreateDeleteParentPlatformResponse() (response *DeleteParentPlatformResponse) {
	response = &DeleteParentPlatformResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
