package servicemesh

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterPrometheus invokes the servicemesh.DescribeClusterPrometheus API synchronously
func (client *Client) DescribeClusterPrometheus(request *DescribeClusterPrometheusRequest) (response *DescribeClusterPrometheusResponse, err error) {
	response = CreateDescribeClusterPrometheusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterPrometheusWithChan invokes the servicemesh.DescribeClusterPrometheus API asynchronously
func (client *Client) DescribeClusterPrometheusWithChan(request *DescribeClusterPrometheusRequest) (<-chan *DescribeClusterPrometheusResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterPrometheusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterPrometheus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterPrometheusWithCallback invokes the servicemesh.DescribeClusterPrometheus API asynchronously
func (client *Client) DescribeClusterPrometheusWithCallback(request *DescribeClusterPrometheusRequest, callback func(response *DescribeClusterPrometheusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterPrometheusResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterPrometheus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterPrometheusRequest is the request struct for api DescribeClusterPrometheus
type DescribeClusterPrometheusRequest struct {
	*requests.RpcRequest
	K8sClusterId       string `position:"Query" name:"K8sClusterId"`
	K8sClusterRegionId string `position:"Query" name:"K8sClusterRegionId"`
	ServiceMeshId      string `position:"Query" name:"ServiceMeshId"`
}

// DescribeClusterPrometheusResponse is the response struct for api DescribeClusterPrometheus
type DescribeClusterPrometheusResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Prometheus string `json:"Prometheus" xml:"Prometheus"`
}

// CreateDescribeClusterPrometheusRequest creates a request to invoke DescribeClusterPrometheus API
func CreateDescribeClusterPrometheusRequest() (request *DescribeClusterPrometheusRequest) {
	request = &DescribeClusterPrometheusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("servicemesh", "2020-01-11", "DescribeClusterPrometheus", "servicemesh", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeClusterPrometheusResponse creates a response to parse from DescribeClusterPrometheus response
func CreateDescribeClusterPrometheusResponse() (response *DescribeClusterPrometheusResponse) {
	response = &DescribeClusterPrometheusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
