package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateService invokes the retailcloud.CreateService API synchronously
func (client *Client) CreateService(request *CreateServiceRequest) (response *CreateServiceResponse, err error) {
	response = CreateCreateServiceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateServiceWithChan invokes the retailcloud.CreateService API asynchronously
func (client *Client) CreateServiceWithChan(request *CreateServiceRequest) (<-chan *CreateServiceResponse, <-chan error) {
	responseChan := make(chan *CreateServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateServiceWithCallback invokes the retailcloud.CreateService API asynchronously
func (client *Client) CreateServiceWithCallback(request *CreateServiceRequest, callback func(response *CreateServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateServiceResponse
		var err error
		defer close(result)
		response, err = client.CreateService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateServiceRequest is the request struct for api CreateService
type CreateServiceRequest struct {
	*requests.RpcRequest
	Headless     requests.Boolean             `position:"Query" name:"Headless"`
	ServiceType  string                       `position:"Query" name:"ServiceType"`
	K8sServiceId string                       `position:"Query" name:"K8sServiceId"`
	Name         string                       `position:"Query" name:"Name"`
	PortMappings *[]CreateServicePortMappings `position:"Body" name:"PortMappings"  type:"Repeated"`
	EnvId        requests.Integer             `position:"Query" name:"EnvId"`
}

// CreateServicePortMappings is a repeated param struct in CreateServiceRequest
type CreateServicePortMappings struct {
	Protocol   string `name:"Protocol"`
	Port       string `name:"Port"`
	Name       string `name:"Name"`
	NodePort   string `name:"NodePort"`
	TargetPort string `name:"TargetPort"`
}

// CreateServiceResponse is the response struct for api CreateService
type CreateServiceResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCreateServiceRequest creates a request to invoke CreateService API
func CreateCreateServiceRequest() (request *CreateServiceRequest) {
	request = &CreateServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "CreateService", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateServiceResponse creates a response to parse from CreateService response
func CreateCreateServiceResponse() (response *CreateServiceResponse) {
	response = &CreateServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
