package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryEmbedTokenInfo invokes the quickbi_public.QueryEmbedTokenInfo API synchronously
func (client *Client) QueryEmbedTokenInfo(request *QueryEmbedTokenInfoRequest) (response *QueryEmbedTokenInfoResponse, err error) {
	response = CreateQueryEmbedTokenInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryEmbedTokenInfoWithChan invokes the quickbi_public.QueryEmbedTokenInfo API asynchronously
func (client *Client) QueryEmbedTokenInfoWithChan(request *QueryEmbedTokenInfoRequest) (<-chan *QueryEmbedTokenInfoResponse, <-chan error) {
	responseChan := make(chan *QueryEmbedTokenInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryEmbedTokenInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryEmbedTokenInfoWithCallback invokes the quickbi_public.QueryEmbedTokenInfo API asynchronously
func (client *Client) QueryEmbedTokenInfoWithCallback(request *QueryEmbedTokenInfoRequest, callback func(response *QueryEmbedTokenInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryEmbedTokenInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryEmbedTokenInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryEmbedTokenInfoRequest is the request struct for api QueryEmbedTokenInfo
type QueryEmbedTokenInfoRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
	Token       string `position:"Query" name:"Token"`
}

// QueryEmbedTokenInfoResponse is the response struct for api QueryEmbedTokenInfo
type QueryEmbedTokenInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateQueryEmbedTokenInfoRequest creates a request to invoke QueryEmbedTokenInfo API
func CreateQueryEmbedTokenInfoRequest() (request *QueryEmbedTokenInfoRequest) {
	request = &QueryEmbedTokenInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2021-03-25", "QueryEmbedTokenInfo", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryEmbedTokenInfoResponse creates a response to parse from QueryEmbedTokenInfo response
func CreateQueryEmbedTokenInfoResponse() (response *QueryEmbedTokenInfoResponse) {
	response = &QueryEmbedTokenInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
