package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSwimmingLaneGroup invokes the mse.DeleteSwimmingLaneGroup API synchronously
func (client *Client) DeleteSwimmingLaneGroup(request *DeleteSwimmingLaneGroupRequest) (response *DeleteSwimmingLaneGroupResponse, err error) {
	response = CreateDeleteSwimmingLaneGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSwimmingLaneGroupWithChan invokes the mse.DeleteSwimmingLaneGroup API asynchronously
func (client *Client) DeleteSwimmingLaneGroupWithChan(request *DeleteSwimmingLaneGroupRequest) (<-chan *DeleteSwimmingLaneGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteSwimmingLaneGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSwimmingLaneGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSwimmingLaneGroupWithCallback invokes the mse.DeleteSwimmingLaneGroup API asynchronously
func (client *Client) DeleteSwimmingLaneGroupWithCallback(request *DeleteSwimmingLaneGroupRequest, callback func(response *DeleteSwimmingLaneGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSwimmingLaneGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteSwimmingLaneGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSwimmingLaneGroupRequest is the request struct for api DeleteSwimmingLaneGroup
type DeleteSwimmingLaneGroupRequest struct {
	*requests.RpcRequest
	GroupId        requests.Integer `position:"Query" name:"GroupId"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
}

// DeleteSwimmingLaneGroupResponse is the response struct for api DeleteSwimmingLaneGroup
type DeleteSwimmingLaneGroupResponse struct {
	*responses.BaseResponse
}

// CreateDeleteSwimmingLaneGroupRequest creates a request to invoke DeleteSwimmingLaneGroup API
func CreateDeleteSwimmingLaneGroupRequest() (request *DeleteSwimmingLaneGroupRequest) {
	request = &DeleteSwimmingLaneGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "DeleteSwimmingLaneGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteSwimmingLaneGroupResponse creates a response to parse from DeleteSwimmingLaneGroup response
func CreateDeleteSwimmingLaneGroupResponse() (response *DeleteSwimmingLaneGroupResponse) {
	response = &DeleteSwimmingLaneGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
