package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ClassifyFNF invokes the imageprocess.ClassifyFNF API synchronously
func (client *Client) ClassifyFNF(request *ClassifyFNFRequest) (response *ClassifyFNFResponse, err error) {
	response = CreateClassifyFNFResponse()
	err = client.DoAction(request, response)
	return
}

// ClassifyFNFWithChan invokes the imageprocess.ClassifyFNF API asynchronously
func (client *Client) ClassifyFNFWithChan(request *ClassifyFNFRequest) (<-chan *ClassifyFNFResponse, <-chan error) {
	responseChan := make(chan *ClassifyFNFResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ClassifyFNF(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ClassifyFNFWithCallback invokes the imageprocess.ClassifyFNF API asynchronously
func (client *Client) ClassifyFNFWithCallback(request *ClassifyFNFRequest, callback func(response *ClassifyFNFResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ClassifyFNFResponse
		var err error
		defer close(result)
		response, err = client.ClassifyFNF(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ClassifyFNFRequest is the request struct for api ClassifyFNF
type ClassifyFNFRequest struct {
	*requests.RpcRequest
	DataFormat string `position:"Body" name:"DataFormat"`
	OrgId      string `position:"Body" name:"OrgId"`
	OrgName    string `position:"Body" name:"OrgName"`
	ImageUrl   string `position:"Body" name:"ImageUrl"`
	TracerId   string `position:"Body" name:"TracerId"`
}

// ClassifyFNFResponse is the response struct for api ClassifyFNF
type ClassifyFNFResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateClassifyFNFRequest creates a request to invoke ClassifyFNF API
func CreateClassifyFNFRequest() (request *ClassifyFNFRequest) {
	request = &ClassifyFNFRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "ClassifyFNF", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateClassifyFNFResponse creates a response to parse from ClassifyFNF response
func CreateClassifyFNFResponse() (response *ClassifyFNFResponse) {
	response = &ClassifyFNFResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
