package imageenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ColorizeImage invokes the imageenhan.ColorizeImage API synchronously
func (client *Client) ColorizeImage(request *ColorizeImageRequest) (response *ColorizeImageResponse, err error) {
	response = CreateColorizeImageResponse()
	err = client.DoAction(request, response)
	return
}

// ColorizeImageWithChan invokes the imageenhan.ColorizeImage API asynchronously
func (client *Client) ColorizeImageWithChan(request *ColorizeImageRequest) (<-chan *ColorizeImageResponse, <-chan error) {
	responseChan := make(chan *ColorizeImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ColorizeImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ColorizeImageWithCallback invokes the imageenhan.ColorizeImage API asynchronously
func (client *Client) ColorizeImageWithCallback(request *ColorizeImageRequest, callback func(response *ColorizeImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ColorizeImageResponse
		var err error
		defer close(result)
		response, err = client.ColorizeImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ColorizeImageRequest is the request struct for api ColorizeImage
type ColorizeImageRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// ColorizeImageResponse is the response struct for api ColorizeImage
type ColorizeImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateColorizeImageRequest creates a request to invoke ColorizeImage API
func CreateColorizeImageRequest() (request *ColorizeImageRequest) {
	request = &ColorizeImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageenhan", "2019-09-30", "ColorizeImage", "imageenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateColorizeImageResponse creates a response to parse from ColorizeImage response
func CreateColorizeImageResponse() (response *ColorizeImageResponse) {
	response = &ColorizeImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
