package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDiskWarningLine invokes the hbase.ModifyDiskWarningLine API synchronously
func (client *Client) ModifyDiskWarningLine(request *ModifyDiskWarningLineRequest) (response *ModifyDiskWarningLineResponse, err error) {
	response = CreateModifyDiskWarningLineResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDiskWarningLineWithChan invokes the hbase.ModifyDiskWarningLine API asynchronously
func (client *Client) ModifyDiskWarningLineWithChan(request *ModifyDiskWarningLineRequest) (<-chan *ModifyDiskWarningLineResponse, <-chan error) {
	responseChan := make(chan *ModifyDiskWarningLineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDiskWarningLine(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDiskWarningLineWithCallback invokes the hbase.ModifyDiskWarningLine API asynchronously
func (client *Client) ModifyDiskWarningLineWithCallback(request *ModifyDiskWarningLineRequest, callback func(response *ModifyDiskWarningLineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDiskWarningLineResponse
		var err error
		defer close(result)
		response, err = client.ModifyDiskWarningLine(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDiskWarningLineRequest is the request struct for api ModifyDiskWarningLine
type ModifyDiskWarningLineRequest struct {
	*requests.RpcRequest
	ClusterId   string           `position:"Query" name:"ClusterId"`
	WarningLine requests.Integer `position:"Query" name:"WarningLine"`
}

// ModifyDiskWarningLineResponse is the response struct for api ModifyDiskWarningLine
type ModifyDiskWarningLineResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDiskWarningLineRequest creates a request to invoke ModifyDiskWarningLine API
func CreateModifyDiskWarningLineRequest() (request *ModifyDiskWarningLineRequest) {
	request = &ModifyDiskWarningLineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "ModifyDiskWarningLine", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDiskWarningLineResponse creates a response to parse from ModifyDiskWarningLine response
func CreateModifyDiskWarningLineResponse() (response *ModifyDiskWarningLineResponse) {
	response = &ModifyDiskWarningLineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
