package fnf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeExecution invokes the fnf.DescribeExecution API synchronously
func (client *Client) DescribeExecution(request *DescribeExecutionRequest) (response *DescribeExecutionResponse, err error) {
	response = CreateDescribeExecutionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeExecutionWithChan invokes the fnf.DescribeExecution API asynchronously
func (client *Client) DescribeExecutionWithChan(request *DescribeExecutionRequest) (<-chan *DescribeExecutionResponse, <-chan error) {
	responseChan := make(chan *DescribeExecutionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeExecution(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeExecutionWithCallback invokes the fnf.DescribeExecution API asynchronously
func (client *Client) DescribeExecutionWithCallback(request *DescribeExecutionRequest, callback func(response *DescribeExecutionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeExecutionResponse
		var err error
		defer close(result)
		response, err = client.DescribeExecution(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeExecutionRequest is the request struct for api DescribeExecution
type DescribeExecutionRequest struct {
	*requests.RpcRequest
	ExecutionName   string           `position:"Query" name:"ExecutionName"`
	WaitTimeSeconds requests.Integer `position:"Query" name:"WaitTimeSeconds"`
	RequestId       string           `position:"Query" name:"RequestId"`
	FlowName        string           `position:"Query" name:"FlowName"`
}

// DescribeExecutionResponse is the response struct for api DescribeExecution
type DescribeExecutionResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	Name              string `json:"Name" xml:"Name"`
	FlowName          string `json:"FlowName" xml:"FlowName"`
	FlowDefinition    string `json:"FlowDefinition" xml:"FlowDefinition"`
	Input             string `json:"Input" xml:"Input"`
	Output            string `json:"Output" xml:"Output"`
	Status            string `json:"Status" xml:"Status"`
	StartedTime       string `json:"StartedTime" xml:"StartedTime"`
	StoppedTime       string `json:"StoppedTime" xml:"StoppedTime"`
	ExternalInputUri  string `json:"ExternalInputUri" xml:"ExternalInputUri"`
	ExternalOutputUri string `json:"ExternalOutputUri" xml:"ExternalOutputUri"`
}

// CreateDescribeExecutionRequest creates a request to invoke DescribeExecution API
func CreateDescribeExecutionRequest() (request *DescribeExecutionRequest) {
	request = &DescribeExecutionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("fnf", "2019-03-15", "DescribeExecution", "fnf", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeExecutionResponse creates a response to parse from DescribeExecution response
func CreateDescribeExecutionResponse() (response *DescribeExecutionResponse) {
	response = &DescribeExecutionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
