package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVm invokes the ens.DeleteVm API synchronously
func (client *Client) DeleteVm(request *DeleteVmRequest) (response *DeleteVmResponse, err error) {
	response = CreateDeleteVmResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVmWithChan invokes the ens.DeleteVm API asynchronously
func (client *Client) DeleteVmWithChan(request *DeleteVmRequest) (<-chan *DeleteVmResponse, <-chan error) {
	responseChan := make(chan *DeleteVmResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVm(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVmWithCallback invokes the ens.DeleteVm API asynchronously
func (client *Client) DeleteVmWithCallback(request *DeleteVmRequest, callback func(response *DeleteVmResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVmResponse
		var err error
		defer close(result)
		response, err = client.DeleteVm(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVmRequest is the request struct for api DeleteVm
type DeleteVmRequest struct {
	*requests.RpcRequest
	AliUid       requests.Integer `position:"Query" name:"AliUid"`
	WorkloadUuid string           `position:"Query" name:"WorkloadUuid"`
}

// DeleteVmResponse is the response struct for api DeleteVm
type DeleteVmResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Msg       string `json:"Msg" xml:"Msg"`
	Desc      string `json:"Desc" xml:"Desc"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteVmRequest creates a request to invoke DeleteVm API
func CreateDeleteVmRequest() (request *DeleteVmRequest) {
	request = &DeleteVmRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DeleteVm", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteVmResponse creates a response to parse from DeleteVm response
func CreateDeleteVmResponse() (response *DeleteVmResponse) {
	response = &DeleteVmResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
