package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigureSynchronizationJobAlert invokes the dts.ConfigureSynchronizationJobAlert API synchronously
func (client *Client) ConfigureSynchronizationJobAlert(request *ConfigureSynchronizationJobAlertRequest) (response *ConfigureSynchronizationJobAlertResponse, err error) {
	response = CreateConfigureSynchronizationJobAlertResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigureSynchronizationJobAlertWithChan invokes the dts.ConfigureSynchronizationJobAlert API asynchronously
func (client *Client) ConfigureSynchronizationJobAlertWithChan(request *ConfigureSynchronizationJobAlertRequest) (<-chan *ConfigureSynchronizationJobAlertResponse, <-chan error) {
	responseChan := make(chan *ConfigureSynchronizationJobAlertResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigureSynchronizationJobAlert(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigureSynchronizationJobAlertWithCallback invokes the dts.ConfigureSynchronizationJobAlert API asynchronously
func (client *Client) ConfigureSynchronizationJobAlertWithCallback(request *ConfigureSynchronizationJobAlertRequest, callback func(response *ConfigureSynchronizationJobAlertResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigureSynchronizationJobAlertResponse
		var err error
		defer close(result)
		response, err = client.ConfigureSynchronizationJobAlert(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigureSynchronizationJobAlertRequest is the request struct for api ConfigureSynchronizationJobAlert
type ConfigureSynchronizationJobAlertRequest struct {
	*requests.RpcRequest
	SynchronizationJobId     string `position:"Query" name:"SynchronizationJobId"`
	AccountId                string `position:"Query" name:"AccountId"`
	DelayAlertPhone          string `position:"Query" name:"DelayAlertPhone"`
	DelayOverSeconds         string `position:"Query" name:"DelayOverSeconds"`
	DelayAlertStatus         string `position:"Query" name:"DelayAlertStatus"`
	OwnerId                  string `position:"Query" name:"OwnerId"`
	ErrorAlertPhone          string `position:"Query" name:"ErrorAlertPhone"`
	ErrorAlertStatus         string `position:"Query" name:"ErrorAlertStatus"`
	SynchronizationDirection string `position:"Query" name:"SynchronizationDirection"`
}

// ConfigureSynchronizationJobAlertResponse is the response struct for api ConfigureSynchronizationJobAlert
type ConfigureSynchronizationJobAlertResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	ErrCode    string `json:"ErrCode" xml:"ErrCode"`
	Success    string `json:"Success" xml:"Success"`
	ErrMessage string `json:"ErrMessage" xml:"ErrMessage"`
}

// CreateConfigureSynchronizationJobAlertRequest creates a request to invoke ConfigureSynchronizationJobAlert API
func CreateConfigureSynchronizationJobAlertRequest() (request *ConfigureSynchronizationJobAlertRequest) {
	request = &ConfigureSynchronizationJobAlertRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "ConfigureSynchronizationJobAlert", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateConfigureSynchronizationJobAlertResponse creates a response to parse from ConfigureSynchronizationJobAlert response
func CreateConfigureSynchronizationJobAlertResponse() (response *ConfigureSynchronizationJobAlertResponse) {
	response = &ConfigureSynchronizationJobAlertResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
