package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImportConnections invokes the dataworks_public.ImportConnections API synchronously
func (client *Client) ImportConnections(request *ImportConnectionsRequest) (response *ImportConnectionsResponse, err error) {
	response = CreateImportConnectionsResponse()
	err = client.DoAction(request, response)
	return
}

// ImportConnectionsWithChan invokes the dataworks_public.ImportConnections API asynchronously
func (client *Client) ImportConnectionsWithChan(request *ImportConnectionsRequest) (<-chan *ImportConnectionsResponse, <-chan error) {
	responseChan := make(chan *ImportConnectionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImportConnections(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImportConnectionsWithCallback invokes the dataworks_public.ImportConnections API asynchronously
func (client *Client) ImportConnectionsWithCallback(request *ImportConnectionsRequest, callback func(response *ImportConnectionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImportConnectionsResponse
		var err error
		defer close(result)
		response, err = client.ImportConnections(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImportConnectionsRequest is the request struct for api ImportConnections
type ImportConnectionsRequest struct {
	*requests.RpcRequest
	ProjectId   requests.Integer `position:"Query" name:"ProjectId"`
	Connections string           `position:"Query" name:"Connections"`
}

// ImportConnectionsResponse is the response struct for api ImportConnections
type ImportConnectionsResponse struct {
	*responses.BaseResponse
	RequestId string                  `json:"RequestId" xml:"RequestId"`
	Success   bool                    `json:"Success" xml:"Success"`
	Data      DataInImportConnections `json:"Data" xml:"Data"`
}

// CreateImportConnectionsRequest creates a request to invoke ImportConnections API
func CreateImportConnectionsRequest() (request *ImportConnectionsRequest) {
	request = &ImportConnectionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ImportConnections", "", "")
	request.Method = requests.POST
	return
}

// CreateImportConnectionsResponse creates a response to parse from ImportConnections response
func CreateImportConnectionsResponse() (response *ImportConnectionsResponse) {
	response = &ImportConnectionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
