package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveContactFlowFromPhoneNumber invokes the cloudcallcenter.RemoveContactFlowFromPhoneNumber API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removecontactflowfromphonenumber.html
func (client *Client) RemoveContactFlowFromPhoneNumber(request *RemoveContactFlowFromPhoneNumberRequest) (response *RemoveContactFlowFromPhoneNumberResponse, err error) {
	response = CreateRemoveContactFlowFromPhoneNumberResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveContactFlowFromPhoneNumberWithChan invokes the cloudcallcenter.RemoveContactFlowFromPhoneNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removecontactflowfromphonenumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveContactFlowFromPhoneNumberWithChan(request *RemoveContactFlowFromPhoneNumberRequest) (<-chan *RemoveContactFlowFromPhoneNumberResponse, <-chan error) {
	responseChan := make(chan *RemoveContactFlowFromPhoneNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveContactFlowFromPhoneNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveContactFlowFromPhoneNumberWithCallback invokes the cloudcallcenter.RemoveContactFlowFromPhoneNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removecontactflowfromphonenumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveContactFlowFromPhoneNumberWithCallback(request *RemoveContactFlowFromPhoneNumberRequest, callback func(response *RemoveContactFlowFromPhoneNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveContactFlowFromPhoneNumberResponse
		var err error
		defer close(result)
		response, err = client.RemoveContactFlowFromPhoneNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveContactFlowFromPhoneNumberRequest is the request struct for api RemoveContactFlowFromPhoneNumber
type RemoveContactFlowFromPhoneNumberRequest struct {
	*requests.RpcRequest
	ContactFlowId string `position:"Query" name:"ContactFlowId"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	PhoneNumberId string `position:"Query" name:"PhoneNumberId"`
}

// RemoveContactFlowFromPhoneNumberResponse is the response struct for api RemoveContactFlowFromPhoneNumber
type RemoveContactFlowFromPhoneNumberResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateRemoveContactFlowFromPhoneNumberRequest creates a request to invoke RemoveContactFlowFromPhoneNumber API
func CreateRemoveContactFlowFromPhoneNumberRequest() (request *RemoveContactFlowFromPhoneNumberRequest) {
	request = &RemoveContactFlowFromPhoneNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "RemoveContactFlowFromPhoneNumber", "", "")
	request.Method = requests.POST
	return
}

// CreateRemoveContactFlowFromPhoneNumberResponse creates a response to parse from RemoveContactFlowFromPhoneNumber response
func CreateRemoveContactFlowFromPhoneNumberResponse() (response *RemoveContactFlowFromPhoneNumberResponse) {
	response = &RemoveContactFlowFromPhoneNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
