package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMeasureRecordFromJiuYun invokes the cloudcallcenter.CreateMeasureRecordFromJiuYun API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createmeasurerecordfromjiuyun.html
func (client *Client) CreateMeasureRecordFromJiuYun(request *CreateMeasureRecordFromJiuYunRequest) (response *CreateMeasureRecordFromJiuYunResponse, err error) {
	response = CreateCreateMeasureRecordFromJiuYunResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMeasureRecordFromJiuYunWithChan invokes the cloudcallcenter.CreateMeasureRecordFromJiuYun API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createmeasurerecordfromjiuyun.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateMeasureRecordFromJiuYunWithChan(request *CreateMeasureRecordFromJiuYunRequest) (<-chan *CreateMeasureRecordFromJiuYunResponse, <-chan error) {
	responseChan := make(chan *CreateMeasureRecordFromJiuYunResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMeasureRecordFromJiuYun(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMeasureRecordFromJiuYunWithCallback invokes the cloudcallcenter.CreateMeasureRecordFromJiuYun API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createmeasurerecordfromjiuyun.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateMeasureRecordFromJiuYunWithCallback(request *CreateMeasureRecordFromJiuYunRequest, callback func(response *CreateMeasureRecordFromJiuYunResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMeasureRecordFromJiuYunResponse
		var err error
		defer close(result)
		response, err = client.CreateMeasureRecordFromJiuYun(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMeasureRecordFromJiuYunRequest is the request struct for api CreateMeasureRecordFromJiuYun
type CreateMeasureRecordFromJiuYunRequest struct {
	*requests.RpcRequest
	Caller       string           `position:"Query" name:"Caller"`
	Callee       string           `position:"Query" name:"Callee"`
	EndTime      string           `position:"Query" name:"EndTime"`
	StartTime    string           `position:"Query" name:"StartTime"`
	OrigDuration requests.Integer `position:"Query" name:"OrigDuration"`
}

// CreateMeasureRecordFromJiuYunResponse is the response struct for api CreateMeasureRecordFromJiuYun
type CreateMeasureRecordFromJiuYunResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateCreateMeasureRecordFromJiuYunRequest creates a request to invoke CreateMeasureRecordFromJiuYun API
func CreateCreateMeasureRecordFromJiuYunRequest() (request *CreateMeasureRecordFromJiuYunRequest) {
	request = &CreateMeasureRecordFromJiuYunRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CreateMeasureRecordFromJiuYun", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMeasureRecordFromJiuYunResponse creates a response to parse from CreateMeasureRecordFromJiuYun response
func CreateCreateMeasureRecordFromJiuYunResponse() (response *CreateMeasureRecordFromJiuYunResponse) {
	response = &CreateMeasureRecordFromJiuYunResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
